/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.ArrayList;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.CustomHashtable;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class CheckboxTableViewer
extends TableViewer
implements ICheckable {
    private ListenerList checkStateListeners = new ListenerList();

    public CheckboxTableViewer(Composite composite) {
        this(composite, 2048);
    }

    public CheckboxTableViewer(Composite composite, int n) {
        this(CheckboxTableViewer.createTable(composite, n));
    }

    public static CheckboxTableViewer newCheckList(Composite composite, int n) {
        Table table = new Table(composite, 0x20 | n);
        return new CheckboxTableViewer(table);
    }

    public CheckboxTableViewer(Table table) {
        super(table);
    }

    public void addCheckStateListener(ICheckStateListener iCheckStateListener) {
        this.checkStateListeners.add(iCheckStateListener);
    }

    protected static Table createTable(Composite composite, int n) {
        Table table = new Table(composite, 0x20 | n);
        new TableColumn(table, 0);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData(new ColumnWeightData(100));
        table.setLayout((Layout)tableLayout);
        return table;
    }

    private void fireCheckStateChanged(final CheckStateChangedEvent checkStateChangedEvent) {
        Object[] objectArray = this.checkStateListeners.getListeners();
        for (int i = 0; i < objectArray.length; ++i) {
            final ICheckStateListener iCheckStateListener = (ICheckStateListener)objectArray[i];
            SafeRunnable.run(new SafeRunnable(){

                public void run() {
                    iCheckStateListener.checkStateChanged(checkStateChangedEvent);
                }
            });
        }
    }

    public boolean getChecked(Object object) {
        Widget widget = this.findItem(object);
        if (widget instanceof TableItem) {
            return ((TableItem)widget).getChecked();
        }
        return false;
    }

    public Object[] getCheckedElements() {
        TableItem[] tableItemArray = this.getTable().getItems();
        ArrayList<Object> arrayList = new ArrayList<Object>(tableItemArray.length);
        for (int i = 0; i < tableItemArray.length; ++i) {
            TableItem tableItem = tableItemArray[i];
            if (!tableItem.getChecked()) continue;
            arrayList.add(tableItem.getData());
        }
        return arrayList.toArray();
    }

    public boolean getGrayed(Object object) {
        Widget widget = this.findItem(object);
        if (widget instanceof TableItem) {
            return ((TableItem)widget).getGrayed();
        }
        return false;
    }

    public Object[] getGrayedElements() {
        TableItem[] tableItemArray = this.getTable().getItems();
        ArrayList<Object> arrayList = new ArrayList<Object>(tableItemArray.length);
        for (int i = 0; i < tableItemArray.length; ++i) {
            TableItem tableItem = tableItemArray[i];
            if (!tableItem.getGrayed()) continue;
            arrayList.add(tableItem.getData());
        }
        return arrayList.toArray();
    }

    public void handleSelect(SelectionEvent selectionEvent) {
        if (selectionEvent.detail == 32) {
            super.handleSelect(selectionEvent);
            TableItem tableItem = (TableItem)selectionEvent.item;
            Object object = tableItem.getData();
            if (object != null) {
                this.fireCheckStateChanged(new CheckStateChangedEvent(this, object, tableItem.getChecked()));
            }
        } else {
            super.handleSelect(selectionEvent);
        }
    }

    protected void preservingSelection(Runnable runnable) {
        Object object;
        TableItem tableItem;
        int n;
        TableItem[] tableItemArray = this.getTable().getItems();
        CustomHashtable customHashtable = this.newHashtable(tableItemArray.length * 2 + 1);
        CustomHashtable customHashtable2 = this.newHashtable(tableItemArray.length * 2 + 1);
        for (n = 0; n < tableItemArray.length; ++n) {
            tableItem = tableItemArray[n];
            object = tableItem.getData();
            if (object == null) continue;
            if (tableItem.getChecked()) {
                customHashtable.put(object, object);
            }
            if (!tableItem.getGrayed()) continue;
            customHashtable2.put(object, object);
        }
        super.preservingSelection(runnable);
        tableItemArray = this.getTable().getItems();
        for (n = 0; n < tableItemArray.length; ++n) {
            tableItem = tableItemArray[n];
            object = tableItem.getData();
            if (object == null) continue;
            tableItem.setChecked(customHashtable.containsKey(object));
            tableItem.setGrayed(customHashtable2.containsKey(object));
        }
    }

    public void removeCheckStateListener(ICheckStateListener iCheckStateListener) {
        this.checkStateListeners.remove(iCheckStateListener);
    }

    public void setAllChecked(boolean bl) {
        TableItem[] tableItemArray = this.getTable().getItems();
        for (int i = 0; i < tableItemArray.length; ++i) {
            TableItem tableItem = tableItemArray[i];
            tableItem.setChecked(bl);
        }
    }

    public void setAllGrayed(boolean bl) {
        TableItem[] tableItemArray = this.getTable().getItems();
        for (int i = 0; i < tableItemArray.length; ++i) {
            TableItem tableItem = tableItemArray[i];
            tableItem.setGrayed(bl);
        }
    }

    public boolean setChecked(Object object, boolean bl) {
        Assert.isNotNull(object);
        Widget widget = this.findItem(object);
        if (widget instanceof TableItem) {
            ((TableItem)widget).setChecked(bl);
            return true;
        }
        return false;
    }

    public void setCheckedElements(Object[] objectArray) {
        this.assertElementsNotNull(objectArray);
        CustomHashtable customHashtable = this.newHashtable(objectArray.length * 2 + 1);
        for (int i = 0; i < objectArray.length; ++i) {
            customHashtable.put(objectArray[i], objectArray[i]);
        }
        TableItem[] tableItemArray = this.getTable().getItems();
        for (int i = 0; i < tableItemArray.length; ++i) {
            TableItem tableItem = tableItemArray[i];
            Object object = tableItem.getData();
            if (object == null) continue;
            boolean bl = customHashtable.containsKey(object);
            if (tableItem.getChecked() == bl) continue;
            tableItem.setChecked(bl);
        }
    }

    public boolean setGrayed(Object object, boolean bl) {
        Assert.isNotNull(object);
        Widget widget = this.findItem(object);
        if (widget instanceof TableItem) {
            ((TableItem)widget).setGrayed(bl);
            return true;
        }
        return false;
    }

    public void setGrayedElements(Object[] objectArray) {
        this.assertElementsNotNull(objectArray);
        CustomHashtable customHashtable = this.newHashtable(objectArray.length * 2 + 1);
        for (int i = 0; i < objectArray.length; ++i) {
            customHashtable.put(objectArray[i], objectArray[i]);
        }
        TableItem[] tableItemArray = this.getTable().getItems();
        for (int i = 0; i < tableItemArray.length; ++i) {
            TableItem tableItem = tableItemArray[i];
            Object object = tableItem.getData();
            if (object == null) continue;
            boolean bl = customHashtable.containsKey(object);
            if (tableItem.getGrayed() == bl) continue;
            tableItem.setGrayed(bl);
        }
    }
}

