/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.jface.viewers.IElementComparer;

final class CustomHashtable {
    transient int elementCount;
    transient HashMapEntry[] elementData;
    private float loadFactor;
    private int threshold;
    transient int firstSlot = 0;
    transient int lastSlot = -1;
    private transient IElementComparer comparer;
    private static final EmptyEnumerator emptyEnumerator = new EmptyEnumerator();
    public static final int DEFAULT_CAPACITY = 13;

    public CustomHashtable() {
        this(13);
    }

    public CustomHashtable(int n) {
        this(n, null);
    }

    public CustomHashtable(IElementComparer iElementComparer) {
        this(13, iElementComparer);
    }

    public CustomHashtable(int n, IElementComparer iElementComparer) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.elementData = new HashMapEntry[n == 0 ? 1 : n];
        this.firstSlot = this.elementData.length;
        this.loadFactor = 0.75f;
        this.computeMaxSize();
        this.comparer = iElementComparer;
    }

    public CustomHashtable(CustomHashtable customHashtable, IElementComparer iElementComparer) {
        this(customHashtable.size() * 2, iElementComparer);
        int n = customHashtable.elementData.length;
        while (--n >= 0) {
            HashMapEntry hashMapEntry = customHashtable.elementData[n];
            while (hashMapEntry != null) {
                this.put(hashMapEntry.key, hashMapEntry.value);
                hashMapEntry = hashMapEntry.next;
            }
        }
    }

    public IElementComparer getComparer() {
        return this.comparer;
    }

    private void computeMaxSize() {
        this.threshold = (int)((float)this.elementData.length * this.loadFactor);
    }

    public boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    public Enumeration elements() {
        if (this.elementCount == 0) {
            return emptyEnumerator;
        }
        return new HashEnumerator(false);
    }

    public Object get(Object object) {
        int n = (this.hashCode(object) & Integer.MAX_VALUE) % this.elementData.length;
        HashMapEntry hashMapEntry = this.elementData[n];
        while (hashMapEntry != null) {
            if (this.keyEquals(object, hashMapEntry.key)) {
                return hashMapEntry.value;
            }
            hashMapEntry = hashMapEntry.next;
        }
        return null;
    }

    private HashMapEntry getEntry(Object object) {
        int n = (this.hashCode(object) & Integer.MAX_VALUE) % this.elementData.length;
        HashMapEntry hashMapEntry = this.elementData[n];
        while (hashMapEntry != null) {
            if (this.keyEquals(object, hashMapEntry.key)) {
                return hashMapEntry;
            }
            hashMapEntry = hashMapEntry.next;
        }
        return null;
    }

    private int hashCode(Object object) {
        if (this.comparer == null) {
            return object.hashCode();
        }
        return this.comparer.hashCode(object);
    }

    private boolean keyEquals(Object object, Object object2) {
        if (this.comparer == null) {
            return object.equals(object2);
        }
        return this.comparer.equals(object, object2);
    }

    public Enumeration keys() {
        if (this.elementCount == 0) {
            return emptyEnumerator;
        }
        return new HashEnumerator(true);
    }

    public Object put(Object object, Object object2) {
        if (object != null && object2 != null) {
            int n = (this.hashCode(object) & Integer.MAX_VALUE) % this.elementData.length;
            HashMapEntry hashMapEntry = this.elementData[n];
            while (hashMapEntry != null && !this.keyEquals(object, hashMapEntry.key)) {
                hashMapEntry = hashMapEntry.next;
            }
            if (hashMapEntry == null) {
                if (++this.elementCount > this.threshold) {
                    this.rehash();
                    n = (this.hashCode(object) & Integer.MAX_VALUE) % this.elementData.length;
                }
                if (n < this.firstSlot) {
                    this.firstSlot = n;
                }
                if (n > this.lastSlot) {
                    this.lastSlot = n;
                }
                hashMapEntry = new HashMapEntry(object, object2);
                hashMapEntry.next = this.elementData[n];
                this.elementData[n] = hashMapEntry;
                return null;
            }
            Object object3 = hashMapEntry.value;
            hashMapEntry.key = object;
            hashMapEntry.value = object2;
            return object3;
        }
        throw new NullPointerException();
    }

    private void rehash() {
        int n = this.elementData.length << 1;
        if (n == 0) {
            n = 1;
        }
        this.firstSlot = n;
        this.lastSlot = -1;
        HashMapEntry[] hashMapEntryArray = new HashMapEntry[n];
        int n2 = this.elementData.length;
        while (--n2 >= 0) {
            HashMapEntry hashMapEntry = this.elementData[n2];
            while (hashMapEntry != null) {
                int n3 = (this.hashCode(hashMapEntry.key) & Integer.MAX_VALUE) % n;
                if (n3 < this.firstSlot) {
                    this.firstSlot = n3;
                }
                if (n3 > this.lastSlot) {
                    this.lastSlot = n3;
                }
                HashMapEntry hashMapEntry2 = hashMapEntry.next;
                hashMapEntry.next = hashMapEntryArray[n3];
                hashMapEntryArray[n3] = hashMapEntry;
                hashMapEntry = hashMapEntry2;
            }
        }
        this.elementData = hashMapEntryArray;
        this.computeMaxSize();
    }

    public Object remove(Object object) {
        HashMapEntry hashMapEntry = null;
        int n = (this.hashCode(object) & Integer.MAX_VALUE) % this.elementData.length;
        HashMapEntry hashMapEntry2 = this.elementData[n];
        while (hashMapEntry2 != null && !this.keyEquals(object, hashMapEntry2.key)) {
            hashMapEntry = hashMapEntry2;
            hashMapEntry2 = hashMapEntry2.next;
        }
        if (hashMapEntry2 != null) {
            if (hashMapEntry == null) {
                this.elementData[n] = hashMapEntry2.next;
            } else {
                hashMapEntry.next = hashMapEntry2.next;
            }
            --this.elementCount;
            return hashMapEntry2.value;
        }
        return null;
    }

    public int size() {
        return this.elementCount;
    }

    public String toString() {
        if (this.size() == 0) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        int n = this.elementData.length;
        while (--n >= 0) {
            HashMapEntry hashMapEntry = this.elementData[n];
            while (hashMapEntry != null) {
                stringBuffer.append(hashMapEntry.key);
                stringBuffer.append('=');
                stringBuffer.append(hashMapEntry.value);
                stringBuffer.append(", ");
                hashMapEntry = hashMapEntry.next;
            }
        }
        if (this.elementCount > 0) {
            stringBuffer.setLength(stringBuffer.length() - 2);
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    private static final class EmptyEnumerator
    implements Enumeration {
        private EmptyEnumerator() {
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    }

    private class HashEnumerator
    implements Enumeration {
        boolean key;
        int start;
        HashMapEntry entry;

        HashEnumerator(boolean bl) {
            this.key = bl;
            this.start = CustomHashtable.this.firstSlot;
        }

        public boolean hasMoreElements() {
            if (this.entry != null) {
                return true;
            }
            while (this.start <= CustomHashtable.this.lastSlot) {
                if (CustomHashtable.this.elementData[this.start++] == null) continue;
                this.entry = CustomHashtable.this.elementData[this.start - 1];
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                Object object = this.key ? this.entry.key : this.entry.value;
                this.entry = this.entry.next;
                return object;
            }
            throw new NoSuchElementException();
        }
    }

    private static class HashMapEntry {
        Object key;
        Object value;
        HashMapEntry next;

        HashMapEntry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }
    }
}

