/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.WrappedViewerLabelProvider;

class TableColumnViewerLabelProvider
extends WrappedViewerLabelProvider {
    private ITableLabelProvider tableLabelProvider;
    private ITableColorProvider tableColorProvider;
    private ITableFontProvider tableFontProvider;

    public TableColumnViewerLabelProvider(IBaseLabelProvider iBaseLabelProvider) {
        super(iBaseLabelProvider);
        if (iBaseLabelProvider instanceof ITableLabelProvider) {
            this.tableLabelProvider = (ITableLabelProvider)iBaseLabelProvider;
        }
        if (iBaseLabelProvider instanceof ITableColorProvider) {
            this.tableColorProvider = (ITableColorProvider)((Object)iBaseLabelProvider);
        }
        if (iBaseLabelProvider instanceof ITableFontProvider) {
            this.tableFontProvider = (ITableFontProvider)((Object)iBaseLabelProvider);
        }
    }

    public void update(ViewerCell viewerCell) {
        Object object = viewerCell.getElement();
        int n = viewerCell.getColumnIndex();
        if (this.tableLabelProvider == null) {
            viewerCell.setText(this.getLabelProvider().getText(object));
            viewerCell.setImage(this.getLabelProvider().getImage(object));
        } else {
            viewerCell.setText(this.tableLabelProvider.getColumnText(object, n));
            viewerCell.setImage(this.tableLabelProvider.getColumnImage(object, n));
        }
        if (this.tableColorProvider == null) {
            if (this.getColorProvider() != null) {
                viewerCell.setBackground(this.getColorProvider().getBackground(object));
                viewerCell.setForeground(this.getColorProvider().getForeground(object));
            }
        } else {
            viewerCell.setBackground(this.tableColorProvider.getBackground(object, n));
            viewerCell.setForeground(this.tableColorProvider.getForeground(object, n));
        }
        if (this.tableFontProvider == null) {
            if (this.getFontProvider() != null) {
                viewerCell.setFont(this.getFontProvider().getFont(object));
            }
        } else {
            viewerCell.setFont(this.tableFontProvider.getFont(object, n));
        }
    }
}

