/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class TableLayout
extends Layout {
    private static int COLUMN_TRIM = "carbon".equals(SWT.getPlatform()) ? 24 : 3;
    private List columns = new ArrayList();
    private boolean firstTime = true;

    public void addColumnData(ColumnLayoutData columnLayoutData) {
        this.columns.add(columnLayoutData);
    }

    public Point computeSize(Composite composite, int n, int n2, boolean bl) {
        if (n != -1 && n2 != -1) {
            return new Point(n, n2);
        }
        Table table = (Table)composite;
        table.setLayout(null);
        Point point = table.computeSize(n, n2, bl);
        table.setLayout((Layout)this);
        int n3 = 0;
        int n4 = this.columns.size();
        for (int i = 0; i < n4; ++i) {
            ColumnLayoutData columnLayoutData;
            ColumnLayoutData columnLayoutData2 = (ColumnLayoutData)this.columns.get(i);
            if (columnLayoutData2 instanceof ColumnPixelData) {
                columnLayoutData = (ColumnPixelData)columnLayoutData2;
                n3 += columnLayoutData.width;
                if (!columnLayoutData.addTrim) continue;
                n3 += COLUMN_TRIM;
                continue;
            }
            if (columnLayoutData2 instanceof ColumnWeightData) {
                columnLayoutData = (ColumnWeightData)columnLayoutData2;
                n3 += ((ColumnWeightData)columnLayoutData).minimumWidth;
                continue;
            }
            Assert.isTrue(false, "Unknown column layout data");
        }
        if (n3 > point.x) {
            point.x = n3;
        }
        return point;
    }

    public void layout(Composite composite, boolean bl) {
        int n;
        int n2;
        if (!this.firstTime) {
            return;
        }
        int n3 = composite.getClientArea().width;
        if (n3 <= 1) {
            return;
        }
        Item[] itemArray = this.getColumns(composite);
        int n4 = Math.min(this.columns.size(), itemArray.length);
        int[] nArray = new int[n4];
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            ColumnLayoutData columnLayoutData;
            ColumnLayoutData columnLayoutData2 = (ColumnLayoutData)this.columns.get(n2);
            if (columnLayoutData2 instanceof ColumnPixelData) {
                columnLayoutData = (ColumnPixelData)columnLayoutData2;
                n = columnLayoutData.width;
                if (columnLayoutData.addTrim) {
                    n += COLUMN_TRIM;
                }
                nArray[n2] = n;
                n5 += n;
                continue;
            }
            if (columnLayoutData2 instanceof ColumnWeightData) {
                columnLayoutData = (ColumnWeightData)columnLayoutData2;
                ++n6;
                n = ((ColumnWeightData)columnLayoutData).weight;
                n7 += n;
                continue;
            }
            Assert.isTrue(false, "Unknown column layout data");
        }
        if (n6 > 0) {
            ColumnLayoutData columnLayoutData;
            int n8;
            n2 = n3 - n5;
            int n9 = 0;
            for (n8 = 0; n8 < n4; ++n8) {
                int n10;
                ColumnLayoutData columnLayoutData3 = (ColumnLayoutData)this.columns.get(n8);
                if (!(columnLayoutData3 instanceof ColumnWeightData)) continue;
                columnLayoutData = (ColumnWeightData)columnLayoutData3;
                int n11 = columnLayoutData.weight;
                int n12 = n10 = n7 == 0 ? 0 : n11 * n2 / n7;
                if (n10 < columnLayoutData.minimumWidth) {
                    n10 = columnLayoutData.minimumWidth;
                }
                n9 += n10;
                nArray[n8] = n10;
            }
            n8 = n2 - n9;
            n = 0;
            while (n8 > 0) {
                if (n == n4) {
                    n = 0;
                }
                if ((columnLayoutData = (ColumnLayoutData)this.columns.get(n)) instanceof ColumnWeightData) {
                    int n13 = n;
                    nArray[n13] = nArray[n13] + 1;
                    --n8;
                }
                ++n;
            }
        }
        this.firstTime = false;
        for (n2 = 0; n2 < n4; ++n2) {
            this.setWidth(itemArray[n2], nArray[n2]);
        }
    }

    private void setWidth(Item item, int n) {
        if (item instanceof TreeColumn) {
            ((TreeColumn)item).setWidth(n);
        } else {
            ((TableColumn)item).setWidth(n);
        }
    }

    private Item[] getColumns(Composite composite) {
        if (composite instanceof Tree) {
            return ((Tree)composite).getColumns();
        }
        return ((Table)composite).getColumns();
    }
}

