/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerRow;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TableViewer
extends AbstractTableViewer {
    private Table table;
    private TableViewerRow cachedRow;

    public TableViewer(Composite composite) {
        this(composite, 2818);
    }

    public TableViewer(Composite composite, int n) {
        this(new Table(composite, n));
    }

    public TableViewer(Table table) {
        this.table = table;
        this.hookControl((Control)table);
    }

    public Control getControl() {
        return this.table;
    }

    public Table getTable() {
        return this.table;
    }

    protected ColumnViewerEditor createViewerEditor() {
        return new TableViewerEditor(this, null, new ColumnViewerEditorActivationStrategy(this), 1);
    }

    public void setSelection(ISelection iSelection, boolean bl) {
        super.setSelection(iSelection, bl);
    }

    protected ViewerRow getViewerRowFromItem(Widget widget) {
        if (this.cachedRow == null) {
            this.cachedRow = new TableViewerRow((TableItem)widget);
        } else {
            this.cachedRow.setItem((TableItem)widget);
        }
        return this.cachedRow;
    }

    protected ViewerRow internalCreateNewRowPart(int n, int n2) {
        TableItem tableItem = n2 >= 0 ? new TableItem(this.table, n, n2) : new TableItem(this.table, n);
        return this.getViewerRowFromItem((Widget)tableItem);
    }

    protected Item getItemAt(Point point) {
        return this.table.getItem(point);
    }

    protected int doGetItemCount() {
        return this.table.getItemCount();
    }

    protected int doIndexOf(Item item) {
        return this.table.indexOf((TableItem)item);
    }

    protected void doSetItemCount(int n) {
        this.table.setItemCount(n);
    }

    protected Item[] doGetItems() {
        return this.table.getItems();
    }

    protected int doGetColumnCount() {
        return this.table.getColumnCount();
    }

    protected Widget doGetColumn(int n) {
        return this.table.getColumn(n);
    }

    protected Item doGetItem(int n) {
        return this.table.getItem(n);
    }

    protected Item[] doGetSelection() {
        return this.table.getSelection();
    }

    protected int[] doGetSelectionIndices() {
        return this.table.getSelectionIndices();
    }

    protected void doClearAll() {
        this.table.clearAll();
    }

    protected void doResetItem(Item item) {
        TableItem tableItem = (TableItem)item;
        int n = Math.max(1, this.table.getColumnCount());
        for (int i = 0; i < n; ++i) {
            tableItem.setText(i, "");
            if (tableItem.getImage(i) == null) continue;
            tableItem.setImage(i, null);
        }
    }

    protected void doRemove(int n, int n2) {
        this.table.remove(n, n2);
    }

    protected void doRemoveAll() {
        this.table.removeAll();
    }

    protected void doRemove(int[] nArray) {
        this.table.remove(nArray);
    }

    protected void doShowItem(Item item) {
        this.table.showItem((TableItem)item);
    }

    protected void doDeselectAll() {
        this.table.deselectAll();
    }

    protected void doSetSelection(Item[] itemArray) {
        Assert.isNotNull(itemArray, "Items-Array can not be null");
        TableItem[] tableItemArray = new TableItem[itemArray.length];
        System.arraycopy(itemArray, 0, tableItemArray, 0, tableItemArray.length);
        this.table.setSelection(tableItemArray);
    }

    protected void doShowSelection() {
        this.table.showSelection();
    }

    protected void doSetSelection(int[] nArray) {
        this.table.setSelection(nArray);
    }

    protected void doClear(int n) {
        this.table.clear(n);
    }

    protected void doSelect(int[] nArray) {
        this.table.select(nArray);
    }

    public void refresh(final Object object, final boolean bl, boolean bl2) {
        if (this.isBusy()) {
            return;
        }
        if (this.isCellEditorActive()) {
            this.cancelEditing();
        }
        this.preservingSelection(new Runnable(){

            public void run() {
                TableViewer.this.internalRefresh(object, bl);
            }
        }, bl2);
    }

    public void refresh(boolean bl, boolean bl2) {
        this.refresh(this.getRoot(), bl, bl2);
    }
}

