/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;

public final class TableViewerEditor
extends ColumnViewerEditor {
    private TableEditor tableEditor;
    private SWTFocusCellManager focusCellManager;

    TableViewerEditor(TableViewer tableViewer, SWTFocusCellManager sWTFocusCellManager, ColumnViewerEditorActivationStrategy columnViewerEditorActivationStrategy, int n) {
        super(tableViewer, columnViewerEditorActivationStrategy, n);
        this.tableEditor = new TableEditor(tableViewer.getTable());
        this.focusCellManager = sWTFocusCellManager;
    }

    public static void create(TableViewer tableViewer, SWTFocusCellManager sWTFocusCellManager, ColumnViewerEditorActivationStrategy columnViewerEditorActivationStrategy, int n) {
        TableViewerEditor tableViewerEditor = new TableViewerEditor(tableViewer, sWTFocusCellManager, columnViewerEditorActivationStrategy, n);
        tableViewer.setColumnViewerEditor(tableViewerEditor);
        if (sWTFocusCellManager != null) {
            sWTFocusCellManager.init();
        }
    }

    public static void create(TableViewer tableViewer, ColumnViewerEditorActivationStrategy columnViewerEditorActivationStrategy, int n) {
        TableViewerEditor.create(tableViewer, null, columnViewerEditorActivationStrategy, n);
    }

    protected void setEditor(Control control, Item item, int n) {
        this.tableEditor.setEditor(control, (TableItem)item, n);
    }

    protected void setLayoutData(CellEditor.LayoutData layoutData) {
        this.tableEditor.grabHorizontal = layoutData.grabHorizontal;
        this.tableEditor.horizontalAlignment = layoutData.horizontalAlignment;
        this.tableEditor.minimumWidth = layoutData.minimumWidth;
    }

    public ViewerCell getFocusCell() {
        if (this.focusCellManager != null) {
            return this.focusCellManager.getFocusCell();
        }
        return super.getFocusCell();
    }

    protected void updateFocusCell(ViewerCell viewerCell, ColumnViewerEditorActivationEvent columnViewerEditorActivationEvent) {
        if (columnViewerEditorActivationEvent.eventType == 4 || columnViewerEditorActivationEvent.eventType == 5) {
            List list = this.getViewer().getSelectionFromWidget();
            if (this.focusCellManager != null) {
                this.focusCellManager.setFocusCell(viewerCell);
            }
            if (!list.contains(viewerCell.getElement())) {
                this.getViewer().setSelection(new StructuredSelection(viewerCell.getElement()));
            }
        }
    }
}

