/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IElementComparer;

public final class TreePath {
    public static final TreePath EMPTY = new TreePath(new Object[0]);
    private Object[] segments;
    private int hash;

    public TreePath(Object[] objectArray) {
        Assert.isNotNull(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            Assert.isNotNull(objectArray[i]);
        }
        this.segments = objectArray;
    }

    public Object getSegment(int n) {
        return this.segments[n];
    }

    public int getSegmentCount() {
        return this.segments.length;
    }

    public Object getFirstSegment() {
        if (this.segments.length == 0) {
            return null;
        }
        return this.segments[0];
    }

    public Object getLastSegment() {
        if (this.segments.length == 0) {
            return null;
        }
        return this.segments[this.segments.length - 1];
    }

    public boolean equals(Object object) {
        if (!(object instanceof TreePath)) {
            return false;
        }
        return this.equals((TreePath)object, null);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.hashCode(null);
        }
        return this.hash;
    }

    public int hashCode(IElementComparer iElementComparer) {
        int n = 0;
        for (int i = 0; i < this.segments.length; ++i) {
            if (iElementComparer == null) {
                n += this.segments[i].hashCode();
                continue;
            }
            n += iElementComparer.hashCode(this.segments[i]);
        }
        return n;
    }

    public boolean equals(TreePath treePath, IElementComparer iElementComparer) {
        if (treePath == null) {
            return false;
        }
        if (this.segments.length != treePath.segments.length) {
            return false;
        }
        for (int i = 0; i < this.segments.length; ++i) {
            if (!(iElementComparer == null ? !this.segments[i].equals(treePath.segments[i]) : !iElementComparer.equals(this.segments[i], treePath.segments[i]))) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(TreePath treePath, IElementComparer iElementComparer) {
        int n = this.getSegmentCount();
        int n2 = treePath.getSegmentCount();
        if (n2 == n) {
            return this.equals(treePath, iElementComparer);
        }
        if (n2 > n) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            Object object = treePath.getSegment(i);
            if (!(iElementComparer == null ? !object.equals(this.segments[i]) : !iElementComparer.equals(object, this.segments[i]))) continue;
            return false;
        }
        return true;
    }

    public TreePath getParentPath() {
        int n = this.getSegmentCount();
        if (n < 1) {
            return null;
        }
        if (n == 1) {
            return EMPTY;
        }
        Object[] objectArray = new Object[n - 1];
        System.arraycopy(this.segments, 0, objectArray, 0, n - 1);
        return new TreePath(objectArray);
    }

    public TreePath createChildPath(Object object) {
        int n = this.getSegmentCount();
        Object[] objectArray = new Object[n + 1];
        if (n > 0) {
            System.arraycopy(this.segments, 0, objectArray, 0, n);
        }
        objectArray[n] = object;
        return new TreePath(objectArray);
    }
}

