/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IInputSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;

public abstract class Viewer
implements IInputSelectionProvider {
    private ListenerList selectionChangedListeners = new ListenerList();
    private ListenerList helpListeners = new ListenerList();
    private String[] keys;
    private Object[] values;
    private boolean helpHooked = false;
    private HelpListener helpListener = null;
    protected static final String WIDGET_DATA_KEY = "org.eclipse.jface.viewers.WIDGET_DATA";

    protected Viewer() {
    }

    public void addHelpListener(HelpListener helpListener) {
        Control control;
        this.helpListeners.add(helpListener);
        if (!this.helpHooked && (control = this.getControl()) != null && !control.isDisposed()) {
            if (this.helpListener == null) {
                this.helpListener = new HelpListener(){

                    public void helpRequested(HelpEvent helpEvent) {
                        Viewer.this.handleHelpRequest(helpEvent);
                    }
                };
            }
            control.addHelpListener(this.helpListener);
            this.helpHooked = true;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionChangedListeners.add(iSelectionChangedListener);
    }

    protected void fireHelpRequested(HelpEvent helpEvent) {
        Object[] objectArray = this.helpListeners.getListeners();
        for (int i = 0; i < objectArray.length; ++i) {
            ((HelpListener)objectArray[i]).helpRequested(helpEvent);
        }
    }

    protected void fireSelectionChanged(final SelectionChangedEvent selectionChangedEvent) {
        Object[] objectArray = this.selectionChangedListeners.getListeners();
        for (int i = 0; i < objectArray.length; ++i) {
            final ISelectionChangedListener iSelectionChangedListener = (ISelectionChangedListener)objectArray[i];
            SafeRunnable.run(new SafeRunnable(){

                public void run() {
                    iSelectionChangedListener.selectionChanged(selectionChangedEvent);
                }
            });
        }
    }

    public abstract Control getControl();

    public Object getData(String string) {
        Assert.isNotNull(string);
        if (this.keys == null) {
            return null;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(string)) continue;
            return this.values[i];
        }
        return null;
    }

    public abstract Object getInput();

    public abstract ISelection getSelection();

    protected void handleHelpRequest(HelpEvent helpEvent) {
        Object object = helpEvent.data;
        helpEvent.data = this;
        this.fireHelpRequested(helpEvent);
        helpEvent.data = object;
    }

    protected void inputChanged(Object object, Object object2) {
    }

    public abstract void refresh();

    public void removeHelpListener(HelpListener helpListener) {
        Control control;
        this.helpListeners.remove(helpListener);
        if (this.helpListeners.size() == 0 && (control = this.getControl()) != null && !control.isDisposed()) {
            control.removeHelpListener(this.helpListener);
            this.helpHooked = false;
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionChangedListeners.remove(iSelectionChangedListener);
    }

    public Item scrollDown(int n, int n2) {
        return null;
    }

    public Item scrollUp(int n, int n2) {
        return null;
    }

    public void setData(String string, Object object) {
        Assert.isNotNull(string);
        if (object == null) {
            int n;
            if (this.keys == null) {
                return;
            }
            for (n = 0; n < this.keys.length && !this.keys[n].equals(string); ++n) {
            }
            if (n == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] stringArray = new String[this.keys.length - 1];
                Object[] objectArray = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, stringArray, 0, n);
                System.arraycopy(this.keys, n + 1, stringArray, n, stringArray.length - n);
                System.arraycopy(this.values, 0, objectArray, 0, n);
                System.arraycopy(this.values, n + 1, objectArray, n, objectArray.length - n);
                this.keys = stringArray;
                this.values = objectArray;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{string};
            this.values = new Object[]{object};
            return;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(string)) continue;
            this.values[i] = object;
            return;
        }
        String[] stringArray = new String[this.keys.length + 1];
        Object[] objectArray = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, stringArray, 0, this.keys.length);
        System.arraycopy(this.values, 0, objectArray, 0, this.values.length);
        stringArray[this.keys.length] = string;
        objectArray[this.values.length] = object;
        this.keys = stringArray;
        this.values = objectArray;
    }

    public abstract void setInput(Object var1);

    public void setSelection(ISelection iSelection) {
        this.setSelection(iSelection, false);
    }

    public abstract void setSelection(ISelection var1, boolean var2);
}

