/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public abstract class ViewerRow
implements Cloneable {
    public static final int ABOVE = 1;
    public static final int BELOW = 2;

    public abstract Rectangle getBounds(int var1);

    public abstract Rectangle getBounds();

    public abstract Widget getItem();

    public abstract int getColumnCount();

    public abstract Image getImage(int var1);

    public abstract void setImage(int var1, Image var2);

    public abstract String getText(int var1);

    public abstract void setText(int var1, String var2);

    public abstract Color getBackground(int var1);

    public abstract void setBackground(int var1, Color var2);

    public abstract Color getForeground(int var1);

    public abstract void setForeground(int var1, Color var2);

    public abstract Font getFont(int var1);

    public abstract void setFont(int var1, Font var2);

    public ViewerCell getCell(Point point) {
        int n = this.getColumnIndex(point);
        return this.getCell(n);
    }

    public int getColumnIndex(Point point) {
        int n = this.getColumnCount();
        if (n == 0) {
            return 0;
        }
        for (int i = 0; i < n; ++i) {
            if (!this.getBounds(i).contains(point)) continue;
            return i;
        }
        return -1;
    }

    public ViewerCell getCell(int n) {
        if (n >= 0) {
            return new ViewerCell((ViewerRow)this.clone(), n, this.getElement());
        }
        return null;
    }

    public abstract Control getControl();

    public abstract ViewerRow getNeighbor(int var1, boolean var2);

    public abstract TreePath getTreePath();

    public abstract Object clone();

    public abstract Object getElement();

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getItem() == null ? 0 : this.getItem().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ViewerRow viewerRow = (ViewerRow)object;
        return !(this.getItem() == null ? viewerRow.getItem() != null : !this.getItem().equals(viewerRow.getItem()));
    }
}

