/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.window;

import java.util.ArrayList;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.jface.window.WindowManager;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public abstract class Window
implements IShellProvider {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private static Image[] defaultImages;
    private static IExceptionHandler exceptionHandler;
    private static int orientation;
    private static IShellProvider defaultModalParent;
    private IShellProvider parentShell;
    private int shellStyle = 1264;
    private WindowManager windowManager;
    private Shell shell;
    private Control contents;
    private int returnCode = 0;
    private boolean block = false;
    private FontChangeListener fontChangeListener;
    private boolean resizeHasOccurred = false;
    private Listener resizeListener;

    protected Window(Shell shell) {
        this(new SameShellProvider((Control)shell));
        if (shell == null) {
            this.setShellStyle(this.getShellStyle() | Window.getDefaultOrientation());
        }
    }

    protected Window(IShellProvider iShellProvider) {
        Assert.isNotNull(iShellProvider);
        this.parentShell = iShellProvider;
    }

    protected boolean canHandleShellCloseEvent() {
        return true;
    }

    public boolean close() {
        if (this.fontChangeListener != null) {
            JFaceResources.getFontRegistry().removeListener(this.fontChangeListener);
            this.fontChangeListener = null;
        }
        if (this.windowManager != null) {
            this.windowManager.remove(this);
            this.windowManager = null;
        }
        if (this.shell == null || this.shell.isDisposed()) {
            return true;
        }
        this.shell.dispose();
        this.shell = null;
        this.contents = null;
        return true;
    }

    protected void configureShell(Shell shell) {
        Object object;
        if (defaultImages != null && defaultImages.length > 0) {
            object = new ArrayList(defaultImages.length);
            for (int i = 0; i < defaultImages.length; ++i) {
                if (defaultImages[i] == null || defaultImages[i].isDisposed()) continue;
                ((ArrayList)object).add(defaultImages[i]);
            }
            if (((ArrayList)object).size() <= 0) {
                System.err.println("Window.configureShell: images disposed");
            } else {
                Image[] imageArray = new Image[((ArrayList)object).size()];
                ((ArrayList)object).toArray(imageArray);
                shell.setImages(imageArray);
            }
        }
        if ((object = this.getLayout()) != null) {
            shell.setLayout((Layout)object);
        }
    }

    protected Layout getLayout() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        return gridLayout;
    }

    protected void constrainShellSize() {
        Rectangle rectangle;
        Rectangle rectangle2 = this.shell.getBounds();
        if (!rectangle2.equals((Object)(rectangle = this.getConstrainedShellBounds(rectangle2)))) {
            this.shell.setBounds(rectangle);
        }
    }

    public void create() {
        this.shell = this.createShell();
        this.contents = this.createContents((Composite)this.shell);
        this.initializeBounds();
    }

    protected Control createContents(Composite composite) {
        return new Composite(composite, 0);
    }

    protected final Shell createShell() {
        Shell shell = this.getParentShell();
        if (shell != null && shell.isDisposed()) {
            this.parentShell = new SameShellProvider(null);
            shell = this.getParentShell();
        }
        Shell shell2 = new Shell(shell, this.getShellStyle());
        this.resizeListener = new Listener(){

            public void handleEvent(Event event) {
                Window.this.resizeHasOccurred = true;
            }
        };
        shell2.addListener(11, this.resizeListener);
        shell2.setData((Object)this);
        shell2.addShellListener(this.getShellListener());
        this.configureShell(shell2);
        if (this.fontChangeListener == null) {
            this.fontChangeListener = new FontChangeListener();
        }
        JFaceResources.getFontRegistry().addListener(this.fontChangeListener);
        return shell2;
    }

    protected Control getContents() {
        return this.contents;
    }

    public static Image getDefaultImage() {
        return defaultImages == null || defaultImages.length < 1 ? null : defaultImages[0];
    }

    public static Image[] getDefaultImages() {
        return defaultImages == null ? new Image[]{} : defaultImages;
    }

    protected Point getInitialLocation(Point point) {
        Composite composite = this.shell.getParent();
        Monitor monitor = this.shell.getDisplay().getPrimaryMonitor();
        if (composite != null) {
            monitor = composite.getMonitor();
        }
        Rectangle rectangle = monitor.getClientArea();
        Point point2 = composite != null ? Geometry.centerPoint(composite.getBounds()) : Geometry.centerPoint(rectangle);
        return new Point(point2.x - point.x / 2, Math.max(rectangle.y, Math.min(point2.y - point.y * 2 / 3, rectangle.y + rectangle.height - point.y)));
    }

    protected Point getInitialSize() {
        return this.shell.computeSize(-1, -1, true);
    }

    private static Shell getModalChild(Shell[] shellArray) {
        int n = 229376;
        for (int i = shellArray.length - 1; i >= 0; --i) {
            Shell shell = shellArray[i];
            Shell[] shellArray2 = shell.getShells();
            Shell shell2 = Window.getModalChild(shellArray2);
            if (shell2 != null) {
                return shell2;
            }
            if (!shell.isVisible() || (shell.getStyle() & n) == 0) continue;
            return shell;
        }
        return null;
    }

    protected Shell getParentShell() {
        Shell shell = this.parentShell.getShell();
        int n = 229376;
        if ((this.getShellStyle() & n) != 0 && shell == null) {
            shell = defaultModalParent.getShell();
        }
        return shell;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public Shell getShell() {
        return this.shell;
    }

    protected ShellListener getShellListener() {
        return new ShellAdapter(){

            public void shellClosed(ShellEvent shellEvent) {
                shellEvent.doit = false;
                if (Window.this.canHandleShellCloseEvent()) {
                    Window.this.handleShellCloseEvent();
                }
            }
        };
    }

    protected int getShellStyle() {
        return this.shellStyle;
    }

    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    protected void handleFontChange(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void handleShellCloseEvent() {
        this.setReturnCode(1);
        this.close();
    }

    protected void initializeBounds() {
        if (this.resizeListener != null) {
            this.shell.removeListener(11, this.resizeListener);
        }
        if (this.resizeHasOccurred) {
            return;
        }
        Point point = this.getInitialSize();
        Point point2 = this.getInitialLocation(point);
        this.shell.setBounds(this.getConstrainedShellBounds(new Rectangle(point2.x, point2.y, point.x, point.y)));
    }

    public int open() {
        if (this.shell == null || this.shell.isDisposed()) {
            this.shell = null;
            this.create();
        }
        this.constrainShellSize();
        this.shell.open();
        if (this.block) {
            this.runEventLoop(this.shell);
        }
        return this.returnCode;
    }

    private void runEventLoop(Shell shell) {
        Display display = this.shell == null ? Display.getCurrent() : shell.getDisplay();
        while (shell != null && !shell.isDisposed()) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Throwable throwable) {
                exceptionHandler.handleException(throwable);
            }
        }
        if (!display.isDisposed()) {
            display.update();
        }
    }

    public void setBlockOnOpen(boolean bl) {
        this.block = bl;
    }

    public static void setDefaultImage(Image image) {
        Image[] imageArray;
        if (image == null) {
            imageArray = null;
        } else {
            Image[] imageArray2 = new Image[1];
            imageArray = imageArray2;
            imageArray2[0] = image;
        }
        defaultImages = imageArray;
    }

    public static void setDefaultImages(Image[] imageArray) {
        Image[] imageArray2 = new Image[imageArray.length];
        System.arraycopy(imageArray, 0, imageArray2, 0, imageArray2.length);
        defaultImages = imageArray2;
    }

    protected void setParentShell(Shell shell) {
        Assert.isTrue(this.shell == null, "There must not be an existing shell.");
        this.parentShell = new SameShellProvider((Control)shell);
    }

    protected void setReturnCode(int n) {
        this.returnCode = n;
    }

    private static Monitor getClosestMonitor(Display display, Point point) {
        int n = Integer.MAX_VALUE;
        Monitor[] monitorArray = display.getMonitors();
        Monitor monitor = monitorArray[0];
        for (int i = 0; i < monitorArray.length; ++i) {
            Monitor monitor2 = monitorArray[i];
            Rectangle rectangle = monitor2.getClientArea();
            if (rectangle.contains(point)) {
                return monitor2;
            }
            int n2 = Geometry.distanceSquared(Geometry.centerPoint(rectangle), point);
            if (n2 >= n) continue;
            n = n2;
            monitor = monitor2;
        }
        return monitor;
    }

    protected Rectangle getConstrainedShellBounds(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Monitor monitor = Window.getClosestMonitor(this.getShell().getDisplay(), Geometry.centerPoint(rectangle2));
        Rectangle rectangle3 = monitor.getClientArea();
        if (rectangle2.height > rectangle3.height) {
            rectangle2.height = rectangle3.height;
        }
        if (rectangle2.width > rectangle3.width) {
            rectangle2.width = rectangle3.width;
        }
        rectangle2.x = Math.max(rectangle3.x, Math.min(rectangle2.x, rectangle3.x + rectangle3.width - rectangle2.width));
        rectangle2.y = Math.max(rectangle3.y, Math.min(rectangle2.y, rectangle3.y + rectangle3.height - rectangle2.height));
        return rectangle2;
    }

    protected void setShellStyle(int n) {
        this.shellStyle = n;
    }

    public void setWindowManager(WindowManager windowManager) {
        this.windowManager = windowManager;
        if (windowManager != null) {
            Window[] windowArray = windowManager.getWindows();
            for (int i = 0; i < windowArray.length; ++i) {
                if (windowArray[i] != this) continue;
                return;
            }
            windowManager.add(this);
        }
    }

    public static void setExceptionHandler(IExceptionHandler iExceptionHandler) {
        if (exceptionHandler instanceof DefaultExceptionHandler) {
            exceptionHandler = iExceptionHandler;
        }
    }

    public static void setDefaultModalParent(IShellProvider iShellProvider) {
        defaultModalParent = iShellProvider;
    }

    public static int getDefaultOrientation() {
        return orientation;
    }

    public static void setDefaultOrientation(int n) {
        orientation = n;
    }

    static {
        exceptionHandler = new DefaultExceptionHandler();
        orientation = 0;
        defaultModalParent = new IShellProvider(){

            public Shell getShell() {
                Display display = Display.getCurrent();
                if (display == null) {
                    return null;
                }
                Shell shell = display.getActiveShell();
                if (shell == null) {
                    shell = Window.getModalChild(Display.getCurrent().getShells());
                } else {
                    Shell shell2 = Window.getModalChild(shell.getShells());
                    if (shell2 != null) {
                        shell = shell2;
                    }
                }
                return shell;
            }
        };
    }

    private static class DefaultExceptionHandler
    implements IExceptionHandler {
        private DefaultExceptionHandler() {
        }

        public void handleException(Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            throwable.printStackTrace();
        }
    }

    private class FontChangeListener
    implements IPropertyChangeListener {
        private FontChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Window.this.handleFontChange(propertyChangeEvent);
        }
    }

    public static interface IExceptionHandler {
        public void handleException(Throwable var1);
    }
}

