#include "plugins.h"

#define MASK555 0x3DEF
#define MASK565 0x7BEF

unsigned short MASK;

void Init(HWND Parent, char Is555,char Is32bit,char Rotated)
{
    if(Is555)
        MASK=MASK555;
    else
        MASK=MASK565;
}

unsigned int SetWidth(unsigned short width)
{
    return 2*width;
}

unsigned int SetHeight(unsigned short height)
{
    return 2*height;
}

void Blit(unsigned short width,unsigned short height,unsigned short *src,unsigned int srcpitch,unsigned short *dst,unsigned int dstpitch,unsigned int *palette32)
{
    int j;
    unsigned short *lines=src;
    unsigned short *lined=dst;
    for(j=0;j<height*2;++j)
    {
        unsigned short *pixels=lines;
        unsigned short *pixeld=lined;

        //Draw the lines in 2 passes, it's faster than drawing
        //both lines (normal,50%) in 1 pass as this way you
        //avoid the video mem address select latency
        if(j&1)
        {
            register int i;
            for(i=0;i<width;++i)
            {
                register unsigned short pixel=*pixels;
                pixeld[0]=pixel;
                pixeld[1]=pixel;
                pixeld+=2;
                ++pixels;
            }
        }
        else
        {
            register int i;
            register unsigned short M=MASK;
            for(i=0;i<width;++i)
            {
                register unsigned short pixel=*pixels;
                pixeld[0]=(pixel>>1)&M;
                pixeld[1]=(pixel>>1)&M;
                pixeld+=2;
                ++pixels;
            }
            lines+=srcpitch;
        }
        lined+=dstpitch/2;
    }
}

void Configure(HINSTANCE Handler,HWND Parent)
{

}

void Terminate()
{

}

struct _PluginInfo PluginInfo=
{
    PLUGINVER,
    VIDEOPLUGIN,
    "Unfiltered Scanlines 50%",
    "ElSemi",
    "http://nebula.emulatronia.com",
    1,
    0,
	//VideoInterface
    SUPPORTS16BIT,
	Init,
	SetWidth,
	SetHeight,
	Blit,
    NULL,
    Terminate
};


struct _PluginInfo __declspec(dllexport) * __cdecl GetInterface()
{
	return &PluginInfo;
}
