#ifndef PLUGIN_H
#define PLUGIN_H

#include "windows.h"

/*
    Nebula & Kawaks plugins specifications.

	Aprin 4th 2002.	Added MMXONLY flag
					Added Terminate() function.
					Renamed SetWidth/SetHeight to GetWidth/GetHeight
					Removed srcpitch from GetWidth

	April 3rd 2002. Initial

    Plugin DLL Exports:

    struct _PluginInfo _cdecl *GetInterface();



*/

#define PLUGINVER   0x100

//Plugin Types
#define VIDEOPLUGIN     0x1
#define INPUTPLUGIN     0x2 //unused
#define DSPPLUGIN       0x4 

//VideoCaps
#define SUPPORTS16BIT   0x1
#define SUPPORTS32BIT   0x2
#define SUPPORTSROTATE  0x4
#define MMXONLY			0x8

struct _VideoPlugin
{
    unsigned int VideoCaps;                         //Plugin capabilities
    void (__cdecl *Init)(                           //Plugin Init, called when plugin/res change
                  HWND Parent,						//Emulator Window
				  char Is555,                       //The source data will be 555 (otherwise it will be 565)
                  char Is32bit,                     //The destination surface is 32 bits, additional transformations will be needed
                  char Rotated                      //The draw must be performed rotated
                );

    unsigned int (__cdecl *GetWidth)(               //Tells the plugin about the source width. It must return the
                                                    //width of the transformed frame (width*1,width*2 are usual values)
                           unsigned short width     //Original Width
                         );

    unsigned int (__cdecl *GetHeight)(              //Tells the plugin about the source height. It must return the
                                                    //height of the transformed frame (height*1,height*2 are usual values)
                            unsigned short height	//Original Height
                          );

    void (__cdecl *Blit)(                           //Perform the blit/transform operation
               unsigned short width,
               unsigned short height,               //Width and height of the frame (must be the same set by SetWidth/Height)
               unsigned short *src,                 //Source data (16 bit  555 or 565)
               unsigned int srcpitch,               //Pitch of the source surface (in words)
               unsigned short *dst,                 //Destination surface (unsigned int * if 32 bit)
               unsigned int dstpitch,               //Pitch of the destination surface (in bytes)
			   unsigned int *palette32				//16->32 bit lookup table
             );

    void (__cdecl *Configure)(                      //Configure Plugin
                    HINSTANCE Handler,              //DLL instance handler
                    HWND Parent                     //Handle of the emulator window (Parent)
                  );

	void (__cdecl *Terminate)();					//Shutdown plugin.
};

struct _AudioPlugin
{
	void (__cdecl *Init)(HWND Parent, unsigned int SampleRate,unsigned int FrameLen);

    unsigned int (__cdecl *DoSamples)(signed short *Left,signed short *Right,unsigned int FrameLen);
                        

	void (__cdecl *Configure)(                      //Configure Plugin
                    HINSTANCE Handler,              //DLL instance handler
                    HWND Parent                     //Handle of the emulator window (Parent)
                  );


	void (__cdecl *Terminate)();
};

struct _PluginInfo
{
    unsigned short Ver;     //Interface version (=PLUGINVER)
    unsigned short Type;    //Plugin Type
    char *Name;				//Plugin Name
    char *Author;
	char *URL;
    unsigned short Major;   //Plugin Version
    unsigned short Minor;
    struct _VideoPlugin VideoInterface;
	struct _AudioPlugin AudioInterface;	
};

#endif




