/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoAttributes;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoThroughput;
import com.sap.conn.jco.rt.ClientConnectionState;
import com.sap.conn.jco.rt.ConnectionAttributes;
import com.sap.conn.jco.rt.DefaultThroughput;
import com.sap.conn.jco.rt.MonitoredConnectionData;
import com.sap.conn.jco.util.Dsr;
import com.sap.conn.jco.util.Jarm;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import java.util.Properties;

public abstract class AbstractConnection
implements Cloneable,
ConnectionAttributes.CPICBasedConnection {
    public static final byte STATE_CONNECTED = 2;
    public static final byte STATE_BUSY = 4;
    protected Properties properties;
    protected ConnectionAttributes attributes = new ConnectionAttributes(this);
    protected byte[] passport_bytes = null;
    protected RfcIoOpenCntl rfcHandle = null;
    protected byte state = 0;
    protected long last_active_timestamp = System.currentTimeMillis();
    protected DefaultThroughput throughput;
    protected Jarm.Monitor jarm_monitor;
    protected Dsr dsr_monitor;
    protected long start_time;
    protected long time_handle_request;
    protected long time_total;
    protected long num_sent_bytes;
    protected long num_received_bytes;
    protected long time_middleware;
    protected String rfm_name;
    protected String sessionId;
    protected int callCounter;
    long threadId;
    String threadName;
    String threadAction;

    protected AbstractConnection() {
        Thread currentThread = Thread.currentThread();
        this.threadId = currentThread.getId();
        this.threadName = currentThread.getName();
        this.callCounter = 0;
    }

    protected long getConnectionHandle() {
        return this.rfcHandle != null ? this.rfcHandle.hrfc : 0L;
    }

    public String getConversationID() {
        if (this.rfcHandle != null) {
            return this.rfcHandle.getCPICConversationID();
        }
        return "";
    }

    public synchronized AbstractConnection clone() {
        try {
            AbstractConnection conn = (AbstractConnection)super.clone();
            conn.properties = this.properties;
            this.rfcHandle = null;
            conn.last_active_timestamp = System.currentTimeMillis();
            return conn;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    protected synchronized AbstractConnection hideConnection() {
        try {
            AbstractConnection conn = (AbstractConnection)super.clone();
            conn.last_active_timestamp = System.currentTimeMillis();
            conn.rfcHandle = this.rfcHandle;
            conn.state = this.state;
            this.rfcHandle = null;
            return conn;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    protected Properties getProperties() {
        return this.properties;
    }

    public boolean isValid() {
        return this.rfcHandle != null && this.rfcHandle.hrfc > 0L;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    protected byte getState() {
        return this.state;
    }

    protected void setState(byte state) {
        this.state = state;
    }

    public final JCoThroughput getThroughput() {
        return this.throughput;
    }

    public final void setThroughput(DefaultThroughput throughput) {
        this.throughput = throughput;
    }

    public JCoAttributes getAttributes() throws JCoException {
        return this.attributes;
    }

    abstract void disconnect() throws JCoException;

    abstract void abort(String var1) throws JCoException;

    public abstract boolean isAlive() throws JCoException;

    void restore(ClientConnectionState aState) throws JCoException {
        this.state = aState.getState();
        this.throughput = aState.getThroughput();
        this.last_active_timestamp = aState.getLastActiveTimestamp();
        this.callCounter = aState.getCallCounter();
    }

    ClientConnectionState store(ClientConnectionState aState) throws JCoException {
        aState.setState(this.state);
        aState.setLastActiveTimestamp(this.last_active_timestamp);
        aState.setThroughput(this.throughput);
        aState.setCallCounter(this.callCounter);
        return aState;
    }

    MonitoredConnectionData getMonitoredData() {
        MonitoredConnectionData md = new MonitoredConnectionData();
        md.abapClient = this.attributes.client != null ? this.attributes.client : "";
        md.abapHost = this.attributes.partner_host != null ? this.attributes.partner_host : "";
        md.abapSID = this.attributes.sysid != null ? this.attributes.sysid : "";
        md.abapUser = this.attributes.user != null ? this.attributes.user : "";
        String string = md.abapLanguage = this.attributes.ISO_language != null ? this.attributes.ISO_language : "";
        if ((this.state & 4) != 0) {
            md.state = 1;
        }
        if (this.sessionId != null) {
            md.state |= 2;
        }
        md.convId = this.getConversationID();
        md.dsrPassport = this.passport_bytes;
        md.function = this.rfm_name != null ? this.rfm_name : "";
        md.sessionId = this.getSessionId();
        if (md.sessionId == null) {
            md.sessionId = "";
        }
        md.lastTimestamp = this.last_active_timestamp;
        md.threadId = this.threadId;
        md.threadName = this.threadName;
        md.rfcHandle = this.getConnectionHandle();
        return md;
    }
}

