/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.ConversionException;
import com.sap.conn.jco.JCoExtendedFieldMetaData;
import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFieldIterator;
import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.JCoMetaData;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoRecord;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoRequest;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.DefaultFieldIterator;
import com.sap.conn.jco.rt.DefaultParameterList;
import com.sap.conn.jco.rt.DefaultStructure;
import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.XMLWriter;
import com.sap.conn.jco.util.FastStringBuffer;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractRequestResponse
implements JCoRecord,
Cloneable {
    private static final long serialVersionUID = 20050909001L;
    String name;
    private int type;
    private JCoParameterList oneway;
    private JCoParameterList changing;
    private JCoParameterList tables;
    private AbapException[] exceptions;
    private JCoListMetaData fullList = null;
    private HashMap<String, Integer> hashOfIndices = null;
    int size = 0;
    protected JCoParameterList[] mapList;
    protected int[] mapIndex;

    protected AbstractRequestResponse(String name, int type, JCoParameterList oneway, JCoParameterList changing, JCoParameterList tables, AbapException[] exceptions) {
        this.name = name;
        this.type = type;
        int changingOffset = 0;
        int tablesOffset = 0;
        this.oneway = oneway;
        this.changing = changing;
        this.tables = tables;
        this.exceptions = exceptions;
        changingOffset = oneway == null ? 0 : oneway.getListMetaData().getFieldCount();
        tablesOffset = changingOffset + (changing == null ? 0 : changing.getListMetaData().getFieldCount());
        this.size = tablesOffset + (tables == null ? 0 : tables.getListMetaData().getFieldCount());
        this.mapList = new JCoParameterList[this.size];
        this.mapIndex = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            if (i < changingOffset) {
                this.mapList[i] = oneway;
                this.mapIndex[i] = i;
                continue;
            }
            if (i < tablesOffset) {
                this.mapList[i] = changing;
                this.mapIndex[i] = i - changingOffset;
                continue;
            }
            this.mapList[i] = tables;
            this.mapIndex[i] = i - tablesOffset;
        }
    }

    int getMappedIndex(int index) {
        return this.mapIndex[index];
    }

    JCoParameterList getMappedList(int index) {
        return this.mapList[index];
    }

    protected final void checkIndex(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException(new FastStringBuffer(150).append("Index [").append(index).append("] out of bounds.").append(this.name).append(" has").append(this.size).append(" fields.").toString());
        }
    }

    protected final void rebuildIndicies() {
        if (this.hashOfIndices == null || this.hashOfIndices.size() < this.size) {
            int hashMapSize = this.size < 4 ? 5 : (this.size < 8 ? 11 : (this.size < 21 ? 29 : (this.size < 35 ? 47 : 89)));
            HashMap<String, Integer> indices = new HashMap<String, Integer>(hashMapSize);
            int i = this.size;
            while (--i >= 0) {
                indices.put(this.mapList[i].getMetaData().getName(this.mapIndex[i]), new Integer(i));
            }
            this.hashOfIndices = indices;
        }
    }

    @Override
    public Object clone() {
        AbstractRequestResponse clone = null;
        try {
            clone = (AbstractRequestResponse)super.clone();
            clone.name = this.name;
            clone.type = this.type;
            clone.size = this.size;
            if (this.oneway != null) {
                clone.oneway = (JCoParameterList)this.oneway.clone();
            }
            if (this.changing != null) {
                clone.changing = (JCoParameterList)this.changing.clone();
            }
            if (this.tables != null) {
                clone.tables = (JCoParameterList)this.tables.clone();
            }
            if (this.exceptions != null) {
                clone.exceptions = this.exceptions;
            }
            if (this.hashOfIndices != null) {
                clone.hashOfIndices = (HashMap)this.hashOfIndices.clone();
            }
            clone.mapIndex = (int[])this.mapIndex.clone();
            clone.mapList = (JCoParameterList[])this.mapList.clone();
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractRequestResponse) {
            boolean equals;
            AbstractRequestResponse r = (AbstractRequestResponse)obj;
            boolean bl = this.oneway != null ? this.oneway.equals(r.oneway) : (equals = r.oneway == null);
            if (equals) {
                boolean bl2 = this.changing != null ? this.changing.equals(r.changing) : (equals = r.changing == null);
            }
            if (equals) {
                equals = this.tables != null ? this.tables.equals(r.tables) : r.tables == null;
            }
            return equals;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.name.hashCode();
        if (this.oneway != null) {
            hashCode = 31 * hashCode + this.oneway.hashCode();
        }
        if (this.changing != null) {
            hashCode = 31 * hashCode + this.changing.hashCode();
        }
        if (this.tables != null) {
            hashCode = 31 * hashCode + this.tables.hashCode();
        }
        return hashCode;
    }

    public String getName() {
        return this.name;
    }

    public final int indexOf(String fieldName) {
        this.rebuildIndicies();
        Integer idx = this.hashOfIndices.get(fieldName);
        if (idx != null) {
            return idx;
        }
        throw new IllegalArgumentException(new FastStringBuffer(150).append("Field ").append(fieldName).append(" not a member of ").append(this instanceof JCoRequest ? "Request" : "Response").toString());
    }

    public JCoListMetaData getListMetaData() {
        if (this.fullList == null) {
            this.fullList = new ResponseRequestMetadata();
        }
        return this.fullList;
    }

    @Override
    public JCoMetaData getMetaData() {
        return this.getListMetaData();
    }

    public boolean isActive(int index) {
        this.checkIndex(index);
        return this.mapList[index].isActive(this.mapIndex[index]);
    }

    public boolean isActive(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].isActive(this.mapIndex[index]);
    }

    public void setActive(int index, boolean active) {
        this.checkIndex(index);
        this.mapList[index].setActive(this.mapIndex[index], active);
    }

    public void setActive(String fieldName, boolean active) {
        int index = this.indexOf(fieldName);
        this.mapList[index].setActive(this.mapIndex[index], active);
    }

    @Override
    public void clear() {
        if (this.oneway != null) {
            this.oneway.clear();
        }
        if (this.changing != null) {
            this.changing.clear();
        }
        if (this.tables != null) {
            this.tables.clear();
        }
    }

    @Override
    public int copyFrom(JCoRecord source) {
        if (source == null) {
            return 0;
        }
        JCoMetaData smd = source.getMetaData();
        JCoMetaData dmd = this.getMetaData();
        if (source instanceof AbstractRequestResponse) {
            AbstractRequestResponse sourceRR = (AbstractRequestResponse)source;
            if (smd.equals(dmd)) {
                if (this.oneway != null) {
                    this.oneway.copyFrom(sourceRR.oneway);
                }
                if (this.changing != null) {
                    this.changing.copyFrom(sourceRR.changing);
                }
                if (this.tables != null) {
                    this.tables.copyFrom(sourceRR.tables);
                }
            }
            return smd.getFieldCount();
        }
        char[] onewayDataSave = null;
        char[][] onewayTableDataRowsSave = null;
        Object[] onewayOdataSave = null;
        byte[] onewayOpcodeSave = null;
        byte[] onewayFlagsSave = null;
        if (this.oneway != null) {
            onewayDataSave = ((DefaultParameterList)this.oneway).data;
            onewayTableDataRowsSave = ((DefaultParameterList)this.oneway).tableDataRows;
            onewayOdataSave = ((DefaultParameterList)this.oneway).odata;
            onewayOpcodeSave = ((DefaultParameterList)this.oneway).opcode;
            onewayFlagsSave = ((DefaultParameterList)this.oneway).flags;
        }
        char[] changingDataSave = null;
        char[][] changingTableDataRowsSave = null;
        Object[] changingOdataSave = null;
        byte[] changingOpcodeSave = null;
        byte[] changingFlagsSave = null;
        if (this.changing != null) {
            changingDataSave = ((DefaultParameterList)this.changing).data;
            changingTableDataRowsSave = ((DefaultParameterList)this.changing).tableDataRows;
            changingOdataSave = ((DefaultParameterList)this.changing).odata;
            changingOpcodeSave = ((DefaultParameterList)this.changing).opcode;
            changingFlagsSave = ((DefaultParameterList)this.changing).flags;
        }
        char[] tablesDataSave = null;
        char[][] tablesTableDataRowsSave = null;
        Object[] tablesOdataSave = null;
        byte[] tablesOpcodeSave = null;
        byte[] tablesFlagsSave = null;
        if (this.tables != null) {
            tablesDataSave = ((DefaultParameterList)this.tables).data;
            tablesTableDataRowsSave = ((DefaultParameterList)this.tables).tableDataRows;
            tablesOdataSave = ((DefaultParameterList)this.tables).odata;
            tablesOpcodeSave = ((DefaultParameterList)this.tables).opcode;
            tablesFlagsSave = ((DefaultParameterList)this.tables).flags;
        }
        try {
            int didx = 0;
            int sidx = 0;
            int copied = 0;
            block8: for (sidx = 0; sidx < smd.getFieldCount(); ++sidx) {
                String fieldName = smd.getName(sidx);
                didx = this.indexOf(fieldName);
                if (dmd.getType(didx) != smd.getType(sidx) || dmd.getRecordTypeName(didx) != null && !dmd.getRecordTypeName(didx).equals(smd.getRecordTypeName(sidx))) continue;
                ++copied;
                switch (dmd.getType(didx)) {
                    case 0: 
                    case 2: 
                    case 6: 
                    case 29: {
                        this.setValue(didx, source.getString(sidx));
                        continue block8;
                    }
                    case 4: 
                    case 30: {
                        this.setValue(didx, source.getByteArray(sidx));
                        continue block8;
                    }
                    case 17: {
                        JCoStructure s = source.getStructure(sidx);
                        this.setValue(didx, (JCoStructure)(s == null ? s : ((DefaultStructure)s).clone()));
                        continue block8;
                    }
                    case 99: {
                        JCoTable t = source.getTable(sidx);
                        this.setValue(didx, (JCoTable)(t == null ? t : ((DefaultTable)t).clone()));
                        continue block8;
                    }
                    default: {
                        this.setValue(didx, source.getValue(sidx));
                    }
                }
            }
            return copied;
        }
        catch (Throwable t) {
            if (this.oneway != null) {
                ((DefaultParameterList)this.oneway).data = onewayDataSave;
                ((DefaultParameterList)this.oneway).tableDataRows = onewayTableDataRowsSave;
                ((DefaultParameterList)this.oneway).odata = onewayOdataSave;
                ((DefaultParameterList)this.oneway).opcode = onewayOpcodeSave;
                ((DefaultParameterList)this.oneway).flags = onewayFlagsSave;
            }
            if (this.changing != null) {
                ((DefaultParameterList)this.changing).data = changingDataSave;
                ((DefaultParameterList)this.changing).tableDataRows = changingTableDataRowsSave;
                ((DefaultParameterList)this.changing).odata = changingOdataSave;
                ((DefaultParameterList)this.changing).opcode = changingOpcodeSave;
                ((DefaultParameterList)this.changing).flags = changingFlagsSave;
            }
            if (this.tables != null) {
                ((DefaultParameterList)this.tables).data = tablesDataSave;
                ((DefaultParameterList)this.tables).tableDataRows = tablesTableDataRowsSave;
                ((DefaultParameterList)this.tables).odata = tablesOdataSave;
                ((DefaultParameterList)this.tables).opcode = tablesOpcodeSave;
                ((DefaultParameterList)this.tables).flags = tablesFlagsSave;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new JCoRuntimeException(108, "JCO_ERROR_INTERNAL", "Throwable in Request/Response copyFrom: " + t.toString(), t);
        }
    }

    @Override
    public int getFieldCount() {
        return this.size;
    }

    protected String dumpContent() {
        DefaultParameterList dump;
        FastStringBuffer buf = new FastStringBuffer();
        if (this.oneway != null) {
            if (this.oneway instanceof DefaultParameterList) {
                dump = (DefaultParameterList)this.oneway;
            } else {
                dump = new DefaultParameterList(this.oneway.getListMetaData());
                dump.copyFrom(this.oneway);
            }
            buf.append(dump.dumpContent());
        }
        if (this.changing != null) {
            if (this.changing instanceof DefaultParameterList) {
                dump = (DefaultParameterList)this.changing;
            } else {
                dump = new DefaultParameterList(this.changing.getListMetaData());
                dump.copyFrom(this.changing);
            }
            buf.append(dump.dumpContent());
        }
        if (this.tables != null) {
            if (this.tables instanceof DefaultParameterList) {
                dump = (DefaultParameterList)this.tables;
            } else {
                dump = new DefaultParameterList(this.tables.getListMetaData());
                dump.copyFrom(this.tables);
            }
            buf.append(dump.dumpContent());
        }
        return buf.toString();
    }

    @Override
    public Object getValue(int index) {
        this.checkIndex(index);
        return this.mapList[index].getValue(this.mapIndex[index]);
    }

    @Override
    public String getString(int index) {
        this.checkIndex(index);
        return this.mapList[index].getString(this.mapIndex[index]);
    }

    @Override
    public char getChar(int index) {
        this.checkIndex(index);
        return this.mapList[index].getChar(this.mapIndex[index]);
    }

    @Override
    public byte getByte(int index) {
        this.checkIndex(index);
        return this.mapList[index].getByte(this.mapIndex[index]);
    }

    @Override
    public byte getByte(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getByte(this.mapIndex[index]);
    }

    @Override
    public float getFloat(int index) {
        this.checkIndex(index);
        return this.mapList[index].getFloat(this.mapIndex[index]);
    }

    @Override
    public float getFloat(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getFloat(this.mapIndex[index]);
    }

    @Override
    public short getShort(int index) {
        this.checkIndex(index);
        return this.mapList[index].getShort(this.mapIndex[index]);
    }

    @Override
    public int getInt(int index) {
        this.checkIndex(index);
        return this.mapList[index].getInt(this.mapIndex[index]);
    }

    @Override
    public long getLong(int index) {
        this.checkIndex(index);
        return this.mapList[index].getLong(this.mapIndex[index]);
    }

    @Override
    public BigInteger getBigInteger(int index) {
        this.checkIndex(index);
        return this.mapList[index].getBigInteger(this.mapIndex[index]);
    }

    @Override
    public double getDouble(int index) {
        this.checkIndex(index);
        return this.mapList[index].getDouble(this.mapIndex[index]);
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        this.checkIndex(index);
        return this.mapList[index].getBigDecimal(this.mapIndex[index]);
    }

    @Override
    public Date getDate(int index) {
        this.checkIndex(index);
        return this.mapList[index].getDate(this.mapIndex[index]);
    }

    @Override
    public Date getTime(int index) {
        this.checkIndex(index);
        return this.mapList[index].getTime(this.mapIndex[index]);
    }

    @Override
    public byte[] getByteArray(int index) {
        this.checkIndex(index);
        return this.mapList[index].getByteArray(this.mapIndex[index]);
    }

    @Override
    public char[] getCharArray(int index) {
        this.checkIndex(index);
        return this.mapList[index].getCharArray(this.mapIndex[index]);
    }

    @Override
    public InputStream getBinaryStream(int index) {
        this.checkIndex(index);
        return this.mapList[index].getBinaryStream(this.mapIndex[index]);
    }

    @Override
    public Reader getCharacterStream(int index) {
        this.checkIndex(index);
        return this.mapList[index].getCharacterStream(this.mapIndex[index]);
    }

    @Override
    public JCoTable getTable(int index) {
        this.checkIndex(index);
        return this.mapList[index].getTable(this.mapIndex[index]);
    }

    @Override
    public JCoStructure getStructure(int index) {
        this.checkIndex(index);
        return this.mapList[index].getStructure(this.mapIndex[index]);
    }

    @Override
    public String toXML(int index) {
        this.checkIndex(index);
        return this.mapList[index].toXML(this.mapIndex[index]);
    }

    @Override
    public String toXML(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getString(this.mapIndex[index]);
    }

    @Override
    public String toXML() {
        return XMLWriter.createXMLDocument(this, this.name);
    }

    @Override
    public void setValue(int index, String value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public String getClassNameOfValue(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getClassNameOfValue(fieldName);
    }

    @Override
    public Object getValue(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getValue(this.mapIndex[index]);
    }

    @Override
    public String getString(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getString(this.mapIndex[index]);
    }

    @Override
    public char getChar(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getChar(this.mapIndex[index]);
    }

    @Override
    public short getShort(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getShort(this.mapIndex[index]);
    }

    @Override
    public int getInt(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getInt(this.mapIndex[index]);
    }

    @Override
    public long getLong(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getLong(this.mapIndex[index]);
    }

    @Override
    public BigInteger getBigInteger(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getBigInteger(this.mapIndex[index]);
    }

    @Override
    public double getDouble(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getDouble(this.mapIndex[index]);
    }

    @Override
    public BigDecimal getBigDecimal(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getBigDecimal(this.mapIndex[index]);
    }

    @Override
    public Date getDate(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getDate(this.mapIndex[index]);
    }

    @Override
    public Date getTime(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getTime(this.mapIndex[index]);
    }

    @Override
    public byte[] getByteArray(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getByteArray(this.mapIndex[index]);
    }

    @Override
    public char[] getCharArray(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getCharArray(this.mapIndex[index]);
    }

    @Override
    public InputStream getBinaryStream(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getBinaryStream(this.mapIndex[index]);
    }

    @Override
    public Reader getCharacterStream(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getCharacterStream(this.mapIndex[index]);
    }

    @Override
    public JCoTable getTable(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getTable(this.mapIndex[index]);
    }

    @Override
    public JCoStructure getStructure(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getStructure(this.mapIndex[index]);
    }

    @Override
    public void setValue(int index, char value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public void setValue(int index, char[] value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public void setValue(int index, char[] value, int from, int length) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value, from, length);
    }

    @Override
    public void setValue(int index, short value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public void setValue(int index, int value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public void setValue(int index, long value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public void setValue(int index, double value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public void setValue(int index, byte[] value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public void setValue(int index, JCoStructure value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public void setValue(int index, JCoTable value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public void setValue(int index, Object value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public void setValue(String name, String value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public void setValue(String name, char[] value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public void setValue(String name, char[] value, int from, int length) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value, from, length);
    }

    @Override
    public void setValue(String name, char value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public void setValue(String name, short value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public void setValue(String name, int value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public void setValue(String name, long value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public void setValue(String name, double value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public void setValue(int index, float value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public void setValue(String name, float value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public void setValue(int index, BigDecimal value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public void setValue(String name, BigDecimal value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public void setValue(int index, byte value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public void setValue(String name, byte value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public void setValue(String name, byte[] value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public void setValue(String name, JCoStructure value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public void setValue(String name, JCoTable value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public void setValue(String name, Object value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    @Override
    public boolean isInitialized(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].isInitialized(this.mapIndex[index]);
    }

    @Override
    public boolean isInitialized(int index) {
        this.checkIndex(index);
        return this.mapList[index].isInitialized(this.mapIndex[index]);
    }

    @Override
    public Iterator<JCoField> iterator() {
        return new DefaultFieldIterator(this);
    }

    @Override
    public JCoFieldIterator getFieldIterator() {
        return new DefaultFieldIterator(this);
    }

    public AbapException[] getExceptionList() {
        return this.exceptions;
    }

    public AbapException getException(String key) {
        if (this.exceptions == null) {
            return null;
        }
        for (int i = 0; i < this.exceptions.length; ++i) {
            if (!this.exceptions[i].getKey().equalsIgnoreCase(key)) continue;
            AbapException ex = this.exceptions[i];
            return new AbapException(ex.getKey(), ex.getMessage() == null ? ex.getKey() : ex.getMessage());
        }
        return null;
    }

    public String toString() {
        int rIdx;
        AbstractRecord r;
        int i;
        int length;
        int index;
        JCoListMetaData metaData = this.getListMetaData();
        FastStringBuffer buf = new FastStringBuffer(200);
        int ilength = 0;
        buf.append('|');
        for (index = 0; index < this.size; ++index) {
            switch (metaData.getType(index)) {
                case 17: 
                case 29: 
                case 30: 
                case 99: {
                    length = metaData.getName(index).length();
                    for (i = 0; i < length; ++i) {
                        buf.append('-');
                    }
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    ilength = ((AbstractRecord)((Object)this.mapList[index])).metaData.blength[index];
                    for (i = 0; i < ilength; ++i) {
                        buf.append("----");
                    }
                    break;
                }
                default: {
                    ilength = ((AbstractRecord)((Object)this.mapList[index])).metaData.blength[index];
                    for (i = 0; i < ilength; ++i) {
                        buf.append('-');
                    }
                }
            }
            buf.append('|');
        }
        String lineString = buf.toString();
        buf.append(JCoRuntime.CRLF);
        buf.append("|");
        buf.append(this.name.toUpperCase());
        buf.append(JCoRuntime.CRLF);
        buf.append(lineString);
        buf.append(JCoRuntime.CRLF);
        for (index = 0; index < this.size; ++index) {
            String iname = metaData.getName(index);
            switch (metaData.getType(index)) {
                case 17: 
                case 29: 
                case 30: 
                case 99: {
                    ilength = iname.length();
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    ilength = ((AbstractRecord)((Object)this.mapList[index])).metaData.blength[index] * 4;
                    break;
                }
                default: {
                    ilength = ((AbstractRecord)((Object)this.mapList[index])).metaData.blength[index];
                }
            }
            if (iname.length() > ilength) {
                iname = iname.substring(0, ilength);
            }
            buf.append("|");
            buf.append(iname);
            length = ilength;
            for (i = iname.length(); i < length; ++i) {
                buf.append(' ');
            }
        }
        buf.append("|" + JCoRuntime.CRLF);
        buf.append(lineString);
        buf.append(JCoRuntime.CRLF);
        buf.append('|');
        for (index = 0; index < this.size; ++index) {
            switch (metaData.getType(index)) {
                case 17: 
                case 29: 
                case 30: 
                case 99: {
                    length = metaData.getName(index).length();
                    for (i = 0; i < length; ++i) {
                        buf.append(' ');
                    }
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    r = (AbstractRecord)((Object)this.mapList[index]);
                    rIdx = this.mapIndex[index];
                    length = r.metaData.boffset[rIdx] + r.metaData.blength[rIdx];
                    for (i = r.metaData.boffset[rIdx]; i < length; ++i) {
                        buf.append("   ");
                        buf.append(i % 10);
                    }
                    break;
                }
                default: {
                    r = (AbstractRecord)((Object)this.mapList[index]);
                    rIdx = this.mapIndex[index];
                    length = r.metaData.boffset[rIdx] + r.metaData.blength[rIdx];
                    for (i = r.metaData.boffset[rIdx]; i < length; ++i) {
                        buf.append(i % 10);
                    }
                }
            }
            buf.append('|');
        }
        buf.append(JCoRuntime.CRLF);
        buf.append(lineString);
        buf.append(JCoRuntime.CRLF);
        buf.append('|');
        for (index = 0; index < this.size; ++index) {
            switch (metaData.getType(index)) {
                case 17: 
                case 99: {
                    buf.append(metaData.getName(index));
                    break;
                }
                case 29: 
                case 30: {
                    try {
                        String temp = this.getString(index);
                        ilength = metaData.getName(index).length();
                        if (temp == null) {
                            temp = "null";
                        }
                        if (temp.length() > ilength) {
                            temp = temp.substring(0, ilength);
                        }
                        buf.append(temp);
                        for (int i2 = temp.length(); i2 < ilength; ++i2) {
                            buf.append(' ');
                        }
                        break;
                    }
                    catch (ConversionException ex) {
                        break;
                    }
                }
                case 2: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    r = (AbstractRecord)((Object)this.mapList[index]);
                    rIdx = this.mapIndex[index];
                    buf.append(r.decodeHEX(rIdx));
                    break;
                }
                default: {
                    buf.append(this.mapList[index].getString(this.mapIndex[index]));
                }
            }
            buf.append('|');
        }
        buf.append(JCoRuntime.CRLF);
        buf.append(lineString);
        buf.append(JCoRuntime.CRLF);
        return buf.toString();
    }

    class ResponseRequestMetadata
    implements JCoListMetaData {
        private static final long serialVersionUID = 20050909001L;

        ResponseRequestMetadata() {
        }

        public void add(String pname, int ptype, int nucByteLength, int ucByteLength, int flags) {
        }

        public void add(String pname, int ptype, JCoRecordMetaData recordMetaData, int flags) {
        }

        public void add(String pname, int ptype, int nucByteLength, int ucByteLength, int decimals, String defaults, String description, int flags, Object tabMetaData, JCoExtendedFieldMetaData extended) {
        }

        public void add(String pname, int ptype, int nucByteLength, int ucByteLength, int decimals, String defaults, String description, int flags, Object tabMetaData, String tableFieldName, JCoExtendedFieldMetaData extended) {
        }

        public Object clone() {
            throw new UnsupportedOperationException();
        }

        public String getDefault(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getDefault(AbstractRequestResponse.this.mapIndex[index]);
        }

        public String getDefault(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getDefault(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isChanging(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isChanging(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isChanging(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isChanging(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isException(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isException(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isException(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isException(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isExport(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isExport(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isExport(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isExport(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isImport(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isImport(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isImport(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isImport(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isOptional(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isOptional(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isOptional(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isOptional(AbstractRequestResponse.this.mapIndex[index]);
        }

        public int getByteLength(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getByteLength(AbstractRequestResponse.this.mapIndex[index]);
        }

        public int getByteLength(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getByteLength(AbstractRequestResponse.this.mapIndex[index]);
        }

        public int getLength(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            switch (this.getType(index)) {
                case 5: 
                case 17: 
                case 29: 
                case 30: 
                case 99: {
                    return 0;
                }
            }
            return this.getByteLength(index);
        }

        public int getLength(String fieldName) {
            return this.getLength(this.indexOf(fieldName));
        }

        public String getClassNameOfField(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getClassNameOfField(AbstractRequestResponse.this.mapIndex[index]);
        }

        public String getClassNameOfField(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getClassNameOfField(AbstractRequestResponse.this.mapIndex[index]);
        }

        public int getDecimals(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getDecimals(AbstractRequestResponse.this.mapIndex[index]);
        }

        public int getDecimals(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getDecimals(AbstractRequestResponse.this.mapIndex[index]);
        }

        public String getDescription(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getDescription(AbstractRequestResponse.this.mapIndex[index]);
        }

        public String getDescription(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getDescription(AbstractRequestResponse.this.mapIndex[index]);
        }

        public JCoExtendedFieldMetaData getExtendedFieldMetaData(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getExtendedFieldMetaData(AbstractRequestResponse.this.mapIndex[index]);
        }

        public JCoExtendedFieldMetaData getExtendedFieldMetaData(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getExtendedFieldMetaData(AbstractRequestResponse.this.mapIndex[index]);
        }

        public int getFieldCount() {
            return AbstractRequestResponse.this.size;
        }

        public String getName() {
            return AbstractRequestResponse.this.name;
        }

        public String getName(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getName(AbstractRequestResponse.this.mapIndex[index]);
        }

        public JCoRecordMetaData getRecordMetaData(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getRecordMetaData(AbstractRequestResponse.this.mapIndex[index]);
        }

        public JCoRecordMetaData getRecordMetaData(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getRecordMetaData(AbstractRequestResponse.this.mapIndex[index]);
        }

        public String getRecordTypeName(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getRecordTypeName(AbstractRequestResponse.this.mapIndex[index]);
        }

        public String getRecordFieldName(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getRecordFieldName(AbstractRequestResponse.this.mapIndex[index]);
        }

        public String getRecordFieldName(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getRecordFieldName(AbstractRequestResponse.this.mapIndex[index]);
        }

        public String getRecordTypeName(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getRecordTypeName(AbstractRequestResponse.this.mapIndex[index]);
        }

        public int getType(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getType(AbstractRequestResponse.this.mapIndex[index]);
        }

        public int getType(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getType(AbstractRequestResponse.this.mapIndex[index]);
        }

        public String getTypeAsString(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getTypeAsString(AbstractRequestResponse.this.mapIndex[index]);
        }

        public String getTypeAsString(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getTypeAsString(AbstractRequestResponse.this.mapIndex[index]);
        }

        public int getUnicodeByteLength(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getUnicodeByteLength(AbstractRequestResponse.this.mapIndex[index]);
        }

        public int getUnicodeByteLength(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getUnicodeByteLength(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean hasField(String fieldName) {
            try {
                AbstractRequestResponse.this.indexOf(fieldName);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public int indexOf(String fieldName) {
            return AbstractRequestResponse.this.indexOf(fieldName);
        }

        public boolean isLocked() {
            return true;
        }

        public boolean isNestedType1Structure(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isNestedType1Structure(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isNestedType1Structure(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isNestedType1Structure(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isStructure(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isStructure(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isStructure(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isStructure(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isTable(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isTable(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isTable(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isTable(AbstractRequestResponse.this.mapIndex[index]);
        }

        public void lock() {
        }

        public int hashCode() {
            return AbstractRequestResponse.this.name.hashCode();
        }

        public boolean equals(Object obj) {
            int fieldCount = 0;
            if (obj == null || !(obj instanceof ResponseRequestMetadata)) {
                return false;
            }
            ResponseRequestMetadata m = (ResponseRequestMetadata)obj;
            fieldCount = this.getFieldCount();
            if (fieldCount != m.getFieldCount()) {
                return false;
            }
            for (int i = 0; i < fieldCount; ++i) {
                if (this.getType(i) != m.getType(i)) {
                    return false;
                }
                if (this.getUnicodeByteLength(i) != m.getUnicodeByteLength(i)) {
                    return false;
                }
                if (this.getByteLength(i) != m.getByteLength(i)) {
                    return false;
                }
                if (!this.getName(i).equals(m.getName(i))) {
                    return false;
                }
                if (this.getDecimals(i) != m.getDecimals(i)) {
                    return false;
                }
                if (!this.isStructure(i) && !this.isTable(i)) continue;
                String o1 = this.getRecordTypeName(i);
                String o2 = m.getRecordTypeName(i);
                if (!(o1 == null || o2 == null ? o1 != o2 : !o1.equals(o2))) continue;
                return false;
            }
            return true;
        }
    }
}

