/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.DefaultParameterList;
import com.sap.conn.jco.rt.DefaultStructure;
import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.jco.util.Codecs;
import com.sap.i18n.decfloat.DecFloat;
import com.sap.i18n.decfloat.DecFloatType;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public class BasXMLWriter {
    private HashMap<String, Integer> m_hashed_strings = new HashMap();
    public static final int START_ID_VALUE = 8;
    private int m_currentID = 8;
    public static final byte[] BXML_DECL = new byte[]{66, 88, 77, 76};
    public static final byte[] BXML_VERSION = new byte[]{48, 46, 55};
    public static final String UTF8_ENCODING = "UTF-8";
    private static byte[] BXML_ENCODING = new byte[]{117, 116, 102, 45, 56};
    public static final byte[] BXML_HEADER_VERSION = new byte[]{3, 86, 69, 82};
    public static final byte[] BXML_HEADER_ENCODING = new byte[]{3, 69, 78, 67};
    private static int HEADER_OFFSET = 0;
    private static byte[] HEADER = new byte[256];
    public static final byte[] ABAP = new byte[]{4, 97, 98, 97, 112};
    public static final byte[] NS_ASX = new byte[]{3, 97, 115, 120};
    public static final byte[] NS_ASXHINT = new byte[]{7, 97, 115, 120, 104, 105, 110, 116};
    public static final byte[] VERSION = new byte[]{7, 118, 101, 114, 115, 105, 111, 110};
    public static final byte[] ABAP_VERSION = new byte[]{3, 49, 46, 48};
    public static final byte[] VALUES = new byte[]{6, 118, 97, 108, 117, 101, 115};
    public static String URI_ABAP_XML = "http://www.sap.com/abapxml";
    public static String URI_ABAP_HINT = "http://www.sap.com/abapxml/hint";
    public static final byte NO_NAMESPACE_ID = 1;
    public static final byte ASX_NAMESPACE_ID = 2;
    public static final byte ASXHINT_NAMESPACE_ID = 3;
    private static final String ITEM = "item";
    private static final String lines = "lines";
    private int lines_id = 0;
    private OutputStream m_out = null;
    private String m_encoding = "UTF-8";

    private static void calculateBinaryHeader() {
        byte[] url;
        System.arraycopy(BXML_DECL, 0, HEADER, 0, BXML_DECL.length);
        HEADER_OFFSET = (byte)BXML_DECL.length;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 63;
        byte length = (byte)BXML_HEADER_VERSION.length;
        System.arraycopy(BXML_HEADER_VERSION, 0, HEADER, HEADER_OFFSET, length);
        HEADER_OFFSET += length;
        length = (byte)BXML_VERSION.length;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = length;
        System.arraycopy(BXML_VERSION, 0, HEADER, HEADER_OFFSET, length);
        HEADER_OFFSET += length;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 63;
        length = (byte)BXML_HEADER_ENCODING.length;
        System.arraycopy(BXML_HEADER_ENCODING, 0, HEADER, HEADER_OFFSET, length);
        HEADER_OFFSET += length;
        length = (byte)BXML_ENCODING.length;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = length;
        System.arraycopy(BXML_ENCODING, 0, HEADER, HEADER_OFFSET, length);
        HEADER_OFFSET += length;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 43;
        length = (byte)NS_ASX.length;
        System.arraycopy(NS_ASX, 0, HEADER, HEADER_OFFSET, length);
        HEADER_OFFSET += length;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 43;
        try {
            url = URI_ABAP_XML.getBytes(UTF8_ENCODING);
            length = (byte)url.length;
            BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = length;
            System.arraycopy(url, 0, HEADER, HEADER_OFFSET, length);
            HEADER_OFFSET += length;
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 58;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 2;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 3;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 43;
        length = (byte)ABAP.length;
        System.arraycopy(ABAP, 0, HEADER, HEADER_OFFSET, length);
        HEADER_OFFSET += length;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 60;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 4;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 2;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 43;
        length = (byte)VERSION.length;
        System.arraycopy(VERSION, 0, HEADER, HEADER_OFFSET, length);
        HEADER_OFFSET += length;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 64;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 5;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 1;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 65;
        length = (byte)ABAP_VERSION.length;
        System.arraycopy(ABAP_VERSION, 0, HEADER, HEADER_OFFSET, length);
        HEADER_OFFSET += length;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 43;
        length = (byte)NS_ASXHINT.length;
        System.arraycopy(NS_ASXHINT, 0, HEADER, HEADER_OFFSET, length);
        HEADER_OFFSET += length;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 43;
        try {
            url = URI_ABAP_HINT.getBytes(UTF8_ENCODING);
            length = (byte)url.length;
            BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = length;
            System.arraycopy(url, 0, HEADER, HEADER_OFFSET, length);
            HEADER_OFFSET += length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 58;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 6;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 7;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 42;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 3;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 43;
        length = (byte)VALUES.length;
        System.arraycopy(VALUES, 0, HEADER, HEADER_OFFSET, length);
        HEADER_OFFSET += length;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 60;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 8;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 2;
    }

    public BasXMLWriter(OutputStream out) {
        this.m_out = out;
        try {
            this.m_out.write(HEADER, 0, HEADER_OFFSET);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void encode(AbstractRecord record, String name) throws IOException {
        this.stag(name);
        if (record instanceof DefaultTable) {
            this.addTableRowCount(((DefaultTable)record).getNumRows());
        }
        this.encode(record);
        this.etag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void encode(AbstractRecord record) throws IOException {
        if (record.recType == 4) {
            String rowTag = ITEM;
            boolean vector = record.metaData.numFields == 1 && record.metaData.name[0].length() == 0;
            int row_save = record.row;
            try {
                if (vector) {
                    int currRow = 0;
                    while (currRow < record.numRows) {
                        record.row = currRow++;
                        this.element(record, 0, rowTag);
                    }
                } else {
                    for (int currRow = 0; currRow < record.numRows; ++currRow) {
                        record.row = currRow;
                        this.stag(rowTag);
                        for (int i = 0; i < record.metaData.numFields; ++i) {
                            this.element(record, i, record.metaData.name[i]);
                        }
                        this.etag();
                    }
                }
                Object var8_9 = null;
                record.row = row_save;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                record.row = row_save;
                throw throwable;
            }
        }
        for (int i = 0; i < record.metaData.numFields; ++i) {
            this.element(record, i, record.metaData.name[i]);
        }
    }

    void encode(DefaultParameterList parameterList, int index) throws IOException {
        this.element(parameterList, index, parameterList.metaData.name[index]);
    }

    private void element(AbstractRecord record, int index, String tag) throws IOException {
        byte itype = record.metaData.type[index];
        this.stag(tag);
        switch (itype) {
            case 4: 
            case 30: {
                byte[] b = record.getByteArray(index);
                if (b == null || b.length == 0) break;
                this.m_out.write(66);
                this.m_out.write(b.length);
                this.m_out.write(b);
                break;
            }
            case 99: {
                DefaultTable table = record.getTable(index);
                if (table != null) {
                    this.addTableRowCount(table.getNumRows());
                    this.encode(table);
                    break;
                }
                this.addTableRowCount(0);
                break;
            }
            case 17: {
                DefaultStructure struct = record.getStructure(index);
                if (struct == null) break;
                this.encode(struct);
                break;
            }
            case 23: {
                byte[] converted_buffer;
                byte[] bytes = record.getByteArray(index);
                String s = DecFloat.toString(DecFloatType.DECFLOAT16_BE, bytes, 0, bytes.length);
                if (s == null || (converted_buffer = s.getBytes(this.m_encoding)).length == 0) break;
                this.m_out.write(84);
                this.m_out.write(converted_buffer.length);
                this.m_out.write(converted_buffer);
                break;
            }
            case 24: {
                byte[] converted_buffer;
                byte[] bytes = record.getByteArray(index);
                String s = DecFloat.toString(DecFloatType.DECFLOAT34_BE, bytes, 0, bytes.length);
                if (s == null || (converted_buffer = s.getBytes(this.m_encoding)).length == 0) break;
                this.m_out.write(84);
                this.m_out.write(converted_buffer.length);
                this.m_out.write(converted_buffer);
                break;
            }
            default: {
                byte[] converted_buffer;
                String s = record.getString(index);
                if (s == null || (converted_buffer = s.getBytes(this.m_encoding)).length == 0) break;
                this.m_out.write(84);
                this.m_out.write(converted_buffer.length);
                this.m_out.write(converted_buffer);
            }
        }
        this.etag();
    }

    private final void stag(String name) throws IOException {
        int string_id = this.handleString(name);
        this.m_out.write(60);
        this.m_out.write(string_id);
        this.m_out.write(1);
    }

    private final void addTableRowCount(int numRows) throws IOException {
        if (this.lines_id == 0) {
            this.lines_id = this.handleString(lines);
        }
        this.m_out.write(64);
        this.m_out.write(this.lines_id);
        this.m_out.write(3);
        this.m_out.write(65);
        byte[] converted_buffer = Integer.toString(numRows).getBytes(this.m_encoding);
        this.m_out.write(converted_buffer.length);
        this.m_out.write(converted_buffer);
    }

    private final int handleString(String name) throws IOException {
        int string_id;
        Integer stringID = this.m_hashed_strings.get(name);
        if (stringID == null) {
            this.m_out.write(43);
            this.m_hashed_strings.put(name, new Integer(++this.m_currentID));
            string_id = this.m_currentID;
            byte[] converted_buffer = this.escape(name).getBytes(this.m_encoding);
            this.m_out.write(converted_buffer.length);
            this.m_out.write(converted_buffer);
        } else {
            string_id = stringID;
        }
        return string_id;
    }

    protected String escape(String name) {
        StringBuilder buf = new StringBuilder(64);
        char ch1 = name.charAt(0);
        if (Character.isLetter(ch1) || ch1 == '_') {
            buf.append(ch1);
        } else if (ch1 == '/') {
            buf.append("_-");
        } else {
            buf.append("_--");
            buf.append(Codecs.Hex.encode((byte)ch1));
        }
        for (int i = 1; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '_') {
                buf.append(ch);
                continue;
            }
            if (ch == '/') {
                buf.append("_-");
                continue;
            }
            buf.append("_--");
            buf.append(Codecs.Hex.encode((byte)ch));
        }
        return buf.toString();
    }

    private final void etag() throws IOException {
        this.m_out.write(62);
    }

    public void close() throws IOException {
        this.m_out.write(62);
        this.m_out.write(62);
        this.m_out.close();
    }

    static {
        BasXMLWriter.calculateBinaryHeader();
    }
}

