/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.XMLParserException;
import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.BasXMLWriter;
import com.sap.conn.jco.rt.StructureParameter;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.rt.XMLWriter;
import com.sap.conn.jco.rt.XRfcParser;
import com.sap.conn.jco.util.FastBufferedWriter;
import com.sap.conn.jco.util.FastStringBuffer;
import com.sap.conn.jco.util.XRfcOutputStream;
import com.sap.conn.rfc.api.BasXMLAware;
import com.sap.conn.rfc.api.IRfcComplexParameter;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.exceptions.RfcGetException;
import com.sap.conn.rfc.exceptions.RfcIoException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class ComplexParameter
extends StructureParameter
implements IRfcComplexParameter,
BasXMLAware {
    AbstractRecord complexParameter;
    int numBytes;
    XRfcParser parser;

    protected ComplexParameter(AbstractRecord complexParameter, String name, int index, byte[] flags) {
        super(name, index, flags);
        this.complexParameter = complexParameter;
        this.numBytes = 0;
    }

    public int getType() {
        return 42;
    }

    public byte[] getBytes() {
        String xmlData = XMLWriter.createXMLDocument(this.complexParameter, this.name);
        try {
            byte[] xmlBytes = xmlData.getBytes("UTF-8");
            this.numBytes = xmlBytes.length;
            return xmlBytes;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.numBytes = 0;
            return new byte[0];
        }
    }

    public void setBytes(byte[] rfcBytes) {
        this.complexParameter.ensureBufferCapacity();
        try {
            String xmlData = new String(rfcBytes, "UTF-8");
            this.complexParameter.fromXML(xmlData);
            int n = this.index;
            this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
            this.numBytes = rfcBytes.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public int getNumBytes() {
        return this.numBytes;
    }

    public void sendXmlDataStream(RfcIoOpenCntl act_cntl) throws RfcIoException {
        try {
            XRfcOutputStream xrfcStream = new XRfcOutputStream(act_cntl);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)xrfcStream, "UTF-8");
            FastBufferedWriter buf = new FastBufferedWriter(osw, 14336);
            XMLWriter.writeXMLDocument(this.complexParameter, this.name, buf);
            buf.close();
            this.numBytes = xrfcStream.getNumBytes();
        }
        catch (RfcIoException rioe) {
            throw rioe;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void receiveXmlDataFinished() throws RfcGetException {
        try {
            this.parser.setFinished();
        }
        catch (XMLParserException ex) {
            Trace.fireTraceCritical(new FastStringBuffer().append("ComplexParameter.receiveXmlDataFinished thrown ").append(ex.toString()).toString(), ex);
            throw new RfcGetException(14, (Throwable)ex);
        }
    }

    public void setXmlBytes(byte[] xmlBytes) throws RfcGetException {
        try {
            this.parser.setBytes(xmlBytes);
            this.parser.parse();
            this.numBytes += xmlBytes.length;
        }
        catch (XMLParserException ex) {
            Trace.fireTraceCritical(new FastStringBuffer().append("ComplexParameter.setXmlBytes thrown ").append(ex.toString()).toString(), ex);
            throw new RfcGetException(14, (Throwable)ex);
        }
    }

    public void receiveXmlDataStarted() {
        this.parser = new XRfcParser(this.complexParameter);
        this.numBytes = 0;
        int n = this.index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
    }

    void setRecord(AbstractRecord record) {
        this.complexParameter = record;
    }

    public AbstractRecord getParameterRecord() {
        int n = this.index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        return this.complexParameter;
    }

    public void writebASXML(BasXMLWriter writer) throws IOException {
        writer.encode(this.complexParameter, this.name);
    }
}

