/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoAttributes;
import com.sap.conn.jco.rt.JCoRuntime;

public final class ConnectionAttributes
implements JCoAttributes {
    private static final long serialVersionUID = 210317032004L;
    protected String dest;
    protected String own_host;
    protected String partner_host;
    protected String systnr;
    protected String sysid;
    protected String client;
    protected String user;
    protected String language;
    protected String ISO_language;
    protected String own_codepage;
    protected String partner_codepage;
    protected String own_charset;
    protected String partner_charset;
    protected String own_encoding;
    protected String partner_encoding;
    protected byte own_bytes_per_char;
    protected byte partner_bytes_per_char;
    protected String own_rel;
    protected String partner_rel;
    protected String kernel_rel;
    protected char partner_type;
    protected char trace;
    protected char rfc_role = (char)32;
    protected char own_type;
    protected String sso_ticket;
    protected int partner_rel_number = -1;
    CPICBasedConnection cpicConnection = null;

    ConnectionAttributes(CPICBasedConnection cpicConnection) {
        this.cpicConnection = cpicConnection;
    }

    public final String getDestination() {
        return this.dest;
    }

    public final String getHost() {
        return this.own_host;
    }

    public final String getPartnerHost() {
        return this.partner_host;
    }

    public final String getSystemID() {
        return this.sysid;
    }

    public final String getSystemNumber() {
        return this.systnr;
    }

    public final String getClient() {
        return this.client;
    }

    public final String getUser() {
        return this.user;
    }

    public final String getLanguage() {
        return this.language;
    }

    public final String getISOLanguage() {
        return this.ISO_language;
    }

    public final String getOwnCodepage() {
        return this.own_codepage;
    }

    public final String getOwnCharset() {
        return this.own_charset;
    }

    public final String getOwnEncoding() {
        return this.own_encoding;
    }

    public final int getOwnBytesPerChar() {
        return this.own_bytes_per_char;
    }

    public final String getPartnerCodepage() {
        return this.partner_codepage;
    }

    public final String getPartnerCharset() {
        return this.partner_charset;
    }

    public final String getPartnerEncoding() {
        return this.partner_encoding;
    }

    public final int getPartnerBytesPerChar() {
        return this.partner_bytes_per_char;
    }

    public final String getRelease() {
        return this.own_rel;
    }

    public final String getPartnerRelease() {
        return this.partner_rel;
    }

    public final String getKernelRelease() {
        return this.kernel_rel;
    }

    public final char getPartnerType() {
        return this.partner_type;
    }

    public final boolean getTrace() {
        return this.trace == 'X' || this.trace == 'x';
    }

    public final char getRfcRole() {
        return this.rfc_role;
    }

    public final char getType() {
        return this.own_type;
    }

    public final String getCPICConversationID() {
        return this.cpicConnection.getConversationID();
    }

    public final String getSSOTicket() {
        return this.sso_ticket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getPartnerReleaseNumber() {
        if (this.partner_rel_number >= 0) {
            return this.partner_rel_number;
        }
        ConnectionAttributes connectionAttributes = this;
        synchronized (connectionAttributes) {
            if (this.partner_type == '2') {
                this.partner_rel_number = 200;
            } else if (this.partner_rel != null && this.partner_rel.length() > 0) {
                this.partner_rel_number = (this.partner_rel.charAt(0) - 48) * 100;
                this.partner_rel_number += (this.partner_rel.charAt(1) - 48) * 10;
                this.partner_rel_number = Character.isDigit(this.partner_rel.charAt(2)) ? (this.partner_rel_number += this.partner_rel.charAt(2) - 48) : (this.partner_rel_number += this.partner_rel.charAt(2) - 65);
            } else {
                return 0;
            }
        }
        return this.partner_rel_number;
    }

    public final String toString() {
        StringBuilder s = new StringBuilder();
        s.append("DEST:                  ");
        s.append(this.dest);
        s.append(JCoRuntime.CRLF);
        s.append("OWN_HOST:              ");
        s.append(this.own_host);
        s.append(JCoRuntime.CRLF);
        s.append("PARTNER_HOST:          ");
        s.append(this.partner_host);
        s.append(JCoRuntime.CRLF);
        s.append("SYSTNR:                ");
        s.append(this.systnr);
        s.append(JCoRuntime.CRLF);
        s.append("SYSID:                 ");
        s.append(this.sysid);
        s.append(JCoRuntime.CRLF);
        s.append("CLIENT:                ");
        s.append(this.client);
        s.append(JCoRuntime.CRLF);
        s.append("USER:                  ");
        s.append(this.user);
        s.append(JCoRuntime.CRLF);
        s.append("LANGUAGE:              ");
        s.append(this.language);
        s.append(JCoRuntime.CRLF);
        s.append("ISO_LANGUAGE:          ");
        s.append(this.ISO_language);
        s.append(JCoRuntime.CRLF);
        s.append("OWN_CODEPAGE:          ");
        s.append(this.own_codepage);
        s.append(JCoRuntime.CRLF);
        s.append("OWN_CHARSET:           ");
        s.append(this.own_charset);
        s.append(JCoRuntime.CRLF);
        s.append("OWN_ENCODING:          ");
        s.append(this.own_encoding);
        s.append(JCoRuntime.CRLF);
        s.append("OWN_BYTES_PER_CHAR:    ");
        s.append(this.own_bytes_per_char);
        s.append(JCoRuntime.CRLF);
        s.append("PARTNER_CODEPAGE:      ");
        s.append(this.partner_codepage);
        s.append(JCoRuntime.CRLF);
        s.append("PARTNER_CHARSET:       ");
        s.append(this.partner_charset);
        s.append(JCoRuntime.CRLF);
        s.append("PARTNER_ENCODING:      ");
        s.append(this.partner_encoding);
        s.append(JCoRuntime.CRLF);
        s.append("PARNER_BYTES_PER_CHAR: ");
        s.append(this.partner_bytes_per_char);
        s.append(JCoRuntime.CRLF);
        s.append("OWN_REL:               ");
        s.append(this.own_rel);
        s.append(JCoRuntime.CRLF);
        s.append("PARTNER_REL:           ");
        s.append(this.partner_rel);
        s.append(JCoRuntime.CRLF);
        s.append("PARTNER_TYPE:          ");
        s.append(this.partner_type);
        s.append(JCoRuntime.CRLF);
        s.append("KERNEL_REL:            ");
        s.append(this.kernel_rel);
        s.append(JCoRuntime.CRLF);
        s.append("TRACE:                 ");
        s.append(this.trace);
        s.append(JCoRuntime.CRLF);
        s.append("RFC_ROLE:              ");
        s.append(this.rfc_role);
        s.append(JCoRuntime.CRLF);
        s.append("OWN_TYPE:              ");
        s.append(this.own_type);
        s.append(JCoRuntime.CRLF);
        s.append("CPIC_CONVID:           ");
        s.append(this.getCPICConversationID());
        s.append(JCoRuntime.CRLF);
        if (this.sso_ticket != null) {
            s.append("SSOTICKET:             ");
            s.append(this.sso_ticket.substring(0, 10) + "...");
            s.append(JCoRuntime.CRLF);
        }
        return s.toString();
    }

    protected void clear() {
        this.dest = null;
        this.own_host = null;
        this.partner_host = null;
        this.systnr = null;
        this.sysid = null;
        this.client = null;
        this.user = null;
        this.language = null;
        this.ISO_language = null;
        this.own_codepage = null;
        this.partner_codepage = null;
        this.own_charset = null;
        this.partner_charset = null;
        this.own_encoding = null;
        this.partner_encoding = null;
        this.own_bytes_per_char = 0;
        this.partner_bytes_per_char = 0;
        this.own_rel = null;
        this.partner_rel = null;
        this.kernel_rel = null;
        this.partner_type = (char)32;
        this.trace = (char)32;
        this.rfc_role = (char)32;
        this.own_type = (char)32;
        this.sso_ticket = null;
        this.partner_rel_number = -1;
    }

    protected boolean isInitial() {
        return this.rfc_role == ' ';
    }

    protected static interface CPICBasedConnection {
        public String getConversationID();
    }
}

