/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoCustomRepository;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.rt.AbapRepository;
import com.sap.conn.jco.rt.ClientConnection;
import com.sap.conn.jco.rt.ConnectionManager;
import com.sap.conn.jco.rt.InternalDestination;

public class CustomRepository
extends AbapRepository
implements JCoCustomRepository {
    protected CustomRepository(String name) {
        super(name);
    }

    public void addFunctionTemplateToCache(JCoFunctionTemplate meta) {
        this.addFunctionTemplate(meta);
    }

    public void addRecordMetaDataToCache(JCoRecordMetaData meta) {
        this.addRecordMetaData(meta);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDestination(JCoDestination abapDestination) throws JCoException, JCoRuntimeException {
        int version;
        block8: {
            if (this.destination != null) {
                throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "Repository destination is already set. The repository destination can not be changed");
            }
            if (abapDestination == null || !(abapDestination instanceof InternalDestination)) {
                String string;
                if (abapDestination == null) {
                    string = "Destination equals null is not allowed.";
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", string);
                }
                string = "Only JCoDestintations created by JCo are supported. Use JCoDestinationManager,getDestination().";
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", string);
            }
            this.destination = (InternalDestination)abapDestination;
            ClientConnection client = null;
            try {
                try {
                    client = ConnectionManager.getConnectionManager().getClient(this.destination, true);
                }
                catch (JCoException ex) {
                    this.destination = null;
                    throw ex;
                }
                Object var5_3 = null;
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (client == null) throw throwable;
                ConnectionManager.getConnectionManager().releaseClient(client);
                throw throwable;
            }
            ConnectionManager.getConnectionManager().releaseClient(client);
        }
        if ((version = this.getVersion()) == 0) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Only destinations to an ABAP instance are allowed. The specified system has the version 0");
        }
        this.containsUnicodeInfo = version > 463;
    }

    public void setQueryMode(JCoCustomRepository.QueryMode queryMode) {
        if (this.destination == null) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "Destination is not defined yet. Use setDestination() before.");
        }
        switch (queryMode) {
            case ALL_AVAILABLE_LAYOUTS: {
                this.containsUnicodeInfo = this.getVersion() > 463;
                break;
            }
            case NON_UNICODE_LAYOUT_ONLY: {
                this.containsUnicodeInfo = false;
                break;
            }
        }
    }

    protected JCoFunctionTemplate queryFunctionTemplateWithRetry(String function_name) throws JCoException {
        if (this.destination != null) {
            return super.queryFunctionTemplateWithRetry(function_name);
        }
        return null;
    }

    protected JCoRecordMetaData queryRecordMetaDataWithRetry(String structure_name) throws JCoException {
        if (this.destination != null) {
            return super.queryRecordMetaDataWithRetry(structure_name);
        }
        return null;
    }
}

