/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.JCoTraceListener;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.ext.JCoSessionReference;
import com.sap.conn.jco.ext.ServerDataProvider;
import com.sap.conn.jco.monitor.JCoServerMonitor;
import com.sap.conn.jco.rt.AutoJobRunner;
import com.sap.conn.jco.rt.ConnectionManager;
import com.sap.conn.jco.rt.ConnectionMonitor;
import com.sap.conn.jco.rt.Context;
import com.sap.conn.jco.rt.DefaultConnectionManager;
import com.sap.conn.jco.rt.DefaultDestinationManager;
import com.sap.conn.jco.rt.DefaultServerManager;
import com.sap.conn.jco.rt.FileDestinationsDataProvider;
import com.sap.conn.jco.rt.JCoMiddleware;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.MiddlewareJavaRfc;
import com.sap.conn.jco.rt.RuntimeEnvironment;
import com.sap.conn.jco.rt.SessionTimeoutChecker;
import com.sap.conn.jco.rt.SimpleSessionRefProvider;
import com.sap.conn.jco.rt.StandaloneServerFactory;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.DefaultSharedStorage;
import com.sap.conn.jco.util.DefaultTrace;
import com.sap.conn.jco.util.SapLoggingTrace;
import com.sap.conn.jco.util.SharedStorage;
import com.sap.conn.rfc.api.RfcRuntime;
import com.sap.conn.rfc.engine.DefaultRfcRuntime;
import com.sap.conn.rfc.engine.Trc;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultJCoRuntime
extends JCoRuntime {
    static final String PROPERTY_DESTINATION_DIRECTORY = "jco.destinations.dir";
    private static Hashtable<String, Object> globalStorage = new Hashtable();
    private static boolean initializedDLL = false;
    private static String dllPath = null;
    private Map<String, Context> contexts = null;
    private RfcRuntime rfcRuntimeInstance = null;
    private ConnectionMonitor connectionMonitor = null;
    private DefaultDestinationManager destinationManager = null;
    private StandaloneServerFactory serverFactory = null;
    private DefaultServerManager serverManager = null;
    private AutoJobRunner autoJobRunner = null;
    private DefaultTrace jcoTrace = null;

    DefaultJCoRuntime() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize() {
        Hashtable<String, Object> hashtable = globalStorage;
        synchronized (hashtable) {
            this.contexts = (Map)globalStorage.get("Contexts");
            if (this.contexts == null) {
                this.contexts = new Hashtable<String, Context>();
                globalStorage.put("Contexts", this.contexts);
            }
        }
        this.destinationManager = this.createDestinationManager();
        this.rfcRuntimeInstance = new DefaultRfcRuntime();
        this.middlewareInstance = new MiddlewareJavaRfc();
        this.createConnectionManager();
        this.connectionMonitor = new ConnectionMonitor();
        this.serverManager = new DefaultServerManager();
        this.serverFactory = this.createServerFactory();
        this.sessionRefProvider = new SimpleSessionRefProvider();
        RuntimeEnvironment.setDefaultSessionReferenceProvider(this.sessionRefProvider);
        this.startAutoJob(new SessionTimeoutChecker(this.contexts));
        this.setMiddlewarePropertyValue("jco.middleware.native_layer_path", dllPath);
        if (Environment.inEclipsePlugin()) {
            SapLoggingTrace.initialize();
        }
    }

    @Override
    protected JCoMiddleware getMiddlewareInstance() {
        return this.middlewareInstance;
    }

    @Override
    protected void updateDestinationDataProvider(DestinationDataProvider provider) {
        this.destinationManager.updateDestinationDataProvider(provider);
    }

    @Override
    protected void updateServerDataProvider(ServerDataProvider provider) {
        this.serverFactory.updateServerDataProvider(provider);
    }

    StandaloneServerFactory getServerFactory() {
        return this.serverFactory;
    }

    StandaloneServerFactory createServerFactory() {
        ServerDataProvider provider = RuntimeEnvironment.getServerDataProvider();
        try {
            String directory = System.getProperty(PROPERTY_DESTINATION_DIRECTORY, ".");
            if (provider == null) {
                provider = new FileDestinationsDataProvider(directory);
            }
        }
        catch (FileNotFoundException e) {
            throw new JCoRuntimeException(106, "JCO_ERROR_RESOURCE", e.toString());
        }
        StandaloneServerFactory factory = new StandaloneServerFactory(provider, this.serverManager);
        return factory;
    }

    @Override
    protected Context getRuntimeContext(boolean create, String scopeType) {
        JCoSessionReference sessionRef = this.sessionRefProvider.getCurrentSessionReference(scopeType);
        Context ctx = null;
        if (sessionRef != null) {
            ctx = this.contexts.get(sessionRef.getID());
            if (ctx != null) {
                ctx.setSessionReference(sessionRef, null);
            } else {
                ctx = new Context();
                ctx.setSessionReference(sessionRef, null);
                this.contexts.put(sessionRef.getID(), ctx);
            }
        } else {
            String msg = "session reference is null. SessionReferenceProvider: " + this.sessionRefProvider.getClass().getName() + ", scope type:" + scopeType;
            Trace.fireTraceCritical(msg, true);
            throw new JCoRuntimeException(153, "JCO_ERROR_SESSION_REF_NOT_VALID", msg);
        }
        ctx.setLastAccess(System.currentTimeMillis());
        return ctx;
    }

    @Override
    protected Context getRuntimeContext(String sessionId, boolean create) {
        Context ctx = this.contexts.get(sessionId);
        if (ctx == null && create) {
            ctx = new Context();
            this.contexts.put(sessionId, ctx);
        }
        return ctx;
    }

    @Override
    protected void releaseRuntimeContext(Context ctx) {
        JCoSessionReference sessionRef;
        if (ctx == null) {
            sessionRef = this.sessionRefProvider.getCurrentSessionReference(null);
        } else {
            sessionRef = ctx.getSessionReference();
            ctx.removeSessionReference();
        }
        if (sessionRef != null) {
            String sessionID = sessionRef.getID();
            Context cached = null;
            if (sessionID != null) {
                cached = this.contexts.remove(sessionID);
            } else if (ctx != null) {
                cached = this.contexts.remove(ctx.getSessionID());
            }
            if (cached != null) {
                ctx = cached;
            }
        }
        if (ctx != null) {
            ctx.reset();
        }
    }

    @Override
    protected DefaultDestinationManager getDestinationManager() {
        return this.destinationManager;
    }

    private DefaultDestinationManager createDestinationManager() {
        try {
            String directory = System.getProperty(PROPERTY_DESTINATION_DIRECTORY, ".");
            FileDestinationsDataProvider defProvider = new FileDestinationsDataProvider(directory);
            RuntimeEnvironment.setDefaultDestinationDataProvider(defProvider);
        }
        catch (FileNotFoundException e) {
            throw new JCoRuntimeException(106, "JCO_ERROR_RESOURCE", e.toString());
        }
        DestinationDataProvider provider = RuntimeEnvironment.getDestinationDataProvider();
        return new DefaultDestinationManager(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <V extends Serializable> SharedStorage<String, V> createSharedStorage(String name) {
        DefaultSharedStorage storage = (DefaultSharedStorage)globalStorage.get(name);
        if (storage == null) {
            Hashtable<String, Object> hashtable = globalStorage;
            synchronized (hashtable) {
                storage = (DefaultSharedStorage)globalStorage.get(name);
                if (storage == null) {
                    storage = new DefaultSharedStorage(name);
                    globalStorage.put(name, storage);
                }
            }
        }
        return storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <V extends Serializable> boolean removeSharedStorage(SharedStorage<String, V> sharedStorage) {
        boolean removed = false;
        if (sharedStorage != null) {
            Hashtable<String, Object> hashtable = globalStorage;
            synchronized (hashtable) {
                removed = globalStorage.remove(sharedStorage.getName()) != null;
            }
        }
        return removed;
    }

    @Override
    protected ConnectionManager createConnectionManager() {
        return new DefaultConnectionManager();
    }

    @Override
    protected String getRuntimeParameter(String parameter) {
        return System.getProperty(parameter);
    }

    @Override
    protected boolean registerNativeMethods(Class<?> clazz) {
        boolean ret = true;
        if (!initializedDLL) {
            try {
                dllPath = DefaultJCoRuntime.loadLibrary("sapjco3");
                initializedDLL = true;
            }
            catch (UnsatisfiedLinkError ule) {
                dllPath = "not loaded, caused by " + ule.toString();
                ule.printStackTrace();
                Trc.criticalTrace("Could not load DLL with native parts of JCo, when trying to load class " + clazz.getName(), ule);
                ret = false;
            }
        }
        return ret;
    }

    private static String loadLibrary(String libname) {
        String syslib;
        String path;
        block16: {
            path = null;
            syslib = System.mapLibraryName(libname);
            String platform = System.getProperty("os.name", "unknown").toLowerCase();
            try {
                File file;
                Class<DefaultJCoRuntime> myClass = DefaultJCoRuntime.class;
                String myResourceName = myClass.getName().replace('.', '/') + ".class";
                URL myUrl = myClass.getClassLoader().getResource(myResourceName);
                String myUrlProtocol = myUrl.getProtocol();
                if ("bundleresource".equals(myUrlProtocol)) {
                    Class<?> classPlatform = myClass.getClassLoader().loadClass("org.eclipse.core.runtime.Platform");
                    Method methodResolve = classPlatform.getDeclaredMethod("resolve", URL.class);
                    myUrl = (URL)methodResolve.invoke(classPlatform, myUrl);
                    myUrlProtocol = myUrl.getProtocol();
                }
                if (!"jar".equals(myUrlProtocol) && !"file".equals(myUrlProtocol)) break block16;
                try {
                    path = URLDecoder.decode(myUrl.getFile(), "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    // empty catch block
                }
                if (path == null) {
                    path = myUrl.getFile();
                }
                if ((path = path.substring(0, path.length() - myResourceName.length() - 1)).startsWith("jar:")) {
                    path = path.substring(4);
                }
                if (path.startsWith("file:")) {
                    path = path.substring(5);
                }
                if (File.separatorChar != '/') {
                    path = path.replace(File.separatorChar, '/');
                }
                if ("jar".equals(myUrlProtocol)) {
                    int index = path.lastIndexOf(47);
                    path = index > 0 ? path.substring(0, index) : "";
                }
                if (((file = new File(path + "/" + syslib)).isFile() || platform.startsWith("os/400") && file.exists()) && file.canRead()) {
                    path = file.getCanonicalPath();
                    System.load(path);
                    return path;
                }
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        try {
            path = System.getProperty("java.library.path", "");
            StringTokenizer tokenizer = new StringTokenizer(path, File.pathSeparator);
            while (tokenizer.hasMoreTokens()) {
                try {
                    File file;
                    path = tokenizer.nextToken();
                    if (path == null || path.length() == 0 || !(file = new File(path + File.separator + syslib)).isFile() || !file.canRead()) continue;
                    path = file.getCanonicalPath();
                    System.load(path);
                    return path;
                }
                catch (Throwable ex) {
                }
            }
        }
        catch (Throwable ex) {
            // empty catch block
        }
        System.loadLibrary(libname);
        return "System-defined path to " + syslib;
    }

    @Override
    public RfcRuntime getRfcRuntimeInstance() {
        return this.rfcRuntimeInstance;
    }

    @Override
    protected DefaultServerManager getJCoServerFactoryInstance() {
        return this.serverManager;
    }

    @Override
    protected void addTraceListener(JCoTraceListener listener) {
        super.addTraceListener(listener);
        if (this.jcoTrace != null && this.jcoTrace.isStandardOutputOn()) {
            Trace.removeTraceListener(this.jcoTrace);
            this.jcoTrace = null;
        }
    }

    @Override
    protected void removeTraceListener(JCoTraceListener listener) {
        super.removeTraceListener(listener);
    }

    @Override
    protected void setRuntimeTrace(int level, String path) {
        super.setRuntimeTrace(level, path);
        if (level == 0) {
            if (this.jcoTrace != null) {
                Trace.removeTraceListener(this.jcoTrace);
                this.jcoTrace = null;
            }
        } else if (this.jcoTrace == null) {
            if (Trace.getTraceListenerCount() == 0) {
                this.jcoTrace = (DefaultTrace)DefaultTrace.getListener();
                Trace.addTracelistener(this.jcoTrace);
                this.jcoTrace.setTrace(level, path);
            }
        } else {
            this.jcoTrace.setTrace(level, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean startAutoJob(AutoJobRunner.AutoJob job) {
        DefaultJCoRuntime defaultJCoRuntime = this;
        synchronized (defaultJCoRuntime) {
            if (this.autoJobRunner == null) {
                this.autoJobRunner = new AutoJobRunner();
                this.autoJobRunner.initialize();
            }
        }
        return this.autoJobRunner.addJob(job);
    }

    @Override
    public void endTask() {
    }

    @Override
    public void startTask(String monitorEntry) {
    }

    @Override
    protected List<String> getServerIDs() {
        return this.getJCoServerFactoryInstance().getServerIDs();
    }

    @Override
    protected JCoServerMonitor getServerMonitor(String serverID) {
        return this.getJCoServerFactoryInstance().getServerMonitor(serverID);
    }

    @Override
    protected ConnectionMonitor getConnectionMonitor() {
        return this.connectionMonitor;
    }
}

