/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoExtendedFieldMetaData;
import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.rt.AbstractMetaData;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.util.FastStringBuffer;

public class DefaultListMetaData
extends AbstractMetaData
implements JCoListMetaData {
    private static final long serialVersionUID = 210317032004L;
    protected byte[] flags = JCoRuntime.EMPTY_BYTE_ARRAY;
    protected String[] defaults = JCoRuntime.EMPTY_STR_ARRAY;
    protected String[] recordFieldNames = JCoRuntime.EMPTY_STR_ARRAY;

    DefaultListMetaData(String name) {
        super(name);
    }

    DefaultListMetaData(String name, int capacity) {
        super(name);
        this.ensureCapacity(capacity);
    }

    DefaultListMetaData(JCoListMetaData obj) {
        this(obj.getName());
        if (obj != null) {
            this.ensureCapacity(obj.getFieldCount());
            this.copy(obj);
            for (int i = 0; i < this.numFields; ++i) {
                if (this.tabMeta[i] == null || this.tabMeta[i] instanceof String) continue;
                this.tabMeta[i] = this.tabMeta[i] instanceof JCoRecordMetaData ? new DefaultRecordMetaData((JCoRecordMetaData)this.tabMeta[i]) : null;
            }
        }
    }

    public Object clone() {
        try {
            DefaultListMetaData clone = (DefaultListMetaData)super.clone();
            clone.flags = new byte[this.flags.length];
            System.arraycopy(this.flags, 0, clone.flags, 0, this.flags.length);
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    protected void copy(JCoListMetaData obj) {
        if (obj == null) {
            return;
        }
        super.copy(obj);
        if (obj instanceof DefaultListMetaData) {
            DefaultListMetaData meta = (DefaultListMetaData)obj;
            System.arraycopy(meta.flags, 0, this.flags, 0, this.numFields);
            if (meta.defaults != null) {
                this.defaults = (String[])meta.defaults.clone();
            }
        } else {
            int n = obj.getFieldCount();
            for (int i = 0; i < n; ++i) {
                int flags = (obj.isOptional(i) ? 1 : 0) | (obj.isChanging(i) ? 8 : 0) | (obj.isExport(i) ? 4 : 0) | (obj.isImport(i) ? 2 : 0);
                this.add(obj.getName(i), obj.getType(i), obj.getByteLength(i), obj.getUnicodeByteLength(i), obj.getDecimals(i), obj.getDefault(i), obj.getDescription(i), flags, obj.getRecordTypeName(i), obj.getRecordFieldName(i), obj.getExtendedFieldMetaData(i));
            }
        }
    }

    public void add(String name, int type, int byteLength, int unicodeByteLength, int flags) {
        this.add(name, type, byteLength, unicodeByteLength, 0, null, null, flags, null, null, null);
    }

    public void add(String name, int type, JCoRecordMetaData recordMetaData, int flags) {
        this.add(name, type, recordMetaData.getRecordLength(), recordMetaData.getUnicodeRecordLength(), 0, null, null, flags, recordMetaData, null, null);
    }

    public void add(String name, int type, int nucByteLength, int ucByteLength, int decimals, String defaultValue, String description, int flags, Object recordMetaData, JCoExtendedFieldMetaData extended) {
        this.add(name, type, nucByteLength, ucByteLength, decimals, defaultValue, description, flags, recordMetaData, null, extended);
    }

    public void add(String name, int type, int nucByteLength, int ucByteLength, int decimals, String defaultValue, String description, int flags, Object recordMetaData, String recordFieldName, JCoExtendedFieldMetaData extended) {
        super.add(name, type, nucByteLength, ucByteLength, decimals, description, recordMetaData, extended);
        this.flags[this.numFields - 1] = (byte)flags;
        if (recordFieldName != null) {
            this.recordFieldNames[this.numFields - 1] = recordFieldName;
        }
        if (defaultValue != null || this.defaults.length > 0 && this.defaults.length < this.numFields) {
            String[] old_defaults = this.defaults;
            this.defaults = new String[this.numFields];
            System.arraycopy(old_defaults, 0, this.defaults, 0, old_defaults.length);
        }
        if (defaultValue != null) {
            this.defaults[this.numFields - 1] = defaultValue;
        }
    }

    public void ensureCapacity(int capacity) {
        if (this.name.length >= capacity) {
            return;
        }
        super.ensureCapacity(capacity);
        byte[] oldFlags = this.flags;
        this.flags = new byte[capacity];
        System.arraycopy(oldFlags, 0, this.flags, 0, oldFlags.length);
        String[] old_recordFieldNames = this.recordFieldNames;
        this.recordFieldNames = new String[capacity];
        System.arraycopy(old_recordFieldNames, 0, this.recordFieldNames, 0, this.numFields);
    }

    public boolean isException(int index) {
        return this.type[index] == 98;
    }

    public boolean isException(String field_name) {
        return this.type[this.indexOf(field_name)] == 98;
    }

    public boolean isOptional(int index) {
        return (this.flags[index] & 1) != 0;
    }

    public boolean isOptional(String field_name) {
        return (this.flags[this.indexOf(field_name)] & 1) != 0;
    }

    public boolean isImport(int index) {
        return (this.flags[index] & 2) != 0;
    }

    public boolean isImport(String field_name) {
        return (this.flags[this.indexOf(field_name)] & 2) != 0;
    }

    public boolean isChanging(int index) {
        return (this.flags[index] & 8) != 0;
    }

    public boolean isChanging(String fieldName) {
        return (this.flags[this.indexOf(fieldName)] & 8) != 0;
    }

    public boolean isExport(int index) {
        return (this.flags[index] & 4) != 0;
    }

    public boolean isExport(String field_name) {
        return (this.flags[this.indexOf(field_name)] & 4) != 0;
    }

    public String getDefault(int index) {
        this.checkIndex(index);
        if (index < this.defaults.length) {
            return this.defaults[index];
        }
        return null;
    }

    public String getDefault(String fieldName) {
        return this.getDefault(this.indexOf(fieldName));
    }

    public String getRecordFieldName(int index) {
        this.checkIndex(index);
        return this.recordFieldNames[index];
    }

    public String getRecordFieldName(String fieldName) {
        return this.getRecordFieldName(this.indexOf(fieldName));
    }

    protected String toString(int level) {
        int n = this.getFieldCount();
        FastStringBuffer s = new FastStringBuffer();
        for (int i = 0; i < n; ++i) {
            int l;
            int k;
            for (k = 0; k < level * 10; ++k) {
                s.append(' ');
            }
            s.append(this.name[i]);
            for (k = l = this.name[i].length(); k < 32; ++k) {
                s.append(' ');
            }
            s.append(',');
            if (this.tabMeta[i] != null) {
                if (this.tabMeta[i] instanceof String) {
                    s.append((String)((Object)this.tabMeta[i]));
                    for (k = l = ((String)((Object)this.tabMeta[i])).length(); k < 32; ++k) {
                        s.append(' ');
                    }
                } else if (this.tabMeta[i] instanceof DefaultRecordMetaData) {
                    String name = ((DefaultRecordMetaData)this.tabMeta[i]).getName();
                    s.append(name);
                    for (k = l = name.length(); k < 32; ++k) {
                        s.append(' ');
                    }
                } else {
                    for (k = 0; k < 32; ++k) {
                        s.append(' ');
                    }
                }
            } else {
                for (k = 0; k < 32; ++k) {
                    s.append(' ');
                }
            }
            s.append(',');
            s.append(DefaultListMetaData.getJCOTypeChar(this.type[i]));
            s.append(',');
            s.append(this.blength[i]);
            s.append(',');
            s.append(this.boffset[i]);
            s.append(',');
            s.append(this.length[0][i]);
            s.append(',');
            s.append(this.length[1][i]);
            s.append(',');
            s.append(this.decimals[i]);
            if (this.defaults != null) {
                s.append(',');
                s.append(this.getDefault(i) != null ? this.getDefault(i) : " ");
            }
            if (this.description != null) {
                s.append(',');
                s.append(this.getDescription(i) != null ? this.getDescription(i) : " ");
            }
            if (this.isImport(i)) {
                s.append(',');
                s.append("IMPORT");
            }
            if (this.isExport(i)) {
                s.append(',');
                s.append("EXPORT");
            }
            if (this.isChanging(i)) {
                s.append(',');
                s.append("CHANGING");
            }
            if (this.isOptional(i)) {
                s.append(',');
                s.append("OPTIONAL");
            }
            if (this.tabMeta[i] != null && this.tabMeta[i] instanceof DefaultRecordMetaData) {
                s.append(JCoRuntime.CRLF);
                s.append(((DefaultRecordMetaData)this.tabMeta[i]).toString(level + 1));
                continue;
            }
            if (this.tabMeta[i] != null && this.tabMeta[i] instanceof String) {
                s.append(',');
                s.append((String)((Object)this.tabMeta[i]));
                if (this.recordFieldNames[i] != null) {
                    s.append(',').append(this.recordFieldNames[i]);
                }
                s.append(JCoRuntime.CRLF);
                continue;
            }
            s.append(JCoRuntime.CRLF);
        }
        return s.toString();
    }

    protected void onLock() {
    }
}

