/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoExtendedFieldMetaData;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.rt.AbstractMetaData;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.util.FastStringBuffer;
import java.io.Serializable;

public class DefaultRecordMetaData
extends AbstractMetaData
implements JCoRecordMetaData {
    private static final long serialVersionUID = 210317032004L;
    protected int[][] offset = new int[][]{JCoRuntime.EMPTY_INT_ARRAY, JCoRuntime.EMPTY_INT_ARRAY};
    protected String typeName = null;
    protected Type1MetaData type1MetaData = null;

    DefaultRecordMetaData(String name) {
        super(name);
    }

    DefaultRecordMetaData(String name, int capacity) {
        super(name);
        this.ensureCapacity(capacity);
    }

    DefaultRecordMetaData(JCoRecordMetaData obj) {
        super(obj.getName());
        this.ensureCapacity(obj.getFieldCount());
        this.copy(obj);
        for (int i = 0; i < this.numFields; ++i) {
            if (this.tabMeta[i] == null || this.tabMeta[i] instanceof String) continue;
            this.tabMeta[i] = this.tabMeta[i] instanceof JCoRecordMetaData ? new DefaultRecordMetaData((JCoRecordMetaData)this.tabMeta[i]) : null;
        }
    }

    public void ensureCapacity(int capacity) {
        if (this.name.length >= capacity) {
            return;
        }
        super.ensureCapacity(capacity);
        int[][] oldOffset = this.offset;
        this.offset = new int[2][capacity];
        System.arraycopy(oldOffset[0], 0, this.offset[0], 0, this.numFields);
        System.arraycopy(oldOffset[1], 0, this.offset[1], 0, this.numFields);
    }

    protected void copy(JCoRecordMetaData obj) {
        if (obj == null) {
            return;
        }
        super.copy(obj);
        this.setRecordLength(obj.getRecordLength(), obj.getUnicodeRecordLength());
        if (obj instanceof DefaultRecordMetaData) {
            DefaultRecordMetaData meta = (DefaultRecordMetaData)obj;
            System.arraycopy(meta.offset[0], 0, this.offset[0], 0, this.numFields);
            System.arraycopy(meta.offset[1], 0, this.offset[1], 0, this.numFields);
            this.typeName = meta.typeName;
            if (meta.type1MetaData != null) {
                this.type1MetaData = new Type1MetaData();
                this.type1MetaData.copy(meta.type1MetaData);
            }
        } else {
            int n = obj.getFieldCount();
            for (int i = 0; i < n; ++i) {
                this.add(obj.getName(i), obj.getType(i), obj.getByteLength(i), obj.getUnicodeByteLength(i), obj.getByteOffset(i), obj.getUnicodeByteOffset(i), obj.getDecimals(i), obj.getDescription(i), obj.getRecordTypeName(i), obj.getExtendedFieldMetaData(i));
            }
            if (obj.isNestedType1Structure()) {
                this.type1MetaData = new Type1MetaData();
                this.type1MetaData.constructMetaData();
            }
        }
    }

    public void add(String fieldname, int fieldType, int byteLength, int byteOffset, int unicodeByteLength, int unicodeOffset) {
        this.add(fieldname, fieldType, byteLength, byteOffset, unicodeByteLength, unicodeOffset, 0, null, null, null);
    }

    public void add(String fieldname, int fieldType, int byteOffset, int unicodeOffset, JCoRecordMetaData recordMetaData) {
        this.add(fieldname, fieldType, recordMetaData.getRecordLength(), byteOffset, recordMetaData.getUnicodeRecordLength(), unicodeOffset, 0, null, recordMetaData, null);
    }

    public void add(String fieldName, int fieldtype, int nucByteLength, int nucByteOffset, int ucByteLength, int ucByteOffset, int fieldDecimals, String fieldDesc, Object recordMetaData, JCoExtendedFieldMetaData extended) {
        super.add(fieldName, fieldtype, nucByteLength, ucByteLength, fieldDecimals, fieldDesc, recordMetaData, extended);
        if (nucByteOffset < 0) {
            int n = nucByteOffset = this.numFields > 0 ? this.offset[0][this.numFields - 1] + this.length[0][this.numFields - 1] : 0;
        }
        if (ucByteOffset < 0) {
            ucByteOffset = this.numFields > 0 ? this.offset[1][this.numFields - 1] + this.length[1][this.numFields - 1] : 0;
        }
        this.offset[0][this.numFields - 1] = nucByteOffset;
        this.offset[1][this.numFields - 1] = ucByteOffset;
    }

    public int getUnicodeRecordLength() {
        return this.tabLength[1];
    }

    public int getRecordLength() {
        return this.tabLength[0];
    }

    public void setRecordLength(int tabNUCLength, int tabUCLength) {
        if (this.isLocked()) {
            throw new UnsupportedOperationException("The JCoMetaData object " + this.name + " is already locked. Changing it is no longer possible");
        }
        this.tabLength[0] = tabNUCLength;
        this.tabLength[1] = tabUCLength;
    }

    public int getUnicodeByteOffset(int index) {
        this.checkIndex(index);
        return this.offset[1][index];
    }

    public int getUnicodeByteOffset(String fieldName) {
        return this.offset[1][this.indexOf(fieldName)];
    }

    public int getByteOffset(int index) {
        super.checkIndex(index);
        return this.offset[0][index];
    }

    public int getByteOffset(String fieldName) {
        return this.offset[0][this.indexOf(fieldName)];
    }

    public boolean isNestedType1Structure() {
        return this.type1MetaData != null;
    }

    public String getLineType() {
        return this.typeName;
    }

    protected String toString(int level) {
        int k;
        int n = this.getFieldCount();
        FastStringBuffer s = new FastStringBuffer();
        s.append(this.recName).append(JCoRuntime.CRLF);
        for (int i = 0; i < n; ++i) {
            int l;
            for (k = 0; k < level * 10; ++k) {
                s.append(' ');
            }
            s.append(this.name[i]);
            for (k = l = this.name[i].length(); k < 32; ++k) {
                s.append(' ');
            }
            s.append(',');
            if (this.tabMeta[i] != null) {
                if (this.tabMeta[i] instanceof String) {
                    s.append((String)((Object)this.tabMeta[i]));
                    for (k = l = ((String)((Object)this.tabMeta[i])).length(); k < 32; ++k) {
                        s.append(' ');
                    }
                } else if (this.tabMeta[i] instanceof DefaultRecordMetaData) {
                    String recordName = ((DefaultRecordMetaData)this.tabMeta[i]).getName();
                    s.append(recordName);
                    for (k = l = recordName.length(); k < 32; ++k) {
                        s.append(' ');
                    }
                } else {
                    for (k = 0; k < 32; ++k) {
                        s.append(' ');
                    }
                }
            } else {
                for (k = 0; k < 32; ++k) {
                    s.append(' ');
                }
            }
            s.append(',');
            s.append(DefaultRecordMetaData.getJCOTypeChar(this.type[i]));
            s.append(',');
            s.append(this.blength[i]);
            s.append(',');
            s.append(this.boffset[i]);
            s.append(',');
            s.append(this.length[0][i]);
            s.append(',');
            s.append(this.offset[0][i]);
            s.append(',');
            s.append(this.length[1][i]);
            s.append(',');
            s.append(this.offset[1][i]);
            s.append(',');
            s.append(this.decimals[i]);
            if (this.description != null) {
                s.append(',');
                s.append(this.getDescription(i) != null ? this.getDescription(i) : " ");
            }
            if (this.tabMeta[i] != null && this.tabMeta[i] instanceof DefaultRecordMetaData) {
                s.append(JCoRuntime.CRLF);
                s.append(((DefaultRecordMetaData)this.tabMeta[i]).toString(level + 1));
                continue;
            }
            s.append(JCoRuntime.CRLF);
        }
        for (k = 0; k < level * 10; ++k) {
            s.append(' ');
        }
        s.append("Record length: ").append(this.tabLength[0]).append(',').append(this.tabLength[1]).append(JCoRuntime.CRLF);
        return s.toString();
    }

    protected void onLock() {
        if (this.numFields > 0) {
            int minLength = this.offset[0][this.numFields - 1] + this.length[0][this.numFields - 1];
            int minLengthUC = this.offset[1][this.numFields - 1] + this.length[1][this.numFields - 1];
            if (this.tabLength[0] < minLength) {
                this.tabLength[0] = minLength;
            }
            if (this.tabLength[1] < minLengthUC) {
                this.tabLength[1] = minLengthUC;
            }
        }
    }

    int computeFieldNumber(int bufferByteLength, int metaDataUnicodeType) {
        int maxFieldNumber = this.numFields;
        if (this.tabLength[metaDataUnicodeType] <= bufferByteLength) {
            return maxFieldNumber;
        }
        while (maxFieldNumber > 0) {
            if (this.offset[metaDataUnicodeType][--maxFieldNumber] + this.length[metaDataUnicodeType][maxFieldNumber] > bufferByteLength) continue;
            return ++maxFieldNumber;
        }
        return maxFieldNumber;
    }

    protected class Type1MetaData
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 210317032004L;
        protected String[] type1Name = JCoRuntime.EMPTY_STR_ARRAY;
        protected int[][] type1Offset = new int[][]{JCoRuntime.EMPTY_INT_ARRAY, JCoRuntime.EMPTY_INT_ARRAY};
        protected int[][] type1Length = new int[][]{JCoRuntime.EMPTY_INT_ARRAY, JCoRuntime.EMPTY_INT_ARRAY};
        protected int[] type1BOffset = JCoRuntime.EMPTY_INT_ARRAY;
        protected int[] type1BLnegth = JCoRuntime.EMPTY_INT_ARRAY;
        protected byte[] type1Type = JCoRuntime.EMPTY_BYTE_ARRAY;
        protected byte[] type1Decimals = JCoRuntime.EMPTY_BYTE_ARRAY;
        protected byte[] flags = JCoRuntime.EMPTY_BYTE_ARRAY;
        protected int type1NumFields = 0;

        protected Type1MetaData() {
        }

        public Object clone() {
            try {
                Type1MetaData obj = (Type1MetaData)super.clone();
                obj.copy(this);
                return obj;
            }
            catch (CloneNotSupportedException ex) {
                return null;
            }
        }

        protected void copy(Type1MetaData type1Template) {
            if (type1Template == null) {
                return;
            }
            this.ensureCapacity(type1Template.type1NumFields);
            this.type1NumFields = type1Template.type1NumFields;
            System.arraycopy(type1Template.type1Name, 0, this.type1Name, 0, this.type1NumFields);
            System.arraycopy(type1Template.type1Offset[0], 0, this.type1Offset[0], 0, this.type1NumFields);
            System.arraycopy(type1Template.type1Offset[1], 0, this.type1Offset[1], 0, this.type1NumFields);
            System.arraycopy(type1Template.type1BOffset, 0, this.type1BOffset, 0, this.type1NumFields);
            System.arraycopy(type1Template.type1Length[0], 0, this.type1Length[0], 0, this.type1NumFields);
            System.arraycopy(type1Template.type1Length[1], 0, this.type1Length[1], 0, this.type1NumFields);
            System.arraycopy(type1Template.type1BLnegth, 0, this.type1BLnegth, 0, this.type1NumFields);
            System.arraycopy(type1Template.type1Type, 0, this.type1Type, 0, this.type1NumFields);
            System.arraycopy(type1Template.type1Decimals, 0, this.type1Decimals, 0, this.type1NumFields);
            System.arraycopy(type1Template.flags, 0, this.flags, 0, this.type1NumFields);
        }

        private void ensureCapacity(int capacity) {
            if (this.type1Name.length < capacity) {
                String[] old_name = this.type1Name;
                this.type1Name = new String[capacity];
                System.arraycopy(old_name, 0, this.type1Name, 0, old_name.length);
                int[][] old_offset = this.type1Offset;
                this.type1Offset = new int[2][capacity];
                System.arraycopy(old_offset[0], 0, this.type1Offset[0], 0, old_offset[0].length);
                System.arraycopy(old_offset[1], 0, this.type1Offset[1], 0, old_offset[1].length);
                int[] old_boffset = this.type1BOffset;
                this.type1BOffset = new int[capacity];
                System.arraycopy(old_boffset, 0, this.type1BOffset, 0, old_boffset.length);
                int[][] old_length = this.type1Length;
                this.type1Length = new int[2][capacity];
                System.arraycopy(old_length[0], 0, this.type1Length[0], 0, old_length[0].length);
                System.arraycopy(old_length[1], 0, this.type1Length[1], 0, old_length[1].length);
                int[] old_blength = this.type1BLnegth;
                this.type1BLnegth = new int[capacity];
                System.arraycopy(old_blength, 0, this.type1BLnegth, 0, old_blength.length);
                byte[] old_type = this.type1Type;
                this.type1Type = new byte[capacity];
                System.arraycopy(old_type, 0, this.type1Type, 0, old_type.length);
                byte[] old_decimals = this.type1Decimals;
                this.type1Decimals = new byte[capacity];
                System.arraycopy(old_decimals, 0, this.type1Decimals, 0, old_decimals.length);
                byte[] old_flags = this.flags;
                this.flags = new byte[capacity];
                System.arraycopy(old_flags, 0, this.flags, 0, old_flags.length);
            }
        }

        private int countNumFields(DefaultRecordMetaData metaData, int fieldCount) {
            int len = metaData.getFieldCount();
            for (int i = 0; i < len; ++i) {
                if (metaData.getType(i) == 17) {
                    fieldCount = this.countNumFields((DefaultRecordMetaData)metaData.getRecordMetaData(i), fieldCount);
                    continue;
                }
                ++fieldCount;
            }
            return fieldCount;
        }

        protected void constructMetaData() {
            this.type1NumFields = this.countNumFields(DefaultRecordMetaData.this, 0);
            this.ensureCapacity(this.type1NumFields);
            this.constructMetaData(DefaultRecordMetaData.this, 0, "", 0, 0);
            this.type1BOffset[0] = 0;
            for (int i = 0; i < this.type1NumFields - 1; ++i) {
                this.type1BOffset[i + 1] = this.type1BOffset[i] + this.type1BLnegth[i];
            }
        }

        private final int constructMetaData(DefaultRecordMetaData metaData, int pos, String prefix, int structOffset, int structUnicodeOffset) {
            for (int i = 0; i < metaData.getFieldCount(); ++i) {
                if (metaData.getType(i) == 17) {
                    pos = this.constructMetaData((DefaultRecordMetaData)metaData.getRecordMetaData(i), pos, prefix + metaData.name[i] + '-', structOffset + metaData.offset[0][i], structUnicodeOffset + metaData.offset[1][i]);
                    continue;
                }
                this.type1Name[pos] = prefix + metaData.name[i];
                this.type1Offset[0][pos] = structOffset + metaData.offset[0][i];
                this.type1Offset[1][pos] = structUnicodeOffset + metaData.offset[1][i];
                this.type1Length[0][pos] = metaData.length[0][i];
                this.type1Length[1][pos] = metaData.length[1][i];
                this.type1BLnegth[pos] = metaData.blength[i];
                this.type1Type[pos] = metaData.type[i];
                this.type1Decimals[pos] = metaData.decimals[i];
                ++pos;
            }
            return pos;
        }

        int computeFieldNumber(int bufferByteLength, int metaDataUnicodeType) {
            int maxFieldNumber = this.type1NumFields;
            while (maxFieldNumber > 0) {
                if (this.type1Offset[metaDataUnicodeType][--maxFieldNumber] + this.type1Length[metaDataUnicodeType][maxFieldNumber] > bufferByteLength) continue;
                return ++maxFieldNumber;
            }
            return maxFieldNumber;
        }
    }
}

