/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.rt.AbapFunctionTemplate;
import com.sap.conn.jco.rt.AbstractMetaData;
import com.sap.conn.jco.rt.DefaultListMetaData;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.DefaultSharedStorage;
import com.sap.conn.jco.util.FastStringBuffer;
import com.sap.conn.jco.util.SharedStorage;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetaDataStorage {
    protected static final String PREFIX = "/com/sap/conn/jco/repository/";
    protected static final String FUNCTIONS = "functions";
    protected static final String STRUCTURES = "structures";
    protected String storageName;
    protected JCoRepository repository = null;
    private SharedStorage<String, AbapFunctionTemplate> functions;
    private SharedStorage<String, DefaultRecordMetaData> structures;
    private static Object mutex = new Object();
    private static final boolean DEBUG = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaDataStorage(JCoRepository repository, String name, boolean localChache) {
        this.storageName = name;
        this.repository = repository;
        String functionStorageName = PREFIX + name + "/" + FUNCTIONS;
        String structureStorageName = PREFIX + name + "/" + STRUCTURES;
        JCoRuntime rt = JCoRuntimeFactory.getRuntime();
        Object object = mutex;
        synchronized (object) {
            if (localChache) {
                this.functions = new DefaultSharedStorage<String, AbapFunctionTemplate>(functionStorageName);
                this.structures = new DefaultSharedStorage<String, DefaultRecordMetaData>(structureStorageName);
            } else {
                this.functions = rt.createSharedStorage(functionStorageName);
                this.structures = rt.createSharedStorage(structureStorageName);
            }
        }
    }

    private void updateParents(AbstractMetaData removed, Serializable meta) {
        boolean updated;
        for (String name : this.getCachedFunctionNames()) {
            AbapFunctionTemplate template = this.functions.getMutableValue(name);
            updated = false;
            updated = this.updateParents((AbstractMetaData)((Object)template.getImportParameterList()), removed, meta);
            updated = updated || this.updateParents((AbstractMetaData)((Object)template.getImportParameterList()), removed, meta);
            updated = updated || this.updateParents((AbstractMetaData)((Object)template.getExportParameterList()), removed, meta);
            updated = updated || this.updateParents((AbstractMetaData)((Object)template.getChangingParameterList()), removed, meta);
            if (!(updated = updated || this.updateParents((AbstractMetaData)((Object)template.getTableParameterList()), removed, meta))) continue;
            this.saveFunctionTemplate(template);
        }
        for (String name : this.getCachedRecordNames()) {
            DefaultRecordMetaData rMd = this.structures.getMutableValue(name);
            updated = false;
            if (!this.updateParents(rMd, removed, meta)) continue;
            this.saveRecordMetaData(rMd);
        }
    }

    private boolean updateParents(AbstractMetaData parent, AbstractMetaData removed, Serializable meta) {
        boolean updated = false;
        if (parent != null && parent.numOdata > 0) {
            for (int i = 0; i < parent.numFields; ++i) {
                if (parent.tabMeta[i] != removed) continue;
                parent.tabMeta[i] = meta;
                if (meta instanceof String) {
                    parent.allTypesResolved = false;
                }
                updated = true;
            }
        }
        return updated;
    }

    private void storeNestedMetaData(AbstractMetaData meta) {
        if (meta == null) {
            return;
        }
        for (int i = 0; i < meta.getFieldCount(); ++i) {
            DefaultRecordMetaData saved;
            DefaultRecordMetaData md;
            int type = meta.getType(i);
            if (type != 99 && type != 17 || !(meta.tabMeta[i] instanceof DefaultRecordMetaData) || (md = (DefaultRecordMetaData)meta.tabMeta[i]) == (saved = this.structures.get(md.recName))) continue;
            this.saveRecordMetaData(md);
        }
    }

    private boolean compare(DefaultRecordMetaData meta1, DefaultRecordMetaData meta2) {
        if (meta1 != meta2) {
            if (meta1 == null || meta2 == null) {
                return false;
            }
            if (meta1.numFields != meta2.numFields) {
                return false;
            }
            for (int i = 0; i < meta1.numFields; ++i) {
                if (meta1.type[i] != meta2.getType(i)) {
                    return false;
                }
                if (meta1.length[1][i] != meta2.getUnicodeByteLength(i)) {
                    return false;
                }
                if (meta1.length[0][i] != meta2.getByteLength(i)) {
                    return false;
                }
                if (!meta1.name[i].equals(meta2.getName(i))) {
                    return false;
                }
                if (meta1.decimals[i] != meta2.getDecimals(i)) {
                    return false;
                }
                if (meta1.tabMeta[i] == meta2.tabMeta[i]) continue;
                return false;
            }
        }
        return true;
    }

    private <MD extends AbstractMetaData> MD resolveMetaData(MD meta) throws JCoException {
        if (meta == null) {
            return null;
        }
        block3: for (int i = 0; i < meta.getFieldCount(); ++i) {
            switch (meta.getType(i)) {
                case 17: 
                case 99: {
                    Serializable tabMeta = meta.tabMeta[i];
                    if (tabMeta instanceof String) {
                        JCoRecordMetaData md = null;
                        md = this.loadRecordMetaData((String)((Object)tabMeta));
                        if (md == null) {
                            md = this.repository.getRecordMetaData((String)((Object)tabMeta));
                            if (md == null) {
                                return null;
                            }
                            md = this.loadRecordMetaData((String)((Object)tabMeta));
                        }
                        meta.tabMeta[i] = md;
                        continue block3;
                    }
                    if (!(tabMeta instanceof DefaultRecordMetaData) || ((DefaultRecordMetaData)meta.tabMeta[i]).allTypesResolved) continue block3;
                    this.resolveMetaData((DefaultRecordMetaData)tabMeta);
                    continue block3;
                }
            }
        }
        return meta;
    }

    AbapFunctionTemplate loadFunctionTemplate(String name) throws JCoException {
        AbapFunctionTemplate template = null;
        template = this.functions.get(name);
        if (template != null) {
            boolean resolved = false;
            AbstractMetaData imports = (AbstractMetaData)((Object)template.getImportParameterList());
            AbstractMetaData changings = (AbstractMetaData)((Object)template.getChangingParameterList());
            AbstractMetaData exports = (AbstractMetaData)((Object)template.getExportParameterList());
            AbstractMetaData tables = (AbstractMetaData)((Object)template.getTableParameterList());
            resolved = imports == null || imports.allTypesResolved;
            resolved = resolved && (changings == null || changings.allTypesResolved);
            resolved = resolved && (exports == null || exports.allTypesResolved);
            boolean bl = resolved = resolved && (tables == null || tables.allTypesResolved);
            if (!resolved) {
                template = this.functions.getMutableValue(name);
                imports = (AbstractMetaData)((Object)template.getImportParameterList());
                changings = (AbstractMetaData)((Object)template.getChangingParameterList());
                exports = (AbstractMetaData)((Object)template.getExportParameterList());
                tables = (AbstractMetaData)((Object)template.getTableParameterList());
                try {
                    if (imports != null && !imports.allTypesResolved) {
                        if ((imports = this.resolveMetaData(imports)) == null) {
                            throw new JCoRuntimeException(101, "JCO_ERROR_PROGRAM", "Not able to resolve the metadata description for the function " + name);
                        }
                        imports.allTypesResolved = true;
                    }
                    if (changings != null && !changings.allTypesResolved) {
                        if ((changings = this.resolveMetaData(changings)) == null) {
                            throw new JCoException(101, "JCO_ERROR_PROGRAM", "Not able to resolve the metadata description for the function " + name);
                        }
                        changings.allTypesResolved = true;
                    }
                    if (exports != null && !exports.allTypesResolved) {
                        if ((exports = this.resolveMetaData(exports)) == null) {
                            throw new JCoException(101, "JCO_ERROR_PROGRAM", "Not able to resolve the metadata description for the function " + name);
                        }
                        exports.allTypesResolved = true;
                    }
                    if (tables != null && !tables.allTypesResolved) {
                        if ((tables = this.resolveMetaData(tables)) == null) {
                            throw new JCoException(101, "JCO_ERROR_PROGRAM", "Not able to resolve the metadata description for the function " + name);
                        }
                        tables.allTypesResolved = true;
                    }
                }
                catch (JCoException je) {
                    Trace.fireTraceCritical(je.getMessage(), true);
                    throw je;
                }
                catch (Throwable t) {
                    Trace.fireTraceCritical(t.getMessage(), true);
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    throw new Error(t);
                }
                this.saveFunctionTemplate(template);
            }
        }
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbapFunctionTemplate saveFunctionTemplate(AbapFunctionTemplate template) {
        AbapFunctionTemplate removed = null;
        if (template == null) {
            return null;
        }
        if (template.getName() == null) {
            throw new IllegalArgumentException("Function name in the template is null.");
        }
        Object object = mutex;
        synchronized (object) {
            this.storeNestedMetaData((DefaultListMetaData)template.getImportParameterList());
            this.storeNestedMetaData((DefaultListMetaData)template.getChangingParameterList());
            this.storeNestedMetaData((DefaultListMetaData)template.getExportParameterList());
            this.storeNestedMetaData((DefaultListMetaData)template.getTableParameterList());
            removed = this.functions.store(template.getName(), template);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbapFunctionTemplate removeFunctionTemplate(String name) {
        if (name == null) {
            return null;
        }
        AbapFunctionTemplate removed = null;
        Object object = mutex;
        synchronized (object) {
            removed = this.functions.remove(name);
        }
        if (removed == null) {
            return null;
        }
        return removed;
    }

    DefaultRecordMetaData loadRecordMetaData(String name) throws JCoException {
        DefaultRecordMetaData meta = null;
        meta = this.structures.get(name);
        if (meta != null && !meta.allTypesResolved) {
            meta = this.structures.getMutableValue(name);
            if ((meta = this.resolveMetaData(meta)) == null) {
                throw new JCoRuntimeException(101, "JCO_ERROR_PROGRAM", "not able to resolve the metadata description for " + name);
            }
            meta.allTypesResolved = true;
            this.saveRecordMetaData(meta);
            meta = this.structures.get(name);
        }
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DefaultRecordMetaData saveRecordMetaData(DefaultRecordMetaData meta) {
        DefaultRecordMetaData removed = null;
        if (meta == null) {
            return null;
        }
        if (meta.recName == null) {
            throw new IllegalArgumentException("Record name is null.");
        }
        Object object = mutex;
        synchronized (object) {
            removed = this.structures.get(meta.getName());
            if (removed == null || !this.compare(removed, meta)) {
                removed = this.structures.store(meta.getName(), meta);
                this.storeNestedMetaData(meta);
            }
            if (removed != null) {
                this.updateParents(removed, meta);
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DefaultRecordMetaData removeRecordMetaData(String name) {
        if (name == null) {
            return null;
        }
        DefaultRecordMetaData removed = null;
        Object object = mutex;
        synchronized (object) {
            removed = this.structures.remove(name);
            if (removed != null) {
                this.updateParents(removed, (Serializable)((Object)removed.recName));
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Object object = mutex;
        synchronized (object) {
            this.functions.clear();
            this.structures.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        JCoRuntime rt = JCoRuntimeFactory.getRuntime();
        Object object = mutex;
        synchronized (object) {
            rt.removeSharedStorage(this.functions);
            rt.removeSharedStorage(this.structures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<String> getCachedFunctionNames() {
        Collection<String> names = null;
        Object object = mutex;
        synchronized (object) {
            names = this.functions.getAllKeys();
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<String> getCachedRecordNames() {
        Collection<String> names = null;
        Object object = mutex;
        synchronized (object) {
            names = this.structures.getAllKeys();
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsFunction(String name) {
        Object object = mutex;
        synchronized (object) {
            return null != this.functions.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsRecord(String name) {
        Object object = mutex;
        synchronized (object) {
            return null != this.structures.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getFunctionMetaDataCount() {
        Object object = mutex;
        synchronized (object) {
            return this.functions.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getRecordMetaDataCount() {
        Object object = mutex;
        synchronized (object) {
            return this.structures.size();
        }
    }

    public String toString() {
        FastStringBuffer buffer = new FastStringBuffer();
        buffer.append("cached functions [");
        buffer.append(this.getCachedFunctionNames().size());
        buffer.append("] :");
        Iterator<String> it = this.getCachedFunctionNames().iterator();
        while (it.hasNext()) {
            buffer.append(it.next());
            if (!it.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("\n");
        buffer.append("cached structures [");
        buffer.append(this.getCachedRecordNames().size());
        buffer.append("] :");
        it = this.getCachedRecordNames().iterator();
        while (it.hasNext()) {
            buffer.append(it.next());
            if (!it.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }
}

