/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.rt.AbapRepository;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.RfcDestination;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.CounterReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryManager {
    private static HashMap<String, CounterReference<JCoRepository>> repositories = new HashMap(29);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JCoRepository getRepository(InternalDestination destination) throws JCoException {
        String key = destination.getSystemID();
        CounterReference<JCoRepository> ref = repositories.get(key);
        JCoRepository repository = null;
        if (ref == null) {
            HashMap<String, CounterReference<JCoRepository>> hashMap = repositories;
            synchronized (hashMap) {
                ref = repositories.get(key);
                if (ref == null) {
                    Trace.fireTrace(16, "[JCoAPI] Adding a repository for " + key);
                    repository = new AbapRepository(key, destination);
                    ref = new CounterReference<JCoRepository>(repository);
                    repositories.put(key, ref);
                } else {
                    repository = ref.get();
                    if (repository instanceof AbapRepository) {
                        ((AbapRepository)repository).addDestination(destination);
                    }
                }
            }
        } else {
            repository = ref.get();
            if (repository instanceof AbapRepository) {
                ((AbapRepository)repository).addDestination(destination);
            }
        }
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JCoRepository registerRepository(JCoRepository repository) {
        HashMap<String, CounterReference<JCoRepository>> hashMap = repositories;
        synchronized (hashMap) {
            CounterReference<JCoRepository> ref = repositories.get(repository.getName());
            if (ref == null) {
                ref = new CounterReference<JCoRepository>(repository);
                repositories.put(repository.getName(), ref);
                if (Trace.isOn(8)) {
                    Trace.fireTrace(8, "[JCoAPI] Registering repository " + repository.getName());
                }
            } else {
                throw new JCoRuntimeException(108, "JCO_ERROR_INTERNAL", "Repository " + repository.getName() + " already registered");
            }
            return ref.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void releaseRepository(RfcDestination destination) {
        if (destination.repository != null) {
            HashMap<String, CounterReference<JCoRepository>> hashMap = repositories;
            synchronized (hashMap) {
                CounterReference<JCoRepository> ref = repositories.get(destination.repository.getName());
                if (ref != null) {
                    ref.release();
                    if (destination.repository instanceof AbapRepository) {
                        ((AbapRepository)destination.repository).removeDestination(destination);
                    }
                }
            }
            destination.repository = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<String> getRepositoryIDs() {
        HashMap<String, CounterReference<JCoRepository>> hashMap = repositories;
        synchronized (hashMap) {
            return new ArrayList<String>(repositories.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JCoRepository getRepository(String repositoryID) {
        CounterReference<JCoRepository> ref = null;
        JCoRepository repository = null;
        HashMap<String, CounterReference<JCoRepository>> hashMap = repositories;
        synchronized (hashMap) {
            ref = repositories.get(repositoryID);
        }
        if (ref != null) {
            repository = ref.get();
            ref.release();
        }
        return repository;
    }
}

