/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCo;
import com.sap.conn.jco.ext.ClientPassportManager;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.ext.ServerDataProvider;
import com.sap.conn.jco.ext.ServerPassportManager;
import com.sap.conn.jco.ext.SessionReferenceProvider;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.Trace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RuntimeEnvironment
extends Environment {
    private static SessionReferenceProvider sessionReferenceProvider;
    private static SessionReferenceProvider defSessionReferenceProvider;
    private static DestinationDataProvider destinationDataProvider;
    private static DestinationDataProvider defDestinationDataProvider;
    private static ServerDataProvider serverDataProvider;
    private static ServerDataProvider defServerDataProvider;
    private static ClientPassportManager clientPassportManager;
    private static ServerPassportManager serverPassportManager;

    public RuntimeEnvironment() {
        JCoRuntimeFactory.getRuntime();
    }

    static void setDefaultSessionReferenceProvider(SessionReferenceProvider defaultProvider) {
        defSessionReferenceProvider = defaultProvider;
    }

    static SessionReferenceProvider getSessionReferenceProvider() {
        if (sessionReferenceProvider == null) {
            return defSessionReferenceProvider;
        }
        return sessionReferenceProvider;
    }

    static void setDefaultDestinationDataProvider(DestinationDataProvider defaultProvider) {
        defDestinationDataProvider = defaultProvider;
    }

    static DestinationDataProvider getDestinationDataProvider() {
        if (destinationDataProvider == null) {
            return defDestinationDataProvider;
        }
        return destinationDataProvider;
    }

    static void setDefaultServerDataProvider(ServerDataProvider defaultProvider) {
        defServerDataProvider = defaultProvider;
    }

    static ServerDataProvider getServerDataProvider() {
        if (serverDataProvider == null) {
            return defServerDataProvider;
        }
        return serverDataProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setSessionReferenceProvider(SessionReferenceProvider provider) {
        if (Trace.isOn(8, true)) {
            Trace.fireTrace(8, "[JCoCallStack] setSessionReferenceProvider(" + (provider == null ? "null" : provider.getClass().getName()) + ") ", true);
        }
        Class<RuntimeEnvironment> clazz = RuntimeEnvironment.class;
        synchronized (RuntimeEnvironment.class) {
            if (sessionReferenceProvider != null) {
                throw new IllegalStateException("SessionReferenceProvider already registered [" + sessionReferenceProvider.getClass().getName() + "]");
            }
            sessionReferenceProvider = provider;
            JCoRuntimeFactory.getRuntime().updateSessionRefProvider(provider);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setDestinationDataProvider(DestinationDataProvider provider) {
        if (Trace.isOn(8, true)) {
            StringBuilder buf = new StringBuilder().append("[JCoCallStack] setDestinationDataProvider(");
            if (provider == null) {
                buf.append("null)");
            } else {
                buf.append(provider.getClass().getName()).append(") ").append(provider.supportsEvents() ? "events are supported" : "events are not supported");
            }
            Trace.fireTrace(8, buf.toString(), true);
        }
        Class<RuntimeEnvironment> clazz = RuntimeEnvironment.class;
        synchronized (RuntimeEnvironment.class) {
            if (destinationDataProvider != null) {
                throw new IllegalStateException("DestinationDataProvider already registered [" + destinationDataProvider.getClass().getName() + "]");
            }
            destinationDataProvider = provider;
            JCoRuntimeFactory.getRuntime().updateDestinationDataProvider(destinationDataProvider);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void removeDestinationDataProvider(DestinationDataProvider provider) {
        if (Trace.isOn(8, true)) {
            Trace.fireTrace(8, "[JCoCallStack] removeDestinationDataProvider(" + (provider == null ? "null" : provider.getClass().getName()) + ") ", true);
        }
        if (destinationDataProvider == null) return;
        Class<RuntimeEnvironment> clazz = RuntimeEnvironment.class;
        synchronized (RuntimeEnvironment.class) {
            if (destinationDataProvider == null) return;
            if (destinationDataProvider != provider) {
                throw new IllegalStateException("A DestinationDataProvider can only deregister itself");
            }
            destinationDataProvider = null;
            JCoRuntimeFactory.getRuntime().updateDestinationDataProvider(defDestinationDataProvider);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setServerDataProvider(ServerDataProvider provider) {
        if (Trace.isOn(8, true)) {
            StringBuilder buf = new StringBuilder().append("[JCoCallStack] setServerDataProvider(");
            if (provider == null) {
                buf.append("null)");
            } else {
                buf.append(provider.getClass().getName()).append(") ").append(provider.supportsEvents() ? "events are supported" : "events are not supported");
            }
            Trace.fireTrace(8, buf.toString(), true);
        }
        Class<RuntimeEnvironment> clazz = RuntimeEnvironment.class;
        synchronized (RuntimeEnvironment.class) {
            if (serverDataProvider != null) {
                throw new IllegalStateException("ServerDataProvider already registered [" + serverDataProvider.getClass().getName() + "]");
            }
            serverDataProvider = provider;
            JCoRuntimeFactory.getRuntime().updateServerDataProvider(serverDataProvider);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void removeServerDataProvider(ServerDataProvider provider) {
        if (Trace.isOn(8, true)) {
            Trace.fireTrace(8, "[JCoCallStack] removeServerDataProvider(" + (provider == null ? "null" : provider.getClass().getName()) + ") ", true);
        }
        if (serverDataProvider == null) return;
        Class<RuntimeEnvironment> clazz = RuntimeEnvironment.class;
        synchronized (RuntimeEnvironment.class) {
            if (serverDataProvider == null) return;
            if (serverDataProvider != provider) {
                throw new IllegalStateException("A ServerDataProvider can only deregister itself");
            }
            serverDataProvider = null;
            JCoRuntimeFactory.getRuntime().updateServerDataProvider(defServerDataProvider);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void removeSessionReferenceProvider(SessionReferenceProvider provider) {
        if (Trace.isOn(8, true)) {
            Trace.fireTrace(8, "[JCoCallStack] removeSessionReferenceProvider(" + (provider == null ? "null" : provider.getClass().getName()) + ") ", true);
        }
        if (sessionReferenceProvider == null) return;
        Class<RuntimeEnvironment> clazz = RuntimeEnvironment.class;
        synchronized (RuntimeEnvironment.class) {
            if (sessionReferenceProvider == null) return;
            if (sessionReferenceProvider != provider) {
                throw new IllegalStateException("A SessionIdProvider can only deregister itself");
            }
            sessionReferenceProvider = null;
            JCoRuntimeFactory.getRuntime().updateSessionRefProvider(defSessionReferenceProvider);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setClientPassportManager(ClientPassportManager passportManager) {
        if (Trace.isOn(8, true)) {
            Trace.fireTrace(8, "[JCoCallStack] registerClientPassportManager(" + (passportManager == null ? "null" : passportManager.toString()) + ") ", true);
        }
        Class<RuntimeEnvironment> clazz = RuntimeEnvironment.class;
        synchronized (RuntimeEnvironment.class) {
            if (clientPassportManager == null) {
                if (passportManager != null) {
                    clientPassportManager = passportManager;
                    JCo.setProperty("jco.jdsr_provider", "1");
                }
            } else {
                throw new IllegalStateException("ClientPassportManager already registered [" + clientPassportManager.getClass().getName() + "]");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected ClientPassportManager getClientPassportManagerInstance() {
        return clientPassportManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setServerPassportManager(ServerPassportManager passportManager) {
        if (Trace.isOn(8, true)) {
            Trace.fireTrace(8, "[JCoCallStack] registerServerPassportManager(" + (passportManager == null ? "null" : passportManager.toString()) + ") ", true);
        }
        Class<RuntimeEnvironment> clazz = RuntimeEnvironment.class;
        synchronized (RuntimeEnvironment.class) {
            if (serverPassportManager == null) {
                if (passportManager != null) {
                    serverPassportManager = passportManager;
                    JCo.setProperty("jco.jdsr_provider", "1");
                }
            } else {
                throw new IllegalStateException("ClientPassportManager already registered [" + clientPassportManager.getClass().getName() + "]");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void removeClientPassportManager(ClientPassportManager passportManager) {
        if (clientPassportManager == null) return;
        Class<RuntimeEnvironment> clazz = RuntimeEnvironment.class;
        synchronized (RuntimeEnvironment.class) {
            if (clientPassportManager == null) return;
            if (clientPassportManager != passportManager) {
                throw new IllegalStateException("A ClientPassportManager can only deregister itself");
            }
            clientPassportManager = null;
            if (serverPassportManager != null) return;
            JCo.setProperty("jco.jdsr_provider", "0");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void removeServerPassportManager(ServerPassportManager passportManager) {
        if (serverPassportManager == null) return;
        Class<RuntimeEnvironment> clazz = RuntimeEnvironment.class;
        synchronized (RuntimeEnvironment.class) {
            if (serverPassportManager == null) return;
            if (serverPassportManager != passportManager) {
                throw new IllegalStateException("A ServerPassportManager can only deregister itself");
            }
            serverPassportManager = null;
            if (clientPassportManager != null) return;
            JCo.setProperty("jco.jdsr_provider", "0");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static ClientPassportManager getClientPassportManager() {
        return clientPassportManager;
    }

    static ServerPassportManager getServerPassportManager() {
        return serverPassportManager;
    }

    static Class<? extends JCoRuntime> getRuntimeImplementation() {
        try {
            if (RuntimeEnvironment.inJStartup()) {
                return Class.forName("com.sap.conn.jco.rt.JCoJ2EERuntime");
            }
            if (RuntimeEnvironment.inJTS()) {
                return Class.forName("com.sap.conn.jco.rt.JCoVMCRuntime");
            }
            return Class.forName("com.sap.conn.jco.rt.DefaultJCoRuntime");
        }
        catch (ClassNotFoundException cnfe) {
            throw new ExceptionInInitializerError(cnfe);
        }
    }

    static {
        clientPassportManager = null;
        serverPassportManager = null;
        if (Environment.inJTS()) {
            Environment.setInstance(new RuntimeEnvironment());
            JCoRuntime.setRuntimeInterface(JCoRuntimeFactory.getRuntime());
        }
    }
}

