/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.ext.ServerDataEventListener;
import com.sap.conn.jco.ext.ServerDataProvider;
import com.sap.conn.jco.rt.DefaultJCoRuntime;
import com.sap.conn.jco.rt.DefaultServer;
import com.sap.conn.jco.rt.DefaultServerManager;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerFactory;
import com.sap.conn.jco.server.JCoServerState;
import com.sap.conn.jco.util.FastStringBuffer;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;

public final class StandaloneServerFactory
extends JCoServerFactory
implements ServerDataEventListener {
    private static ServerDataProvider serverDataProvider;
    private DefaultServerManager serverManager = null;
    private static Hashtable<String, DefaultServer> availableServers;
    private static Hashtable<String, Properties> availableServerCfgs;

    StandaloneServerFactory(ServerDataProvider provider, DefaultServerManager serverManager) {
        this.serverManager = serverManager;
        if (provider != null) {
            this.updateServerDataProvider(provider);
        }
    }

    final void updateServerDataProvider(ServerDataProvider provider) {
        serverDataProvider = provider;
        if (provider != null && provider.supportsEvents()) {
            provider.setServerDataEventListener(this);
        }
    }

    public static synchronized StandaloneServerFactory createServerFactory(DefaultServerManager serverManager) {
        HashSet<String> friends = new HashSet<String>();
        friends.add("com.sap.conn.idoc.jco.JCoIDoc");
        if (!JCoRuntime.checkAccess(friends, StandaloneServerFactory.class.getName())) {
            throw new UnsupportedOperationException("It is not allowed to use the StandaloneServerFactory");
        }
        return new StandaloneServerFactory(null, serverManager);
    }

    static CompareResult compareServerCfg(Properties current, Properties updated) {
        if (updated == null) {
            return CompareResult.REMOVED;
        }
        if (current == null) {
            return CompareResult.CREATED;
        }
        String key = "jco.server.gwhost";
        if (!current.getProperty(key).equals(updated.getProperty(key))) {
            return CompareResult.CHANGED_RESTART;
        }
        key = "jco.server.gwserv";
        if (!current.getProperty(key).equals(updated.getProperty(key))) {
            return CompareResult.CHANGED_RESTART;
        }
        key = "jco.server.progid";
        if (!current.getProperty(key).equals(updated.getProperty(key))) {
            return CompareResult.CHANGED_RESTART;
        }
        key = "jco.server.repository_destination";
        if (!current.getProperty(key).equals(updated.getProperty(key))) {
            return CompareResult.CHANGED_RESTART;
        }
        return CompareResult.CHANGED_UPDATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCoServer getServerInstance(String serverName) throws JCoException {
        if (Trace.isOn(64)) {
            Trace.fireTrace(64, new FastStringBuffer().append("[JCoAPI] JCoServerFactory.createServerConfig(").append(serverName == null ? "null" : serverName).append(") called on provider ").append(serverDataProvider == null ? "null" : serverDataProvider.getClass().getName()).toString());
        }
        if (serverName == null) {
            throw new JCoException(106, "JCO_ERROR_RESOURCE", "server name is null when looking up the server data. Please specify a valid server name.");
        }
        StandaloneServerFactory standaloneServerFactory = this;
        synchronized (standaloneServerFactory) {
            Properties serverCfg = availableServerCfgs.get(serverName);
            CompareResult compareResult = CompareResult.CREATED;
            if (serverCfg == null || !serverDataProvider.supportsEvents()) {
                Properties updatedServerCfg = serverDataProvider.getServerProperties(serverName);
                compareResult = StandaloneServerFactory.compareServerCfg(serverCfg, updatedServerCfg);
                if (compareResult == CompareResult.REMOVED) {
                    this.deleted(serverName);
                    throw new JCoException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "server configuration for " + serverName + " was not found");
                }
                if (compareResult == CompareResult.CHANGED_RESTART) {
                    this.deleted(serverName);
                    compareResult = CompareResult.CREATED;
                }
                serverCfg = updatedServerCfg;
            }
            String serverKey = DefaultServerManager.computeGroupKey(serverCfg);
            DefaultServer availableServer = null;
            if (compareResult == CompareResult.CREATED) {
                availableServer = availableServers.get(serverKey);
                if (this.serverManager.isAvailable(serverKey)) {
                    throw new JCoException(101, "JCO_ERROR_CONFIGURATION", "Server configuration for " + serverName + " is already used for a running server");
                }
            }
            availableServerCfgs.put(serverName, serverCfg);
            if (compareResult == CompareResult.CHANGED_UPDATE) {
                availableServer = availableServers.get(serverKey);
                if (availableServer == null) {
                    throw new JCoException(108, "JCO_ERROR_INTERNAL", "Unable to find the server instance, despite the properties are cached");
                }
                availableServer.update(serverCfg);
            } else if (compareResult == CompareResult.CREATED) {
                availableServer = this.serverManager.getServer(serverCfg, true);
                availableServers.put(serverKey, availableServer);
            }
            return availableServer;
        }
    }

    public int getNumServerConnections(String serverName) throws JCoException {
        if (Trace.isOn(64)) {
            Trace.fireTrace(64, new FastStringBuffer().append("[JCoAPI] JCoServerFactory.getNumServerConnections(").append(serverName == null ? "null" : serverName).append(") called on provider ").append(serverDataProvider == null ? "null" : serverDataProvider.getClass().getName()).toString());
        }
        if (serverName == null) {
            throw new JCoException(106, "JCO_ERROR_RESOURCE", "server name is null when looking up the server data. Please specify a valid server name.");
        }
        Properties serverProperties = serverDataProvider.getServerProperties(serverName);
        if (serverProperties == null) {
            throw new JCoException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "server configuration for " + serverName + " was not found");
        }
        return this.serverManager.getNumServerConnections(serverProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleted(String serverName) {
        DefaultServer availableServer = null;
        StandaloneServerFactory standaloneServerFactory = this;
        synchronized (standaloneServerFactory) {
            String key;
            Properties cfg = availableServerCfgs.remove(serverName);
            if (cfg != null && (availableServer = availableServers.remove(key = DefaultServerManager.computeGroupKey(cfg))) != null && availableServer.getState() != JCoServerState.STOPPED) {
                availableServer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(String serverName) {
        StandaloneServerFactory standaloneServerFactory = this;
        synchronized (standaloneServerFactory) {
            Properties currentCfg = availableServerCfgs.get(serverName);
            Properties updatedCfg = serverDataProvider.getServerProperties(serverName);
            CompareResult cmpResult = StandaloneServerFactory.compareServerCfg(currentCfg, updatedCfg);
            if (cmpResult == CompareResult.REMOVED || cmpResult == CompareResult.CHANGED_RESTART) {
                this.deleted(serverName);
            }
            if (updatedCfg == null) {
                throw new JCoRuntimeException(101, "JCO_ERROR_CONFIGURATION", "cannot get properties for " + serverName + " on event updated");
            }
            if (cmpResult == CompareResult.EQUALS) {
                return;
            }
            availableServerCfgs.put(serverName, updatedCfg);
            String groupKey = DefaultServerManager.computeGroupKey(updatedCfg);
            updatedCfg.setProperty("jco.server.group_key", groupKey);
            DefaultServer availableServer = availableServers.get(groupKey);
            if (availableServer != null) {
                try {
                    availableServer.update(updatedCfg);
                }
                catch (JCoException ex) {
                    throw new JCoRuntimeException(101, "JCO_ERROR_CONFIGURATION", ex.getMessage(), ex);
                }
            }
            try {
                availableServer = this.serverManager.getServer(updatedCfg, true);
            }
            catch (JCoException ex) {
                throw new JCoRuntimeException(101, "JCO_ERROR_CONFIGURATION", ex.getMessage(), ex);
            }
            availableServers.put(groupKey, availableServer);
        }
    }

    public static StandaloneServerFactory get() {
        JCoRuntime runtime = JCoRuntimeFactory.getRuntime();
        try {
            return ((DefaultJCoRuntime)runtime).getServerFactory();
        }
        catch (ClassCastException ex) {
            throw new RuntimeException("StandaloneServerFactory is only avialble in standalone environment");
        }
    }

    static {
        availableServers = new Hashtable();
        availableServerCfgs = new Hashtable();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CompareResult {
        REMOVED,
        CHANGED_RESTART,
        CHANGED_UPDATE,
        EQUALS,
        CREATED;

    }
}

