/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.BasXMLWriter;
import com.sap.conn.jco.rt.Converter;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.rfc.api.BasXMLAware;
import com.sap.conn.rfc.api.IRfcTable;
import java.io.IOException;

public class TableParameter
implements IRfcTable,
BasXMLAware {
    DefaultTable table;
    Converter converter;
    String name;
    boolean active;
    int index;
    IRfcTable.DeltaState state;

    protected TableParameter(JCoTable table, String name) {
        this((DefaultTable)table, name, null);
    }

    protected TableParameter(DefaultTable table, String name) {
        this(table, name, null);
    }

    protected TableParameter(DefaultTable table, String name, Converter converter) {
        this.table = table;
        this.name = name;
        this.converter = converter;
        this.active = false;
        this.index = 0;
    }

    protected TableParameter(DefaultTable table, String name, Converter converter, int index) {
        this.table = table;
        this.name = name;
        this.converter = converter;
        this.active = false;
        this.index = index;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getBytes(int row) {
        if (row >= this.table.numRows || row < 0) {
            throw new ArrayIndexOutOfBoundsException("No such row " + row + "; possible: [0-" + (this.table.numRows - 1) + ']');
        }
        this.table.row = row;
        byte[] ret = new byte[this.getRowLength()];
        block6: for (int i = 0; i < this.table.metaData.numFields; ++i) {
            int offset = ((DefaultRecordMetaData)this.table.metaData).offset[this.converter.sendI][i];
            switch (this.table.metaData.type[i]) {
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.converter.decodeNumber(this.table, ret, i, offset, this.table.metaData.length[this.converter.sendI][i]);
                    continue block6;
                }
                case 2: 
                case 4: {
                    this.converter.decodeBinary(this.table, ret, i, offset, this.table.metaData.length[this.converter.sendI][i]);
                    continue block6;
                }
                case 0: 
                case 1: 
                case 3: 
                case 6: {
                    this.converter.decodeChar(this.table, ret, i, offset, this.table.metaData.length[this.converter.sendI][i]);
                    continue block6;
                }
                case 23: 
                case 24: {
                    this.converter.decodeDecNumber(this.table, ret, i, offset, this.table.metaData.length[this.converter.sendI][i]);
                    continue block6;
                }
            }
        }
        return ret;
    }

    public void setBytes(int row, byte[] rfcBytes) {
        if (row >= this.table.numRows || row < 0) {
            throw new ArrayIndexOutOfBoundsException("No such row " + row + "; possible: [0-" + (this.table.numRows - 1) + ']');
        }
        this.table.row = row;
        int numFields = ((DefaultRecordMetaData)this.table.metaData).computeFieldNumber(rfcBytes.length, this.converter.receiveI);
        block6: for (int i = 0; i < numFields; ++i) {
            int offset = ((DefaultRecordMetaData)this.table.metaData).offset[this.converter.receiveI][i];
            switch (this.table.metaData.type[i]) {
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.converter.encodeNumber(this.table, rfcBytes, i, offset, this.table.metaData.length[this.converter.receiveI][i]);
                    continue block6;
                }
                case 2: 
                case 4: {
                    this.converter.encodeBinary(this.table, rfcBytes, i, offset, this.table.metaData.length[this.converter.receiveI][i]);
                    continue block6;
                }
                case 0: 
                case 1: 
                case 3: 
                case 6: {
                    this.converter.encodeChar(this.table, rfcBytes, i, offset, this.table.metaData.length[this.converter.receiveI][i]);
                    continue block6;
                }
                case 23: 
                case 24: {
                    this.converter.encodeDecNumber(this.table, rfcBytes, i, offset, this.table.metaData.length[this.converter.receiveI][i]);
                    continue block6;
                }
            }
        }
    }

    public void appendRow(byte[] rfcBytes) {
        int rowIndex = this.table.numRows;
        this.table.appendRow();
        this.setBytes(rowIndex, rfcBytes);
    }

    public void appendRows(int numRows) {
        this.table.appendRows(numRows);
    }

    public void clear() {
        this.table.clear();
    }

    public int getNumRows() {
        return this.table.numRows;
    }

    public int getRowLength() {
        return this.table.metaData.tabLength[this.converter.sendI];
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive() {
        this.active = true;
    }

    public int getIndex() {
        return this.index;
    }

    public void ensureBufferCapacity(int numRows) {
        this.table.ensureBufferCapacity(numRows);
    }

    void setTable(DefaultTable table) {
        this.table = table;
    }

    public DefaultTable getTable() {
        return this.table;
    }

    public AbstractRecord getParameterRecord() {
        return this.table;
    }

    public void writebASXML(BasXMLWriter writer) throws IOException {
        writer.encode(this.table, this.name);
    }

    public boolean deleteRow(int pos) {
        if (pos < 0 || pos >= this.table.getNumRows()) {
            return false;
        }
        this.table.deleteRow(pos);
        return true;
    }

    public boolean insertRow(int pos) {
        if (pos < 0 || pos > this.table.getNumRows()) {
            return false;
        }
        this.table.insertRow(pos);
        return true;
    }

    public void setDmState(IRfcTable.DeltaState state) {
        this.state = state;
    }
}

