/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.driver;

import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.util.I18NConverters;
import com.sap.conn.rfc.driver.CpicDriverState;
import com.sap.conn.rfc.driver.RfcDriver;
import com.sap.conn.rfc.driver.RfcDriverState;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcUtilities;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.exceptions.RfcException;
import com.sap.i18n.cp.ConvertXToC;

public abstract class CpicDriver
extends RfcDriver {
    static final int BUFFER_SIZE = 28000;
    static final int sizeOfSAP_LOGON = 75;
    public static final int CM_INVALID_HDL = -1;
    public static final int CM_DONT_WAIT = -2;
    protected byte[] conv_id = new byte[8];
    protected int cm_retcode;
    protected int cm_data_received;
    protected int cm_status_received;
    long tOfLastIO;
    protected boolean all_received;
    protected boolean broken;
    protected boolean deallocated;
    protected boolean accepted;
    protected boolean server_mode;
    int[] cmData = new int[3];
    protected static final byte[] ebcdic_trace = new byte[]{-29, -39, -63, -61, -59};
    protected static final byte[] ebcdic_conncpic = new byte[]{-61, -42, -43, -43, -61, -41, -55, -61};
    private static final byte[] appcfree = new byte[]{-58, -39, -59, -59};
    private static ConvertXToC converterBytesToChar0100;
    static final int SAP_CONV_ID_LN = 8;
    protected static final String INT_SOCK_COMM = "I";
    protected static final String REG_SOCK_COMM = "R";
    protected static final String EXT_SOCK_COMM = "E";
    protected static final int APCDUMMY_LN = 12;
    public static final int RFCOPT_RFCHOST_LN = 100;
    public static final int CM_OK = 0;
    public static final int CM_SAP_TIMEOUT_RETRY = 10001;
    public static final int CM_SAP_PING_RECEIVED = 10003;
    public static final int CM_SEND_RECEIVED = 1;
    public static final int CM_DEALLOCATED_NORMAL = 18;
    public static final int CM_PRODUCT_SPECIFIC_ERROR = 20;
    public static final int CM_NO_DATA_RECEIVED = 0;
    public static final int COXREAD_WAIT = 0;
    public static final int COXREAD_NOBLOCK = 1;
    public static final int g_rfc_max_reg_idle = 300;

    public int getPacketSize() {
        return 28000;
    }

    public int wait(byte[] buffer, int bufsize, int[] bytes_read) {
        bytes_read[0] = 0;
        return 0;
    }

    protected CpicDriver(RfcIoOpenCntl iocntl) {
        super(iocntl);
    }

    protected int deallocated_normal_ext(int data_received, byte[] buffer, int received_leng) {
        this.deallocated = true;
        this.act_cntl.close_pending = true;
        if (data_received == 0) {
            this.setMessageTRC("connection closed without message (CM_NO_DATA_RECEIVED)");
            return 1;
        }
        if (received_leng > 0) {
            int l = received_leng;
            int ptr = 0;
            if (received_leng >= 2 && buffer[received_leng - 2] == -1 && buffer[ptr + received_leng - 2] == -1) {
                this.setMessage("connection closed without message");
                return 0;
            }
            if (received_leng == 1 && buffer[ptr] == -1) {
                this.setMessage("connection closed without message");
                return 0;
            }
            int ret = 1;
            if (received_leng >= appcfree.length && RfcUtilities.memcmp(buffer, 0, appcfree, 0, appcfree.length) == 0 && received_leng >= 12) {
                l -= 12;
                ptr += 12;
            }
            if (l > 0) {
                char[] text = converterBytesToChar0100.ConvertArr(buffer, ptr, l);
                if (text != null) {
                    String msg = new String(text);
                    this.setMessage(msg);
                }
                ret = 2;
            } else {
                this.clearMessage();
            }
            return ret;
        }
        this.setMessageTRC("connection closed without message");
        return 1;
    }

    protected int coxread(byte[] buffer, int bufsize, int[] bytes_read, int wait) {
        int d_rc;
        int rc = 0;
        int cm_org_data_received = 0;
        int input_size = 0;
        int input_ptr = 0;
        int received_leng = 0;
        if (this.deallocated || this.broken) {
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("coxread :: Error : " + Integer.toString(10) + '\n');
            }
            return 10;
        }
        rc = this.cpic_coxread(wait, buffer, this.cmData);
        if (rc == -1) {
            return rc;
        }
        this.cm_data_received = this.cmData[0];
        this.cm_status_received = this.cmData[1];
        received_leng = this.cmData[2];
        cm_org_data_received = this.cm_data_received;
        this.all_received = this.cm_status_received == 1;
        this.cm_retcode = rc;
        ++this.cm_data_received;
        ++this.cm_status_received;
        if (rc != 0) {
            this.deallocated = true;
        }
        if (rc != 0 && rc != 18) {
            this.get_cpic_error("CMRCV");
            return 5;
        }
        if (rc == 18 && (d_rc = this.deallocated_normal_ext(cm_org_data_received, buffer, received_leng)) != 0) {
            int ret;
            int n = ret = d_rc == 2 ? 33 : 10;
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("coxread :: Error : " + Integer.toString(ret) + '\n');
            }
            return ret;
        }
        input_size = Math.min(buffer.length, received_leng);
        input_ptr = 0;
        if (this.accepted) {
            this.accepted = false;
            if (RfcUtilities.memcmp(buffer, 0, ebcdic_conncpic, 0, Math.min(ebcdic_conncpic.length, input_size)) == 0) {
                if (input_size < 75) {
                    this.broken = true;
                    this.setMessageTRC("CPIC-CALL: 'CMRCV'\n no login data received\n");
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("coxread :: Error : " + Integer.toString(8) + '\n');
                    }
                    return 8;
                }
                if (RfcUtilities.memcmp(buffer, 45, ebcdic_trace, 0, 5) == 0) {
                    this.act_cntl.trace = true;
                }
                input_size -= 75;
                input_ptr += 75;
            } else if (buffer[input_ptr] == 84 || buffer[input_ptr] == -29) {
                this.act_cntl.trace = true;
                ++input_ptr;
            }
        }
        bytes_read[0] = --input_size;
        if (input_size <= 0) {
            this.broken = true;
            this.setMessage("CPIC-CALL: 'CMRCV'\n" + this.getMessage() + '\n');
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("coxread :: Error : " + Integer.toString(8) + '\n');
            }
            return 8;
        }
        if (input_ptr > 0) {
            System.arraycopy(buffer, input_ptr, buffer, 0, input_size);
        }
        this.tOfLastIO = System.currentTimeMillis();
        return 0;
    }

    public int proto(int set_get, int proto) {
        if (set_get == 1) {
            this.server_mode = false;
            if (0 != (proto & 0x200)) {
                this.server_mode = true;
            }
        }
        return proto;
    }

    public int ab_drvfill(byte[] aComHead) {
        int bufsize = aComHead.length;
        if (this.act_cntl.m_bytes_free >= bufsize) {
            System.arraycopy(aComHead, 0, this.act_cntl.m_buffer, 0, bufsize);
            this.act_cntl.m_buffer_ptr += bufsize;
            this.act_cntl.m_bytes_free -= bufsize;
            return 0;
        }
        assert (false) : "initial communcation buffer to small: " + bufsize + '>' + this.act_cntl.m_bytes_free;
        return 1;
    }

    public synchronized int rflush() {
        byte[] buffer = new byte[1000];
        int req_leng = 0;
        int rc = 0;
        int received_leng = 0;
        if (this.deallocated || this.broken) {
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("rflush :: Error : (deallocated or broken)");
            }
            return 1;
        }
        if (!this.all_received) {
            do {
                int d_rc;
                int cm_org_data_received = 0;
                req_leng = buffer.length;
                rc = this.rflushCMRCV(buffer, req_leng, this.cmData);
                this.cm_data_received = this.cmData[0];
                this.cm_status_received = this.cmData[1];
                received_leng = this.cmData[2];
                cm_org_data_received = this.cm_data_received++;
                if (rc != 0) {
                    this.deallocated = true;
                    this.get_cpic_error("CMRCV (Flush)");
                }
                if (rc != 0 && rc != 18) {
                    ++this.cm_status_received;
                    this.get_cpic_error("CMRCV");
                    return 5;
                }
                if (rc != 18 || (d_rc = this.deallocated_normal_ext(cm_org_data_received, buffer, received_leng)) == 0) continue;
                ++this.cm_status_received;
                this.tOfLastIO = System.currentTimeMillis();
                if (this.act_cntl.trace) {
                    Trc.ab_rfctrc("rflush :: Error : " + Integer.toString(d_rc));
                }
                return d_rc == 2 ? 33 : 10;
            } while (this.cm_status_received != 1);
            ++this.cm_status_received;
            this.all_received = true;
        }
        this.tOfLastIO = System.currentTimeMillis();
        return 0;
    }

    public synchronized int write(byte[] buffer, int buffersize, boolean last) {
        int rc = 0;
        if (this.deallocated || this.broken) {
            this.setMessage("CPIC-CALL: 'CMSEND'\n; connection closed\n");
            return 5;
        }
        rc = this.CMSEND(buffer, buffersize);
        if (rc != 0) {
            this.deallocated = true;
            this.get_cpic_error("CMSEND");
            return 5;
        }
        this.tOfLastIO = System.currentTimeMillis();
        return 0;
    }

    public synchronized void info(byte[] info) {
        System.arraycopy(this.conv_id, 0, info, 0, 8);
    }

    protected String get_cpic_error(String cpic_call) {
        String ptr = CpicDriver.SAP_CMPERR();
        String msg = null;
        StringBuilder msgBuf = new StringBuilder(100);
        msgBuf.append("CPIC-CALL: ").append(cpic_call).append(" on convId: ").append(Trc.convIDToString(this.conv_id));
        msgBuf.append('\n');
        if (ptr != null) {
            msgBuf.append(ptr);
        } else {
            msgBuf.append("No specific info available");
        }
        msg = msgBuf.toString();
        if (null != this.act_cntl && this.act_cntl.trace) {
            Trc.ab_rfctrc("get_cpic_error :: Error : " + msg);
        }
        this.setMessage(msg);
        return msg;
    }

    public RfcDriverState getRfcDriverState() {
        return new CpicDriverState(this);
    }

    public void restoreState(RfcDriverState driverState) {
        try {
            CpicDriverState cpicDriverState = (CpicDriverState)driverState;
            System.arraycopy(cpicDriverState.conv_id, 0, this.conv_id, 0, 8);
            this.server_mode = cpicDriverState.server_mode;
            this.cm_retcode = 0;
            this.cm_data_received = 0;
            this.cm_status_received = 0;
            this.tOfLastIO = 0L;
            this.all_received = true;
            this.broken = false;
            this.deallocated = false;
            this.accepted = false;
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("A CpicDriver can only be restored with a CpicDriverState, not with a " + driverState.getClass().getName());
        }
    }

    public static native String getTraceFileName();

    private static synchronized native int INIT();

    protected int SAP_CMINIT3(String sym_dest_name, String lu, String tp, String gw_host, String gw_serv, String prot, int cpic_trace, int snc_mode, int snc_qop, String snc_myname, String snc_partnername, String snc_lib, int return_code) {
        int rc = 0;
        if (this.act_cntl.trace) {
            StringBuffer text = new StringBuffer(256);
            Trc.TCpicNativeBegin("SAP_CMINIT3", this.act_cntl.hrfc, this.conv_id);
            text.append("    sym_dest_name: ");
            text.append(sym_dest_name);
            text.append("\n    lu: ");
            text.append(lu);
            text.append("\n    tp: ");
            text.append(tp);
            text.append("\n    gw_host: ");
            text.append(gw_host);
            text.append("\n    gw_serv: ");
            text.append(gw_serv);
            text.append("\n    prot: ");
            text.append(prot);
            text.append("\n    snc_mode: ");
            text.append(snc_mode);
            text.append("\n    snc_qop: ");
            text.append(snc_qop);
            text.append("\n    snc_myname: ");
            text.append(snc_myname);
            text.append("\n    snc_partnername: ");
            text.append(snc_partnername);
            text.append("\n    snc_lib: ");
            text.append(snc_lib);
            text.append("\n");
            Trc.ab_rfctrc(text.toString());
        }
        rc = CpicDriver.nativeSAP_CMINIT3(this.conv_id, sym_dest_name, lu, tp, gw_host, gw_serv, prot, cpic_trace, snc_mode, snc_qop, snc_myname, snc_partnername, snc_lib, return_code);
        if (this.act_cntl.trace) {
            Trc.TCpicNativeEnd("SAP_CMINIT3", this.act_cntl.hrfc, this.conv_id, rc);
        }
        return rc;
    }

    private static native int nativeSAP_CMINIT3(byte[] var0, String var1, String var2, String var3, String var4, String var5, String var6, int var7, int var8, int var9, String var10, String var11, String var12, int var13);

    protected int CMSPLN(String lu_buf) {
        int rc = 0;
        if (this.act_cntl.trace) {
            Trc.TCpicNativeBegin("CMSPLN", this.act_cntl.hrfc, this.conv_id);
        }
        rc = CpicDriver.nativeCMSPLN(this.conv_id, lu_buf);
        if (this.act_cntl.trace) {
            Trc.TCpicNativeEnd("CMSPLN", this.act_cntl.hrfc, this.conv_id, rc);
        }
        return rc;
    }

    private static native int nativeCMSPLN(byte[] var0, String var1);

    protected int CMALLC() {
        int rc = 0;
        if (this.act_cntl.trace) {
            Trc.TCpicNativeBegin("CMALLC", this.act_cntl.hrfc, this.conv_id);
        }
        rc = CpicDriver.nativeCMALLC(this.conv_id);
        if (this.act_cntl.trace) {
            Trc.TCpicNativeEnd("CMALLC", this.act_cntl.hrfc, this.conv_id, rc);
        }
        return rc;
    }

    private static native int nativeCMALLC(byte[] var0);

    protected int CMSEND(byte[] buffer, int buffersize) {
        int rc = 0;
        if (this.act_cntl.trace) {
            Trc.TCpicNativeBegin("CMSEND", this.act_cntl.hrfc, this.conv_id);
        }
        rc = CpicDriver.nativeCMSEND(this.conv_id, buffer, buffersize);
        if (this.act_cntl.trace) {
            Trc.TCpicNativeEnd("CMSEND", this.act_cntl.hrfc, this.conv_id, rc);
        }
        return rc;
    }

    private static native int nativeCMSEND(byte[] var0, byte[] var1, int var2);

    protected int cpic_coxread(int wait, byte[] cpic_buffer, int[] cm_data) {
        int rc = 0;
        if (this.act_cntl.trace) {
            Trc.TCpicNativeBegin("cpic_coxread", this.act_cntl.hrfc, this.conv_id);
        }
        rc = CpicDriver.nativeCpic_coxread(this.conv_id, wait, cpic_buffer, cm_data);
        if (this.act_cntl.trace) {
            Trc.TCpicNativeEnd("cpic_coxread", this.act_cntl.hrfc, this.conv_id, rc);
        }
        return rc;
    }

    private static native int nativeCpic_coxread(byte[] var0, int var1, byte[] var2, int[] var3);

    protected static native String SAP_CMPERR();

    protected int SAP_CMREGTP3(String tpname, String gwhost, String gwserv, int[] reg_handle, String myname, String lib, byte qop, boolean snc_mode_on) {
        int rc = 0;
        if (this.act_cntl.trace) {
            Trc.TCpicNativeBegin("SAP_CMREGTP3", (long)reg_handle[0], (byte[])null);
        }
        rc = CpicDriver.nativeSAP_CMREGTP3(tpname, gwhost, gwserv, reg_handle, myname, lib, qop, snc_mode_on);
        if (this.act_cntl.trace) {
            Trc.TCpicNativeEnd("SAP_CMREGTP3", (long)reg_handle[0], (byte[])null, rc);
        }
        return rc;
    }

    private static native int nativeSAP_CMREGTP3(String var0, String var1, String var2, int[] var3, String var4, String var5, byte var6, boolean var7);

    protected int SAP_CMUNREGTP3(int reg_handle) {
        int rc = 0;
        if (this.act_cntl.trace) {
            Trc.TCpicNativeBegin("SAP_CMUNREGTP3", this.act_cntl.hrfc, (byte[])null);
        }
        rc = CpicDriver.nativeSAP_CMUNREGTP3(reg_handle);
        if (this.act_cntl.trace) {
            Trc.TCpicNativeEnd("SAP_CMUNREGTP3", this.act_cntl.hrfc, (byte[])null, rc);
        }
        return rc;
    }

    private static native int nativeSAP_CMUNREGTP3(int var0);

    protected static int SAP_CMLISTEN(int timeout) {
        int rc = 0;
        boolean trace = false;
        if (trace) {
            Trc.TCpicNativeBegin("SAP_CMLISTEN", 0L, (byte[])null);
        }
        rc = CpicDriver.nativeSAP_CMLISTEN(timeout);
        if (trace) {
            Trc.TCpicNativeEnd("SAP_CMLISTEN", 0L, (byte[])null, rc);
        }
        return rc;
    }

    private static native int nativeSAP_CMLISTEN(int var0);

    protected int SAP_CMLISTEN3() {
        int rc = 0;
        if (this.act_cntl.trace) {
            Trc.TCpicNativeBegin("SAP_CMLISTEN3", this.act_cntl.hrfc, this.conv_id);
        }
        rc = CpicDriver.nativeSAP_CMLISTEN3(this.conv_id);
        if (this.act_cntl.trace) {
            Trc.TCpicNativeEnd("SAP_CMLISTEN3", this.act_cntl.hrfc, this.conv_id, rc);
        }
        return rc;
    }

    private static native int nativeSAP_CMLISTEN3(byte[] var0);

    protected int SAP_CMACCPTP3(int reg_handle, int wtime_cpic) {
        int rc = 0;
        if (this.act_cntl.trace) {
            Trc.TCpicNativeBegin("SAP_CMACCPTP3", (long)reg_handle, (byte[])null);
        }
        rc = CpicDriver.nativeSAP_CMACCPTP3(this.conv_id, reg_handle, wtime_cpic);
        if (this.act_cntl.trace) {
            Trc.TCpicNativeEnd("SAP_CMACCPTP3", (long)reg_handle, (byte[])null, rc);
        }
        return rc;
    }

    private static native int nativeSAP_CMACCPTP3(byte[] var0, int var1, int var2);

    protected static int SAP_CMGETNEXTHDL(int[] reg_handle) {
        int rc = 0;
        boolean trace = false;
        if (trace) {
            Trc.TCpicNativeBegin("SAP_CMGETNEXTHDL", 0L, (byte[])null);
        }
        rc = CpicDriver.nativeSAP_CMGETNEXTHDL(reg_handle);
        if (trace) {
            Trc.TCpicNativeEnd("SAP_CMGETNEXTHDL", 0L, (byte[])null, rc);
        }
        return rc;
    }

    private static native int nativeSAP_CMGETNEXTHDL(int[] var0);

    public static int setCpicTrace(int level, String fileName) {
        int rc = 0;
        rc = CpicDriver.nativeSetCpicTrace(level, fileName);
        return rc;
    }

    private static native int nativeSetCpicTrace(int var0, String var1);

    public static int getCpicTrace() {
        int rc = 0;
        rc = CpicDriver.nativeGetCpicTrace();
        return rc;
    }

    private static native int nativeGetCpicTrace();

    protected int rflushCMRCV(byte[] buffer, int req_leng, int[] rc_arr) {
        int rc = 0;
        if (this.act_cntl.trace) {
            Trc.TCpicNativeBegin("rflushCMRCV", this.act_cntl.hrfc, this.conv_id);
        }
        rc = CpicDriver.nativeRflushCMRCV(this.conv_id, buffer, req_leng, rc_arr);
        if (this.act_cntl.trace) {
            Trc.TCpicNativeEnd("rflushCMRCV", this.act_cntl.hrfc, this.conv_id, rc);
        }
        return rc;
    }

    private static native int nativeRflushCMRCV(byte[] var0, byte[] var1, int var2, int[] var3);

    protected int CMDEAL() {
        int rc = 0;
        if (this.act_cntl.trace) {
            Trc.TCpicNativeBegin("CMDEAL", this.act_cntl.hrfc, this.conv_id);
        }
        rc = CpicDriver.nativeCMDEAL(this.conv_id);
        if (this.act_cntl.trace) {
            Trc.TCpicNativeEnd("CMDEAL", this.act_cntl.hrfc, this.conv_id, rc);
        }
        return rc;
    }

    private static native int nativeCMDEAL(byte[] var0);

    private static native int nativeSncMode(byte[] var0);

    private static native String nativeSncPartnerName(byte[] var0);

    private static native int nativeSncPartnerAclKey(byte[] var0, byte[] var1);

    public static String CpicGetVersion() {
        int[] versions = new int[2];
        CpicDriver.nativeCpicGetVersion(versions);
        return versions[0] + "." + versions[1];
    }

    private static native int nativeCpicGetVersion(int[] var0);

    public boolean isSncMode() {
        boolean sncMode = false;
        if (this.act_cntl.trace) {
            Trc.TCpicNativeBegin("sncMode", this.act_cntl.hrfc, this.conv_id);
        }
        boolean bl = sncMode = CpicDriver.nativeSncMode(this.conv_id) == 1;
        if (this.act_cntl.trace) {
            Trc.TCpicNativeEnd("sncMode", this.act_cntl.hrfc, this.conv_id, "returns sncMode=" + sncMode);
        }
        return sncMode;
    }

    public byte[] getSncPartnerAclKey() {
        if (this.act_cntl.trace) {
            Trc.TCpicNativeBegin("sncPartnerAclKey", this.act_cntl.hrfc, this.conv_id);
        }
        byte[] buffer = new byte[2048];
        int keyLength = CpicDriver.nativeSncPartnerAclKey(this.conv_id, buffer);
        if (this.act_cntl.trace) {
            Trc.TCpicNativeEnd("sncPartnerAclKey", this.act_cntl.hrfc, this.conv_id, keyLength);
        }
        byte[] aclKey = null;
        if (keyLength > 0) {
            aclKey = new byte[keyLength];
            System.arraycopy(buffer, 0, aclKey, 0, keyLength);
        }
        return aclKey;
    }

    public String getSncPartnerName() {
        if (this.act_cntl.trace) {
            Trc.TCpicNativeBegin("sncPartnerName", this.act_cntl.hrfc, this.conv_id);
        }
        String partnerName = CpicDriver.nativeSncPartnerName(this.conv_id);
        if (this.act_cntl.trace) {
            Trc.TCpicNativeEnd("sncPartnerName", this.act_cntl.hrfc, this.conv_id, "returns " + partnerName);
        }
        return partnerName;
    }

    static int SAP_CMNOREGTP(String tpname, String gwhost, String gwserv, int[] numberRegTPs) {
        return CpicDriver.nativeSAP_CMNOREGTP(tpname, gwhost, gwserv, numberRegTPs);
    }

    private static native int nativeSAP_CMNOREGTP(String var0, String var1, String var2, int[] var3);

    public static void setCpicMaxConv(int no_elem) throws RfcException {
        int cpicRc = CpicDriver.nativeSAP_CMMAXCONV(no_elem);
        if (cpicRc != 0) {
            String message = CpicDriver.SAP_CMPERR();
            int group = 108;
            Trc.criticalTrace("[JCoAPI] JNI call SAP_CMMAXCONV returns " + cpicRc + " with message:" + message, (Exception)null);
            throw new RfcException(1, message, group, 0L, false, null);
        }
    }

    private static native int nativeSAP_CMMAXCONV(int var0);

    public static void setupRegKeepAlive(boolean pingActivate, boolean pingReply, int ping_period_in_sec, int ping_write_timeout_in_ms) throws RfcException {
        try {
            int cpicRc = CpicDriver.nativeSAP_CMSETPING(pingActivate ? 1 : 0, pingReply ? 1 : 0, ping_period_in_sec, ping_write_timeout_in_ms);
            if (cpicRc != 0) {
                String message = CpicDriver.SAP_CMPERR();
                int group = 108;
                Trc.criticalTrace("JNI call SAP_CMSETPING returns " + cpicRc + " with message:" + message, (Exception)null);
                throw new RfcException(1, message, group, 0L, false, null);
            }
        }
        catch (UnsatisfiedLinkError e) {
            Trc.generalInfo(null, "SAP_CMSETPING is not avaialble");
        }
    }

    private static native int nativeSAP_CMSETPING(int var0, int var1, int var2, int var3);

    public String[] launchSapGui(String startCommand, String sapGuiId, String systemID, int systemNr) {
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("Starting SAP GUI with '" + startCommand + "' GUI ID='" + sapGuiId + "' for " + systemID + "[" + systemNr + "]\n");
            Trc.nativeBegin("nativeLaunchSapGui");
        }
        String[] launchResults = CpicDriver.nativeLaunchSapGui(startCommand, sapGuiId, systemID, systemNr);
        if (this.act_cntl.trace) {
            Trc.nativeEnd("nativeLaunchSapGui");
            Trc.ab_rfctrc("Starting SAP GUI " + (launchResults[0] != null ? "successfully finished." : "failed: " + launchResults[1]) + '\n');
        }
        return launchResults;
    }

    private static native String[] nativeLaunchSapGui(String var0, String var1, String var2, int var3);

    static {
        if (JCoRuntime.registerNatives(CpicDriver.class)) {
            try {
                CpicDriver.INIT();
                converterBytesToChar0100 = I18NConverters.getConvertXToC("0100");
            }
            catch (UnsatisfiedLinkError ule) {
                if (Environment.inJStartup()) {
                    UnsatisfiedLinkError newule = new UnsatisfiedLinkError("Could not load native layer: startup framework did not register native methods correctly");
                    newule.printStackTrace();
                    throw newule;
                }
                ExceptionInInitializerError eiie = new ExceptionInInitializerError("JCo with jco_j2ee.jar can only be used within the SAP Java EE runtime. If you want to run JCo applications in other Java runtimes, make sure to have a reference to sapjco.jar.");
                eiie.printStackTrace();
                throw eiie;
            }
            catch (Exception e) {
                Trc.criticalTrace("Class initialization failed: ", e);
            }
            catch (Error e) {
                Trc.criticalTrace("Class initialization failed: ", e);
            }
        }
    }
}

