/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.exceptions;

import com.sap.conn.jco.ext.Environment;
import com.sap.conn.rfc.engine.RfcIoControl;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.exceptions.RfcGetException;
import com.sap.conn.rfc.exceptions.RfcIoException;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class RfcException
extends Exception {
    private static final long serialVersionUID = 300012082005L;
    private int m_rfcRc;
    private int m_errorGroup;
    private String m_key;
    private String messageClass;
    private char messageType;
    private String messageNumber;
    private String[] messageParameters = null;
    private String systemInfo;

    public static int rfcIOtoRC(int iorc) {
        switch (iorc) {
            case 0: {
                return 0;
            }
            case 4: {
                return 18;
            }
            case 2: {
                return 11;
            }
            case 10: 
            case 29: {
                return 6;
            }
            case 25: 
            case 26: {
                return 21;
            }
            case 17: {
                return 7;
            }
        }
        return 1;
    }

    private static String getKey(int group) {
        switch (group) {
            case 101: {
                return "RFC_ERROR_PROGRAM";
            }
            case 102: {
                return "RFC_ERROR_COMMUNICATION";
            }
            case 103: {
                return "RFC_ERROR_LOGON_FAILURE";
            }
            case 104: {
                return "RFC_ERROR_SYSTEM_FAILURE";
            }
            case 105: {
                return "RFC_ERROR_APPLICATION_EXCEPTION";
            }
            case 106: {
                return "RFC_ERROR_RESOURCE";
            }
            case 107: {
                return "RFC_ERROR_PROTOCOL";
            }
            case 108: {
                return "RFC_ERROR_INTERNAL";
            }
            case 109: {
                return "RFC_ERROR_CANCELLED";
            }
            case 110: {
                return "RFC_ERROR_BUSY";
            }
        }
        return "UNKNOWN_" + group;
    }

    public static String getRcAsString(int rfcRc) {
        switch (rfcRc) {
            case 0: {
                return "RFC_OK";
            }
            case 1: {
                return "RFC_FAILURE";
            }
            case 2: {
                return "RFC_EXCEPTION";
            }
            case 3: {
                return "RFC_SYS_EXCEPTION";
            }
            case 4: {
                return "RFC_CALL";
            }
            case 5: {
                return "RFC_INTERNAL_COM";
            }
            case 6: {
                return "RFC_CLOSED";
            }
            case 7: {
                return "RFC_RETRY";
            }
            case 8: {
                return "RFC_NO_TID";
            }
            case 9: {
                return "RFC_EXECUTED";
            }
            case 10: {
                return "RFC_SYNCHRONIZE";
            }
            case 11: {
                return "RFC_MEMORY_INSUFFICIENT";
            }
            case 12: {
                return "RFC_VERSION_MISMATCH";
            }
            case 13: {
                return "RFC_NOT_FOUND";
            }
            case 14: {
                return "RFC_CALL_NOT_SUPPORTED";
            }
            case 15: {
                return "RFC_NOT_OWNER";
            }
            case 16: {
                return "RFC_NOT_INITIALIZED";
            }
            case 17: {
                return "RFC_SYSTEM_CALLED";
            }
            case 18: {
                return "RFC_INVALID_HANDLE";
            }
            case 19: {
                return "RFC_INVALID_PARAMETER";
            }
            case 20: {
                return "RFC_CANCELED";
            }
            case 21: {
                return "RFC_CONVERSION";
            }
            case 22: {
                return "RFC_INVALID_PROTOCOL";
            }
        }
        return "Unknown RFC return code " + rfcRc;
    }

    private static int rfcGetToRc(int getRc) {
        switch (getRc) {
            case 0: {
                return 0;
            }
            case 1: {
                return 18;
            }
            case 2: {
                return 22;
            }
            case 7: {
                return 3;
            }
            case 14: {
                return 21;
            }
            case 8: {
                return 2;
            }
            case 13: {
                return 19;
            }
            case 12: {
                return 11;
            }
            case 11: {
                return 6;
            }
        }
        return 1;
    }

    public RfcException(int rfc_rc, String message, int errorGroup, long handle, boolean trace) {
        this(rfc_rc, message, errorGroup, handle, trace, null);
    }

    public RfcException(int rfc_rc, String message, int errorGroup, long handle, boolean trace, Throwable cause) {
        super(message, cause);
        this.m_rfcRc = rfc_rc;
        this.m_errorGroup = errorGroup;
        this.m_key = RfcException.getKey(errorGroup);
        RfcIoOpenCntl act_cntl = RfcIoControl.ab_rfccntl(handle);
        if (act_cntl != null) {
            this.systemInfo = "System " + (act_cntl.sysid == null ? "<empty>" : act_cntl.sysid) + '|' + act_cntl.target;
        }
        if (trace) {
            if (this.m_rfcRc != 2) {
                String msg = null;
                if (errorGroup == 101) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    this.printStackTrace(pw);
                    pw.flush();
                    pw.close();
                    msg = sw.toString();
                } else {
                    msg = this.toString();
                }
                Trc.criticalTrace(handle, msg);
            }
            if (act_cntl != null && act_cntl.trace && !Environment.inJTS()) {
                Trc.ab_rfctrc(this.toString());
            }
        } else if (act_cntl != null && act_cntl.trace) {
            Trc.ab_rfctrc(this.toString());
        }
    }

    public RfcException(RfcIoException ioEx) {
        super(ioEx.getMessage(), ioEx);
        this.m_rfcRc = RfcException.rfcIOtoRC(ioEx.getIoRc());
        this.m_errorGroup = ioEx.getErrorGroup();
        this.m_key = ioEx.getKey();
    }

    public RfcException(RfcGetException getEx, long handle) {
        super(getEx.getMessage(), getEx);
        this.m_rfcRc = RfcException.rfcGetToRc(getEx.getRc());
        this.m_errorGroup = getEx.getErrorGroup();
        this.m_key = getEx.getKey();
        switch (getEx.getRc()) {
            case 7: 
            case 8: {
                this.messageClass = getEx.getMessageClass();
                this.messageType = getEx.getMessageType();
                this.messageNumber = getEx.getMessageNumber();
                this.messageParameters = getEx.getMessageParameters();
                break;
            }
        }
        RfcIoOpenCntl act_cntl = RfcIoControl.ab_rfccntl(handle);
        if (act_cntl != null && act_cntl.trace) {
            Trc.ab_rfctrc(this.toString());
        }
    }

    public int getRc() {
        return this.m_rfcRc;
    }

    public int getErrorGroup() {
        return this.m_errorGroup;
    }

    public String getKey() {
        return this.m_key;
    }

    public String getMessageClass() {
        return this.messageClass;
    }

    public char getMessageType() {
        return this.messageType;
    }

    public String getMessageNumber() {
        return this.messageNumber;
    }

    public String[] getMessageParameters() {
        return this.messageParameters;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(300);
        buf.append("\nRfcException: [").append(this.systemInfo).append("]\n    message: ");
        buf.append(this.getMessage() == null ? "<no message>" : this.getMessage());
        buf.append("\n    Return code: ");
        buf.append(RfcException.getRcAsString(this.m_rfcRc));
        buf.append('(').append(this.m_rfcRc).append(')');
        buf.append("\n    error group: ");
        buf.append(this.m_errorGroup);
        buf.append("\n    key: ");
        buf.append(this.m_key);
        if (this.messageClass != null && this.messageClass.length() > 0) {
            buf.append("\n    message class: ");
            buf.append(this.messageClass);
        }
        if (this.messageType != '\u0000') {
            buf.append("\n    message type: ");
            buf.append(this.messageType);
        }
        if (this.messageNumber != null && this.messageNumber.length() > 0) {
            buf.append("\n    message number: ");
            buf.append(this.messageNumber);
        }
        if (this.messageParameters != null) {
            for (int i = 0; i < this.messageParameters.length; ++i) {
                if (this.messageParameters[i] == null || this.messageParameters[i].length() <= 0) continue;
                buf.append("\n    message parameter").append(" " + i).append(": ");
                buf.append(this.messageParameters[i]);
            }
        }
        return buf.toString();
    }
}

