/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.LogController;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.LoggingManager;
import com.sap.tc.logging.MSGCollection;
import com.sap.tc.logging.MsgObject;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Location
extends LogController {
    private static Location LOC = Location.getLocation("com.sap.tc.logging.Location", "tc~logging~java", "BC-JAS-ADM-LOG-API");
    static final String MSG_ENTERING = "Entering method";
    static final String MSG_ENTERING_WITH_PARS = "Entering method with ({0})";
    static final String MSG_EXITING = "Exiting method";
    static final String MSG_EXITING_WITH_RES = "Exiting method with {0}";
    public static final String ROOT_NAME = "";
    public static final char SEPARATOR = '.';
    public static final char SPACE = ' ';
    public static final char SINGLE_QUOTE = '\'';
    protected String vendor = "com.sap.";
    protected String dcName;
    protected String csnComponent;

    protected Location(String name) {
        super(name);
    }

    protected Location(String name, Location parent) {
        super(name, parent);
    }

    public static Location getRoot() {
        return Location.getLocation(ROOT_NAME);
    }

    public Location getParent() {
        return (Location)this.getParentInt();
    }

    private static String correctLocationName(String locationName) {
        boolean lastNotSeparator = true;
        if ((locationName = locationName.trim()).length() == 0) {
            return ROOT_NAME;
        }
        StringBuffer correctName = new StringBuffer(locationName.length());
        for (int i = 0; i < locationName.length(); ++i) {
            char currentChar = locationName.charAt(i);
            if (currentChar == '/' || currentChar <= ' ' || currentChar == '\'') continue;
            if (currentChar == '.') {
                if (lastNotSeparator) {
                    correctName.append(currentChar);
                }
                lastNotSeparator = false;
                continue;
            }
            correctName.append(currentChar);
            lastNotSeparator = true;
        }
        String finalName = correctName.toString();
        int len = finalName.length();
        if (len > 1 && finalName.charAt(len - 1) == '.') {
            finalName = finalName.substring(0, len - 1);
        }
        if (len > 1 && finalName.charAt(0) == '.') {
            finalName = finalName.substring(1);
        }
        return finalName;
    }

    public static Location getLocation(String name) {
        return Location.getLocation(Location.correctLocationName(name), null);
    }

    public static Location getLocation(String name, String vendor) {
        String callerClassloaderName = null;
        if (LoggingManager.classLoadInfoProvider != null) {
            callerClassloaderName = LoggingManager.classLoadInfoProvider.getCallerClassLoaderName();
        }
        Location result = LoggingManager.getLoggingManager().getLocation(name.trim());
        if ((result.csnComponent == null || result.csnComponent.equals(ROOT_NAME)) && (result.dcName == null || result.dcName.equals(ROOT_NAME)) && LoggingManager.classLoadInfoProvider != null && callerClassloaderName != null) {
            result.csnComponent = LoggingManager.classLoadInfoProvider.getCsnComponent(callerClassloaderName);
            result.dcName = LoggingManager.classLoadInfoProvider.getDcName(callerClassloaderName);
            if (result.dcName != null && result.csnComponent == null && LoggingManager.deployInfoProvider != null) {
                result.csnComponent = LoggingManager.deployInfoProvider.getCsnComponentByDcName(result.dcName);
            }
        }
        if (vendor != null) {
            result.setVendor(vendor);
        }
        return result;
    }

    public static Location getLocation(String name, String dcName, String csnComponent) {
        Location result = LoggingManager.getLoggingManager().getLocation(name.trim());
        result.dcName = dcName;
        result.csnComponent = csnComponent;
        if (result.dcName != null && result.csnComponent == null && LoggingManager.deployInfoProvider != null) {
            result.csnComponent = LoggingManager.deployInfoProvider.getCsnComponentByDcName(result.dcName);
        }
        return result;
    }

    public static Location getLocation(Object instance) {
        if (instance != null) {
            return Location.getLocation(instance.getClass());
        }
        LOC.logIntByAPI(400, LOC, "[getLocation(Object instance)]", MSGCollection.LOGGING_MSG_ID_OBJECT_IS_NULL, MSGCollection.LOGGING_MSG_STR_OBJECT_IS_NULL, new String[]{"Object", "Location", ROOT_NAME});
        return null;
    }

    public static Location getLocation(Class forClass) {
        if (forClass != null) {
            return Location.getLocation(forClass.getName());
        }
        LOC.logIntByAPI(400, LOC, "[getLocation(Class forClass)]", MSGCollection.LOGGING_MSG_ID_OBJECT_IS_NULL, MSGCollection.LOGGING_MSG_STR_OBJECT_IS_NULL, new String[]{"Class", "Location", ROOT_NAME});
        return null;
    }

    public static Location getLocation(Location loc, String name) {
        if (loc != Location.getRoot()) {
            return Location.getLocation(loc.getName() + '.' + name.trim());
        }
        return Location.getLocation(name);
    }

    public LogRecord log(int severity, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logTInt(severity, this, MSG_RELATIVES, MSG_SUB_LOC, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category category, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityTInt(severity, this, new LogController[]{category}, MSG_SUB_LOC, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category[] categories, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityTInt(severity, this, categories, MSG_SUB_LOC, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, String subloc, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logTInt(severity, this, MSG_RELATIVES, subloc, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category category, String subloc, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityTInt(severity, this, new LogController[]{category}, subloc, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category[] categories, String subloc, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityTInt(severity, this, categories, subloc, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logTInt(severity, this, MSG_RELATIVES, MSG_SUB_LOC, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category category, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityTInt(severity, this, new LogController[]{category}, MSG_SUB_LOC, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category[] categories, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityTInt(severity, this, categories, MSG_SUB_LOC, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, String subloc, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logTInt(severity, this, MSG_RELATIVES, subloc, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category category, String subloc, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityTInt(severity, this, new LogController[]{category}, subloc, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category[] categories, String subloc, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityTInt(severity, this, categories, subloc, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, String msg) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logTInt(severity, this, MSG_RELATIVES, MSG_SUB_LOC, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, Category category, String msg) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityTInt(severity, this, new LogController[]{category}, MSG_SUB_LOC, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, Category[] categories, String msg) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityTInt(severity, this, categories, MSG_SUB_LOC, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logTInt(severity, this, MSG_RELATIVES, subloc, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, Category category, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityTInt(severity, this, new LogController[]{category}, subloc, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, Category[] categories, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityTInt(severity, this, categories, subloc, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logTInt(severity, this, MSG_RELATIVES, MSG_SUB_LOC, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, Category category, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityTInt(severity, this, new LogController[]{category}, MSG_SUB_LOC, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, Category[] categories, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityTInt(severity, this, categories, MSG_SUB_LOC, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logTInt(severity, this, MSG_RELATIVES, subloc, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, Category category, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityTInt(severity, this, new LogController[]{category}, subloc, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, Category[] categories, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityTInt(severity, this, categories, subloc, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category category, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityInt(severity, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category[] categories, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityInt(severity, (LogController)this, (LogController[])categories, MSG_SUB_LOC, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category category, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityInt(severity, (LogController)this, new LogController[]{category}, subloc, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category[] categories, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityInt(severity, (LogController)this, (LogController[])categories, subloc, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category category, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityInt(severity, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category[] categories, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityInt(severity, (LogController)this, (LogController[])categories, MSG_SUB_LOC, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category category, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityInt(severity, (LogController)this, new LogController[]{category}, subloc, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category[] categories, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityInt(severity, (LogController)this, (LogController[])categories, subloc, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category category, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityInt(severity, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category[] categories, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityInt(severity, (LogController)this, (LogController[])categories, MSG_SUB_LOC, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category category, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityInt(severity, (LogController)this, new LogController[]{category}, subloc, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category[] categories, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityInt(severity, (LogController)this, (LogController[])categories, subloc, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category category, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityInt(severity, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category[] categories, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityInt(severity, (LogController)this, (LogController[])categories, null, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category category, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityInt(severity, (LogController)this, new LogController[]{category}, subloc, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category[] categories, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityInt(severity, (LogController)this, (LogController[])categories, subloc, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beDebug()) {
            writtenRec = this.logTInt(100, this, MSG_RELATIVES, MSG_SUB_LOC, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(Category category, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityTInt(100, this, new LogController[]{category}, MSG_SUB_LOC, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(Category[] categories, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityTInt(100, this, categories, MSG_SUB_LOC, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(String subloc, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beDebug()) {
            writtenRec = this.logTInt(100, this, MSG_RELATIVES, subloc, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(Category category, String subloc, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityTInt(100, this, new LogController[]{category}, subloc, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(Category[] categories, String subloc, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityTInt(100, this, categories, subloc, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beDebug()) {
            writtenRec = this.logTInt(100, this, MSG_RELATIVES, MSG_SUB_LOC, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(Category category, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityTInt(100, this, new LogController[]{category}, MSG_SUB_LOC, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(Category[] categories, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityTInt(100, this, categories, MSG_SUB_LOC, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(String subloc, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beDebug()) {
            writtenRec = this.logTInt(100, this, MSG_RELATIVES, subloc, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(Category category, String subloc, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityTInt(100, this, new LogController[]{category}, subloc, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(Category[] categories, String subloc, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityTInt(100, this, categories, subloc, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debugT(String msg) {
        LogRecord writtenRec = null;
        if (this.beDebug()) {
            writtenRec = this.logTInt(100, this, MSG_RELATIVES, MSG_SUB_LOC, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debugT(Category category, String msg) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityTInt(100, this, new LogController[]{category}, MSG_SUB_LOC, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debugT(Category[] categories, String msg) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityTInt(100, this, categories, MSG_SUB_LOC, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debugT(String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beDebug()) {
            writtenRec = this.logTInt(100, this, MSG_RELATIVES, subloc, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debugT(Category category, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityTInt(100, this, new LogController[]{category}, subloc, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debugT(Category[] categories, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityTInt(100, this, categories, subloc, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debugT(String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beDebug()) {
            writtenRec = this.logTInt(100, this, MSG_RELATIVES, MSG_SUB_LOC, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debugT(Category category, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityTInt(100, this, new LogController[]{category}, MSG_SUB_LOC, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debugT(Category[] categories, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityTInt(100, this, categories, MSG_SUB_LOC, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debugT(String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beDebug()) {
            writtenRec = this.logTInt(100, this, MSG_RELATIVES, subloc, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debugT(Category category, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityTInt(100, this, new LogController[]{category}, subloc, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debugT(Category[] categories, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityTInt(100, this, categories, subloc, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(Category category, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityInt(100, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(Category[] categories, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityInt(100, (LogController)this, (LogController[])categories, MSG_SUB_LOC, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(Category category, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityInt(100, (LogController)this, new LogController[]{category}, subloc, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(Category[] categories, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityInt(100, (LogController)this, (LogController[])categories, subloc, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(Category category, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityInt(100, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(Category[] categories, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityInt(100, (LogController)this, (LogController[])categories, MSG_SUB_LOC, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(Category category, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityInt(100, (LogController)this, new LogController[]{category}, subloc, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(Category[] categories, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityInt(100, (LogController)this, (LogController[])categories, subloc, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(Category category, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityInt(100, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(Category[] categories, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityInt(100, (LogController)this, (LogController[])categories, MSG_SUB_LOC, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(Category category, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityInt(100, (LogController)this, new LogController[]{category}, subloc, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(Category[] categories, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityInt(100, (LogController)this, (LogController[])categories, subloc, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(Category category, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityInt(100, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(Category[] categories, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityInt(100, (LogController)this, (LogController[])categories, MSG_SUB_LOC, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(Category category, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityInt(100, (LogController)this, new LogController[]{category}, subloc, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord debug(Category[] categories, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityInt(100, (LogController)this, (LogController[])categories, subloc, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            writtenRec = this.logTInt(200, this, MSG_RELATIVES, MSG_SUB_LOC, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(Category category, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityTInt(200, this, new LogController[]{category}, MSG_SUB_LOC, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(Category[] categories, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityTInt(200, this, categories, MSG_SUB_LOC, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(String subloc, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            writtenRec = this.logTInt(200, this, MSG_RELATIVES, subloc, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(Category category, String subloc, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityTInt(200, this, new LogController[]{category}, MSG_SUB_LOC, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(Category[] categories, String subloc, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityTInt(200, this, categories, subloc, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            writtenRec = this.logTInt(200, this, MSG_RELATIVES, MSG_SUB_LOC, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(Category category, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityTInt(200, this, new LogController[]{category}, MSG_SUB_LOC, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(Category[] categories, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityTInt(200, this, categories, MSG_SUB_LOC, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(String subloc, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            writtenRec = this.logTInt(200, this, MSG_RELATIVES, subloc, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(Category category, String subloc, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityTInt(200, this, new LogController[]{category}, subloc, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(Category[] categories, String subloc, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityTInt(200, this, categories, subloc, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord pathT(String msg) {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            writtenRec = this.logTInt(200, this, MSG_RELATIVES, MSG_SUB_LOC, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord pathT(Category category, String msg) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityTInt(200, this, new LogController[]{category}, MSG_SUB_LOC, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord pathT(Category[] categories, String msg) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityTInt(200, this, categories, MSG_SUB_LOC, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord pathT(String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            writtenRec = this.logTInt(200, this, MSG_RELATIVES, subloc, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord pathT(Category category, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityTInt(200, this, new LogController[]{category}, MSG_SUB_LOC, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord pathT(Category[] categories, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityTInt(200, this, categories, subloc, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord pathT(String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            writtenRec = this.logTInt(200, this, MSG_RELATIVES, MSG_SUB_LOC, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord pathT(Category category, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityTInt(200, this, new LogController[]{category}, MSG_SUB_LOC, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord pathT(Category[] categories, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityTInt(200, this, categories, MSG_SUB_LOC, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord pathT(String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            writtenRec = this.logTInt(200, this, MSG_RELATIVES, subloc, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord pathT(Category category, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityTInt(200, this, new LogController[]{category}, subloc, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord pathT(Category[] categories, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityTInt(200, this, categories, subloc, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(Category category, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityInt(200, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(Category[] categories, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityInt(200, (LogController)this, (LogController[])categories, MSG_SUB_LOC, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(Category category, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityInt(200, (LogController)this, new LogController[]{category}, subloc, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(Category[] categories, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityInt(200, (LogController)this, (LogController[])categories, subloc, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(Category category, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityInt(200, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(Category[] categories, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityInt(200, (LogController)this, (LogController[])categories, MSG_SUB_LOC, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(Category category, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityInt(200, (LogController)this, new LogController[]{category}, subloc, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(Category[] categories, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityInt(200, (LogController)this, (LogController[])categories, subloc, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(Category category, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityInt(200, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(Category[] categories, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityInt(200, (LogController)this, (LogController[])categories, MSG_SUB_LOC, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(Category category, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityInt(200, (LogController)this, new LogController[]{category}, subloc, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(Category[] categories, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityInt(200, (LogController)this, (LogController[])categories, subloc, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(Category category, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityInt(200, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(Category[] categories, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityInt(200, (LogController)this, (LogController[])categories, null, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(Category category, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityInt(200, (LogController)this, new LogController[]{category}, subloc, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord path(Category[] categories, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityInt(200, (LogController)this, (LogController[])categories, subloc, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beInfo()) {
            writtenRec = this.logTInt(300, this, MSG_RELATIVES, MSG_SUB_LOC, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(Category category, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityTInt(300, this, new LogController[]{category}, MSG_SUB_LOC, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(Category[] categories, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityTInt(300, this, categories, MSG_SUB_LOC, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(String subloc, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beInfo()) {
            writtenRec = this.logTInt(300, this, MSG_RELATIVES, subloc, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(Category category, String subloc, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityTInt(300, this, new LogController[]{category}, subloc, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(Category[] categories, String subloc, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityTInt(300, this, categories, subloc, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo()) {
            writtenRec = this.logTInt(300, this, MSG_RELATIVES, MSG_SUB_LOC, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(Category category, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityTInt(300, this, new LogController[]{category}, MSG_SUB_LOC, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(Category[] categories, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityTInt(300, this, categories, MSG_SUB_LOC, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(String subloc, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo()) {
            writtenRec = this.logTInt(300, this, MSG_RELATIVES, subloc, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(Category category, String subloc, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityTInt(300, this, new LogController[]{category}, subloc, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(Category[] categories, String subloc, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityTInt(300, this, categories, subloc, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord infoT(String msg) {
        LogRecord writtenRec = null;
        if (this.beInfo()) {
            writtenRec = this.logTInt(300, this, MSG_RELATIVES, MSG_SUB_LOC, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord infoT(Category category, String msg) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityTInt(300, this, new LogController[]{category}, MSG_SUB_LOC, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord infoT(Category[] categories, String msg) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityTInt(300, this, categories, MSG_SUB_LOC, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord infoT(String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beInfo()) {
            writtenRec = this.logTInt(300, this, MSG_RELATIVES, subloc, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord infoT(Category category, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityTInt(300, this, new LogController[]{category}, subloc, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord infoT(Category[] categories, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityTInt(300, this, categories, subloc, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord infoT(String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo()) {
            writtenRec = this.logTInt(300, this, MSG_RELATIVES, MSG_SUB_LOC, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord infoT(Category category, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityTInt(300, this, new LogController[]{category}, MSG_SUB_LOC, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord infoT(Category[] categories, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityTInt(300, this, categories, MSG_SUB_LOC, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord infoT(String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo()) {
            writtenRec = this.logTInt(300, this, MSG_RELATIVES, subloc, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord infoT(Category category, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityTInt(300, this, new LogController[]{category}, subloc, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord infoT(Category[] categories, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityTInt(300, this, categories, subloc, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(Category category, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityInt(300, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(Category[] categories, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityInt(300, (LogController)this, (LogController[])categories, MSG_SUB_LOC, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(Category category, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityInt(300, (LogController)this, new LogController[]{category}, subloc, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(Category[] categories, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityInt(300, (LogController)this, (LogController[])categories, subloc, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(Category category, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityInt(300, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(Category[] categories, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityInt(300, (LogController)this, (LogController[])categories, MSG_SUB_LOC, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(Category category, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityInt(300, (LogController)this, new LogController[]{category}, subloc, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(Category[] categories, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityInt(300, (LogController)this, (LogController[])categories, subloc, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(Category category, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityInt(300, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(Category[] categories, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityInt(300, (LogController)this, (LogController[])categories, MSG_SUB_LOC, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(Category category, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityInt(300, (LogController)this, new LogController[]{category}, subloc, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(Category[] categories, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityInt(300, (LogController)this, (LogController[])categories, subloc, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(Category category, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityInt(300, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(Category[] categories, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityInt(300, (LogController)this, (LogController[])categories, null, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(Category category, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityInt(300, (LogController)this, new LogController[]{category}, subloc, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord info(Category[] categories, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityInt(300, (LogController)this, (LogController[])categories, subloc, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beWarning()) {
            writtenRec = this.logTInt(400, this, MSG_RELATIVES, MSG_SUB_LOC, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(Category category, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityTInt(400, this, new LogController[]{category}, MSG_SUB_LOC, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(Category[] categories, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityTInt(400, this, categories, MSG_SUB_LOC, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(String subloc, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beWarning()) {
            writtenRec = this.logTInt(400, this, MSG_RELATIVES, subloc, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(Category category, String subloc, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityTInt(400, this, new LogController[]{category}, subloc, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(Category[] categories, String subloc, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityTInt(400, this, categories, subloc, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning()) {
            writtenRec = this.logTInt(400, this, MSG_RELATIVES, MSG_SUB_LOC, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(Category category, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityTInt(400, this, new LogController[]{category}, MSG_SUB_LOC, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(Category[] categories, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityTInt(400, this, categories, MSG_SUB_LOC, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(String subloc, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning()) {
            writtenRec = this.logTInt(400, this, MSG_RELATIVES, subloc, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(Category category, String subloc, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityTInt(400, this, new LogController[]{category}, subloc, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(Category[] categories, String subloc, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityTInt(400, this, categories, subloc, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warningT(String msg) {
        LogRecord writtenRec = null;
        if (this.beWarning()) {
            writtenRec = this.logTInt(400, this, MSG_RELATIVES, MSG_SUB_LOC, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warningT(Category category, String msg) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityTInt(400, this, new LogController[]{category}, MSG_SUB_LOC, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warningT(Category[] categories, String msg) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityTInt(400, this, categories, MSG_SUB_LOC, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warningT(String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beWarning()) {
            writtenRec = this.logTInt(400, this, MSG_RELATIVES, subloc, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warningT(Category category, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityTInt(400, this, new LogController[]{category}, subloc, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warningT(Category[] categories, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityTInt(400, this, categories, subloc, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warningT(String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning()) {
            writtenRec = this.logTInt(400, this, MSG_RELATIVES, MSG_SUB_LOC, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warningT(Category category, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityTInt(400, this, new LogController[]{category}, MSG_SUB_LOC, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warningT(Category[] categories, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityTInt(400, this, categories, MSG_SUB_LOC, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warningT(String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning()) {
            writtenRec = this.logTInt(400, this, MSG_RELATIVES, subloc, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warningT(Category category, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityTInt(400, this, new LogController[]{category}, subloc, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warningT(Category[] categories, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityTInt(400, this, categories, subloc, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(Category category, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityInt(400, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(Category[] categories, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityInt(400, (LogController)this, (LogController[])categories, MSG_SUB_LOC, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(Category category, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityInt(400, (LogController)this, new LogController[]{category}, subloc, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(Category[] categories, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityInt(400, (LogController)this, (LogController[])categories, subloc, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(Category category, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityInt(400, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(Category[] categories, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityInt(400, (LogController)this, (LogController[])categories, MSG_SUB_LOC, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(Category category, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityInt(400, (LogController)this, new LogController[]{category}, subloc, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(Category[] categories, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityInt(400, (LogController)this, (LogController[])categories, subloc, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(Category category, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityInt(400, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(Category[] categories, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityInt(400, (LogController)this, (LogController[])categories, MSG_SUB_LOC, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(Category category, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityInt(400, (LogController)this, new LogController[]{category}, subloc, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(Category[] categories, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityInt(400, (LogController)this, (LogController[])categories, subloc, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(Category category, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityInt(400, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(Category[] categories, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityInt(400, (LogController)this, (LogController[])categories, null, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(Category category, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityInt(400, (LogController)this, new LogController[]{category}, subloc, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord warning(Category[] categories, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityInt(400, (LogController)this, (LogController[])categories, subloc, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord error(MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beError()) {
            writtenRec = this.logTInt(500, this, MSG_RELATIVES, MSG_SUB_LOC, msgObject.getMsgText(), 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord error(Category category, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityTInt(500, this, new LogController[]{category}, MSG_SUB_LOC, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord error(Category[] categories, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityTInt(500, this, categories, MSG_SUB_LOC, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord error(String subloc, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beError()) {
            writtenRec = this.logTInt(500, this, MSG_RELATIVES, subloc, msgObject.getMsgText(), 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord error(Category category, String subloc, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityTInt(500, this, new LogController[]{category}, subloc, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord error(Category[] categories, String subloc, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityTInt(500, this, categories, subloc, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord error(MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError()) {
            writtenRec = this.logTInt(500, this, MSG_RELATIVES, MSG_SUB_LOC, msgObject.getMsgText(), 1, args);
        }
        return writtenRec;
    }

    public LogRecord error(Category category, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityTInt(500, this, new LogController[]{category}, MSG_SUB_LOC, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord error(Category[] categories, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityTInt(500, this, categories, MSG_SUB_LOC, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord error(String subloc, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError()) {
            writtenRec = this.logTInt(500, this, MSG_RELATIVES, subloc, msgObject.getMsgText(), 1, args);
        }
        return writtenRec;
    }

    public LogRecord error(Category category, String subloc, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityTInt(500, this, new LogController[]{category}, subloc, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord error(Category[] categories, String subloc, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityTInt(500, this, categories, subloc, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord errorT(String msg) {
        LogRecord writtenRec = null;
        if (this.beError()) {
            writtenRec = this.logTInt(500, this, MSG_RELATIVES, MSG_SUB_LOC, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord errorT(Category category, String msg) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityTInt(500, this, new LogController[]{category}, MSG_SUB_LOC, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord errorT(Category[] categories, String msg) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityTInt(500, this, categories, MSG_SUB_LOC, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord errorT(String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beError()) {
            writtenRec = this.logTInt(500, this, MSG_RELATIVES, subloc, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord errorT(Category category, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityTInt(500, this, new LogController[]{category}, subloc, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord errorT(Category[] categories, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityTInt(500, this, categories, subloc, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord errorT(String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError()) {
            writtenRec = this.logTInt(500, this, MSG_RELATIVES, MSG_SUB_LOC, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord errorT(Category category, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityTInt(500, this, new LogController[]{category}, MSG_SUB_LOC, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord errorT(Category[] categories, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityTInt(500, this, categories, MSG_SUB_LOC, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord errorT(String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError()) {
            writtenRec = this.logTInt(500, this, MSG_RELATIVES, subloc, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord errorT(Category category, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityTInt(500, this, new LogController[]{category}, subloc, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord errorT(Category[] categories, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityTInt(500, this, categories, subloc, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord error(Category category, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityInt(500, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord error(Category[] categories, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityInt(500, (LogController)this, (LogController[])categories, MSG_SUB_LOC, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord error(Category category, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityInt(500, (LogController)this, new LogController[]{category}, subloc, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord error(Category[] categories, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityInt(500, (LogController)this, (LogController[])categories, subloc, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord error(Category category, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityInt(500, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord error(Category[] categories, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityInt(500, (LogController)this, (LogController[])categories, MSG_SUB_LOC, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord error(Category category, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityInt(500, (LogController)this, new LogController[]{category}, subloc, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord error(Category[] categories, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityInt(500, (LogController)this, (LogController[])categories, subloc, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord error(Category category, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityInt(500, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord error(Category[] categories, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityInt(500, (LogController)this, (LogController[])categories, MSG_SUB_LOC, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord error(Category category, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityInt(500, (LogController)this, new LogController[]{category}, subloc, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord error(Category[] categories, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityInt(500, (LogController)this, (LogController[])categories, subloc, null, msgClear, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord error(Category category, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityInt(500, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord error(Category[] categories, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityInt(500, (LogController)this, (LogController[])categories, MSG_SUB_LOC, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord error(Category category, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityInt(500, (LogController)this, new LogController[]{category}, subloc, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord error(Category[] categories, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityInt(500, (LogController)this, (LogController[])categories, subloc, null, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatal(MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beFatal()) {
            writtenRec = this.logTInt(600, this, MSG_RELATIVES, MSG_SUB_LOC, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category category, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityTInt(600, this, new LogController[]{category}, MSG_SUB_LOC, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category[] categories, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityTInt(600, this, categories, MSG_SUB_LOC, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(String subloc, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beFatal()) {
            writtenRec = this.logTInt(600, this, MSG_RELATIVES, subloc, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category category, String subloc, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityTInt(600, this, new LogController[]{category}, MSG_SUB_LOC, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category[] categories, String subloc, MsgObject msgObject) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityTInt(600, this, categories, subloc, msgObject.getMsgText(), 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal()) {
            writtenRec = this.logTInt(600, this, MSG_RELATIVES, MSG_SUB_LOC, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category category, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityTInt(600, this, new LogController[]{category}, MSG_SUB_LOC, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category[] categories, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityTInt(600, this, categories, MSG_SUB_LOC, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(String subloc, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal()) {
            writtenRec = this.logTInt(600, this, MSG_RELATIVES, subloc, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category category, String subloc, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityTInt(600, this, new LogController[]{category}, subloc, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category[] categories, String subloc, MsgObject msgObject, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityTInt(600, this, categories, subloc, msgObject.getMsgText(), 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatalT(String msg) {
        LogRecord writtenRec = null;
        if (this.beFatal()) {
            writtenRec = this.logTInt(600, this, MSG_RELATIVES, MSG_SUB_LOC, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatalT(Category category, String msg) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityTInt(600, this, new LogController[]{category}, MSG_SUB_LOC, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatalT(Category[] categories, String msg) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityTInt(600, this, categories, MSG_SUB_LOC, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatalT(String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beFatal()) {
            writtenRec = this.logTInt(600, this, MSG_RELATIVES, subloc, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatalT(Category category, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityTInt(600, this, new LogController[]{category}, MSG_SUB_LOC, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatalT(Category[] categories, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityTInt(600, this, categories, subloc, msg, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatalT(String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal()) {
            writtenRec = this.logTInt(600, this, MSG_RELATIVES, MSG_SUB_LOC, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatalT(Category category, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityTInt(600, this, new LogController[]{category}, MSG_SUB_LOC, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatalT(Category[] categories, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityTInt(600, this, categories, MSG_SUB_LOC, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatalT(String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal()) {
            writtenRec = this.logTInt(600, this, MSG_RELATIVES, subloc, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatalT(Category category, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityTInt(600, this, new LogController[]{category}, subloc, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatalT(Category[] categories, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityTInt(600, this, categories, subloc, msg, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category category, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityInt(600, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category[] categories, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityInt(600, (LogController)this, (LogController[])categories, MSG_SUB_LOC, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category category, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityInt(600, (LogController)this, new LogController[]{category}, subloc, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category[] categories, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityInt(600, (LogController)this, (LogController[])categories, subloc, null, null, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category category, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityInt(600, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category[] categories, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityInt(600, (LogController)this, (LogController[])categories, MSG_SUB_LOC, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category category, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityInt(600, (LogController)this, new LogController[]{category}, subloc, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category[] categories, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityInt(600, (LogController)this, (LogController[])categories, subloc, null, null, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category category, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityInt(600, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category[] categories, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityInt(600, (LogController)this, (LogController[])categories, MSG_SUB_LOC, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category category, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityInt(600, (LogController)this, new LogController[]{category}, subloc, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category[] categories, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityInt(600, (LogController)this, (LogController[])categories, subloc, null, msgClear, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category category, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityInt(600, (LogController)this, new LogController[]{category}, MSG_SUB_LOC, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category[] categories, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityInt(600, (LogController)this, (LogController[])categories, null, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category category, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityInt(600, (LogController)this, new LogController[]{category}, subloc, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category[] categories, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityInt(600, (LogController)this, (LogController[])categories, subloc, null, msgClear, 1, args, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord entering() {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            writtenRec = this.logTInt(200, this, MSG_RELATIVES, MSG_SUB_LOC, MSG_ENTERING, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord entering(Category category) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityTInt(200, this, new LogController[]{category}, MSG_SUB_LOC, MSG_ENTERING, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord entering(Category[] categories) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityTInt(200, this, categories, MSG_SUB_LOC, MSG_ENTERING, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord entering(String subloc) {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            writtenRec = this.logTInt(200, this, MSG_RELATIVES, subloc, MSG_ENTERING, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord entering(Category category, String subloc) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityTInt(200, this, new LogController[]{category}, subloc, MSG_ENTERING, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord entering(Category[] categories, String subloc) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityTInt(200, this, categories, subloc, MSG_ENTERING, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    private String argumentsPack(Object[] args) {
        String argList = null;
        if (args != null) {
            argList = ROOT_NAME;
            for (int i = 0; i < args.length; ++i) {
                if (i >= 1) {
                    argList = argList + ", ";
                }
                if (args[i] != null) {
                    try {
                        argList = argList + args[i].toString();
                    }
                    catch (Exception ex) {
                        argList = argList + "<null>";
                    }
                    continue;
                }
                argList = argList + "<null>";
            }
        }
        return argList;
    }

    public LogRecord entering(Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            String argList = this.argumentsPack(args);
            writtenRec = this.logTInt(200, this, MSG_RELATIVES, MSG_SUB_LOC, MSG_ENTERING_WITH_PARS, 1, new Object[]{argList}, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord entering(Category category, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            String argList = this.argumentsPack(args);
            writtenRec = this.logSeverityTInt(200, this, new LogController[]{category}, MSG_SUB_LOC, MSG_ENTERING_WITH_PARS, 1, new Object[]{argList}, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord entering(Category[] categories, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            String argList = this.argumentsPack(args);
            writtenRec = this.logSeverityTInt(200, this, categories, MSG_SUB_LOC, MSG_ENTERING_WITH_PARS, 1, new Object[]{argList}, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord entering(String subloc, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            String argList = this.argumentsPack(args);
            writtenRec = this.logTInt(200, this, MSG_RELATIVES, subloc, MSG_ENTERING_WITH_PARS, 1, new Object[]{argList}, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord entering(Category category, String subloc, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            String argList = this.argumentsPack(args);
            writtenRec = this.logSeverityTInt(200, this, new LogController[]{category}, subloc, MSG_ENTERING_WITH_PARS, 1, new Object[]{argList}, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord entering(Category[] categories, String subloc, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            String argList = this.argumentsPack(args);
            writtenRec = this.logSeverityTInt(200, this, categories, subloc, MSG_ENTERING_WITH_PARS, 1, new Object[]{argList}, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord exiting() {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            writtenRec = this.logTInt(200, this, MSG_RELATIVES, MSG_SUB_LOC, MSG_EXITING, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public void exiting(String subloc) {
        if (this.bePath()) {
            this.logTInt(200, this, MSG_RELATIVES, subloc, MSG_EXITING, 0, MSG_ARGS, null, null, this.csnComponent, this.dcName);
        }
    }

    public LogRecord exiting(Object res) {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            writtenRec = this.logTInt(200, this, MSG_RELATIVES, MSG_SUB_LOC, MSG_EXITING_WITH_RES, 1, new Object[]{res}, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public void exiting(String subloc, Object res) {
        if (this.bePath()) {
            this.logTInt(200, this, MSG_RELATIVES, subloc, MSG_EXITING_WITH_RES, 1, new Object[]{res}, null, null, this.csnComponent, this.dcName);
        }
    }

    public LogRecord assertion(boolean assertion, String desc) {
        LogRecord writtenRec = null;
        if (!assertion && this.beError()) {
            writtenRec = this.logTInt(500, this, MSG_RELATIVES, MSG_SUB_LOC, "Assertion failed: {0}", 1, new Object[]{desc}, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord assertion(Category category, boolean assertion, String desc) {
        LogRecord writtenRec = null;
        if (!assertion && this.beError(category)) {
            writtenRec = this.logTInt(500, this, new LogController[]{category}, MSG_SUB_LOC, "Assertion failed: {0}", 1, new Object[]{desc}, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord assertion(Category[] categories, boolean assertion, String desc) {
        LogRecord writtenRec = null;
        if (!assertion && this.beError(categories)) {
            writtenRec = this.logTInt(500, this, categories, MSG_SUB_LOC, "Assertion failed: {0}", 1, new Object[]{desc}, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord assertion(String subloc, boolean assertion, String desc) {
        LogRecord writtenRec = null;
        if (!assertion && this.beError()) {
            writtenRec = this.logTInt(500, this, MSG_RELATIVES, subloc, "Assertion failed: {0}", 1, new Object[]{desc}, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord assertion(Category category, String subloc, boolean assertion, String desc) {
        LogRecord writtenRec = null;
        if (!assertion && this.beError(category)) {
            writtenRec = this.logTInt(500, this, new LogController[]{category}, subloc, "Assertion failed: {0}", 1, new Object[]{desc}, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord assertion(Category[] categories, String subloc, boolean assertion, String desc) {
        LogRecord writtenRec = null;
        if (!assertion && this.beError(categories)) {
            writtenRec = this.logTInt(500, this, categories, subloc, "Assertion failed: {0}", 1, new Object[]{desc}, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord throwing(Throwable exc) {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            writtenRec = this.logTInt(200, this, MSG_RELATIVES, MSG_SUB_LOC, "Throwing {0}", 1, new Object[]{exc}, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord throwing(Category category, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logTInt(200, this, new LogController[]{category}, MSG_SUB_LOC, "Throwing {0}", 1, new Object[]{exc}, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord throwing(Category[] categories, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logTInt(200, this, categories, MSG_SUB_LOC, "Throwing {0}", 1, new Object[]{exc}, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord throwing(String subloc, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            writtenRec = this.logTInt(200, this, MSG_RELATIVES, subloc, "Throwing {0}", 1, new Object[]{exc}, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord throwing(Category category, String subloc, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logTInt(200, this, new LogController[]{category}, subloc, "Throwing {0}", 1, new Object[]{exc}, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord throwing(Category[] categories, String subloc, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logTInt(200, this, categories, subloc, "Throwing {0}", 1, new Object[]{exc}, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    private String getStackTrace(Throwable exc) {
        StringWriter stack = new StringWriter();
        PrintWriter writer = new PrintWriter(stack);
        exc.printStackTrace(writer);
        return ((Object)stack).toString();
    }

    public LogRecord catching(Throwable exc) {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            writtenRec = this.logTInt(200, this, MSG_RELATIVES, MSG_SUB_LOC, "Caught {0}", 1, new Object[]{this.getStackTrace(exc)}, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord catching(Category category, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logTInt(200, this, new LogController[]{category}, MSG_SUB_LOC, "Caught {0}", 1, new Object[]{this.getStackTrace(exc)}, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord catching(Category[] categories, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logTInt(200, this, categories, MSG_SUB_LOC, "Caught {0}", 1, new Object[]{this.getStackTrace(exc)}, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord catching(String subloc, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            writtenRec = this.logTInt(200, this, MSG_RELATIVES, subloc, "Caught {0}", 1, new Object[]{this.getStackTrace(exc)}, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord catching(Category category, String subloc, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logTInt(200, this, new LogController[]{category}, subloc, "Caught {0}", 1, new Object[]{this.getStackTrace(exc)}, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord catching(Category[] categories, String subloc, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logTInt(200, this, categories, subloc, "Caught {0}", 1, new Object[]{this.getStackTrace(exc)}, null, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord traceThrowable(int severity, MsgObject msgObject, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logSeverityTInt(severity, this, MSG_RELATIVES, MSG_SUB_LOC, msgObject.getMsgText(), 1, MSG_ARGS, exc, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord traceThrowable(int severity, String subloc, MsgObject msgObject, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logSeverityTInt(severity, this, MSG_RELATIVES, subloc, msgObject.getMsgText(), 1, MSG_ARGS, exc, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord traceThrowable(int severity, MsgObject msgObject, Object[] args, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logSeverityTInt(severity, this, MSG_RELATIVES, MSG_SUB_LOC, msgObject.getMsgText(), 1, args, exc, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord traceThrowable(int severity, String subloc, MsgObject msgObject, Object[] args, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logSeverityTInt(severity, this, MSG_RELATIVES, subloc, msgObject.getMsgText(), 1, args, exc, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord traceThrowableT(int severity, String msg, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logSeverityTInt(severity, this, MSG_RELATIVES, MSG_SUB_LOC, msg, 1, MSG_ARGS, exc, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord traceThrowableT(int severity, String subloc, String msg, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logSeverityTInt(severity, this, MSG_RELATIVES, subloc, msg, 1, MSG_ARGS, exc, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord traceThrowableT(int severity, String msg, Object[] args, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logSeverityTInt(severity, this, MSG_RELATIVES, MSG_SUB_LOC, msg, 1, args, exc, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord traceThrowableT(int severity, String subloc, String msg, Object[] args, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logSeverityTInt(severity, this, MSG_RELATIVES, subloc, msg, 1, args, exc, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord traceThrowableT(int severity, Category cat, String msg, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, cat)) {
            writtenRec = this.logSeverityTInt(severity, this, new LogController[]{cat}, MSG_SUB_LOC, msg, 1, MSG_ARGS, exc, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord traceThrowableT(int severity, Category cat, String subloc, String msg, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, cat)) {
            writtenRec = this.logSeverityTInt(severity, this, new LogController[]{cat}, subloc, msg, 1, MSG_ARGS, exc, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord traceThrowableT(int severity, Category cat, String msg, Object[] args, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, cat)) {
            writtenRec = this.logSeverityTInt(severity, this, new LogController[]{cat}, MSG_SUB_LOC, msg, 1, args, exc, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public LogRecord traceThrowableT(int severity, Category cat, String subloc, String msg, Object[] args, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, cat)) {
            writtenRec = this.logSeverityTInt(severity, this, new LogController[]{cat}, subloc, msg, 1, args, exc, null, this.csnComponent, this.dcName);
        }
        return writtenRec;
    }

    public void openGroup(int severity) {
    }

    public void openGroup(int severity, String subloc) {
    }

    public void openGroup(int severity, Category category) {
    }

    public void openGroup(int severity, Category category, String subloc) {
    }

    public void openGroup(int severity, Category[] categories) {
    }

    public void openGroup(int severity, Category[] categories, String subloc) {
    }

    public void setMinimumSeverity(Category relative, int severity) {
        super.setMinimumSeverity(relative, severity);
    }

    public void setMinimumSeverity(Category relative) {
        super.setMinimumSeverity(relative);
    }

    public void setEffectiveSeverity(Category relative, int severity) {
        super.setEffectiveSeverity(relative, severity);
    }

    public void setEffectiveSeverity(Category relative) {
        super.setEffectiveSeverity(relative);
    }

    public void setMaximumSeverity(Category relative, int severity) {
        super.setMaximumSeverity(relative, severity);
    }

    public void setMaximumSeverity(Category relative) {
        super.setMaximumSeverity(relative);
    }

    protected String[] convertRelatives(LogController[] relatives) {
        return super.convertRelatives(relatives);
    }

    public void setVendor(String aVendor) {
        this.vendor = aVendor + ".";
    }

    public String getVendor() {
        return this.vendor.substring(0, this.vendor.length() - 1);
    }

    public void setDCName(String aDCName) {
        this.dcName = aDCName;
    }

    public String getDCName() {
        return this.dcName;
    }

    public void setCSNComponent(String aCSNComponent) {
        this.csnComponent = aCSNComponent;
    }

    public String getCSNComponent() {
        return this.csnComponent;
    }
}

