/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.APILogger;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.ExceptionHandling;
import com.sap.tc.logging.ExceptionManager;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Filter;
import com.sap.tc.logging.Group;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.LoggingManager;
import com.sap.tc.logging.MSGCollection;
import com.sap.tc.logging.Severity;
import com.sap.tc.logging.interfaces.IObjectInfo;
import com.sap.tc.logging.interfaces.ISATChecker;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LogController
extends ExceptionHandling
implements IObjectInfo {
    private static String subLoc = "LogController";
    static final String MSG_GRP_NAME = null;
    static final String MSG_GRP_DESC = null;
    static final String MSG_SUB_LOC = null;
    static final Object[] MSG_ARGS = null;
    static final LogController[] MSG_RELATIVES = null;
    static final String NO_RELATIVE_EMSG = "No relative";
    static final String NO_RELATIVES_EMSG = "No relatives";
    static final String MSG_ASSERT = "Assertion failed: {0}";
    static final String MSG_THROWING = "Throwing {0}";
    static final String MSG_CATCHING = "Caught {0}";
    static final String NULL_STRING = "<null>";
    private String lcName;
    private String lcDescription;
    private String logVerInUse;
    private LogController parent;
    private LinkedList<LogController> children = new LinkedList();
    private volatile boolean exceptionGuardian = false;
    private volatile String resourceBundleName = null;
    private volatile boolean resourceBundleSet = false;
    private volatile ClassLoader classLoader = null;
    private volatile boolean classLoaderSet = false;
    private volatile boolean isConfigChanged = false;
    private volatile Collection<Filter> filters = null;
    private volatile Collection<Log> logsRegistry = null;
    private volatile Collection<Log> logsNormal = null;
    private volatile Collection<Log> logsPrivate = null;
    private volatile Map<Log, LogController> logsLocal = null;
    private volatile int minSeverity = 0;
    private volatile int maxSeverity = 701;
    private volatile int prevMinSeverity = 0;
    private volatile int prevMaxSeverity = 701;
    volatile int effSeverity = 701;
    private Relations relations = new Relations();
    private Regarders regarders = new Regarders();
    private volatile int minEffRelationSeverity = 701;
    private int loggedSumCnt = 0;
    private int loggedCnt = 0;
    private static boolean isActivityTrackingEnabled;
    private static ISATChecker isActivityTracking;
    private boolean inheritFromParent = true;
    private boolean copyToSubtree = true;
    private static long[] SEVERITIES_USED;
    private static final Location mLoc;
    private static final Relation standardRelation;

    LogController(String name) {
        this.lcName = name;
        this.parent = null;
    }

    LogController(String name, LogController parent) {
        this.lcName = name;
        this.parent = parent;
        parent.addChild(this);
        this.initializeSeverities();
        this.initializeLogs();
    }

    public synchronized boolean isConfigurationChanged() {
        return this.isConfigChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Regarders regarders;
            Object[] lcs = this.getChildrenInt().toArray();
            for (int i = 0; i < lcs.length; ++i) {
                ((LogController)lcs[i]).release();
            }
            Regarders regarders2 = regarders = this.getRegarders();
            synchronized (regarders2) {
                while (!regarders.isEmpty()) {
                    LogController lc = regarders.getFirst();
                    lc.setEffectiveSeverity(this);
                    regarders.remove(lc);
                }
            }
            this.removeLogs();
            if (this.parent != null) {
                this.parent.getChildrenInt().remove(this);
            }
            this.isConfigChanged = false;
        }
        LoggingManager.getLoggingManager().release(this);
        APILogger.instrumentIntByAPI(subLoc + "[release()]", MSGCollection.CONFIGURATION_RESET(), new Object[]{this.getName()});
    }

    public synchronized void reset() {
        this.resetInt();
        this.resetLogs();
        LoggingManager.getLoggingManager().notifyLogControllerReset(this, false);
        APILogger.instrumentIntByAPI(subLoc + "[reset()]", MSGCollection.CONFIGURATION_RESET(), new Object[]{this.getName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAll() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.resetAllInt();
        }
        LoggingManager.getLoggingManager().notifyLogControllerReset(this, true);
        APILogger.instrumentIntByAPI(subLoc + "[resetAll()]", MSGCollection.CONFIGURATION_RESET(), new Object[]{this.getName()});
    }

    @Override
    public synchronized String getName() {
        return this.lcName;
    }

    public synchronized void setName(String name) {
        this.lcName = name;
    }

    @Override
    public synchronized String getDescription() {
        return this.lcDescription;
    }

    public synchronized void setDescription(String value) {
        this.lcDescription = value;
    }

    @Override
    public synchronized String getVerInUse() {
        return this.logVerInUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<LogController> getChildren() {
        Collection<LogController> children;
        Collection<LogController> collection = children = this.getChildrenInt();
        synchronized (collection) {
            return Collections.unmodifiableCollection(new ArrayList<LogController>(children));
        }
    }

    public void closeGroup() {
    }

    public int getGroupSize() {
        return 0;
    }

    public void setGroupSize(int size) {
    }

    public LogRecord groupT(String msg) {
        return null;
    }

    public LogRecord groupT(String subloc, String msg) {
        return null;
    }

    public LogRecord groupT(String msg, Object[] args) {
        return null;
    }

    public LogRecord groupT(String subloc, String msg, Object[] args) {
        return null;
    }

    public LogRecord group(Object msgCode) {
        return null;
    }

    public LogRecord group(String subloc, Object msgCode) {
        return null;
    }

    public LogRecord group(Object msgCode, Object[] args) {
        return null;
    }

    public LogRecord group(String subloc, Object msgCode, Object[] args) {
        return null;
    }

    public LogRecord group(Object msgCode, String msgClear) {
        return null;
    }

    public LogRecord group(String subloc, Object msgCode, String msgClear) {
        return null;
    }

    public LogRecord group(Object msgCode, Object[] args, String msgClear) {
        return null;
    }

    public LogRecord group(String subloc, Object msgCode, Object[] args, String msgClear) {
        return null;
    }

    public int getMinimumSeverity() {
        return this.minSeverity;
    }

    public int getMinimumSeverity(LogController relative) {
        if (this.check(relative)) {
            int minRelationSeverity = this.relations.get((LogController)relative).minSeverity;
            return this.minSeverity < minRelationSeverity ? this.minSeverity : minRelationSeverity;
        }
        return this.minSeverity;
    }

    public int getMinimumSeverity(LogController[] relatives) {
        this.check(relatives);
        if (relatives != null) {
            for (int i = 0; i < relatives.length; ++i) {
                int minRelationSeverity = this.relations.get((LogController)relatives[i]).minSeverity;
                this.minSeverity = this.minSeverity < minRelationSeverity ? this.minSeverity : minRelationSeverity;
            }
            return this.minSeverity;
        }
        return this.minSeverity;
    }

    public int getEffectiveSeverity() {
        return this.effSeverity;
    }

    public int getEffectiveSeverity(LogController relative) {
        if (this.check(relative)) {
            int effRelationSeverity = this.relations.get((LogController)relative).effSeverity;
            return this.effSeverity < effRelationSeverity ? this.effSeverity : effRelationSeverity;
        }
        return this.effSeverity;
    }

    public int getEffectiveSeverity(LogController[] relatives) {
        if (relatives != null) {
            this.check(relatives);
            for (int i = 0; i < relatives.length; ++i) {
                int effRelationSeverity = this.relations.get((LogController)relatives[i]).effSeverity;
                this.effSeverity = this.effSeverity < effRelationSeverity ? this.effSeverity : effRelationSeverity;
            }
        }
        return this.effSeverity;
    }

    public int getMaximumSeverity() {
        return this.maxSeverity;
    }

    public int getMaximumSeverity(LogController relative) {
        if (this.check(relative)) {
            int maxRelationSeverity = this.relations.get((LogController)relative).maxSeverity;
            return this.maxSeverity < maxRelationSeverity ? this.maxSeverity : maxRelationSeverity;
        }
        return this.maxSeverity;
    }

    public int getMaximumSeverity(LogController[] relatives) {
        this.check(relatives);
        if (relatives != null) {
            for (int i = 0; i < relatives.length; ++i) {
                int maxRelationSeverity = this.relations.get((LogController)relatives[i]).maxSeverity;
                this.maxSeverity = this.maxSeverity < maxRelationSeverity ? this.maxSeverity : maxRelationSeverity;
            }
            return this.maxSeverity;
        }
        return this.maxSeverity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinimumSeverity(int severity) {
        int oldValue = -1;
        int newValue = -1;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            oldValue = this.getMinimumSeverity();
            severity = Severity.correct(severity);
            boolean inherit = oldValue != severity;
            this.setInheritFromParent(inherit);
            LogController parent = this.getParentInt();
            if (parent != null && inherit) {
                this.minSeverity = severity;
                if (this.maxSeverity < this.minSeverity) {
                    this.maxSeverity = this.minSeverity;
                }
                this.calculateEffectiveSeverity();
            } else {
                this.setEffectiveSeverity(severity);
            }
            newValue = this.getMinimumSeverity();
            this.isConfigChanged = true;
        }
        if (oldValue != newValue && mLoc.bePath()) {
            Exception ex = new Exception("This exception stacktrace is to help seeing who is calling LogController.setMinimumSeverity() method that changes controller severity during runtime.");
            mLoc.traceThrowableT(200, "Severity of log controller " + this.getName() + " changed from " + Severity.toString(oldValue) + " to " + Severity.toString(newValue), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinimumSeverity() {
        int oldValue = -1;
        int newValue = -1;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            oldValue = this.getMinimumSeverity();
            this.setInheritFromParent(true);
            LogController parent = this.getParentInt();
            if (parent != null) {
                this.minSeverity = 0;
                this.calculateEffectiveSeverity();
            }
            newValue = this.getMinimumSeverity();
            this.isConfigChanged = true;
        }
        if (oldValue != newValue && mLoc.bePath()) {
            Exception ex = new Exception("This exception stacktrace is to help seeing who is calling LogController.setMinimumSeverity() method that changes controller severity during runtime.");
            mLoc.traceThrowableT(200, "Severity of log controller " + this.getName() + " changed from " + Severity.toString(oldValue) + " to " + Severity.toString(newValue), ex);
        }
    }

    public void setEffectiveSeverity(int severity) {
        this.setEffectiveSeverity(severity, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEffectiveSeverity(int severity, boolean copyToSubtree) {
        int oldValue = -1;
        int newValue = -1;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            oldValue = this.getEffectiveSeverity();
            severity = Severity.correct(severity);
            LogController parent = this.getParentInt();
            if (parent != null) {
                boolean inherit;
                boolean bl = inherit = severity == parent.getEffectiveSeverity();
                if (!inherit) {
                    this.setInheritFromParent(false);
                }
                if (!this.inheritFromParent) {
                    this.effSeverity = severity;
                }
            } else {
                this.effSeverity = severity;
            }
            this.minSeverity = severity;
            this.maxSeverity = severity;
            this.setCopyToSubtree(copyToSubtree);
            this.calculateEffectiveSeverity();
            newValue = this.getEffectiveSeverity();
            this.isConfigChanged = true;
        }
        if (oldValue != newValue && mLoc.bePath()) {
            Exception ex = new Exception("This exception stacktrace is to help seeing who is calling Logcontroller.setEffectiveSeverity() method that changes controller severity during runtime.");
            mLoc.traceThrowableT(200, "Severity of log controller " + this.getName() + " changed from " + Severity.toString(oldValue) + " to " + Severity.toString(newValue), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEffectiveSeverity() {
        int oldValue = -1;
        int newValue = -1;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            oldValue = this.getEffectiveSeverity();
            this.minSeverity = 0;
            this.maxSeverity = 701;
            this.setInheritFromParent(true);
            LogController parent = this.getParentInt();
            if (parent != null) {
                this.calculateEffectiveSeverity();
            } else {
                this.effSeverity = 701;
            }
            newValue = this.getEffectiveSeverity();
            this.isConfigChanged = true;
        }
        if (oldValue != newValue && mLoc.bePath()) {
            Exception ex = new Exception("This exception stacktrace is to help seeing who is calling Logcontroller.setEffectiveSeverity() method that changes controller severity during runtime.");
            mLoc.traceThrowableT(200, "Severity of log controller " + this.getName() + " changed from " + Severity.toString(oldValue) + " to " + Severity.toString(newValue), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumSeverity(int severity) {
        int oldValue = -1;
        int newValue = -1;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            oldValue = this.getMaximumSeverity();
            severity = Severity.correct(severity);
            boolean inherit = oldValue != severity;
            this.setInheritFromParent(inherit);
            LogController parent = this.getParentInt();
            if (parent != null && inherit) {
                this.maxSeverity = severity;
                if (this.maxSeverity < this.minSeverity) {
                    this.minSeverity = this.maxSeverity;
                }
                this.calculateEffectiveSeverity();
            } else {
                this.setEffectiveSeverity(severity);
            }
            newValue = this.getMaximumSeverity();
            this.isConfigChanged = true;
        }
        if (oldValue != newValue && mLoc.bePath()) {
            Exception ex = new Exception("This exception stacktrace is to help seeing who is calling LogController.setMaximumSeverity() method that changes controller severity during runtime.");
            mLoc.traceThrowableT(200, "Severity of log controller " + this.getName() + " changed from " + Severity.toString(oldValue) + " to " + Severity.toString(newValue), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumSeverity() {
        int oldValue = -1;
        int newValue = -1;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            oldValue = this.getMaximumSeverity();
            this.setInheritFromParent(true);
            LogController parent = this.getParentInt();
            if (parent != null) {
                this.maxSeverity = 701;
                this.calculateEffectiveSeverity();
            }
            newValue = this.getMaximumSeverity();
            this.isConfigChanged = true;
        }
        if (oldValue != newValue && mLoc.bePath()) {
            Exception ex = new Exception("This exception stacktrace is to help seeing who is calling LogController.setMaximumSeverity() method that changes controller severity during runtime.");
            mLoc.traceThrowableT(200, "Severity of log controller " + this.getName() + " changed from " + Severity.toString(oldValue) + " to " + Severity.toString(newValue), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Log> getLogs() {
        if (this.logsNormal == null) {
            return new HashSet<Log>();
        }
        Collection<Log> collection = this.logsNormal;
        synchronized (collection) {
            if (!this.logsNormal.isEmpty()) {
                return Collections.unmodifiableCollection(this.logsNormal);
            }
        }
        return new HashSet<Log>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Log> getLocalLogs() {
        if (this.logsLocal == null) {
            return new HashSet<Log>();
        }
        Map<Log, LogController> map = this.logsLocal;
        synchronized (map) {
            if (!this.logsLocal.isEmpty()) {
                return Collections.unmodifiableCollection(this.logsLocal.keySet());
            }
        }
        return new HashSet<Log>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Log> getPrivateLogs() {
        if (this.logsPrivate == null) {
            return new HashSet<Log>();
        }
        Collection<Log> collection = this.logsPrivate;
        synchronized (collection) {
            if (!this.logsPrivate.isEmpty()) {
                return Collections.unmodifiableCollection(this.logsPrivate);
            }
        }
        return new HashSet<Log>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Log> getAllLogs() {
        if (this.logsRegistry == null) {
            return new HashSet<Log>();
        }
        Collection<Log> collection = this.logsRegistry;
        synchronized (collection) {
            if (!this.logsRegistry.isEmpty()) {
                return Collections.unmodifiableCollection(this.logsRegistry);
            }
        }
        return new HashSet<Log>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLog(Log log) {
        boolean result = false;
        if (log != null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (!this.isLogInRegistry(log)) {
                    result = this.addLogNormalInt(log);
                    this.isConfigChanged = true;
                }
            }
            if (result) {
                LoggingManager.getLoggingManager().notifyAddLog(log);
                APILogger.instrumentIntByAPI(subLoc + "[addLog()]", MSGCollection.CONFIGURATION_NEW_ITEM(), new Object[]{"Log", log.getName(), this.getName()});
            }
        } else {
            APILogger.instrumentIntByAPI(100, subLoc + "[addLog(Log log)] " + MSGCollection.LOGGING_MSG_ID_OBJECT_IS_NULL, (Object[])new String[]{"Normal Log", "LogController", this.getName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalLog(Log log) {
        boolean result = false;
        if (log != null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (!this.isLogInRegistry(log)) {
                    result = this.addLogLocalInt(this, log);
                    this.isConfigChanged = true;
                }
            }
            if (result) {
                LoggingManager.getLoggingManager().notifyAddLog(log);
                APILogger.instrumentIntByAPI(subLoc + "[addLocalLog()]", MSGCollection.CONFIGURATION_NEW_ITEM(), new Object[]{"Local log", log.getName(), this.getName()});
            }
        } else {
            APILogger.instrumentIntByAPI(100, subLoc + "[addLocalLog(Log log)] " + MSGCollection.LOGGING_MSG_ID_OBJECT_IS_NULL, (Object[])new String[]{"Local Log", "LogController", this.getName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrivateLog(Log log) {
        boolean result = false;
        if (log != null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (!this.isLogInRegistry(log)) {
                    result = this.addLogPrivateInt(log);
                    this.isConfigChanged = true;
                }
            }
            if (result) {
                LoggingManager.getLoggingManager().notifyAddLog(log);
                APILogger.instrumentIntByAPI(subLoc + "[addPrivateLog()]", MSGCollection.CONFIGURATION_NEW_ITEM(), new Object[]{"Private log", log.getName(), this.getName()});
            }
        } else {
            APILogger.instrumentIntByAPI(100, subLoc + "[addPrivateLog(Log log)] " + MSGCollection.LOGGING_MSG_ID_OBJECT_IS_NULL, (Object[])new String[]{"Private Log", "LogController", this.getName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLog(Log log) {
        if (log != null) {
            boolean result = false;
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (this.isLogInRegistry(log)) {
                    if (this.logsNormal != null && !this.logsNormal.isEmpty()) {
                        this.removeLogNormalInt(log);
                    }
                    if (this.logsLocal != null && !this.logsLocal.isEmpty()) {
                        this.removeLogLocalInt(log);
                    }
                    if (this.logsPrivate != null && !this.logsPrivate.isEmpty()) {
                        this.removeLogPrivateInt(log);
                    }
                    result = true;
                    this.isConfigChanged = true;
                }
            }
            if (result) {
                LoggingManager.getLoggingManager().notifyRemoveLog(log);
                APILogger.instrumentIntByAPI(subLoc + "[removeLog(Log log)]", MSGCollection.CONFIGURATION_REMOVE_ITEM(), new Object[]{"Log", log.getName(), this.getName()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLogs() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (this.logsNormal != null && !this.logsNormal.isEmpty()) {
                this.removeLogsNormalInt();
            }
            if (this.logsLocal != null && !this.logsLocal.isEmpty()) {
                this.removeLogsLocalInt();
            }
            if (this.logsPrivate != null && !this.logsPrivate.isEmpty()) {
                this.removeLogsPrivateInt();
            }
            this.isConfigChanged = true;
        }
        APILogger.instrumentIntByAPI(subLoc + "[removeLogs()]", MSGCollection.CONFIGURATION_REMOVE_ITEM(), new Object[]{"Log", "ALL", this.getName()});
    }

    public boolean isFiltersAgreeing(LogRecord rec) {
        Collection<Filter> filters;
        if (rec.getSeverity() != 800 && !(filters = this.getFiltersInt()).isEmpty()) {
            Iterator<Filter> iter = filters.iterator();
            try {
                while (iter.hasNext()) {
                    if (iter.next().beLogged(rec)) continue;
                    return false;
                }
            }
            catch (Exception ex) {
                APILogger.logIntByAPI(400, subLoc + "[isFiltersAgreeing(LogRecord rec)]", MSGCollection.LOGGING_MSG_ID_FILTER_EXCEPTION, MSGCollection.LOGGING_MSG_STR_FILTER_EXCEPTION, new String[]{"LogController", this.getName()});
                APILogger.catchingIntByAPI(ex);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getFilters() {
        if (this.filters == null) {
            return Collections.EMPTY_LIST;
        }
        Collection<Filter> collection = this.filters;
        synchronized (collection) {
            if (!this.filters.isEmpty()) {
                return Collections.unmodifiableCollection(this.getFiltersInt());
            }
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Filter> getFiltersInt() {
        if (this.filters == null) {
            return new HashSet<Filter>();
        }
        Collection<Filter> collection = this.filters;
        synchronized (collection) {
            if (!this.filters.isEmpty()) {
                return this.filters;
            }
        }
        return new HashSet<Filter>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilter(Filter filter) {
        boolean result = false;
        if (this.filters == null) {
            this.filters = new HashSet<Filter>();
        }
        if (filter != null) {
            Collection<Filter> collection = this.filters;
            synchronized (collection) {
                if (!this.filters.contains(filter)) {
                    this.filters.add(filter);
                    result = true;
                    this.isConfigChanged = true;
                }
            }
            if (result) {
                APILogger.instrumentIntByAPI(subLoc + "[addFilter()]", MSGCollection.CONFIGURATION_NEW_ITEM(), new Object[]{"Filter", filter.getClass().getName(), this.getName()});
            }
        } else {
            APILogger.logIntByAPI(400, subLoc + "[addFilter(Filter filter)]", MSGCollection.LOGGING_MSG_ID_OBJECT_IS_NULL, MSGCollection.LOGGING_MSG_ID_OBJECT_IS_NULL, new String[]{"Filter", "LogController", this.getName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilter(Filter filter) {
        if (this.filters == null) {
            return;
        }
        Collection<Filter> collection = this.filters;
        synchronized (collection) {
            this.filters.remove(filter);
        }
        APILogger.instrumentIntByAPI(subLoc + "[removeFilter(Filter filter)]", MSGCollection.CONFIGURATION_REMOVE_ITEM(), new Object[]{"filter", filter.getClass().getName(), this.getName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilters() {
        if (this.filters == null) {
            return;
        }
        Collection<Filter> collection = this.filters;
        synchronized (collection) {
            this.filters.clear();
        }
        APILogger.instrumentIntByAPI(subLoc + "[removeFilters()]", MSGCollection.CONFIGURATION_REMOVE_ITEM(), new Object[]{"Filter", "ALL", this.getName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogController[] getRelatives() {
        LogController[] logControlers = null;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (this.relations == null) {
                return null;
            }
            if (!this.relations.relations.isEmpty()) {
                logControlers = this.relations.relations.keySet().toArray(new LogController[0]);
            }
        }
        return logControlers;
    }

    public String getResourceBundleName() {
        if (this.resourceBundleSet) {
            return this.resourceBundleName;
        }
        LogController parent = this.getParentInt();
        if (parent != null) {
            return parent.getResourceBundleName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceBundleName(String resourceBundleName) {
        String oldValue = "";
        String newValue = "";
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            oldValue = this.getResourceBundleName();
            this.resourceBundleName = resourceBundleName;
            this.resourceBundleSet = true;
            newValue = this.getResourceBundleName();
        }
        APILogger.instrumentIntByAPI(subLoc + "[setResourceBundleName(String resourceBundleName)]", MSGCollection.CONFIGURATION_IS_CHANGED(), new Object[]{"resource bundle name", "LogController", this.getName(), oldValue, newValue});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceBundleName() {
        String oldValue = "";
        String newValue = "";
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            oldValue = this.getResourceBundleName();
            this.resourceBundleName = null;
            this.resourceBundleSet = false;
            newValue = this.getResourceBundleName();
        }
        APILogger.instrumentIntByAPI(subLoc + "[setResourceBundleName()]", MSGCollection.CONFIGURATION_IS_CHANGED(), new Object[]{"resource bundle name", "LogController", this.getName(), oldValue, newValue});
    }

    public synchronized ClassLoader getClassLoader() {
        if (this.classLoaderSet) {
            return this.classLoader;
        }
        LogController parent = this.getParentInt();
        if (parent != null) {
            return parent.getClassLoader();
        }
        return null;
    }

    public synchronized void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.classLoaderSet = true;
    }

    public synchronized void setClassLoader() {
        this.classLoader = null;
        this.classLoaderSet = false;
    }

    public boolean beLogged(int severity) {
        return isActivityTrackingEnabled && this.isActivityTracking(severity) || severity >= this.effSeverity;
    }

    public boolean beLogged(int severity, LogController relative) {
        if (isActivityTrackingEnabled && this.isActivityTracking(severity) || severity >= this.effSeverity) {
            return true;
        }
        if (severity < this.minEffRelationSeverity) {
            return false;
        }
        return severity >= this.getEffectiveSeverity(relative);
    }

    public boolean beLogged(int severity, LogController[] relatives) {
        if (isActivityTrackingEnabled && this.isActivityTracking(severity) || severity >= this.effSeverity) {
            return true;
        }
        if (severity < this.minEffRelationSeverity) {
            return false;
        }
        return severity >= this.getEffectiveSeverity(relatives);
    }

    public boolean beDebug() {
        return isActivityTrackingEnabled && this.isActivityTracking(100) || 100 >= this.effSeverity;
    }

    public boolean beDebug(LogController relative) {
        if (isActivityTrackingEnabled && this.isActivityTracking(100) || 100 >= this.effSeverity) {
            return true;
        }
        if (100 < this.minEffRelationSeverity) {
            return false;
        }
        return 100 >= this.getEffectiveSeverity(relative);
    }

    public boolean beDebug(LogController[] relatives) {
        if (isActivityTrackingEnabled && this.isActivityTracking(100) || 100 >= this.effSeverity) {
            return true;
        }
        if (100 < this.minEffRelationSeverity) {
            return false;
        }
        return 100 >= this.getEffectiveSeverity(relatives);
    }

    public boolean bePath() {
        return isActivityTrackingEnabled && this.isActivityTracking(200) || 200 >= this.effSeverity;
    }

    public boolean bePath(LogController relative) {
        if (isActivityTrackingEnabled && this.isActivityTracking(200) || 200 >= this.effSeverity) {
            return true;
        }
        if (200 < this.minEffRelationSeverity) {
            return false;
        }
        return 200 >= this.getEffectiveSeverity(relative);
    }

    public boolean bePath(LogController[] relatives) {
        if (isActivityTrackingEnabled && this.isActivityTracking(200) || 200 >= this.effSeverity) {
            return true;
        }
        if (200 < this.minEffRelationSeverity) {
            return false;
        }
        return 200 >= this.getEffectiveSeverity(relatives);
    }

    public boolean beInfo() {
        return isActivityTrackingEnabled && this.isActivityTracking(300) || 300 >= this.effSeverity;
    }

    public boolean beInfo(LogController relative) {
        if (isActivityTrackingEnabled && this.isActivityTracking(300) || 300 >= this.effSeverity) {
            return true;
        }
        if (300 < this.minEffRelationSeverity) {
            return false;
        }
        return 300 >= this.getEffectiveSeverity(relative);
    }

    public boolean beInfo(LogController[] relatives) {
        if (isActivityTrackingEnabled && this.isActivityTracking(300) || 300 >= this.effSeverity) {
            return true;
        }
        if (300 < this.minEffRelationSeverity) {
            return false;
        }
        return 300 >= this.getEffectiveSeverity(relatives);
    }

    public boolean beWarning() {
        return isActivityTrackingEnabled && this.isActivityTracking(400) || 400 >= this.effSeverity;
    }

    public boolean beWarning(LogController relative) {
        if (isActivityTrackingEnabled && this.isActivityTracking(400) || 400 >= this.effSeverity) {
            return true;
        }
        if (400 < this.minEffRelationSeverity) {
            return false;
        }
        return 400 >= this.getEffectiveSeverity(relative);
    }

    public boolean beWarning(LogController[] relatives) {
        if (isActivityTrackingEnabled && this.isActivityTracking(400) || 400 >= this.effSeverity) {
            return true;
        }
        if (400 < this.minEffRelationSeverity) {
            return false;
        }
        return 400 >= this.getEffectiveSeverity(relatives);
    }

    public boolean beError() {
        return isActivityTrackingEnabled && this.isActivityTracking(500) || 500 >= this.effSeverity;
    }

    public boolean beError(LogController relative) {
        if (isActivityTrackingEnabled && this.isActivityTracking(500) || 500 >= this.effSeverity) {
            return true;
        }
        if (500 < this.minEffRelationSeverity) {
            return false;
        }
        return 500 >= this.getEffectiveSeverity(relative);
    }

    public boolean beError(LogController[] relatives) {
        if (isActivityTrackingEnabled && this.isActivityTracking(500) || 500 >= this.effSeverity) {
            return true;
        }
        if (500 < this.minEffRelationSeverity) {
            return false;
        }
        return 500 >= this.getEffectiveSeverity(relatives);
    }

    public boolean beFatal() {
        return isActivityTrackingEnabled && this.isActivityTracking(600) || 600 >= this.effSeverity;
    }

    public boolean beFatal(LogController relative) {
        if (isActivityTrackingEnabled && this.isActivityTracking(600) || 600 >= this.effSeverity) {
            return true;
        }
        if (600 < this.minEffRelationSeverity) {
            return false;
        }
        return 600 >= this.getEffectiveSeverity(relative);
    }

    public boolean beFatal(LogController[] relatives) {
        if (isActivityTrackingEnabled && this.isActivityTracking(600) || 600 >= this.effSeverity) {
            return true;
        }
        if (600 < this.minEffRelationSeverity) {
            return false;
        }
        return 600 >= this.getEffectiveSeverity(relatives);
    }

    public boolean beGroup() {
        return false;
    }

    public boolean isActivityTracking(int severity) {
        return isActivityTrackingEnabled && isActivityTracking.isActivity(this.getName(), severity);
    }

    public static synchronized void setActivityTracking(ISATChecker value) {
        isActivityTracking = value;
        isActivityTrackingEnabled = value != null;
    }

    public boolean getIsActivityTrackingEnabled() {
        return isActivityTrackingEnabled;
    }

    public int getLoggedCount() {
        return this.loggedSumCnt;
    }

    public void resetLoggedCount() {
        this.loggedSumCnt = 0;
    }

    public int getLoggedCnt() {
        return this.loggedCnt;
    }

    protected Map getLocalLogsMap() {
        if (this.logsLocal == null) {
            return Collections.EMPTY_MAP;
        }
        if (this.logsLocal != null) {
            return this.logsLocal;
        }
        return Collections.EMPTY_MAP;
    }

    protected String[] convertRelatives(LogController[] relatives) {
        String[] tmpValues = null;
        if (relatives != null) {
            tmpValues = new String[relatives.length];
            for (int i = 0; i < relatives.length; ++i) {
                tmpValues[i] = relatives[i].getName();
            }
        }
        return tmpValues;
    }

    protected LogRecord logIntByAPI(int severity, Location loc, String subloc, String msgCode, String msgClear, Object[] args) {
        return this.logInt(severity, (LogController)loc, null, subloc, msgCode, msgClear, 1, args);
    }

    protected LogRecord logIntByAPI(int severity, Location loc, String subloc, String msgCode, String msgClear, Object[] args, Throwable exc) {
        return this.logInt(severity, (LogController)loc, null, subloc, msgCode, msgClear, 1, args, exc);
    }

    protected LogRecord catchingIntByAPI(Throwable exc) {
        return this.logTInt(200, this, MSG_RELATIVES, MSG_SUB_LOC, MSG_CATCHING, 1, new Object[]{ExceptionManager.getStackTrace(exc)});
    }

    protected LogRecord messageInternal(LogRecord rec) throws Exception {
        LogRecord writtenRec = null;
        if (this.isFiltersAgreeing(rec)) {
            LogRecord tmpRec;
            if (this.logsNormal != null && !this.logsNormal.isEmpty() && (tmpRec = this.writeToLogs(this.logsNormal, rec)) != null) {
                this.setSumLogged();
                writtenRec = tmpRec;
            }
            if (this.logsLocal != null && !this.logsLocal.isEmpty() && (tmpRec = this.writeToLocalLogs(this.logsLocal, rec)) != null) {
                this.setSumLogged();
                writtenRec = tmpRec;
            }
            if (this.logsPrivate != null && !this.logsPrivate.isEmpty() && (tmpRec = this.writeToLogs(this.logsPrivate, rec)) != null) {
                this.setSumLogged();
                writtenRec = tmpRec;
            }
            if (writtenRec != null) {
                this.setLogged();
                LoggingManager.getLoggingManager().notifyWriteMessage(rec);
            }
        }
        return writtenRec;
    }

    void increaseSeverityCounters(LogRecord result, int severity) {
        if (result != null) {
            int index;
            int n = index = severity / 100 - 1;
            SEVERITIES_USED[n] = SEVERITIES_USED[n] + 1L;
        }
    }

    LogRecord logTInt(int severity, LogController loc, LogController[] relatives, String subloc, String msg, int msgType, Object[] args) {
        LogRecord result = this.logTInt(severity, loc, relatives, subloc, msg, msgType, args, null);
        this.increaseSeverityCounters(result, severity);
        return result;
    }

    LogRecord logTInt(int severity, LogController loc, LogController[] relatives, String subloc, String msg, int msgType, Object[] args, Throwable msgExc) {
        return this.logTInt(severity, loc, relatives, subloc, msg, msgType, args, msgExc, null, null, null);
    }

    LogRecord logTInt(int severity, LogController loc, LogController[] relatives, String subloc, String msg, int msgType, Object[] args, Throwable msgExc, String msgCode, String csnComponent, String dcName) {
        return this.logTInt(severity, loc, relatives, subloc, msg, msgType, args, msgExc, msgCode, csnComponent, dcName, null);
    }

    LogRecord logTInt(int severity, LogController loc, LogController[] relatives, String subloc, String msg, int msgType, Object[] args, Throwable msgExc, String msgCode, String csnComponent, String dcName, String sourceName) {
        LogRecord writtenRec = null;
        try {
            String locName = loc.getName();
            if (subloc != null) {
                locName = locName + '.' + subloc;
            }
            if (LoggingManager.getLoggingManager().getIncludeStackTraceForEachRecord()) {
                Exception e = new Exception();
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                msg = msg + System.getProperty("line.separator") + "Full message stacktrace: " + sw.toString();
                pw.close();
            }
            LogRecord rec = new LogRecord(this, locName, severity, this.convertRelatives(relatives), msgType, msg, this.checkArguments(args), msgExc);
            if (dcName != null) {
                rec.dcName = dcName;
            }
            if (csnComponent != null) {
                rec.csnComponent = csnComponent;
            }
            if (sourceName != null) {
                rec.setSourceName(sourceName);
            }
            writtenRec = this.messageInternal(rec);
        }
        catch (Exception ex) {
            if (this.exceptionGuardian) {
                this.increaseSeverityCounters(writtenRec, severity);
                return writtenRec;
            }
            this.exceptionGuardian = true;
            APILogger.logIntByAPI(400, subLoc + "[logIntT(...)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{this.getName()});
            APILogger.catchingIntByAPI(ex);
            this.handleException(ex, 3);
            this.exceptionGuardian = false;
        }
        this.increaseSeverityCounters(writtenRec, severity);
        return writtenRec;
    }

    LogRecord logSeverityTInt(int severity, LogController loc, LogController[] relatives, String subloc, String msg, int msgType, Object[] args) {
        return this.logSeverityTInt(severity, loc, relatives, subloc, msg, msgType, args, null, null, null, null);
    }

    LogRecord logSeverityTInt(int severity, LogController loc, LogController[] relatives, String subloc, String msg, int msgType, Object[] args, Throwable msgExc, String msgCode, String csnComponent, String dcName) {
        LogRecord writtenRec = null;
        writtenRec = this.logTInt(severity, loc, relatives, subloc, msg, msgType, args, msgExc, msgCode, csnComponent, dcName);
        if (relatives != null) {
            for (int i = 0; i < relatives.length; ++i) {
                LogController[] newRelatives = this.copyRelatives(relatives[i], relatives);
                if (!relatives[i].beLogged(severity, newRelatives)) continue;
                relatives[i].logTInt(severity, loc, newRelatives, subloc, msg, msgType, args, msgExc, msgCode, csnComponent, dcName, this.lcName);
            }
        }
        this.increaseSeverityCounters(writtenRec, severity);
        return writtenRec;
    }

    LogRecord logInt(int severity, LogController logC, LogController[] relatives, String subloc, String msgCode, String msgClear, int msgType, Object ... args) {
        return this.logInt(severity, logC, relatives, subloc, msgCode, msgClear, msgType, args, null);
    }

    LogRecord logInt(int severity, LogController logC, LogController[] relatives, String subloc, String msgCode, String msgClear, int msgType, Object[] args, Throwable msgExc) {
        return this.logInt(severity, logC, relatives, subloc, msgCode, null, null, msgClear, msgType, args, msgExc);
    }

    LogRecord logInt(int severity, LogController logC, LogController[] relatives, String subloc, String msgCode, String csnComponent, String dcName, String msgClear, int msgType, Object[] args, Throwable msgExc) {
        LogRecord writtenRec = null;
        try {
            String resBundleName = logC.getResourceBundleName();
            if (resBundleName == null) {
                resBundleName = this.getResourceBundleName();
            }
            String locName = logC.getName();
            if (subloc != null) {
                locName = locName + '.' + subloc;
            }
            if (LoggingManager.getLoggingManager().getIncludeStackTraceForEachRecord()) {
                Exception e = new Exception();
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                msgClear = msgClear + System.getProperty("line.separator") + "Full message stacktrace: " + sw.toString();
                pw.close();
            }
            String msgLocalized = this.resolveMessageAccordingResourceBundle(resBundleName, msgCode);
            LogRecord rec = new LogRecord(this, locName, severity, this.convertRelatives(relatives), msgType, msgCode, resBundleName, msgClear, this.checkArguments(args), msgExc, csnComponent);
            rec.resourceBundleName = resBundleName;
            rec.msgClear = msgLocalized != null ? msgLocalized : rec.msgDefault;
            if (dcName != null) {
                rec.dcName = dcName;
            }
            if (csnComponent != null) {
                rec.csnComponent = csnComponent;
            }
            writtenRec = this.messageInternal(rec);
        }
        catch (Exception ex) {
            if (this.exceptionGuardian) {
                this.increaseSeverityCounters(writtenRec, severity);
                return writtenRec;
            }
            this.exceptionGuardian = true;
            APILogger.logIntByAPI(400, subLoc + "[logInt(...)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{this.getName()});
            APILogger.catchingIntByAPI(ex);
            this.handleException(ex, 3);
            this.exceptionGuardian = false;
        }
        catch (Throwable th) {
            if (this.exceptionGuardian) {
                this.increaseSeverityCounters(writtenRec, severity);
                return writtenRec;
            }
            this.exceptionGuardian = true;
            APILogger.logIntByAPI(400, subLoc + "[logInt(...)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{this.getName()});
            APILogger.catchingIntByAPI(th);
            this.exceptionGuardian = false;
        }
        this.increaseSeverityCounters(writtenRec, severity);
        return writtenRec;
    }

    private String resolveMessageAccordingResourceBundle(String resBundleName, String msgID) {
        String thisMsgLocalized = null;
        if (resBundleName != null) {
            try {
                ResourceBundle msgs;
                ClassLoader classLoader = this.getClassLoader();
                if (classLoader != null) {
                    msgs = ResourceBundle.getBundle(resBundleName, LogRecord.STANDARD_LOCALE, classLoader);
                } else {
                    try {
                        msgs = ResourceBundle.getBundle(resBundleName, LogRecord.STANDARD_LOCALE);
                    }
                    catch (MissingResourceException exc) {
                        msgs = ResourceBundle.getBundle(resBundleName, LogRecord.STANDARD_LOCALE, Thread.currentThread().getContextClassLoader());
                    }
                }
                thisMsgLocalized = msgs.getString(msgID);
            }
            catch (MissingResourceException exc) {
                this.handleException(exc);
            }
            catch (SecurityException exc) {
                this.handleException(exc);
            }
            catch (NullPointerException exc) {
                this.handleException(exc);
            }
        }
        return thisMsgLocalized;
    }

    LogRecord logSeverityInt(int severity, LogController loc, LogController[] relatives, String subloc, String msgCode, String msgClear, int msgType, Object ... args) {
        return this.logSeverityInt(severity, loc, relatives, subloc, msgCode, null, null, msgClear, msgType, args);
    }

    LogRecord logSeverityInt(int severity, LogController loc, LogController[] relatives, String subloc, String msgCode, String csnComponent, String dcName, String msgClear, int msgType, Object ... args) {
        return this.logSeverityInt(severity, loc, relatives, subloc, null, msgType, msgCode, csnComponent, dcName, msgClear, args);
    }

    LogRecord logSeverityInt(int severity, LogController loc, LogController[] relatives, String subloc, Throwable msgExc, int msgType, String msgCode, String csnComponent, String dcName, String msgClear, Object ... args) {
        LogRecord writtenRec = this.logInt(severity, loc, relatives, subloc, msgCode, csnComponent, dcName, msgClear, msgType, args, msgExc);
        if (relatives != null) {
            for (int i = 0; i < relatives.length; ++i) {
                LogController[] newRelatives = this.copyRelatives(relatives[i], relatives);
                if (!relatives[i].beLogged(severity, newRelatives)) continue;
                relatives[i].logInt(severity, loc, newRelatives, subloc, msgCode, csnComponent, dcName, msgClear, msgType, args, msgExc);
            }
        }
        return writtenRec;
    }

    void openGroupInt(String grpName, String grpDescription, int severity, String subloc) {
    }

    void openGroupInt(String grpName, String grpDescription, int severity, String subloc, LogController logC) {
    }

    void openGroupInt(String grpName, String grpDescription, int severity, String subloc, LogController[] logCs) {
    }

    void closeGroupInt() {
    }

    void closeGroupInt(Group group) {
    }

    LogController getParentInt() {
        if (this.parent == null) {
            return this.parent;
        }
        if (this.parent.isCopyToSubtree()) {
            return this.parent;
        }
        return this.parent.getParentInt();
    }

    Collection<LogController> getChildrenInt() {
        return this.children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChild(LogController child) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            LinkedList<LogController> linkedList = this.children;
            synchronized (linkedList) {
                this.children.add(child);
            }
        }
    }

    Relations getRelations() {
        return this.relations;
    }

    Regarders getRegarders() {
        return this.regarders;
    }

    void resetAllInt() {
        this.resetInt();
        this.resetLogsInt();
        for (LogController lc : this.getChildrenInt()) {
            lc.resetAllInt();
            lc.resetLogsInt();
        }
    }

    void resetLogs() {
        this.resetLogsInt();
        for (LogController lc : this.getChildrenInt()) {
            lc.resetLogsInt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void resetLogsInt() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (this.logsNormal != null) {
                this.logsNormal.clear();
            }
            if (this.logsPrivate != null) {
                this.logsPrivate.clear();
            }
            if (this.logsLocal != null) {
                this.logsLocal.clear();
            }
            if (this.logsRegistry != null) {
                this.logsRegistry.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetInt() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.inheritFromParent = true;
            this.copyToSubtree = true;
            this.isConfigChanged = false;
            this.minSeverity = 0;
            this.maxSeverity = 701;
            this.prevMinSeverity = 0;
            this.prevMaxSeverity = 701;
            this.minEffRelationSeverity = 701;
            this.effSeverity = 701;
            if (this.filters != null) {
                this.filters.clear();
            }
            this.loggedCnt = 0;
            this.loggedSumCnt = 0;
        }
    }

    void setSumLogged() {
        ++this.loggedSumCnt;
    }

    boolean wasLogged() {
        return this.loggedCnt > 0;
    }

    void resetLogged() {
        this.loggedCnt = 0;
    }

    void setLogged() {
        ++this.loggedCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMinimumSeverity(LogController relative, int severity) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            LogController parent = this.getParentInt();
            if (this.isInheritFromParent() && parent != null) {
                severity = Severity.correct(severity);
                if (relative == null) {
                    this.handleException(new IllegalArgumentException(NO_RELATIVE_EMSG));
                }
                Relations relations = this.getRelations();
                Relation relation = (Relation)relations.get(relative).clone();
                relation.setLocalMinimumSeverity(severity);
                relations.put(relative, relation);
                this.calculateEffectiveSeverity(relative);
            } else {
                this.setEffectiveSeverity(relative, severity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMinimumSeverity(LogController relative) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            LogController parent = this.getParentInt();
            if (this.isInheritFromParent() && parent != null) {
                if (relative == null) {
                    this.handleException(new IllegalArgumentException(NO_RELATIVE_EMSG));
                }
                Relations relations = this.getRelations();
                Relation relation = (Relation)relations.get(relative).clone();
                relation.setLocalMinimumSeverity();
                relations.put(relative, relation);
                this.calculateEffectiveSeverity(relative);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEffectiveSeverity(LogController relative, int severity) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            severity = Severity.correct(severity);
            if (relative == null) {
                this.handleException(new IllegalArgumentException(NO_RELATIVE_EMSG));
            }
            Relations relations = this.getRelations();
            Relation relation = (Relation)relations.get(relative).clone();
            relation.setLocalMinimumSeverity(severity);
            relation.setLocalMaximumSeverity(severity);
            relations.put(relative, relation);
            this.calculateEffectiveSeverity(relative);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEffectiveSeverity(LogController relative) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            LogController parent = this.getParentInt();
            if (this.isInheritFromParent() && parent != null) {
                if (relative == null) {
                    this.handleException(new IllegalArgumentException(NO_RELATIVE_EMSG));
                }
                Relations relations = this.getRelations();
                Relation relation = (Relation)relations.get(relative).clone();
                relation.setEffectiveSeverity();
                relations.put(relative, relation);
                this.calculateEffectiveSeverity(relative);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMaximumSeverity(LogController relative, int severity) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            LogController parent = this.getParentInt();
            if (this.isInheritFromParent() && parent != null) {
                severity = Severity.correct(severity);
                if (relative == null) {
                    this.handleException(new IllegalArgumentException(NO_RELATIVE_EMSG));
                }
                Relations relations = this.getRelations();
                Relation relation = (Relation)relations.get(relative).clone();
                relation.setLocalMaximumSeverity(severity);
                relations.put(relative, relation);
                this.calculateEffectiveSeverity(relative);
            } else {
                this.setEffectiveSeverity(relative, severity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMaximumSeverity(LogController relative) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            LogController parent = this.getParentInt();
            if (this.isInheritFromParent() && parent != null) {
                if (relative == null) {
                    this.handleException(new IllegalArgumentException(NO_RELATIVE_EMSG));
                }
                Relations relations = this.getRelations();
                Relation relation = (Relation)relations.get(relative).clone();
                relation.setLocalMaximumSeverity();
                relations.put(relative, relation);
                this.calculateEffectiveSeverity(relative);
            }
        }
    }

    boolean beLogged(LogRecord rec) {
        int severity = rec.getSeverity();
        return this.beLogged(severity) && this.isFiltersAgreeing(rec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSeverities() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.calculateEffectiveSeverityInt();
            LogController parent = this.getParentInt();
            if (parent != null && this.isInheritFromParent()) {
                for (Map.Entry entry : parent.getRelations().entrySet()) {
                    Relation relation;
                    Relation parentRelation = (Relation)entry.getValue();
                    if (parentRelation.getMinimumSeverity() == 0 && parentRelation.getMaximumSeverity() == 701) {
                        relation = parentRelation;
                    } else {
                        relation = new Relation();
                        relation.calculateEffectiveSeverity(parentRelation.getEffectiveSeverity());
                    }
                    this.getRelations().put((LogController)entry.getKey(), relation);
                }
                this.minEffRelationSeverity = parent.minEffRelationSeverity;
                Iterator iter = parent.getRegarders().iterator();
                while (iter.hasNext()) {
                    LogController regarder = (LogController)iter.next();
                    Relations regarderRelations = regarder.getRelations();
                    Relation regarderRelation = new Relation();
                    Relation regarderParentRelation = regarderRelations.get(parent);
                    regarderRelation.calculateMinimumSeverity(regarderParentRelation.getMinimumSeverity());
                    regarderRelation.calculateMaximumSeverity(regarderParentRelation.getMaximumSeverity());
                    LogController parentRegarder = regarder.getParentInt();
                    if (parentRegarder != null) {
                        Relation parentRegarderRelation = parentRegarder.getRelations().get(this);
                        int parentRegarderMinSeverity = parentRegarderRelation.getMinimumSeverity();
                        int parentRegarderMaxSeverity = parentRegarderRelation.getMaximumSeverity();
                        if (parentRegarderMinSeverity == 0 && regarderRelation.getMinimumSeverity() == parentRegarderMinSeverity && parentRegarderMaxSeverity == 701 && regarderRelation.getMaximumSeverity() == parentRegarderMaxSeverity) {
                            regarderRelation = parentRegarderRelation;
                        } else {
                            regarderRelation.calculateEffectiveSeverity(parentRegarderRelation.getEffectiveSeverity());
                        }
                    } else {
                        regarderRelation.calculateEffectiveSeverity(regarderParentRelation.getEffectiveSeverity());
                    }
                    regarderRelations.put(this, regarderRelation);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateEffectiveSeverity() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (this.isChanged()) {
                this.calculateEffectiveSeverityInt();
            }
        }
    }

    private void calculateEffectiveSeverityInt() {
        LogController parent = this.getParentInt();
        if (parent != null && this.isInheritFromParent()) {
            int parentSeverity = parent.getEffectiveSeverity();
            this.effSeverity = parentSeverity < this.minSeverity ? this.minSeverity : (this.maxSeverity < parentSeverity ? this.maxSeverity : parentSeverity);
        }
        if (this.isCopyToSubtree()) {
            for (LogController lc : this.getChildrenInt()) {
                lc.calculateEffectiveSeverityInt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateEffectiveSeverity(LogController relative) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (this.getRelations().get(relative).isUnchanged()) {
                return;
            }
            this.calculateEffectiveSeverityInt(relative);
        }
    }

    private void calculateEffectiveSeverityInt(LogController relative) {
        Relations relations = this.getRelations();
        Relation relation = (Relation)relations.get(relative).clone();
        int prevEffSeverity = relation.getEffectiveSeverity();
        LogController parentRelative = relative.getParentInt();
        Relation parentRelativeRelation = relations.get(parentRelative);
        if (parentRelative != null) {
            relation.calculateMinimumSeverity(parentRelativeRelation.getMinimumSeverity());
            relation.calculateMaximumSeverity(parentRelativeRelation.getMaximumSeverity());
        } else {
            relation.calculateMinimumSeverity(relation.getLocalMinimumSeverity());
            relation.calculateMaximumSeverity(relation.getLocalMaximumSeverity());
        }
        LogController parent = this.getParentInt();
        if (parent != null && this.isInheritFromParent()) {
            Relation parentRelation = parent.getRelations().get(relative);
            int parentMinSeverity = parentRelation.getMinimumSeverity();
            int parentMaxSeverity = parentRelation.getMaximumSeverity();
            if (parentMinSeverity == 0 && relation.getMinimumSeverity() == parentMinSeverity && parentMaxSeverity == 701 && relation.getMaximumSeverity() == parentMaxSeverity) {
                relation = parentRelation;
            } else {
                relation.calculateEffectiveSeverity(parentRelation.getEffectiveSeverity());
            }
        } else {
            relation.calculateEffectiveSeverity(parentRelativeRelation.getEffectiveSeverity());
        }
        relations.put(relative, relation);
        int effSeverity = relation.getEffectiveSeverity();
        if (effSeverity < this.minEffRelationSeverity) {
            this.minEffRelationSeverity = effSeverity;
        } else if (effSeverity != this.minEffRelationSeverity && this.minEffRelationSeverity >= prevEffSeverity) {
            Iterator iter = this.getRelations().values().iterator();
            this.minEffRelationSeverity = 701;
            while (iter.hasNext()) {
                effSeverity = ((Relation)iter.next()).getEffectiveSeverity();
                if (effSeverity >= this.minEffRelationSeverity) continue;
                this.minEffRelationSeverity = effSeverity;
            }
        }
        if (this.isCopyToSubtree()) {
            Iterator<LogController> iter = this.getChildrenInt().iterator();
            while (iter.hasNext()) {
                iter.next().calculateEffectiveSeverityInt(relative);
            }
        }
        if (relative.isCopyToSubtree()) {
            Iterator<LogController> iter = relative.getChildrenInt().iterator();
            while (iter.hasNext()) {
                this.calculateEffectiveSeverityInt(iter.next());
            }
        }
    }

    private boolean isChanged() {
        if (!this.isCopyToSubtree() && this.minSeverity == this.prevMinSeverity && this.maxSeverity == this.prevMaxSeverity) {
            return false;
        }
        this.prevMinSeverity = this.minSeverity;
        this.prevMaxSeverity = this.maxSeverity;
        return true;
    }

    private Object[] checkArguments(Object[] args) {
        Object[] argValues = args;
        if (argValues != null) {
            for (int i = 0; i < argValues.length; ++i) {
                if (argValues[i] != null) continue;
                argValues[i] = NULL_STRING;
            }
        }
        return argValues;
    }

    private LogController[] copyRelatives(LogController logLC, LogController[] relatives) {
        LogController[] tmpRelatives = new LogController[relatives.length];
        for (int i = 0; i < relatives.length; ++i) {
            tmpRelatives[i] = relatives[i] != logLC ? relatives[i] : this;
        }
        return tmpRelatives;
    }

    private LogRecord writeToLogs(Collection logs, LogRecord rec) throws Exception {
        LogRecord writtenRec = null;
        for (Log log : logs) {
            if (!log.beLogged(rec)) continue;
            writtenRec = log.writeInternalByAPI(rec);
        }
        return writtenRec;
    }

    private LogRecord writeToLocalLogs(Map logs, LogRecord rec) throws Exception {
        LogRecord writtenRec = null;
        for (Map.Entry entry : logs.entrySet()) {
            Log log = (Log)entry.getKey();
            LogController lc = (LogController)entry.getValue();
            if (lc.equals(this) || !lc.beLogged(rec)) continue;
            writtenRec = log.writeInternalByAPI(rec);
        }
        return writtenRec;
    }

    private void initializeLogs() {
        LogController parent = this.getParentInt();
        if (parent != null) {
            for (Log log : parent.getLogs()) {
                this.addLogNormalInt(log);
            }
        }
        if (parent != null) {
            for (Map.Entry entry : parent.getLocalLogsMap().entrySet()) {
                Log log = (Log)entry.getKey();
                LogController lc = (LogController)entry.getValue();
                this.addLogLocalInt(lc, log);
            }
        }
    }

    private boolean isLogInRegistry(Log log) {
        if (this.logsRegistry == null) {
            return false;
        }
        return this.logsRegistry.contains(log);
    }

    private synchronized void addLogToRegistry(Log log) {
        if (this.logsRegistry == null) {
            this.logsRegistry = new HashSet<Log>();
        }
        if (!this.logsRegistry.contains(log)) {
            HashSet<Log> newLogs = new HashSet<Log>(this.logsRegistry);
            newLogs.add(log);
            this.logsRegistry = newLogs;
        }
    }

    private synchronized void removeLogFromRegistry(Log log) {
        if (this.logsRegistry == null) {
            return;
        }
        if (this.logsRegistry.contains(log)) {
            log.close();
            HashSet<Log> newLogs = new HashSet<Log>(this.logsRegistry);
            newLogs.remove(log);
            this.logsRegistry = newLogs;
            log.removeOwner(this.getName());
        }
    }

    private synchronized boolean addLogNormalInt(Log log) {
        if (this.logsNormal == null) {
            this.logsNormal = new HashSet<Log>();
        }
        if (!this.logsNormal.contains(log)) {
            HashSet<Log> newLogs = new HashSet<Log>(this.logsNormal);
            newLogs.add(log);
            this.logsNormal = newLogs;
            this.addLogToRegistry(log);
            log.addOwner(this.getName());
            for (LogController lc : this.getChildrenInt()) {
                lc.addLogNormalInt(log);
            }
            return true;
        }
        return false;
    }

    private synchronized boolean addLogLocalInt(LogController parent, Log log) {
        if (this.logsLocal == null) {
            this.logsLocal = new HashMap<Log, LogController>();
        }
        if (!this.logsLocal.containsValue(log)) {
            HashMap<Log, LogController> newLogs = new HashMap<Log, LogController>(this.logsLocal);
            newLogs.put(log, parent);
            this.logsLocal = newLogs;
            this.addLogToRegistry(log);
            log.addOwner(this.getName());
            Iterator<LogController> iter = this.getChildrenInt().iterator();
            while (iter.hasNext()) {
                iter.next().addLogLocalInt(parent, log);
            }
            return true;
        }
        return false;
    }

    private synchronized boolean addLogPrivateInt(Log log) {
        if (this.logsPrivate == null) {
            this.logsPrivate = new HashSet<Log>();
        }
        if (!this.logsPrivate.contains(log)) {
            HashSet<Log> newLogs = new HashSet<Log>(this.logsPrivate);
            newLogs.add(log);
            this.logsPrivate = newLogs;
            this.addLogToRegistry(log);
            log.addOwner(this.getName());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLogsNormalInt() {
        Log[] aLogs;
        if (this.logsNormal == null) {
            return;
        }
        Collection<Log> collection = this.logsNormal;
        synchronized (collection) {
            aLogs = this.logsNormal.toArray(new Log[this.logsNormal.size()]);
        }
        for (int i = 0; i < aLogs.length; ++i) {
            this.removeLogNormalInt(aLogs[i]);
            LoggingManager.getLoggingManager().notifyRemoveLog(aLogs[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLogsLocalInt() {
        Log[] aLogs;
        if (this.logsLocal == null) {
            return;
        }
        Map<Log, LogController> map = this.logsLocal;
        synchronized (map) {
            aLogs = this.logsLocal.keySet().toArray(new Log[this.logsLocal.size()]);
        }
        for (int i = 0; i < aLogs.length; ++i) {
            this.removeLogLocalInt(aLogs[i]);
            LoggingManager.getLoggingManager().notifyRemoveLog(aLogs[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLogsPrivateInt() {
        Log[] aLogs;
        if (this.logsPrivate == null) {
            return;
        }
        Collection<Log> collection = this.logsPrivate;
        synchronized (collection) {
            aLogs = this.logsPrivate.toArray(new Log[this.logsPrivate.size()]);
        }
        for (int i = 0; i < aLogs.length; ++i) {
            this.removeLogPrivateInt(aLogs[i]);
            LoggingManager.getLoggingManager().notifyRemoveLog(aLogs[i]);
        }
    }

    private synchronized void removeLogNormalInt(Log log) {
        if (this.logsNormal == null) {
            return;
        }
        if (this.logsNormal.contains(log)) {
            HashSet<Log> newLogs = new HashSet<Log>(this.logsNormal);
            newLogs.remove(log);
            this.logsNormal = newLogs;
            this.removeLogFromRegistry(log);
            Iterator<LogController> iter = this.getChildrenInt().iterator();
            while (iter.hasNext()) {
                iter.next().removeLogNormalInt(log);
            }
        }
    }

    private synchronized void removeLogLocalInt(Log log) {
        if (this.logsLocal == null) {
            return;
        }
        if (this.logsLocal.containsKey(log)) {
            HashMap<Log, LogController> newLogs = new HashMap<Log, LogController>(this.logsLocal);
            newLogs.remove(log);
            this.logsLocal = newLogs;
            this.removeLogFromRegistry(log);
            Iterator<LogController> iter = this.getChildrenInt().iterator();
            while (iter.hasNext()) {
                iter.next().removeLogLocalInt(log);
            }
        }
    }

    private synchronized void removeLogPrivateInt(Log log) {
        if (this.logsPrivate == null) {
            return;
        }
        if (this.logsPrivate.contains(log)) {
            HashSet<Log> newLogs = new HashSet<Log>(this.logsPrivate);
            newLogs.remove(log);
            this.logsPrivate = newLogs;
            this.removeLogFromRegistry(log);
        }
    }

    private boolean check(LogController relative) {
        if (relative != null) {
            return true;
        }
        this.handleException(new IllegalArgumentException(NO_RELATIVE_EMSG));
        return false;
    }

    private boolean check(LogController[] relatives) {
        if (relatives != null) {
            for (int i = 0; i < relatives.length; ++i) {
                if (relatives[i] != null) continue;
                this.handleException(new IllegalArgumentException(NO_RELATIVE_EMSG));
                return false;
            }
            return true;
        }
        this.handleException(new IllegalArgumentException(NO_RELATIVES_EMSG));
        return false;
    }

    protected LogRecord messageInt(LogRecord rec) {
        LogRecord writtenRec = null;
        try {
            writtenRec = this.messageInternal(rec);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return writtenRec;
    }

    public boolean isCopyToSubtree() {
        return this.copyToSubtree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCopyToSubtree(boolean copyToSubtree) {
        this.copyToSubtree = copyToSubtree;
        if (copyToSubtree) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                this.setInheritFromParent(this.getChildrenInt(), true);
                this.setCopyToSubtree(this.getChildrenInt(), true);
                for (LogController lc : this.getChildrenInt()) {
                    lc.calculateEffectiveSeverityInt();
                }
            }
        }
        this.inheritFromParent = copyToSubtree;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.setInheritFromParent(this.getChildrenInt(), false);
            for (LogController lc : this.getChildrenInt()) {
                lc.calculateEffectiveSeverityInt();
            }
        }
    }

    private void setInheritFromParent(Collection<LogController> children, boolean inherit) {
        for (LogController lc : children) {
            lc.setInheritFromParent(inherit);
            lc.maxSeverity = this.effSeverity;
            lc.minSeverity = this.effSeverity;
            this.setInheritFromParent(lc.getChildren(), inherit);
        }
    }

    private void setCopyToSubtree(Collection<LogController> children, boolean copyToSubtree) {
        for (LogController lc : children) {
            lc.setCopyToSubtreeProperty(copyToSubtree);
            this.setCopyToSubtree(lc.getChildren(), copyToSubtree);
        }
    }

    public boolean isInheritFromParent() {
        return this.inheritFromParent;
    }

    private void setInheritFromParent(boolean inheritFromParent) {
        this.inheritFromParent = inheritFromParent;
    }

    private void setCopyToSubtreeProperty(boolean copyToSubtree) {
        this.copyToSubtree = copyToSubtree;
    }

    public static void resetSeverityCounters() {
        for (int i = 0; i < SEVERITIES_USED.length; ++i) {
            LogController.SEVERITIES_USED[i] = 0L;
        }
    }

    public static long getDebugCounter() {
        return SEVERITIES_USED[0];
    }

    public static long getPathCounter() {
        return SEVERITIES_USED[1];
    }

    public static long getInfoCounter() {
        return SEVERITIES_USED[2];
    }

    public static long getWarningCounter() {
        return SEVERITIES_USED[3];
    }

    public static long getErrorCounter() {
        return SEVERITIES_USED[4];
    }

    public static long getFatalCounter() {
        return SEVERITIES_USED[5];
    }

    public static long getTotalLogsCount() {
        return LogController.getDebugCounter() + LogController.getPathCounter() + LogController.getInfoCounter() + LogController.getWarningCounter() + LogController.getErrorCounter() + LogController.getFatalCounter();
    }

    static {
        String flagAPI = null;
        try {
            flagAPI = System.getProperty("eventLog");
        }
        catch (Exception ex) {
            flagAPI = null;
        }
        if (flagAPI != null && flagAPI.length() > 0) {
            if (flagAPI.equalsIgnoreCase("all") || flagAPI.equalsIgnoreCase("log")) {
                Category.SYS_LOGGING.setEffectiveSeverity(0);
                Category.SYS_LOGGING.addLog(new FileLog("loggingAPI.log"));
            }
            if (flagAPI.equalsIgnoreCase("all") || flagAPI.equalsIgnoreCase("trace")) {
                Location.getLocation("com.sap.tc.logging", "tc~logging~java", "BC-JAS-ADM-LOG-API").setEffectiveSeverity(0);
                Location.getLocation("com.sap.tc.logging", "tc~logging~java", "BC-JAS-ADM-LOG-API").addLog(new FileLog("loggingAPI.trc"));
            }
        }
        SEVERITIES_USED = new long[6];
        mLoc = Location.getLocation(LogController.class.getName(), "tc~logging~java", "BC-JAS-ADM-LOG-API");
        standardRelation = new Relation();
    }

    private static class Regarders {
        private LinkedList<LogController> ordered = new LinkedList();
        private HashSet<LogController> contained = new HashSet();

        private Regarders() {
        }

        public void put(LogController regarder) {
            if (!this.contained.contains(regarder)) {
                LogController parent;
                for (parent = regarder.getParentInt(); parent != null && !this.contained.contains(parent); parent = parent.getParentInt()) {
                }
                if (parent != null) {
                    ListIterator<LogController> iter = this.ordered.listIterator();
                    while (iter.hasNext()) {
                        if (iter.next() != parent) continue;
                        iter.add(regarder);
                        break;
                    }
                } else {
                    this.ordered.addFirst(regarder);
                }
                this.contained.add(regarder);
            }
        }

        public void remove(LogController regarder) {
            if (this.contained.contains(regarder)) {
                this.ordered.remove(regarder);
                this.contained.remove(regarder);
            }
        }

        public boolean isEmpty() {
            return this.ordered.isEmpty();
        }

        public LogController getFirst() {
            return this.ordered.getFirst();
        }

        public Iterator iterator() {
            return this.ordered.iterator();
        }
    }

    private class Relations {
        private HashMap<LogController, Relation> relations = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Relation get(LogController relative) {
            Relation relation;
            HashMap<LogController, Relation> hashMap = this.relations;
            synchronized (hashMap) {
                relation = this.relations.get(relative);
            }
            if (relation == null) {
                relation = standardRelation;
            }
            return relation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(LogController relative, Relation relation) {
            if (!relation.equals(standardRelation)) {
                HashMap<LogController, Relation> hashMap = this.relations;
                synchronized (hashMap) {
                    this.relations.put(relative, relation);
                }
                relative.getRegarders().put(LogController.this);
            } else {
                HashMap<LogController, Relation> hashMap = this.relations;
                synchronized (hashMap) {
                    this.relations.remove(relative);
                }
                relative.getRegarders().remove(LogController.this);
            }
        }

        public Set entrySet() {
            return this.relations.entrySet();
        }

        public Collection values() {
            return this.relations.values();
        }
    }

    private static class Relation
    implements Cloneable {
        public volatile int localMinSeverity = 0;
        public volatile int minSeverity = 0;
        public volatile int localMaxSeverity = 701;
        public volatile int maxSeverity = 701;
        public volatile int effSeverity = 701;
        private volatile int prevLocalMinSeverity = 0;
        private volatile int prevLocalMaxSeverity = 701;

        private Relation() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException exc) {
                return null;
            }
        }

        public int getLocalMinimumSeverity() {
            return this.localMinSeverity;
        }

        public int getMinimumSeverity() {
            return this.minSeverity;
        }

        public int getEffectiveSeverity() {
            return this.effSeverity;
        }

        public int getLocalMaximumSeverity() {
            return this.localMaxSeverity;
        }

        public int getMaximumSeverity() {
            return this.maxSeverity;
        }

        public synchronized void setLocalMinimumSeverity(int severity) {
            this.localMinSeverity = severity;
            if (this.localMinSeverity > this.localMaxSeverity) {
                this.localMaxSeverity = this.localMinSeverity;
            }
        }

        public void setLocalMinimumSeverity() {
            this.localMinSeverity = 0;
        }

        public synchronized void calculateMinimumSeverity(int parentSeverity) {
            this.minSeverity = parentSeverity < this.localMinSeverity ? this.localMinSeverity : (this.localMaxSeverity < parentSeverity ? this.localMaxSeverity : parentSeverity);
        }

        public void setEffectiveSeverity(int severity) {
            this.effSeverity = severity;
        }

        public void setEffectiveSeverity() {
            this.localMinSeverity = 0;
            this.localMaxSeverity = 701;
        }

        public synchronized void calculateEffectiveSeverity(int parentSeverity) {
            this.effSeverity = parentSeverity < this.minSeverity ? this.minSeverity : (this.maxSeverity < parentSeverity ? this.maxSeverity : parentSeverity);
        }

        public synchronized void setLocalMaximumSeverity(int severity) {
            this.localMaxSeverity = severity;
            if (this.localMinSeverity > this.localMaxSeverity) {
                this.localMinSeverity = this.localMaxSeverity;
            }
        }

        public void setLocalMaximumSeverity() {
            this.localMaxSeverity = 701;
        }

        public synchronized void calculateMaximumSeverity(int parentSeverity) {
            this.maxSeverity = this.localMaxSeverity < parentSeverity ? this.localMaxSeverity : (parentSeverity < this.localMinSeverity ? this.localMinSeverity : parentSeverity);
        }

        public synchronized boolean isUnchanged() {
            if (this.localMinSeverity == this.prevLocalMinSeverity && this.localMaxSeverity == this.prevLocalMaxSeverity) {
                return true;
            }
            this.prevLocalMinSeverity = this.localMinSeverity;
            this.prevLocalMaxSeverity = this.localMaxSeverity;
            return false;
        }
    }
}

