/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.LoggingManager;
import com.sap.tc.logging.Version;

public abstract class LogInfoData {
    private String logName;
    private String logDescription;
    private String logVersion;
    private String logType;
    private Formatter logFormatter;
    private String logHeader;
    private String logFooter;
    private boolean isChanged;

    public String getVerInUse() {
        if (this.logVersion != null) {
            return this.logVersion;
        }
        return Version.getFullVersion();
    }

    public String getName() {
        return this.logName;
    }

    public String getDescription() {
        return this.logDescription;
    }

    public String getType() {
        return this.logType;
    }

    public Formatter getFormatter() {
        if (this.logFormatter != null) {
            return this.logFormatter;
        }
        this.logFormatter = LoggingManager.DEFAULT_FORMATTER;
        return this.logFormatter;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public String getHeader() {
        if (this.logHeader != null) {
            return this.logHeader;
        }
        return "";
    }

    public String getFooter() {
        if (this.logFooter != null) {
            return this.logFooter;
        }
        return "";
    }

    public int length() {
        return this.getHeader().length();
    }

    protected void setVerInUse(String value) {
        this.logVersion = value;
        this.isChanged = true;
    }

    protected void setName(String value) {
        this.logName = value;
        this.isChanged = true;
    }

    protected void setDescription(String value) {
        this.logDescription = value;
        this.isChanged = true;
    }

    protected void setType(int value) {
    }

    public void setFormatter(Formatter value) {
        this.logFormatter = value;
        this.isChanged = true;
    }

    protected void headerIsChanged() {
        this.isChanged = true;
    }

    protected void resetIsChanged() {
        this.isChanged = false;
    }

    protected void setHeader(String value) {
        this.logHeader = value;
    }
}

