/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.APILogger;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Configurator;
import com.sap.tc.logging.ConsoleLog;
import com.sap.tc.logging.CreateLogfileEvent;
import com.sap.tc.logging.CreateLogfileListener;
import com.sap.tc.logging.EventDispatcher;
import com.sap.tc.logging.EventListener;
import com.sap.tc.logging.ExceptionHandling;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.GUId;
import com.sap.tc.logging.ListFormatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogController;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.MSGCollection;
import com.sap.tc.logging.MessageEvent;
import com.sap.tc.logging.MessageEventListener;
import com.sap.tc.logging.MsgType;
import com.sap.tc.logging.NewLogEvent;
import com.sap.tc.logging.NewLogListener;
import com.sap.tc.logging.OverwriteLogfileEvent;
import com.sap.tc.logging.OverwriteLogfileListener;
import com.sap.tc.logging.PropertiesConfigurator;
import com.sap.tc.logging.ReleaseLogEvent;
import com.sap.tc.logging.ReleaseLogListener;
import com.sap.tc.logging.RemoveLogEvent;
import com.sap.tc.logging.RemoveLogListener;
import com.sap.tc.logging.ResetLogControllerListener;
import com.sap.tc.logging.Severity;
import com.sap.tc.logging.StreamLog;
import com.sap.tc.logging.TraceFormatter;
import com.sap.tc.logging.XMLFormatter;
import com.sap.tc.logging.interfaces.IClassLoadRuntimeInfoProvider;
import com.sap.tc.logging.interfaces.IDeployRuntimeInfoProvider;
import com.sap.tc.logging.interfaces.IRPPublisher;
import com.sap.tc.logging.interfaces.IThreadRuntimeInfoProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class LoggingManager
extends ExceptionHandling
implements EventDispatcher {
    private static final String INVALID_LISTENER_TYPE = "Invalid listener type";
    private static LoggingManager manager = null;
    private static IRPPublisher runPropPub = null;
    private static MessageEventListener msgListener = null;
    private static Location classLoc = null;
    private List<EventListener> newLogListeners = new Vector<EventListener>();
    private List<EventListener> removeLogListeners = new Vector<EventListener>();
    private List<EventListener> overwriteLogfileListeners = new Vector<EventListener>();
    private List<EventListener> createLogfileListeners = new Vector<EventListener>();
    private List<EventListener> resetLogControllerListener = new Vector<EventListener>();
    private List<EventListener> releaseLogListener = new Vector<EventListener>();
    private HashMap<String, Location> locations = new HashMap();
    private HashMap<String, Category> categories = new HashMap();
    public static final Formatter DEFAULT_FORMATTER = new TraceFormatter();
    private boolean includeStackTraceForEachRecord = false;
    protected static IClassLoadRuntimeInfoProvider classLoadInfoProvider;
    protected static IThreadRuntimeInfoProvider threadInfoProvider;
    protected static IDeployRuntimeInfoProvider deployInfoProvider;

    private LoggingManager() {
    }

    public static synchronized LoggingManager getLoggingManager() {
        if (manager == null) {
            manager = new LoggingManager();
            LoggingManager.init();
        }
        return manager;
    }

    public static void registerRuntimePropertiesPublisher(IRPPublisher runPropPublisher) {
        runPropPub = runPropPublisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(EventListener listener) throws IllegalArgumentException {
        Object object;
        boolean isFounded = false;
        if (listener instanceof NewLogListener) {
            object = this.newLogListeners;
            synchronized (object) {
                this.newLogListeners.add(listener);
            }
            isFounded = true;
            Collection existingLogs = this.getAllLogs();
            if (existingLogs != null) {
                Iterator logIter = existingLogs.iterator();
                while (logIter.hasNext()) {
                    try {
                        Log _log = (Log)logIter.next();
                        if (_log instanceof ConsoleLog) continue;
                        ((NewLogListener)listener).handleEvent(new NewLogEvent(_log));
                    }
                    catch (Exception ex) {
                        Category.SYS_LOGGING.logIntByAPI(400, classLoc, "[addListener(EventListener listener)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{"Implementation of the NewLogListener"});
                        Category.SYS_LOGGING.catchingIntByAPI(ex);
                        this.handleException(ex, 0);
                    }
                }
            }
        }
        if (listener instanceof RemoveLogListener) {
            object = this.removeLogListeners;
            synchronized (object) {
                this.removeLogListeners.add(listener);
            }
            isFounded = true;
        }
        if (listener instanceof OverwriteLogfileListener) {
            object = this.overwriteLogfileListeners;
            synchronized (object) {
                this.overwriteLogfileListeners.add(listener);
            }
            isFounded = true;
        }
        if (listener instanceof CreateLogfileListener) {
            object = this.createLogfileListeners;
            synchronized (object) {
                this.createLogfileListeners.add(listener);
            }
            isFounded = true;
        }
        if (listener instanceof ResetLogControllerListener) {
            object = this.resetLogControllerListener;
            synchronized (object) {
                this.resetLogControllerListener.add(listener);
            }
            isFounded = true;
        }
        if (listener instanceof ReleaseLogListener) {
            object = this.releaseLogListener;
            synchronized (object) {
                this.releaseLogListener.add(listener);
            }
            isFounded = true;
        }
        if (listener instanceof MessageEventListener) {
            object = this;
            synchronized (object) {
                msgListener = (MessageEventListener)listener;
            }
            isFounded = true;
        }
        if (!isFounded) {
            throw new IllegalArgumentException("Invalid listener type : " + listener.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(EventListener listener) throws IllegalArgumentException {
        Object object;
        boolean isFounded = false;
        if (listener instanceof NewLogListener) {
            object = this.newLogListeners;
            synchronized (object) {
                this.newLogListeners.remove(listener);
            }
            isFounded = true;
        }
        if (listener instanceof RemoveLogListener) {
            object = this.removeLogListeners;
            synchronized (object) {
                this.removeLogListeners.remove(listener);
            }
            isFounded = true;
        }
        if (listener instanceof OverwriteLogfileListener) {
            object = this.overwriteLogfileListeners;
            synchronized (object) {
                this.overwriteLogfileListeners.remove(listener);
            }
            isFounded = true;
        }
        if (listener instanceof CreateLogfileListener) {
            object = this.createLogfileListeners;
            synchronized (object) {
                this.createLogfileListeners.remove(listener);
            }
            isFounded = true;
        }
        if (listener instanceof ResetLogControllerListener) {
            object = this.resetLogControllerListener;
            synchronized (object) {
                this.resetLogControllerListener.remove(listener);
            }
            isFounded = true;
        }
        if (listener instanceof ReleaseLogListener) {
            object = this.releaseLogListener;
            synchronized (object) {
                this.releaseLogListener.remove(listener);
            }
            isFounded = true;
        }
        if (listener instanceof MessageEventListener) {
            object = this;
            synchronized (object) {
                msgListener = null;
            }
            isFounded = true;
        }
        if (!isFounded) {
            throw new IllegalArgumentException("Invalid listener type : " + listener.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllLogs() {
        Object[] lcs;
        HashSet<Log> existingLogs = new HashSet<Log>();
        if (this.locations != null) {
            lcs = null;
            HashMap<String, Location> hashMap = this.locations;
            synchronized (hashMap) {
                lcs = this.locations.values().toArray();
            }
            for (int i = 0; i < lcs.length; ++i) {
                existingLogs.addAll(((LogController)lcs[i]).getAllLogs());
            }
        }
        if (this.locations != null) {
            lcs = null;
            HashMap<String, Category> i = this.categories;
            synchronized (i) {
                lcs = this.categories.values().toArray();
            }
            for (int i2 = 0; i2 < lcs.length; ++i2) {
                existingLogs.addAll(((LogController)lcs[i2]).getAllLogs());
            }
        }
        return existingLogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() {
        HashMap<String, Location> hashMap = this.locations;
        synchronized (hashMap) {
            this.locations.clear();
        }
        Object[] tmpLC = this.categories.values().toArray();
        for (int i = 0; i < tmpLC.length; ++i) {
            this.release((LogController)tmpLC[i]);
        }
        LoggingManager.init();
    }

    protected void notifyWriteMessage(LogRecord record) {
        if (msgListener == null) {
            return;
        }
        try {
            if (msgListener.beRead(record)) {
                msgListener.handleEvent(new MessageEvent(record));
            }
        }
        catch (Exception ex) {
            APILogger.logIntByAPI(400, classLoc, "[notifyWriteMessage(LogRecord record)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{"Implementation of the MessageEventListener"});
            APILogger.catchingIntByAPI(ex);
            this.handleException(ex, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyAddLog(Log newLog) {
        if (this.newLogListeners.isEmpty()) {
            return;
        }
        if (newLog instanceof ConsoleLog) {
            return;
        }
        Object[] lsnArray = null;
        NewLogEvent evt = new NewLogEvent(newLog);
        List<EventListener> list = this.newLogListeners;
        synchronized (list) {
            lsnArray = this.newLogListeners.toArray();
        }
        for (int i = 0; i < lsnArray.length; ++i) {
            try {
                ((NewLogListener)lsnArray[i]).handleEvent(evt);
                continue;
            }
            catch (Exception ex) {
                Category.SYS_LOGGING.logIntByAPI(400, classLoc, "[notifyAddLog(Log newLog)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{"Implementation of the NewLogListener"});
                Category.SYS_LOGGING.catchingIntByAPI(ex);
                this.handleException(ex, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyRemoveLog(Log removeLog) {
        if (this.removeLogListeners.isEmpty()) {
            return;
        }
        if (removeLog instanceof ConsoleLog) {
            return;
        }
        if (this.isBeingAttached(removeLog)) {
            return;
        }
        Object[] lsnArray = null;
        RemoveLogEvent evt = new RemoveLogEvent(removeLog);
        List<EventListener> list = this.removeLogListeners;
        synchronized (list) {
            lsnArray = this.removeLogListeners.toArray();
        }
        for (int i = 0; i < lsnArray.length; ++i) {
            try {
                ((RemoveLogListener)lsnArray[i]).handleEvent(evt);
                continue;
            }
            catch (Exception ex) {
                Category.SYS_LOGGING.logIntByAPI(400, classLoc, "[notifyRemoveLog(Log removeLog)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{"Implementation of the RemoveLogListener"});
                Category.SYS_LOGGING.catchingIntByAPI(ex);
                this.handleException(ex, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyOverwriteLogfile(FileLog fileLog) {
        if (this.overwriteLogfileListeners.isEmpty()) {
            return;
        }
        Object[] lsnArray = null;
        OverwriteLogfileEvent evt = new OverwriteLogfileEvent(fileLog);
        List<EventListener> list = this.overwriteLogfileListeners;
        synchronized (list) {
            lsnArray = this.overwriteLogfileListeners.toArray();
        }
        for (int i = 0; i < lsnArray.length; ++i) {
            try {
                ((OverwriteLogfileListener)lsnArray[i]).handleEvent(evt);
                continue;
            }
            catch (Exception ex) {
                Category.SYS_LOGGING.logIntByAPI(400, classLoc, "[notifyOverwriteLogfile(String filename, int limit, int cnt)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{"Implementation of the OverwriteLogfileListener"});
                Category.SYS_LOGGING.catchingIntByAPI(ex);
                this.handleException(ex, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyReleaseLogfile(FileLog fileLog) {
        if (this.releaseLogListener.isEmpty()) {
            return;
        }
        Object[] lsnArray = null;
        ReleaseLogEvent evt = new ReleaseLogEvent(fileLog);
        List<EventListener> list = this.releaseLogListener;
        synchronized (list) {
            lsnArray = this.releaseLogListener.toArray();
        }
        for (int i = 0; i < lsnArray.length; ++i) {
            try {
                ((ReleaseLogListener)lsnArray[i]).handleEvent(evt);
                continue;
            }
            catch (Exception ex) {
                Category.SYS_LOGGING.logIntByAPI(400, classLoc, "[notifyReleaseLogfile(String filename, int limit, int cnt)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{"Implementation of the ReleaseLogListener"});
                Category.SYS_LOGGING.catchingIntByAPI(ex);
                this.handleException(ex, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyCreateLogfile(String filename, int limit, int cnt) {
        if (this.createLogfileListeners.isEmpty()) {
            return;
        }
        Object[] lsnArray = null;
        CreateLogfileEvent evt = new CreateLogfileEvent(filename, limit, cnt);
        List<EventListener> list = this.createLogfileListeners;
        synchronized (list) {
            lsnArray = this.createLogfileListeners.toArray();
        }
        for (int i = 0; i < lsnArray.length; ++i) {
            try {
                ((CreateLogfileListener)lsnArray[i]).handleEvent(evt);
                continue;
            }
            catch (Exception ex) {
                Category.SYS_LOGGING.logIntByAPI(400, classLoc, "[notifyCreateLogfile(String filename, int limit, int cnt)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{"Implementation of the CreateLogfileListener"});
                Category.SYS_LOGGING.catchingIntByAPI(ex);
                this.handleException(ex, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLogControllerReset(LogController logController, boolean isResetTree) {
        if (this.resetLogControllerListener.isEmpty()) {
            return;
        }
        Object[] lsnArray = null;
        List<EventListener> list = this.resetLogControllerListener;
        synchronized (list) {
            lsnArray = this.resetLogControllerListener.toArray();
        }
        for (int i = 0; i < lsnArray.length; ++i) {
            try {
                ((ResetLogControllerListener)lsnArray[i]).handleEvent(logController, isResetTree);
                continue;
            }
            catch (Exception ex) {
                Category.SYS_LOGGING.logIntByAPI(400, classLoc, "[notifyLogControllerReset(LogController logController, boolean isResetTree)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{"Implementation of the ResetLogControllerListener"});
                Category.SYS_LOGGING.catchingIntByAPI(ex);
                this.handleException(ex, 0);
            }
        }
    }

    static IRPPublisher getRuntimePropertiesPublisher() {
        return runPropPub;
    }

    static MessageEventListener getMessageEventListener() {
        return msgListener;
    }

    Location getLocation(String name) {
        return this.getLocation(name, name);
    }

    Category getCategory(String name) {
        return this.getCategory(name, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(LogController controller) {
        if (controller instanceof Location) {
            HashMap<String, Location> hashMap = this.locations;
            synchronized (hashMap) {
                this.locations.remove(controller.getName());
            }
        }
        if (!this.isPredefCategory(controller.getName())) {
            HashMap<String, Category> hashMap = this.categories;
            synchronized (hashMap) {
                this.categories.remove(controller.getName());
            }
        }
    }

    private boolean isPredefCategory(String name) {
        return Category.PREDEF_CATEGORIES.containsKey(name);
    }

    private static void init() {
        classLoc = Location.getLocation(LoggingManager.class.getName(), "tc~logging~java", "BC-JAS-ADM-LOG-API");
        Location.getLocation("com.sap.tc.logging.Category", "tc~logging~java", "BC-JAS-ADM-LOG-API");
        Location.getLocation(Configurator.class.getName(), "tc~logging~java", "BC-JAS-ADM-LOG-API");
        Location.getLocation(ConsoleLog.class.getName(), "tc~logging~java", "BC-JAS-ADM-LOG-API");
        Location.getLocation(FileLog.class.getName(), "tc~logging~java", "BC-JAS-ADM-LOG-API");
        Location.getLocation(Formatter.class.getName(), "tc~logging~java", "BC-JAS-ADM-LOG-API");
        Location.getLocation(GUId.class.getName(), "tc~logging~java", "BC-JAS-ADM-LOG-API");
        Location.getLocation(ListFormatter.class.getName(), "tc~logging~java", "BC-JAS-ADM-LOG-API");
        Location.getLocation(Location.class.getName(), "tc~logging~java", "BC-JAS-ADM-LOG-API");
        Location.getLocation(Log.class.getName(), "tc~logging~java", "BC-JAS-ADM-LOG-API");
        Location.getLocation(LogController.class.getName(), "tc~logging~java", "BC-JAS-ADM-LOG-API");
        Location.getLocation(LogRecord.class.getName(), "tc~logging~java", "BC-JAS-ADM-LOG-API");
        Location.getLocation(MsgType.class.getName(), "tc~logging~java", "BC-JAS-ADM-LOG-API");
        Location.getLocation(PropertiesConfigurator.class.getName(), "tc~logging~java", "BC-JAS-ADM-LOG-API");
        Location.getLocation(Severity.class.getName(), "tc~logging~java", "BC-JAS-ADM-LOG-API");
        Location.getLocation(StreamLog.class.getName(), "tc~logging~java", "BC-JAS-ADM-LOG-API");
        Location.getLocation(TraceFormatter.class.getName(), "tc~logging~java", "BC-JAS-ADM-LOG-API");
        Location.getLocation(XMLFormatter.class.getName(), "tc~logging~java", "BC-JAS-ADM-LOG-API");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Location getLocation(String locFullName, String nameTokens) {
        try {
            String name = nameTokens;
            Location loc = this.locations.get(name);
            if (loc == null) {
                Location parent;
                if (nameTokens.indexOf(46) == -1) {
                    if (nameTokens.length() == 0) {
                        loc = new Location(name);
                    } else {
                        nameTokens = "";
                        parent = this.getLocation(name, nameTokens);
                        loc = new Location(name, parent);
                    }
                } else {
                    nameTokens = nameTokens.substring(0, nameTokens.lastIndexOf(46));
                    parent = this.getLocation(name, nameTokens);
                    loc = new Location(name, parent);
                }
                HashMap<String, Location> hashMap = this.locations;
                synchronized (hashMap) {
                    this.locations.put(name, loc);
                }
            }
            return loc;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Location : " + locFullName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Category getCategory(String catFullName, String nameTokens) {
        try {
            String name = nameTokens;
            Category category = this.categories.get(name);
            if (category == null) {
                int lastIndex = nameTokens.lastIndexOf(47);
                if (nameTokens.indexOf(47) == lastIndex) {
                    if (nameTokens.length() == 1 && nameTokens.charAt(0) == '/') {
                        category = new Category(name);
                    } else {
                        nameTokens = "/";
                        category = new Category(name, this.getCategory(name, nameTokens));
                    }
                } else {
                    nameTokens = nameTokens.substring(0, lastIndex);
                    category = new Category(name, this.getCategory(name, nameTokens));
                }
                HashMap<String, Category> hashMap = this.categories;
                synchronized (hashMap) {
                    this.categories.put(name, category);
                }
            }
            return category;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Category : " + catFullName);
        }
    }

    protected boolean isBeingAttached(Log aLog) {
        return this.getAllLogs().contains(aLog);
    }

    static Category getLog() {
        return Category.SYS_LOGGING;
    }

    public void setIncludeStackTraceForEachRecord(boolean aIncludeStackTraceForEachRecord) {
        this.includeStackTraceForEachRecord = aIncludeStackTraceForEachRecord;
    }

    public boolean getIncludeStackTraceForEachRecord() {
        return this.includeStackTraceForEachRecord;
    }

    public static void registerClassLoadRuntimeInfoProvider(IClassLoadRuntimeInfoProvider aClassLoadRuntimeInfoProvider) {
        if (classLoadInfoProvider != null) {
            throw new IllegalStateException("ClassLoadRuntimeInfoProvider is already registered.");
        }
        classLoadInfoProvider = aClassLoadRuntimeInfoProvider;
    }

    public static void registerThreadRuntimeInfoProvider(IThreadRuntimeInfoProvider aThreadRuntimeInfoProvider) {
        if (threadInfoProvider != null) {
            throw new IllegalStateException("ThreadRuntimeInfoProvider is already registered.");
        }
        threadInfoProvider = aThreadRuntimeInfoProvider;
    }

    public static void registerDeployRuntimeInfoProvider(IDeployRuntimeInfoProvider aDeployRuntimeInfoProvider) {
        if (deployInfoProvider != null) {
            throw new IllegalStateException("DeployRuntimeInfoProvider is already registered.");
        }
        deployInfoProvider = aDeployRuntimeInfoProvider;
    }

    public static IClassLoadRuntimeInfoProvider getClassLoadRuntimeInfoProvider() {
        return classLoadInfoProvider;
    }

    public static IThreadRuntimeInfoProvider getThreadRuntimeInfoProvider() {
        return threadInfoProvider;
    }

    public static IDeployRuntimeInfoProvider getDeployRuntimeInfoProvider() {
        return deployInfoProvider;
    }
}

