/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.server;

import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.server.JCoServer;
import java.lang.reflect.Method;

public abstract class JCoServerFactory {
    private static String SERVER_FACTORY_CLASS = "com.sap.conn.jco.rt.StandaloneServerFactory";
    private static JCoServerFactory runtime = null;

    public static synchronized JCoServerFactory get() {
        if (runtime == null) {
            try {
                Class<?> runtimeClass = Class.forName(SERVER_FACTORY_CLASS);
                Method getRuntime = runtimeClass.getMethod("get", new Class[0]);
                runtime = (JCoServerFactory)getRuntime.invoke(null, new Object[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return runtime;
    }

    public abstract JCoServer getServerInstance(String var1) throws JCoException;

    public abstract int getNumServerConnections(String var1) throws JCoException;

    public static JCoServer getServer(String serverName) throws JCoException {
        return JCoServerFactory.get().getServerInstance(serverName);
    }

    public static int getNumberOfServerConnections(String serverName) throws JCoException {
        return JCoServerFactory.get().getNumServerConnections(serverName);
    }
}

