/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Codecs {

    public static class MD5 {
        static final ThreadLocal<MessageDigest> messageDigestThreadLocal = new ThreadLocal<MessageDigest>(){

            @Override
            protected MessageDigest initialValue() {
                try {
                    return MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new Error(e.toString(), e);
                }
            }
        };

        public static byte[] getMD5Hash(String string) {
            try {
                return messageDigestThreadLocal.get().digest(string.getBytes("UTF8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e.toString(), e);
            }
        }

        public static String getMD5HashAsString(String string) {
            byte[] hash = MD5.getMD5Hash(string);
            return Hex.encode(hash);
        }
    }

    public static class Base64 {
        private static final char[] base64_table;
        private static final byte[] base64_inv_table;

        public static final char[] encode(String value) {
            if (value == null) {
                return new char[0];
            }
            try {
                byte[] p = value.getBytes("UTF8");
                return Base64.encode(p, 0, p.length);
            }
            catch (UnsupportedEncodingException e) {
                return new char[0];
            }
        }

        public static final char[] encode(byte[] bytes) {
            if (bytes == null) {
                return new char[0];
            }
            return Base64.encode(bytes, 0, bytes.length);
        }

        public static final char[] encode(byte[] bytes, int offset, int length) {
            int v;
            int i;
            int is = 0;
            if (bytes == null || length <= 0) {
                return new char[0];
            }
            char[] s = new char[4 * ((length + 2) / 3)];
            int n = offset + length - length % 3;
            for (i = offset; i < n; i += 3) {
                v = bytes[i] << 16 & 0xFF0000 | bytes[i + 1] << 8 & 0xFF00 | bytes[i + 2] & 0xFF;
                s[is++] = base64_table[v >> 18 & 0x3F];
                s[is++] = base64_table[v >> 12 & 0x3F];
                s[is++] = base64_table[v >> 6 & 0x3F];
                s[is++] = base64_table[v & 0x3F];
            }
            n = length % 3;
            i = offset + length - n;
            if (n == 2) {
                v = bytes[i] << 16 | bytes[i + 1] << 8;
                v = bytes[i] << 16 & 0xFF0000 | bytes[i + 1] << 8 & 0xFF00;
                s[is++] = base64_table[v >> 18 & 0x3F];
                s[is++] = base64_table[v >> 12 & 0x3F];
                s[is++] = base64_table[v >> 6 & 0x3F];
                s[is++] = 61;
            } else if (n == 1) {
                v = bytes[i] << 16 & 0xFF0000;
                s[is++] = base64_table[v >> 18 & 0x3F];
                s[is++] = base64_table[v >> 12 & 0x3F];
                s[is++] = 61;
                s[is++] = 61;
            }
            return s;
        }

        public static final byte[] decode(String value) {
            if (value == null) {
                return new byte[0];
            }
            char[] p = value.toCharArray();
            return Base64.decode(p, 0, p.length);
        }

        public static final byte[] decode(char[] chars) {
            if (chars == null) {
                return new byte[0];
            }
            return Base64.decode(chars, 0, chars.length);
        }

        public static final byte[] decode(char[] chars, int offset, int length) {
            if (chars == null) {
                return new byte[0];
            }
            int shift = 0;
            int accum = 0;
            int index = 0;
            int tmp_length = length;
            for (int i = offset; i < offset + length; ++i) {
                byte value = base64_inv_table[chars[i] & 0xFF];
                if (value >= 0 || chars[i] == '=') continue;
                --tmp_length;
            }
            int len = (tmp_length + 3) / 4 * 3;
            if (tmp_length > 0 && chars[offset + length - 1] == '=') {
                --len;
            }
            if (tmp_length > 1 && chars[offset + length - 2] == '=') {
                --len;
            }
            byte[] s = new byte[len];
            for (int i = offset; i < offset + length; ++i) {
                byte value = base64_inv_table[chars[i] & 0xFF];
                if (value < 0) continue;
                accum <<= 6;
                accum |= value;
                if ((shift += 6) < 8) continue;
                s[index++] = (byte)(accum >> (shift -= 8) & 0xFF);
            }
            return s;
        }

        static {
            int i;
            base64_table = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
            base64_inv_table = new byte[256];
            for (i = 0; i < 256; ++i) {
                Base64.base64_inv_table[i] = -1;
            }
            for (i = 0; i < 64; ++i) {
                Base64.base64_inv_table[Base64.base64_table[i]] = (byte)i;
            }
        }
    }

    public static class Hex {
        private static char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

        public static final String encode(byte[] value) {
            if (value == null) {
                return "";
            }
            char[] s = new char[value.length * 2];
            int k = 0;
            for (int i = 0; i < value.length; ++i) {
                s[k++] = hex[value[i] >> 4 & 0xF];
                s[k++] = hex[value[i] & 0xF];
            }
            return new String(s);
        }

        public static final String encode(byte value) {
            char[] s = new char[]{hex[value >> 4 & 0xF], hex[value & 0xF]};
            return new String(s);
        }

        public static final String encode(char value) {
            char[] s = new char[]{hex[value >> 12 & 0xF], hex[value >> 8 & 0xF], hex[value >> 4 & 0xF], hex[value & 0xF]};
            return new String(s);
        }

        public static final String encode(int value) {
            char[] s = new char[]{hex[value >> 28 & 0xF], hex[value >> 24 & 0xF], hex[value >> 20 & 0xF], hex[value >> 16 & 0xF], hex[value >> 12 & 0xF], hex[value >> 8 & 0xF], hex[value >> 4 & 0xF], hex[value & 0xF]};
            return new String(s);
        }

        public static final byte[] decode(String value) {
            if (value == null) {
                return new byte[0];
            }
            char[] chars = value.toCharArray();
            return Hex.decode(chars, 0, chars.length);
        }

        public static final byte[] decode(char[] chars, int offset, int length) {
            if (chars == null) {
                return new byte[0];
            }
            byte[] buf = new byte[(length + 1) / 2];
            for (int i = 0; i < length; ++i) {
                byte d = (byte)Character.digit(chars[offset + i], 16);
                int n = i >> 1;
                buf[n] = (byte)(buf[n] | d << (1 - (i & 1) << 2));
            }
            return buf;
        }

        public static final int decode(char char0, char char1) {
            return Character.digit(char0, 16) * 16 + Character.digit(char1, 16);
        }
    }
}

