/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.util;

public final class FastStringBuffer {
    static final char[] digitsTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    char[] buf;
    int capacity;
    int pos;
    char[] conv = null;

    public FastStringBuffer() {
        this(256);
    }

    public FastStringBuffer(int size) {
        this.capacity = size;
        this.buf = new char[size];
        this.pos = 0;
    }

    public void ensureCapacity(int capacity) {
        if (capacity > this.capacity) {
            this.expandCapacity(capacity);
        }
    }

    private void expandCapacity(int capacity) {
        do {
            this.capacity *= 2;
        } while (this.capacity < capacity);
        char[] newbuf = new char[this.capacity];
        System.arraycopy(this.buf, 0, newbuf, 0, this.pos);
        this.buf = newbuf;
    }

    public void reset() {
        this.pos = 0;
    }

    public int length() {
        return this.pos;
    }

    public FastStringBuffer append(String value) {
        if (value == null) {
            return this;
        }
        int len = value.length();
        int newLen = this.pos + len;
        if (newLen > this.capacity) {
            this.expandCapacity(newLen);
        }
        value.getChars(0, len, this.buf, this.pos);
        this.pos = newLen;
        return this;
    }

    public FastStringBuffer append(char value) {
        int newLen = this.pos + 1;
        if (newLen > this.capacity) {
            this.expandCapacity(newLen);
        }
        this.buf[this.pos++] = value;
        return this;
    }

    public FastStringBuffer append(char[] value) {
        if (value == null) {
            return this;
        }
        int newLen = this.pos + value.length;
        if (newLen > this.capacity) {
            this.expandCapacity(newLen);
        }
        System.arraycopy(value, 0, this.buf, this.pos, value.length);
        this.pos = newLen;
        return this;
    }

    public FastStringBuffer append(char[] value, int offset, int len) {
        if (value == null) {
            return this;
        }
        int newLen = this.pos + len;
        if (newLen > this.capacity) {
            this.expandCapacity(newLen);
        }
        System.arraycopy(value, offset, this.buf, this.pos, len);
        this.pos = newLen;
        return this;
    }

    public FastStringBuffer append(int value) {
        int remainder;
        int quot;
        switch (value) {
            case -2147483648: {
                return this.append("-2147483648");
            }
            case -3: {
                int newLen = this.pos + 2;
                if (newLen > this.capacity) {
                    this.expandCapacity(newLen);
                }
                this.buf[this.pos++] = 45;
                this.buf[this.pos++] = digits[3];
                return this;
            }
            case -2: {
                int newLen = this.pos + 2;
                if (newLen > this.capacity) {
                    this.expandCapacity(newLen);
                }
                this.buf[this.pos++] = 45;
                this.buf[this.pos++] = digits[2];
                return this;
            }
            case -1: {
                int newLen = this.pos + 2;
                if (newLen > this.capacity) {
                    this.expandCapacity(newLen);
                }
                this.buf[this.pos++] = 45;
                this.buf[this.pos++] = digits[1];
                return this;
            }
            case 0: {
                return this.append(digits[0]);
            }
            case 1: {
                return this.append(digits[1]);
            }
            case 2: {
                return this.append(digits[2]);
            }
            case 3: {
                return this.append(digits[3]);
            }
            case 4: {
                return this.append(digits[4]);
            }
            case 5: {
                return this.append(digits[5]);
            }
            case 6: {
                return this.append(digits[6]);
            }
            case 7: {
                return this.append(digits[7]);
            }
            case 8: {
                return this.append(digits[8]);
            }
            case 9: {
                return this.append(digits[9]);
            }
            case 10: {
                int newLen = this.pos + 2;
                if (newLen > this.capacity) {
                    this.expandCapacity(newLen);
                }
                this.buf[this.pos++] = 49;
                this.buf[this.pos++] = 48;
                return this;
            }
        }
        if (value < 0) {
            this.append('-');
            value = -value;
        }
        if (this.conv == null) {
            this.conv = new char[20];
        }
        int convPos = 20;
        while (value > 65536) {
            quot = value / 100;
            remainder = value - ((quot << 6) + (quot << 5) + (quot << 2));
            value = quot;
            this.conv[--convPos] = digits[remainder];
            this.conv[--convPos] = digitsTens[remainder];
        }
        do {
            quot = value * 52429 >>> 19;
            remainder = value - ((quot << 3) + (quot << 1));
            value = quot;
            this.conv[--convPos] = digits[remainder];
        } while (quot != 0);
        return this.append(this.conv, convPos, 20 - convPos);
    }

    public FastStringBuffer append(long value) {
        int quotInt;
        int remainder;
        if (value == Long.MIN_VALUE) {
            return this.append("-9223372036854775808");
        }
        if (value < 0L) {
            this.append('-');
            value = -value;
        }
        if (value < 10L) {
            return this.append(digits[(int)value]);
        }
        if (this.conv == null) {
            this.conv = new char[20];
        }
        int convPos = 20;
        while (value > Integer.MAX_VALUE) {
            long quot = value / 100L;
            remainder = (int)(value - ((quot << 6) + (quot << 5) + (quot << 2)));
            value = quot;
            this.conv[--convPos] = digits[remainder];
            this.conv[--convPos] = digitsTens[remainder];
        }
        int valueInt = (int)value;
        while (valueInt > 65536) {
            quotInt = valueInt / 100;
            remainder = valueInt - ((quotInt << 6) + (quotInt << 5) + (quotInt << 2));
            valueInt = quotInt;
            this.conv[--convPos] = digits[remainder];
            this.conv[--convPos] = digitsTens[remainder];
        }
        do {
            quotInt = valueInt * 52429 >>> 19;
            remainder = valueInt - ((quotInt << 3) + (quotInt << 1));
            valueInt = quotInt;
            this.conv[--convPos] = digits[remainder];
        } while (quotInt != 0);
        return this.append(this.conv, convPos, 20 - convPos);
    }

    public FastStringBuffer append(byte value) {
        return this.append((int)value);
    }

    public FastStringBuffer append(boolean value) {
        if (value) {
            int newLen = this.pos + 4;
            if (newLen > this.capacity) {
                this.expandCapacity(newLen);
            }
            this.buf[this.pos++] = 116;
            this.buf[this.pos++] = 114;
            this.buf[this.pos++] = 117;
            this.buf[this.pos++] = 101;
        } else {
            int newLen = this.pos + 5;
            if (newLen > this.capacity) {
                this.expandCapacity(newLen);
            }
            this.buf[this.pos++] = 102;
            this.buf[this.pos++] = 97;
            this.buf[this.pos++] = 108;
            this.buf[this.pos++] = 115;
            this.buf[this.pos++] = 101;
        }
        return this;
    }

    public FastStringBuffer append(FastStringBuffer value) {
        if (value == null) {
            return this;
        }
        int newLen = this.pos + value.pos;
        if (newLen > this.capacity) {
            this.expandCapacity(newLen);
        }
        System.arraycopy(value.buf, 0, this.buf, this.pos, value.pos);
        this.pos = newLen;
        return this;
    }

    public String toString() {
        return new String(this.buf, 0, this.pos);
    }

    public char[] getBufferReference() {
        return this.buf;
    }
}

