/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.APILogger;
import com.sap.tc.logging.ExceptionHandling;
import com.sap.tc.logging.Filter;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.ListFormatter;
import com.sap.tc.logging.LogController;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.MSGCollection;
import com.sap.tc.logging.Severity;
import com.sap.tc.logging.interfaces.ILog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class Log
extends ExceptionHandling
implements ILog {
    private static String subLoc = "Log";
    public static final int STATUS_INVALID = 0;
    public static final int STATUS_CLOSED = 1;
    public static final int STATUS_OPENED = 2;
    private boolean suppressing = false;
    private int loggedCnt = 0;
    private boolean headerWritten = false;
    private boolean autoFlush = true;
    private int effSeverity = 0;
    private int logTypeAccessibility;
    private HashSet filters = new HashSet();
    private Formatter formatter;
    private LinkedList lcOwners = new LinkedList();
    private LogController localLogOwner;
    private String logName;
    private String logDescription;
    private int logStatus = 1;
    private String logHeader = "";
    private String logFooter = "";
    private long logSize;
    private String logVerInUse;
    private Date timeStamp = new Date();
    private volatile boolean exceptionGuardian = false;
    private static final int LOG_ACCESSABILITY_TYPE_MIN = 0;
    public static final int LOG_ACCESSABILITY_TYPE_NORMAL_LOG = 1;
    public static final int LOG_ACCESSABILITY_TYPE_LOCAL_LOG = 2;
    public static final int LOG_ACCESSABILITY_TYPE_PRIVATE_LOG = 3;
    private static final int LOG_ACCESSABILITY_TYPE_MAX = 4;

    protected Log() {
        this.formatter = new ListFormatter();
    }

    protected Log(Formatter formatter) {
        this.setFormatter(formatter);
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.close();
    }

    public synchronized String getName() {
        return this.logName;
    }

    public synchronized void setName(String name) {
        this.logName = name;
    }

    public synchronized String getDescription() {
        return this.logDescription;
    }

    public synchronized void setDescription(String value) {
        this.logDescription = value;
    }

    public synchronized String getVerInUse() {
        return this.logVerInUse;
    }

    public int status() {
        return this.logStatus;
    }

    public String getHeader() {
        return this.logHeader + this.getFormatter().getHeader(this);
    }

    public String getFooter() {
        return this.logFooter + this.getFormatter().getFooter(this);
    }

    public synchronized int getEffectiveSeverity() {
        return this.effSeverity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEffectiveSeverity(int severity) {
        int oldValue = -1;
        int newValue = -1;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            oldValue = this.getEffectiveSeverity();
            this.effSeverity = Severity.correct(severity);
            newValue = this.getEffectiveSeverity();
        }
        if (oldValue != newValue) {
            APILogger.instrumentIntByAPI(subLoc + "[setEffectiveSeverity(int severity)]", MSGCollection.CONFIGURATION_IS_CHANGED(), new Object[]{"effective severity", "Log", this.getName(), "" + oldValue, "" + newValue});
        }
    }

    public synchronized int getLogTypeAccessibility() {
        return this.logTypeAccessibility;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogTypeAccessibility(int value) {
        int oldValue = -1;
        int newValue = -1;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            oldValue = this.getLogTypeAccessibility();
            if (value <= 0 || value >= 4) {
                value = 3;
            }
            this.logTypeAccessibility = value;
            newValue = this.getLogTypeAccessibility();
        }
        if (oldValue != newValue) {
            APILogger.instrumentIntByAPI(subLoc + "[setLogTypeAccessibility(int value)]", MSGCollection.CONFIGURATION_IS_CHANGED(), new Object[]{"accessibility level", "Log", this.getName(), "" + oldValue, "" + newValue});
        }
    }

    public synchronized Formatter getFormatter() {
        return this.formatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFormatter(Formatter formatter) {
        String oldValue;
        String string = oldValue = this.getFormatter() != null ? this.getFormatter().getClass().getName() : null;
        if (formatter != null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                this.formatter = formatter;
            }
        }
        APILogger.instrumentIntByAPI(100, subLoc + "[setFormatter(Formatter formatter)] " + "Excepted object is not specified ({0} == null) for {1}({2})! Default {3} ({4}) is created!", (Object[])new String[]{"Formatter", "Log", this.getName(), "Formatter", "ListFormatter"});
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            formatter = new ListFormatter();
        }
        if (oldValue != null) {
            APILogger.instrumentIntByAPI(subLoc + "[setFormatter()]", MSGCollection.CONFIGURATION_IS_CHANGED(), new Object[]{"formatter", "Log", this.getName(), oldValue, this.getFormatter().getClass().getName()});
        }
    }

    public int getNumberOfLogRecordsWritten() {
        return this.getLoggedCount();
    }

    public long size() {
        return this.logSize;
    }

    public abstract String getEncoding();

    public abstract void setEncoding(String var1);

    public boolean isFiltersAgreeing(LogRecord rec) {
        if (rec == null) {
            return false;
        }
        if (this.filters != null && !this.filters.isEmpty() && rec.getSeverity() != 800) {
            Iterator iter = this.getFilters().iterator();
            while (iter.hasNext()) {
                try {
                    if (((Filter)iter.next()).beLogged(rec)) continue;
                    return false;
                }
                catch (Exception ex) {
                    if (this.exceptionGuardian) {
                        return false;
                    }
                    this.exceptionGuardian = true;
                    APILogger.logIntByAPI(400, subLoc + "[isFiltersAgreeing(LogRecord rec)]", "ASJ.log_api.000029", "Exception in custom filter for this {0} ({1})!", new String[]{"Log", this.getName()});
                    APILogger.catchingIntByAPI(ex);
                    this.exceptionGuardian = false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getFilters() {
        if (this.filters != null) {
            HashSet hashSet = this.filters;
            synchronized (hashSet) {
                return Collections.unmodifiableCollection(new ArrayList(this.filters));
            }
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilter(Filter filter) {
        if (filter != null) {
            HashSet hashSet = this.filters;
            synchronized (hashSet) {
                if (!this.filters.contains(filter)) {
                    this.filters.add(filter);
                }
            }
        } else {
            APILogger.logIntByAPI(400, subLoc + "[addFilter(Filter filter)]", "ASJ.log_api.000023", "Excepted object is not specified ({0} == null) for {1}({2})!", new String[]{"Filter", "Log", this.getName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilter(Filter filter) {
        HashSet hashSet = this.filters;
        synchronized (hashSet) {
            this.filters.remove(filter);
        }
        APILogger.instrumentIntByAPI(subLoc + "[removeFilter(Filter filter)]", MSGCollection.CONFIGURATION_REMOVE_ITEM(), new Object[]{"filter", filter.getClass().getName(), this.getName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilters() {
        HashSet hashSet = this.filters;
        synchronized (hashSet) {
            this.filters.clear();
        }
        APILogger.instrumentIntByAPI(subLoc + "[removeFilters()]", MSGCollection.CONFIGURATION_REMOVE_ITEM(), new Object[]{"Filter", "ALL", this.getName()});
    }

    public boolean beLogged(int severity) {
        return severity >= this.getEffectiveSeverity();
    }

    public LogRecord write(LogRecord rec) {
        LogRecord writtenRec = null;
        try {
            if (this.beLogged(rec)) {
                writtenRec = this.writeInternalByAPI(rec);
            }
        }
        catch (Exception ex) {
            if (this.exceptionGuardian) {
                return null;
            }
            this.exceptionGuardian = true;
            APILogger.logIntByAPI(400, subLoc + "[write(LogRecord rec)]", "ASJ.log_api.000034", "Exception when trying writes a log record to this log({0})!", new String[]{this.getName()});
            APILogger.catchingIntByAPI(ex);
            this.exceptionGuardian = false;
        }
        return writtenRec;
    }

    public void flush() {
        try {
            this.flushInt();
        }
        catch (IOException ex) {
            if (this.exceptionGuardian) {
                return;
            }
            this.exceptionGuardian = true;
            APILogger.logIntByAPI(400, subLoc + "[flush()]", "ASJ.log_api.000033", "Exception when trying writes a log record to this log({0})!", new String[]{this.getName()});
            APILogger.catchingIntByAPI(ex);
            this.exceptionGuardian = false;
        }
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoFlush(boolean autoFlush) {
        boolean oldValue = false;
        boolean newValue = false;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            oldValue = this.isAutoFlush();
            this.autoFlush = autoFlush;
            newValue = this.isAutoFlush();
        }
        if (oldValue != newValue) {
            APILogger.instrumentIntByAPI(subLoc + "[setAutoFlush(boolean autoFlush)]", MSGCollection.CONFIGURATION_IS_CHANGED(), new Object[]{"auto flush", "Log", this.getName(), "" + oldValue, "" + newValue});
        }
    }

    public void open() {
        try {
            this.openInt();
        }
        catch (IOException ex) {
            if (this.exceptionGuardian) {
                return;
            }
            this.exceptionGuardian = true;
            APILogger.logIntByAPI(500, subLoc + "[open()]", "ASJ.log_api.000037", "Exception when trying to open this log({0})!", new String[]{this.getName()});
            APILogger.catchingIntByAPI(ex);
            this.exceptionGuardian = false;
        }
    }

    public synchronized void close() {
        try {
            this.writeLogFooter();
            this.closeInt();
            this.setSize(0L);
        }
        catch (Exception ex) {
            APILogger.logIntByAPI(500, subLoc + "[close()]", "ASJ.log_api.000035", "Exception when trying to close this log({0})!", new String[]{this.getName()});
            APILogger.catchingIntByAPI(ex);
        }
    }

    public synchronized boolean isClosed() {
        return this.logStatus == 1;
    }

    public synchronized boolean isOpened() {
        return this.logStatus == 2;
    }

    public void reset() {
        try {
            this.resetInt();
            APILogger.instrumentIntByAPI(subLoc + "[reset()]", MSGCollection.CONFIGURATION_RESET(), new Object[]{this.getName()});
        }
        catch (Exception ex) {
            APILogger.logIntByAPI(400, subLoc + "[reset()]", "ASJ.log_api.000005", "Unexcepted error occured on {0}!", new String[]{this.getName()});
            APILogger.catchingIntByAPI(ex);
        }
    }

    public boolean isSuppressing() {
        return this.suppressing;
    }

    public void setSuppressing(boolean suppressing) {
        this.suppressing = suppressing;
    }

    public int getLoggedCount() {
        return this.loggedCnt;
    }

    public void resetLoggedCount() {
        this.loggedCnt = 0;
    }

    public List getOwners() {
        if (!this.lcOwners.isEmpty()) {
            return this.lcOwners;
        }
        return Collections.EMPTY_LIST;
    }

    protected synchronized void setSize(long value) {
        this.logSize = value;
    }

    protected synchronized void setStatus(int status) {
        this.logStatus = status < 1 || status > 2 ? 0 : status;
    }

    protected synchronized void setHeader(String value) {
        this.logHeader = value == null ? "" : value;
    }

    protected synchronized void setFooter(String value) {
        this.logFooter = value;
    }

    protected synchronized void setVerInUse(String value) {
        this.logVerInUse = value;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected void writeInt(String s) throws Exception {
    }

    protected void flushInt() throws IOException {
    }

    protected void closeInt() throws IOException {
    }

    protected void openInt() throws IOException {
    }

    protected void resetInt() throws Exception {
    }

    protected synchronized String writeInt(LogRecord rec) throws Exception {
        rec.setThreadInternal(true);
        this.timeStamp = rec.refreshTime(this.timeStamp);
        String msg = this.getFormatter().format(rec);
        rec.setThreadInternal(false);
        if (!this.isSuppressing()) {
            this.writeInt(msg);
        }
        return msg;
    }

    protected synchronized boolean isHeaderWritten() {
        return this.headerWritten;
    }

    protected void setHeaderWritten(boolean headerWritten) {
        this.headerWritten = headerWritten;
    }

    protected synchronized void addOwner(String owner) {
        this.lcOwners.add(owner);
    }

    protected synchronized void removeOwner(String owner) {
        if (this.lcOwners.contains(owner)) {
            LinkedList newOwners = new LinkedList(this.lcOwners);
            newOwners.remove(owner);
            this.lcOwners = newOwners;
        }
    }

    protected synchronized void setLocalLogOwner(LogController owner) {
        this.localLogOwner = owner;
    }

    protected LogController getLocalLogOwner() {
        return this.localLogOwner;
    }

    boolean beLogged(LogRecord rec) {
        return this.beLogged(rec.getSeverity()) && this.isFiltersAgreeing(rec);
    }

    LogRecord writeIntByAPI(LogRecord rec) {
        LogRecord writtenRec = null;
        try {
            writtenRec = this.writeInternalByAPI(rec);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return writtenRec;
    }

    LogRecord writeInternalByAPI(LogRecord rec) throws Exception {
        LogRecord writtenRec = null;
        this.writeInt(rec);
        writtenRec = rec;
        this.setLogged();
        if (this.autoFlush) {
            this.flush();
        }
        return writtenRec;
    }

    boolean wasLogged() {
        return this.loggedCnt > 0;
    }

    void setLogged() {
        ++this.loggedCnt;
    }

    protected synchronized void writeLogHeader() {
    }

    protected synchronized void writeLogFooter() {
    }

    public LogRecord getRecord() {
        return null;
    }

    public boolean beGroup() {
        return false;
    }

    public synchronized String getLogName() {
        return this.logName;
    }

    public synchronized void setLogName(String name) {
        this.logName = name;
    }
}

