/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.reader;

import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.LogEvents;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.LoggingManager;
import com.sap.tc.logging.MSGCollection;
import com.sap.tc.logging.exceptions.DataException;
import com.sap.tc.logging.exceptions.FileDataException;
import com.sap.tc.logging.exceptions.UnsupportedFormatException;
import com.sap.tc.logging.interfaces.IBaseLog;
import com.sap.tc.logging.interfaces.ILoggingResultSet;
import com.sap.tc.logging.interfaces.IReadLog;
import com.sap.tc.logging.interfaces.IReadableLog;
import com.sap.tc.logging.messagedepot.MessageAccessor;
import com.sap.tc.logging.reader.FileReadFilter;
import com.sap.tc.logging.reader.FileReadLog;
import com.sap.tc.logging.reader.LogRecordResultSet;
import com.sap.tc.logging.reader.ReaderLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;

public class ReadableLog
extends FileLog
implements IReadableLog {
    public static final Location tracer = Location.getLocation(ReadableLog.class.getName(), "tc~logging~java", "BC-JAS-ADM-LOG-API");
    private static String subLoc = "ReadableLog";
    FileReadLog source = null;
    LogEventsListener localListener = new LogEventsListener();
    int grabCounter = 0;
    private boolean isTimeFilterSet = false;
    long start = -1L;
    long end = -1L;
    int startFileSetIndex = -1;
    long startFileBookmark = -1L;
    int endFileSetIndex = -1;
    long endFileBookmark = -1L;
    boolean willItBeFirstReadAfterTimeFilterWasApplied = true;
    private String latestMSG;
    private String currentMSG;

    public ReadableLog(String pattern) {
        super(pattern);
        this.source = (FileReadLog)ReadableLog.createFileReadLog(new FileLog(pattern));
        this.setStatus(1);
        this.source.registerForLogEvents(this.localListener);
    }

    private ReadableLog(FileLog fileLog) {
        this.source = (FileReadLog)ReadableLog.createFileReadLog(fileLog);
        this.setStatus(1);
        this.source.registerForLogEvents(this.localListener);
    }

    private ReadableLog(FileLog fileLog, MessageAccessor accessor) {
        this.source = (FileReadLog)ReadableLog.createFileReadLog(fileLog, accessor);
        this.setStatus(1);
        this.source.registerForLogEvents(this.localListener);
    }

    public static IReadLog createFileReadLog(FileLog fileLog) {
        return new FileReadLog(fileLog);
    }

    public static IReadLog createFileReadLog(FileLog fileLog, MessageAccessor accessor) {
        return new FileReadLog(fileLog, accessor);
    }

    public static IReadLog createFileReadLog(String fileName) throws FileDataException {
        return new FileReadLog(fileName);
    }

    public static IReadLog createFileReadLog(String fileName, MessageAccessor accessor) throws FileDataException {
        return new FileReadLog(fileName, accessor);
    }

    public static IReadableLog createReadableLog(FileLog fileLog) {
        return ReadableLog.createReadableLog(fileLog, null);
    }

    public static IReadableLog createReadableLog(FileLog fileLog, MessageAccessor accessor) {
        ReadableLog rLogcopy = new ReadableLog(fileLog, accessor);
        rLogcopy.setName(fileLog.getName());
        rLogcopy.source.setName(fileLog.getName());
        rLogcopy.setDescription(fileLog.getDescription());
        rLogcopy.source.setDescription(fileLog.getDescription());
        rLogcopy.setPattern(fileLog.getPattern());
        rLogcopy.source.setPattern(fileLog.getPattern());
        rLogcopy.setFormatter(fileLog.getFormatter());
        rLogcopy.source.setFormatter(fileLog.getFormatter());
        rLogcopy.setCnt(fileLog.getCnt());
        rLogcopy.source.setSize(fileLog.getCnt());
        rLogcopy.setLimit(fileLog.getLimit());
        rLogcopy.source.setLimit(fileLog.getLimit());
        rLogcopy.setIndex(fileLog.getIndex());
        rLogcopy.source.setIndex(fileLog.getIndex());
        rLogcopy.setEncoding(fileLog.getEncoding());
        rLogcopy.source.setEncoding(fileLog.getEncoding());
        rLogcopy.setMode(fileLog.getMode());
        rLogcopy.source.setMode(fileLog.getMode());
        try {
            rLogcopy.source.open();
            rLogcopy.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rLogcopy;
    }

    public IReadableLog createReadableLog() {
        return ReadableLog.createReadableLog(this, null);
    }

    public IReadableLog createReadableLog(MessageAccessor accessor) {
        return ReadableLog.createReadableLog(this, accessor);
    }

    public boolean resetTimeFilter() {
        if (this.isTimeFilterSet) {
            this.isTimeFilterSet = false;
            this.start = -1L;
            this.end = -1L;
            this.startFileSetIndex = -1;
            this.startFileBookmark = -1L;
            this.endFileSetIndex = -1;
            this.endFileBookmark = -1L;
            this.willItBeFirstReadAfterTimeFilterWasApplied = true;
            return true;
        }
        return false;
    }

    public boolean isTimeFilterSet() {
        return this.isTimeFilterSet;
    }

    public boolean setTimeFilter(long start, long end) {
        if (!this.isTimeFilterSet) {
            this.resetTimeFilter();
            this.start = start;
            this.end = end;
            this.isTimeFilterSet = true;
            return true;
        }
        ReaderLogger.traceThrowableIntByAPI(400, subLoc + "[setFilter()]", "An attempt to apply time&date filter in Logging API, without reseting the one, already set.", new Exception("An attempt to apply time&date filter in Logging API, without reseting the one, already set."));
        return false;
    }

    private void removeTooNewFiles(TreeMap timeIndexMap, long end) {
        Iterator it = timeIndexMap.keySet().iterator();
        while (it.hasNext()) {
            long startTimestamp = -((Long)it.next()).longValue();
            if (end >= startTimestamp || end == 0L) continue;
            it.remove();
        }
    }

    private void removeTooOldFiles(TreeMap timeIndexMap, long start) {
        Object o = null;
        TreeSet timeKeysToRemove = new TreeSet();
        timeKeysToRemove.addAll(timeIndexMap.keySet());
        while (!timeKeysToRemove.isEmpty()) {
            Object e = timeKeysToRemove.last();
            o = e;
            if (e == null || start != 0L && (Long)o < start) break;
            timeKeysToRemove.remove(o);
        }
        if (!timeKeysToRemove.isEmpty()) {
            Object e = timeKeysToRemove.last();
            o = e;
            if (e != null && (start == 0L || (Long)o < start)) {
                timeKeysToRemove.remove(o);
            }
        }
        Iterator i = timeKeysToRemove.iterator();
        while (i.hasNext()) {
            timeIndexMap.remove((Long)i.next());
        }
    }

    private boolean setStartBookmarks() {
        TreeMap<Long, Integer> timeFileindexMap = new TreeMap<Long, Integer>();
        try {
            if (this.source.isClosed()) {
                this.source.open();
            }
            this.source.moveToBOF();
            boolean toBreak = false;
            while (true) {
                if (this.source.isEnd()) {
                    toBreak = true;
                }
                ILoggingResultSet firstRowInFile = this.source.readNext();
                LogRecord lr = (LogRecord)firstRowInFile.getResults().get(0);
                timeFileindexMap.put(new Long(lr.getTime().getTime()), new Integer(this.source.getIndex()));
                if (toBreak) break;
                this.source.next();
                this.source.close();
                this.source.open();
                this.source.moveToBeginningOfCurrentFile();
            }
            this.removeTooOldFiles(timeFileindexMap, this.start);
            Iterator it = timeFileindexMap.values().iterator();
            while (it.hasNext()) {
                int index = (Integer)it.next();
                this.source.setIndex(index);
                this.source.close();
                this.source.open();
                LogRecord lr = null;
                long startPosition = 0L;
                while (!this.source.isEndOfCurrentFile()) {
                    startPosition = this.source.getBookMark();
                    ILoggingResultSet aRow = this.source.readNext();
                    lr = (LogRecord)aRow.getResults().get(0);
                    if (lr.getTime().getTime() < this.start && this.start != 0L) continue;
                    this.startFileBookmark = startPosition;
                    this.startFileSetIndex = index;
                    return true;
                }
            }
            return true;
        }
        catch (Exception ex) {
            ReaderLogger.traceThrowableIntByAPI(500, subLoc + "[setStartBookmarks()]", "Exception while applying time filter in Logging API for file " + this.getName(), new Exception("Exception while applying time filter in Logging API for file " + this.getName()));
            this.isTimeFilterSet = false;
            return false;
        }
    }

    private boolean setEndBookmarks() {
        TreeMap<Long, Integer> timeFileindexMap = new TreeMap<Long, Integer>();
        try {
            if (this.source.isClosed()) {
                this.source.open();
            }
            this.source.moveToBOF();
            boolean toBreak = false;
            while (true) {
                if (this.source.isEnd()) {
                    toBreak = true;
                }
                ILoggingResultSet firstRowInFile = this.source.readNext();
                LogRecord lr = (LogRecord)firstRowInFile.getResults().get(0);
                timeFileindexMap.put(new Long(-lr.getTime().getTime()), new Integer(this.source.getIndex()));
                if (toBreak) break;
                this.source.next();
                this.source.close();
                this.source.open();
                this.source.moveToBeginningOfCurrentFile();
            }
            this.removeTooNewFiles(timeFileindexMap, this.end);
            Iterator it = timeFileindexMap.values().iterator();
            while (it.hasNext()) {
                int index = (Integer)it.next();
                this.source.setIndex(index);
                this.source.close();
                this.source.open();
                this.source.moveToEndOfCurrentFile();
                LogRecord lr = null;
                long endPosition = 0L;
                while (!this.source.isBeginningOfCurrentFile()) {
                    endPosition = this.source.getBookMark();
                    ILoggingResultSet aRow = this.source.readPrevious();
                    lr = (LogRecord)aRow.getResults().get(0);
                    if (lr.getTime().getTime() > this.end && this.end != 0L) continue;
                    this.endFileBookmark = endPosition;
                    this.endFileSetIndex = index;
                    return true;
                }
            }
            return true;
        }
        catch (Exception ex) {
            ReaderLogger.traceThrowableIntByAPI(500, subLoc + "[setEndBookmarks()]", "Exception while applying time filter in Logging API for file " + this.getName(), ex);
            this.isTimeFilterSet = false;
            return false;
        }
    }

    public ILoggingResultSet readLatestMsgRecords(int numberOfRecords) throws IllegalArgumentException, UnsupportedFormatException, FileNotFoundException, SecurityException, IOException {
        LogRecordResultSet resultSet;
        File checkIfFileExists = new File(this.source.getSource());
        if (this.isTimeFilterSet && checkIfFileExists.exists() && checkIfFileExists.isFile()) {
            try {
                ILoggingResultSet rSet;
                LogRecord aMessage;
                LogRecordResultSet resultSet2 = new LogRecordResultSet();
                if (!this.setEndBookmarks()) {
                    throw new Exception("Failed to set end bookmark for time filter. See traces for exact exception.");
                }
                if (this.endFileBookmark == -1L || this.endFileSetIndex == -1) {
                    return new LogRecordResultSet();
                }
                this.source.setIndex(this.endFileSetIndex);
                this.source.close();
                this.source.open();
                this.source.setBookMark(this.endFileBookmark - 1L);
                if (this.endFileBookmark == 0L) {
                    this.source.moveToEndOfCurrentFile();
                }
                if ((aMessage = (LogRecord)(rSet = this.source.readPrevious()).getResults().get(0)).getTime().getTime() < this.start) {
                    LogRecordResultSet runt = new LogRecordResultSet();
                    runt.setStatus(-1);
                    runt.setException(new Exception("Incorrectly set time filter in Logging API"));
                    return runt;
                }
                resultSet2.add(aMessage);
                rSet = null;
                while (resultSet2.getSize() < numberOfRecords && (rSet = this.source.readPrevious()).getSize() != 0 && (aMessage = (LogRecord)rSet.getResults().get(0)).getTime().getTime() >= this.start) {
                    resultSet2.add(aMessage);
                }
                this.willItBeFirstReadAfterTimeFilterWasApplied = false;
                return resultSet2;
            }
            catch (Exception e) {
                resultSet = new LogRecordResultSet();
                resultSet.setStatus(-1);
                resultSet.setException(e);
            }
        } else {
            try {
                this.source.open();
                this.source.moveToEOF();
                resultSet = (LogRecordResultSet)this.source.readPrevious(numberOfRecords);
            }
            catch (Exception ex) {
                resultSet = new LogRecordResultSet();
                resultSet.setStatus(-1);
                resultSet.setException(ex);
            }
        }
        return resultSet;
    }

    public ILoggingResultSet readOldestMsgRecords(int numberOfRecords) throws IllegalArgumentException, UnsupportedFormatException, FileNotFoundException, SecurityException, IOException {
        LogRecordResultSet resultSet;
        File checkIfFileExists = new File(this.source.getSource());
        if (this.isTimeFilterSet && checkIfFileExists.exists() && checkIfFileExists.isFile()) {
            try {
                LogRecordResultSet resultSet2 = new LogRecordResultSet();
                if (!this.setStartBookmarks()) {
                    throw new Exception("Failed to set start bookmark for time filter. See traces for exact exception.");
                }
                if (this.startFileBookmark == -1L || this.startFileSetIndex == -1) {
                    return new LogRecordResultSet();
                }
                this.source.setIndex(this.startFileSetIndex);
                this.source.close();
                this.source.open();
                this.source.setBookMark(this.startFileBookmark);
                ILoggingResultSet rSet = this.source.readNext();
                LogRecord aMessage = (LogRecord)rSet.getResults().get(0);
                if (aMessage.getTime().getTime() > this.end && this.end != 0L) {
                    LogRecordResultSet runt = new LogRecordResultSet();
                    runt.setStatus(-1);
                    runt.setException(new Exception("Incorrectly set time filter in Logging API"));
                    return runt;
                }
                resultSet2.add(aMessage);
                rSet = null;
                while (resultSet2.getSize() < numberOfRecords && (rSet = this.source.readNext()).getSize() != 0 && ((aMessage = (LogRecord)rSet.getResults().get(0)).getTime().getTime() <= this.end || this.end == 0L)) {
                    resultSet2.add(aMessage);
                }
                this.willItBeFirstReadAfterTimeFilterWasApplied = false;
                return resultSet2;
            }
            catch (Exception e) {
                resultSet = new LogRecordResultSet();
                resultSet.setStatus(-1);
                resultSet.setException(e);
            }
        } else {
            try {
                this.source.open();
                this.source.moveToBOF();
                resultSet = (LogRecordResultSet)this.source.readNext(numberOfRecords);
            }
            catch (Exception ex) {
                resultSet = new LogRecordResultSet();
                resultSet.setStatus(-1);
                resultSet.setException(ex);
            }
        }
        return resultSet;
    }

    public ILoggingResultSet readPrevMsgRecords(int numberOfRecords) throws IllegalArgumentException, UnsupportedFormatException, FileNotFoundException, SecurityException, IOException {
        LogRecordResultSet resultSet;
        File checkIfFileExists = new File(this.source.getSource());
        if (this.isTimeFilterSet && checkIfFileExists.exists() && checkIfFileExists.isFile()) {
            try {
                LogRecord aMessage;
                ILoggingResultSet rSet;
                LogRecordResultSet resultSet2 = new LogRecordResultSet();
                if (this.willItBeFirstReadAfterTimeFilterWasApplied) {
                    if (!this.setEndBookmarks()) {
                        throw new Exception("Failed to set end bookmark for time filter. See traces for exact exception.");
                    }
                    if (this.endFileBookmark == -1L || this.endFileSetIndex == -1) {
                        return new LogRecordResultSet();
                    }
                    this.source.setIndex(this.endFileSetIndex);
                    this.source.close();
                    this.source.open();
                    this.source.setBookMark(this.endFileBookmark - 1L);
                    if (this.endFileBookmark == 0L) {
                        this.source.moveToEndOfCurrentFile();
                    } else {
                        this.source.readPrevious();
                    }
                    rSet = this.source.readPrevious();
                    aMessage = (LogRecord)rSet.getResults().get(0);
                    if (aMessage.getTime().getTime() < this.start) {
                        LogRecordResultSet runt = new LogRecordResultSet();
                        runt.setStatus(-1);
                        runt.setException(new Exception("Incorrectly set time filter in Logging API"));
                        return runt;
                    }
                    resultSet2.add(aMessage);
                    this.willItBeFirstReadAfterTimeFilterWasApplied = false;
                }
                rSet = null;
                while (resultSet2.getSize() < numberOfRecords && (rSet = this.source.readPrevious()).getSize() != 0 && (aMessage = (LogRecord)rSet.getResults().get(0)).getTime().getTime() >= this.start) {
                    resultSet2.add(aMessage);
                }
                return resultSet2;
            }
            catch (Exception e) {
                resultSet = new LogRecordResultSet();
                resultSet.setStatus(-1);
                resultSet.setException(e);
            }
        } else if (!this.source.isOpened()) {
            resultSet = (LogRecordResultSet)this.readLatestMsgRecords(numberOfRecords);
        } else {
            try {
                resultSet = (LogRecordResultSet)this.source.readPrevious(numberOfRecords);
            }
            catch (Exception ex) {
                resultSet = new LogRecordResultSet();
                resultSet.setStatus(-1);
                resultSet.setException(ex);
            }
        }
        return resultSet;
    }

    public ILoggingResultSet readNextMsgRecords(int numberOfRecords) throws IllegalArgumentException, UnsupportedFormatException, FileNotFoundException, SecurityException, IOException {
        LogRecordResultSet resultSet;
        File checkIfFileExists = new File(this.source.getSource());
        if (this.isTimeFilterSet && checkIfFileExists.exists() && checkIfFileExists.isFile()) {
            try {
                LogRecord aMessage;
                ILoggingResultSet rSet;
                LogRecordResultSet resultSet2 = new LogRecordResultSet();
                if (this.willItBeFirstReadAfterTimeFilterWasApplied) {
                    if (!this.setStartBookmarks()) {
                        throw new Exception("Failed to set start bookmark for time filter. See traces for exact exception.");
                    }
                    if (this.startFileBookmark == -1L || this.startFileSetIndex == -1) {
                        return new LogRecordResultSet();
                    }
                    this.source.setIndex(this.startFileSetIndex);
                    this.source.close();
                    this.source.open();
                    this.source.setBookMark(this.startFileBookmark);
                    rSet = this.source.readNext();
                    aMessage = (LogRecord)rSet.getResults().get(0);
                    if (aMessage.getTime().getTime() > this.end) {
                        LogRecordResultSet runt = new LogRecordResultSet();
                        runt.setStatus(-1);
                        runt.setException(new Exception("Incorrectly set time filter in Logging API"));
                        return runt;
                    }
                    resultSet2.add(aMessage);
                    this.willItBeFirstReadAfterTimeFilterWasApplied = false;
                }
                rSet = null;
                while (resultSet2.getSize() < numberOfRecords && (rSet = this.source.readNext()).getSize() != 0 && (aMessage = (LogRecord)rSet.getResults().get(0)).getTime().getTime() <= this.end) {
                    resultSet2.add(aMessage);
                }
                return resultSet2;
            }
            catch (Exception e) {
                resultSet = new LogRecordResultSet();
                resultSet.setStatus(-1);
                resultSet.setException(e);
            }
        } else if (!this.source.isOpened()) {
            resultSet = (LogRecordResultSet)this.readOldestMsgRecords(numberOfRecords);
        } else {
            try {
                resultSet = (LogRecordResultSet)this.source.readNext(numberOfRecords);
            }
            catch (Exception ex) {
                resultSet = new LogRecordResultSet();
                resultSet.setStatus(-1);
                resultSet.setException(ex);
            }
        }
        return resultSet;
    }

    public ILoggingResultSet getNextMatch(String[] searchTokens) throws IllegalArgumentException, UnsupportedFormatException, FileNotFoundException, SecurityException, IOException {
        return this.getNextMatch(searchTokens, false);
    }

    public ILoggingResultSet getNextMatch(String[] searchTokens, boolean ignoreCase) throws IllegalArgumentException, UnsupportedFormatException, FileNotFoundException, SecurityException, IOException {
        LogRecordResultSet resultSet;
        try {
            if (searchTokens == null || searchTokens.length == 0) {
                throw new IllegalArgumentException("Conditional string is null or it is empty!");
            }
            if (!this.source.isOpened()) {
                this.source.open();
                this.source.moveToBOF();
            }
            FileReadFilter filter = new FileReadFilter(searchTokens, FileReadFilter.LOG_OPERATER_OR, !ignoreCase);
            this.source.addFilter(filter);
            resultSet = (LogRecordResultSet)this.source.readNext();
            this.source.removeFilter(filter);
        }
        catch (Exception ex) {
            resultSet = new LogRecordResultSet();
            resultSet.setStatus(-1);
            resultSet.setException(ex);
        }
        return resultSet;
    }

    public ILoggingResultSet getPreviousMatch(String[] searchTokens) throws IllegalArgumentException, UnsupportedFormatException, FileNotFoundException, SecurityException, IOException {
        return this.getPreviousMatch(searchTokens, false);
    }

    public ILoggingResultSet getPreviousMatch(String[] searchTokens, boolean ignoreCase) throws IllegalArgumentException, UnsupportedFormatException, FileNotFoundException, SecurityException, IOException {
        LogRecordResultSet resultSet;
        try {
            if (searchTokens == null || searchTokens.length == 0) {
                throw new IllegalArgumentException("Conditional string is null or it is empty!");
            }
            if (!this.source.isOpened()) {
                this.source.open();
                this.source.moveToEOF();
            }
            FileReadFilter filter = new FileReadFilter(searchTokens, FileReadFilter.LOG_OPERATER_OR, !ignoreCase);
            this.source.addFilter(filter);
            resultSet = (LogRecordResultSet)this.source.readPrevious();
            this.source.removeFilter(filter);
        }
        catch (Exception ex) {
            resultSet = new LogRecordResultSet();
            resultSet.setStatus(-1);
            resultSet.setException(ex);
        }
        return resultSet;
    }

    public boolean areLoggingAttributesEditable() {
        Collection existingLogs = LoggingManager.getLoggingManager().getAllLogs();
        return existingLogs.contains(this);
    }

    public String getFileBeingCurrentlyRead() {
        return this.source.getSource();
    }

    public long getFilePointer() throws IOException {
        try {
            return this.source.getBookMark();
        }
        catch (DataException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public void seek(long filePointer) throws IOException {
        try {
            this.source.seek(filePointer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public long getLastModified() throws IOException {
        long result = 0L;
        try {
            result = this.source.getFileLatest().lastModified();
        }
        catch (Exception ex) {
            result = -1L;
        }
        return result;
    }

    public int status() {
        return this.source.status();
    }

    public synchronized void open() {
        try {
            this.source.open();
        }
        catch (Exception ex) {
            tracer.traceThrowableT(400, "Exception when trying to open this log({0})!", new String[]{this.getName()}, (Throwable)ex);
        }
    }

    public synchronized void close() {
        try {
            if (this.source != null) {
                this.source.close();
            }
        }
        catch (Exception ex) {
            tracer.traceThrowableT(400, "Exception when trying to close this log({0})!", new String[]{this.getName()}, (Throwable)ex);
        }
    }

    public synchronized void setFormatter(Formatter formatter) {
        if (this.source != null) {
            try {
                this.source.setFormatter(formatter);
            }
            catch (Exception ex) {
                ReaderLogger.instrumentIntByAPI(subLoc + "[setFormatter(Formatter formatter)]", MSGCollection.FORMATTER_CHANGED_ON_OPEN_LOG(), new Object[]{this.getName()});
                this.close();
            }
        }
        this.setFormatterInt(formatter);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public ArrayList readLatestRecords(int numMsg) throws IllegalArgumentException, UnsupportedFormatException, IOException {
        return (ArrayList)this.readLatestMsgRecords(numMsg).getResults();
    }

    public ArrayList readOldestRecords(int numMsg) throws IllegalArgumentException, UnsupportedFormatException, IOException {
        return (ArrayList)this.readOldestMsgRecords(numMsg).getResults();
    }

    public ArrayList readPrevRecords(int numMsg) throws IllegalArgumentException, UnsupportedFormatException, IOException {
        return (ArrayList)this.readPrevMsgRecords(numMsg).getResults();
    }

    public ArrayList readNextRecords(int numMsg) throws IllegalArgumentException, UnsupportedFormatException, IOException {
        return (ArrayList)this.readNextMsgRecords(numMsg).getResults();
    }

    public long length() {
        return this.getFileLength();
    }

    class LogEventsListener
    implements LogEvents {
        LogEventsListener() {
        }

        public void eventLogIsClosed(IBaseLog log) {
        }

        public void eventLogIsOpen(IBaseLog log) {
            FileReadLog readLog = (FileReadLog)log;
            ReadableLog.this.setName(readLog.getSource());
            ReadableLog.this.setDescription(readLog.getDescription());
            ReadableLog.this.setPattern(readLog.getPattern());
            ReadableLog.this.setFormatter(readLog.getFormatter());
            ReadableLog.this.setCnt(readLog.getSize());
            ReadableLog.this.setLimit(readLog.getLimit());
            ReadableLog.this.setIndex(readLog.getIndex());
            ReadableLog.this.setEncoding(readLog.getEncoding());
            ReadableLog.this.setMode(readLog.getMode());
            ReadableLog.this.setStatus(readLog.status());
            ReadableLog.this.setFooter(readLog.getFooter());
            ReadableLog.this.setHeader(readLog.getHeader());
        }
    }
}

