﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Globalization;

namespace Horoscope
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }
        private DateTime birthday;
        private string nz = String.Empty;
        private string yz = String.Empty;
        private string rz = String.Empty;
        private string sz = String.Empty;
        ChineseLunisolarCalendar clc = new ChineseLunisolarCalendar();
        function func = new function();
        SolarTerms solarterms = new SolarTerms();

        private void button1_Click(object sender, EventArgs e)
        {
            if (comboBox1.SelectedIndex < 0)
            {
                MessageBox.Show("请选择你的出生时辰！不会的可参考“帮助”", String.Empty, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            else
            {
                birthday = new DateTime(dateTimePicker1.Value.Year, dateTimePicker1.Value.Month, dateTimePicker1.Value.Day);
                nz = func.Get_nz(clc.GetYear(birthday));
                yz = func.Get_yz(birthday, nz);
                rz = func.Get_rz(birthday);
                sz = func.Get_sz(rz, comboBox1.SelectedItem.ToString());
                label3.Text = "八字：" + nz + " " + yz + " " + rz + " " + sz;
                label4.Text = "五行：" + func.Get_wx(nz + " " + yz + " " + rz + " " + sz);
                label5.Text = "农历：" + clc.GetYear(birthday).ToString() + "年" + clc.GetMonth(birthday).ToString() + "月" + clc.GetDayOfMonth(birthday).ToString() + "日";
                label6.Text = func.Get_sx(nz) + "年";
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            comboBox1.DropDownStyle = ComboBoxStyle.DropDownList;
            dateTimePicker1.MinDate = new DateTime(1901, 2, 19);
            dateTimePicker1.MaxDate = new DateTime(2099, 12, 31);
            string[] temp = new string[] { "子", "丑", "寅", "卯", "辰", "巳", "午", "未", "申", "酉", "戌", "亥" };
            foreach(string element in temp)
            {
                comboBox1.Items.Add(element);
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            Form2 form2 = new Form2();
            form2.ShowInTaskbar = false;
            form2.ShowDialog();
        }
    }
}
