﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Globalization;

namespace Horoscope
{
    public class function
    {
        private string[] TG = { "癸", "甲", "乙", "丙", "丁", "戊", "己", "庚", "辛", "壬" };
        private string[] DZ = { "亥", "子", "丑", "寅", "卯", "辰", "巳", "午", "未", "申", "酉", "戌" };
        JieQi lichun = new JieQi();
        JieQi qingming = new JieQi();
        JieQi jingzhe = new JieQi();
        JieQi lixia = new JieQi();
        JieQi mangzhong = new JieQi();
        JieQi xiaoshu = new JieQi();
        JieQi liqiu = new JieQi();
        JieQi bailu = new JieQi();
        JieQi hanlu = new JieQi();
        JieQi lidong = new JieQi();
        JieQi daxue = new JieQi();
        JieQi xiaohan = new JieQi();
        SolarTerms solarterms = new SolarTerms();

        public string Get_nz(int year)
        {
            int r1 = (year - 3) % 10;
            int r2 = (year - 3) % 12;
            return TG[r1] + DZ[r2];
        }

        public string Get_yz(DateTime datetime,string nz)
        {
            int r1=0, r2, _r2;
            Get_jq(datetime);
            r2 = Get_yz_r2(datetime);
            _r2 = r2;
            if (_r2 == 0 || _r2 == 1 || _r2 == 2)
            {
                _r2 += 12;
            }
            if (nz.IndexOf("甲") != -1 || nz.IndexOf("己") != -1)
            {
                r1 = 3;
                for (; _r2 > 3; _r2--)
                {
                    r1++;
                    if (r1 == 10)
                    {
                        r1 = 0;
                    }
                }
            }
            else if (nz.IndexOf("乙") != -1 || nz.IndexOf("庚") != -1)
            {
                r1 = 5;
                for (; _r2 > 3; _r2--)
                {
                    r1++;
                    if (r1 == 10)
                    {
                        r1 = 0;
                    }
                }
            }
            else if (nz.IndexOf("丙") != -1 || nz.IndexOf("辛") != -1)
            {
                r1 = 7;
                for (; _r2 > 3; _r2--)
                {
                    r1++;
                    if (r1 == 10)
                    {
                        r1 = 0;
                    }
                }
            }
            else if (nz.IndexOf("丁") != -1 || nz.IndexOf("壬") != -1)
            {
                r1 = 9;
                for (; _r2 > 3; _r2--)
                {
                    r1++;
                    if (r1 == 10)
                    {
                        r1 = 0;
                    }
                }
            }
            else if (nz.IndexOf("戊") != -1 || nz.IndexOf("癸") != -1)
            {
                r1 = 1;
                for (; _r2 > 3; _r2--)
                {
                    r1++;
                    if (r1 == 10)
                    {
                        r1 = 0;
                    }
                }
            }
            return TG[r1] + DZ[r2];
        }

        public string Get_rz(DateTime datetime)
        {
            int c, y, year = datetime.Year;
            int m = datetime.Month;
            int d = datetime.Day;
            if (m == 1)
            {
                year -= 1;
                m = 13;
            }
            else if (m == 2)
            {
                year -= 1;
                m = 14;
            }
            c = year / 100;
            y = year % 100;
            int Z, G = 4 * c + 5 * y + c / 4 + y / 4 + (int)(0.6 * (m + 1)) + d - 3;
            if (m % 2 == 0)
            {
                Z = G + 10 + 6 + 4 * c;
            }
            else
            {
                Z = G + 10 + 4 * c;
            }
            return TG[G % 10] + DZ[Z % 12];
        }

        public string Get_sz(string rz, string HourPeriod)
        {
            int r1, _r2, r2 = Get_r2(HourPeriod);
            _r2 = r2;
            if (_r2 == 0)
            {
                _r2 = 12;
            }
            r1 = Get_r1(rz, _r2);
            if (r1 == 10)
            {
                r1 = 0;
            }
            return TG[r1] + DZ[r2];
        }

        private int Get_r2(string HourPeriod)
        {
            if (HourPeriod == "癸")
            {
                return 0;
            }
            else
            {
                for(int i = 0; i <= DZ.Length - 1; i++)
                {
                    if (DZ[i] == HourPeriod)
                    {
                        return i;
                    }
                }
            }
            return 0;
        }

        private int Get_r1(string rz,int _r2)
        {
            int r1 = 0;
            if (rz.IndexOf("甲") != -1 || rz.IndexOf("己") != -1)
            {
                r1 = 1;
                for (; _r2 >1; _r2--)
                {
                    r1++;
                    if (r1 == 10)
                    {
                        r1 = 0;
                    }
                }
            }
            else if (rz.IndexOf("乙") != -1 || rz.IndexOf("庚") != -1)
            {
                r1 = 3;
                for (; _r2 >1; _r2--)
                {
                    r1++;
                    if (r1 == 10)
                    {
                        r1 = 0;
                    }
                }
            }
            else if (rz.IndexOf("丙") != -1 || rz.IndexOf("辛") != -1)
            {
                r1 = 5;
                for (; _r2 >1; _r2--)
                {
                    r1++;
                    if (r1 == 10)
                    {
                        r1 = 0;
                    }
                }
            }
            else if (rz.IndexOf("丁") != -1 || rz.IndexOf("壬") != -1)
            {
                r1 = 7;
                for (; _r2 >1; _r2--)
                {
                    r1++;
                    if (r1 == 10)
                    {
                        r1 = 0;
                    }
                }
            }
            else if (rz.IndexOf("戊") != -1 || rz.IndexOf("癸") != -1)
            {
                r1 = 9;
                for (; _r2 > 1; _r2--)
                {
                    r1++;
                    if (r1 == 10)
                    {
                        r1 = 0;
                    }
                }
            }
            return r1;
        } 

        private struct JieQi
        {
            public int year;
            public int month;
            public int day;
        }

        private void Get_jq(DateTime datetime)
        {
            lichun.year = datetime.Year;
            lichun.month = 2;
            lichun.day = solarterms.calc_lc(datetime);

            jingzhe.year = datetime.Year;
            jingzhe.month = 3;
            jingzhe.day = solarterms.calc_jz(datetime);

            qingming.year = datetime.Year;
            qingming.month = 4;
            qingming.day = solarterms.calc_qm(datetime);

            lixia.year = datetime.Year;
            lixia.month = 5;
            lixia.day = solarterms.calc_lx(datetime);

            mangzhong.year = datetime.Year;
            mangzhong.month = 6;
            mangzhong.day = solarterms.calc_mz(datetime);

            xiaoshu.year = datetime.Year;
            xiaoshu.month = 7;
            xiaoshu.day = solarterms.calc_xs(datetime);

            liqiu.year = datetime.Year;
            liqiu.month = 8;
            liqiu.day = solarterms.calc_lq(datetime);

            bailu.year = datetime.Year;
            bailu.month = 9;
            bailu.day = solarterms.calc_bl(datetime);

            hanlu.year = datetime.Year;
            hanlu.month = 10;
            hanlu.day = solarterms.calc_hl(datetime);

            lidong.year = datetime.Year;
            lidong.month = 11;
            lidong.day = solarterms.calc_ld(datetime);

            daxue.year = datetime.Year;
            daxue.month = 12;
            daxue.day = solarterms.calc_dx(datetime);

            xiaohan.year = datetime.Year;
            xiaohan.month = 1;
            xiaohan.day = solarterms.calc_xh(datetime);
        }

        private int Get_yz_r2(DateTime datetime)
        {
            if (datetime.Month == lichun.month)
            {
                if (datetime.Day >= lichun.day)
                {
                    return 3;
                }
                else
                {
                    return 2;
                }
            }
            else if (datetime.Month == jingzhe.month)
            {
                if (datetime.Day >= jingzhe.day)
                {
                    return 4;
                }
                else
                {
                    return 3;
                }
            }
            else if (datetime.Month == qingming.month)
            {
                if (datetime.Day >= qingming.day)
                {
                    return 5;
                }
                else
                {
                    return 4;
                }
            }
            else if (datetime.Month == lixia.month)
            {
                if (datetime.Day >= lixia.day)
                {
                    return 6;
                }
                else
                {
                    return 5;
                }
            }
            else if (datetime.Month == mangzhong.month)
            {
                if (datetime.Day >= mangzhong.day)
                {
                    return 7;
                }
                else
                {
                    return 6;
                }
            }
            else if (datetime.Month == xiaoshu.month)
            {
                if (datetime.Day >= xiaoshu.day)
                {
                    return 8;
                }
                else
                {
                    return 7;
                }
            }
            else if(datetime.Month == liqiu.month)
            {
                if (datetime.Day >= liqiu.day)
                {
                    return 9;
                }
                else
                {
                    return 8;
                }
            }
            else if (datetime.Month == bailu.month)
            {
                if (datetime.Day >= bailu.day)
                {
                    return 10;
                }
                else
                {
                    return 9;
                }
            }
            else if (datetime.Month == hanlu.month)
            {
                if (datetime.Day >= hanlu.day)
                {
                    return 11;
                }
                else
                {
                    return 10;
                }
            }
            else if (datetime.Month == lidong.month)
            {
                if (datetime.Day >= lidong.day)
                {
                    return 0;
                }
                else
                {
                    return 11;
                }
            }
            else if (datetime.Month == daxue.month)
            {
                if (datetime.Day >= daxue.day)
                {
                    return 1;
                }
                else
                {
                    return 0;
                }
            }
            else if (datetime.Month == xiaohan.month)
            {
                if (datetime.Day >= xiaohan.day)
                {
                    return 2;
                }
                else
                {
                    return 1;
                }
            }
            return 0;
        }

        public string Get_wx(string horoscope)
        {
            string[] m = new string[] { "甲", "乙", "寅", "卯" };
            string[] h = new string[] { "丙", "丁", "巳", "午" };
            string[] t = new string[] { "戊", "己", "丑", "辰", "未", "戌" };
            string[] j = new string[] { "庚", "辛", "申", "酉" };
            string[] s = new string[] { "壬", "癸", "子", "亥" };
            foreach(string element in m)
            {
                horoscope = horoscope.Replace(element, "木");
            }
            foreach (string element in h)
            {
                horoscope = horoscope.Replace(element, "火");
            }
            foreach (string element in t)
            {
                horoscope = horoscope.Replace(element, "土");
            }
            foreach (string element in j)
            {
                horoscope = horoscope.Replace(element, "金");
            }
            foreach (string element in s)
            {
                horoscope = horoscope.Replace(element, "水");
            }
            return horoscope;
        }

        public string Get_sx(string nz)
        {
            if (nz.IndexOf("子") != -1)
            {
                return "鼠";
            }
            else if (nz.IndexOf("丑") != -1) 
            {
                return "牛";
            }
            else if (nz.IndexOf("寅") != -1)
            {
                return "虎";
            }
            else if (nz.IndexOf("卯") != -1)
            {
                return "兔";
            }
            else if (nz.IndexOf("辰") != -1)
            {
                return "龙";
            }
            else if (nz.IndexOf("巳") != -1)
            {
                return "蛇";
            }
            else if (nz.IndexOf("午") != -1)
            {
                return "马";
            }
            else if (nz.IndexOf("未") != -1)
            {
                return "羊";
            }
            else if (nz.IndexOf("申") != -1)
            {
                return "猴";
            }
            else if (nz.IndexOf("酉") != -1)
            {
                return "鸡";
            }
            else if (nz.IndexOf("戌") != -1)
            {
                return "狗";
            }
            else if (nz.IndexOf("亥") != -1)
            {
                return "猪";
            }
            return String.Empty;
        }
    }
}
