/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.support;

import com.alipay.config.Config;
import com.alipay.config.Env;
import com.alipay.support.RSAWindow;
import com.alipay.support.util.GenerateRsaUtil;
import com.alipay.support.util.RsaKey;
import com.alipay.support.util.SupportUtil;
import com.swt.util.dialog.FileDialogUtil;
import com.swt.util.listener.KeyListenerUtil;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class RSAKeyFormatComposite
extends Composite {
    private Text text_input_rsa;
    private Text text_output_rsa;
    private String privateKeyPath = Config.KEY_SAVE_PATH;
    private String inputPrivateKeyDemo = "\u8bf7\u8f93\u5165\u5546\u6237\u5e94\u7528\u79c1\u94a5\uff0c\u6b64\u79c1\u94a5\u662f\u5546\u6237\u8c03\u7528\u652f\u4ed8\u5b9d\u63a5\u53e3\u8fdb\u884c\u4ea4\u6613\u7684\u552f\u4e00\u51ed\u8bc1\uff0c\u8bf7\u8c28\u614e\u4fdd\u7ba1\uff01";

    public RSAKeyFormatComposite(Composite parent, int style) {
        super(parent, style);
        final Button clip_public_button = new Button((Composite)this, 8);
        clip_public_button.setBounds(646, 543, 100, 35);
        clip_public_button.setToolTipText("\u70b9\u51fb\u590d\u5236\u6587\u672c\u6846\u4e2d\u4fe1\u606f\u81f3\u526a\u5207\u677f");
        clip_public_button.setText("\u590d\u5236");
        clip_public_button.setEnabled(false);
        FormData fd_clip_public_button = new FormData();
        clip_public_button.setLayoutData((Object)fd_clip_public_button);
        clip_public_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String output = RSAKeyFormatComposite.this.text_output_rsa.getText().trim();
                if (output == null || "".equals(output)) {
                    RSAKeyFormatComposite.this.text_output_rsa.setText("\u6587\u672c\u6846\u4e2d\u65e0\u6587\u672c\u4fe1\u606f\u3002\n");
                    return;
                }
                Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection tText = new StringSelection(output);
                clip.setContents(tText, null);
            }
        });
        this.text_input_rsa = new Text((Composite)this, 2624);
        this.text_input_rsa.setBounds(100, 60, 670, 240);
        this.text_input_rsa.addKeyListener(KeyListenerUtil.mkCtrlAKeyListener(this.text_input_rsa));
        this.text_input_rsa.setForeground(this.getDisplay().getSystemColor(15));
        this.text_input_rsa.setText(this.inputPrivateKeyDemo);
        this.text_input_rsa.addListener(15, new Listener(){

            public void handleEvent(Event e) {
                if (RSAKeyFormatComposite.this.inputPrivateKeyDemo.equals(RSAKeyFormatComposite.this.text_input_rsa.getText())) {
                    RSAKeyFormatComposite.this.text_input_rsa.setText("");
                    RSAKeyFormatComposite.this.text_input_rsa.setForeground(RSAKeyFormatComposite.this.getDisplay().getSystemColor(2));
                }
            }
        });
        this.text_input_rsa.addListener(16, new Listener(){

            public void handleEvent(Event e) {
                if (StringUtils.isEmpty((String)RSAKeyFormatComposite.this.text_input_rsa.getText())) {
                    RSAKeyFormatComposite.this.text_input_rsa.setText(RSAKeyFormatComposite.this.inputPrivateKeyDemo);
                    RSAKeyFormatComposite.this.text_input_rsa.setForeground(RSAKeyFormatComposite.this.getDisplay().getSystemColor(15));
                }
            }
        });
        Label label = new Label((Composite)this, 0);
        label.setText("\u5546\u6237\r\n\u5e94\u7528\u79c1\u94a5\uff1a");
        label.setBounds(5, 150, 90, 40);
        Label label_1 = new Label((Composite)this, 0);
        label_1.setText("\u8f93\u51fa\uff1a");
        label_1.setBounds(5, 430, 90, 17);
        this.text_output_rsa = new Text((Composite)this, 2624);
        this.text_output_rsa.setBounds(100, 360, 670, 220);
        this.text_output_rsa.addKeyListener(KeyListenerUtil.mkCtrlAKeyListener(this.text_output_rsa));
        Button button = new Button((Composite)this, 0);
        button.setBounds(100, 15, 100, 35);
        button.setText("\u4ece\u6587\u4ef6\u8bfb\u5165");
        button.setToolTipText("\u5c06\u5bc6\u94a5\u6587\u4ef6\u8bfb\u5165\u5230\u6587\u672c\u6846\u4e2d\uff0c\u8f6c\u6210\u4e00\u884c\u3002");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String file = FileDialogUtil.openGetFileDialog(RSAKeyFormatComposite.this.getShell());
                if (!StringUtils.isEmpty((String)file) && new File(file).exists()) {
                    try {
                        RSAKeyFormatComposite.this.text_input_rsa.setForeground(RSAKeyFormatComposite.this.getDisplay().getSystemColor(2));
                        RSAKeyFormatComposite.this.text_input_rsa.setText(RsaKey.getKeyFromFile(file));
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        final Button open_key_btn = new Button((Composite)this, 0);
        open_key_btn.setToolTipText("\u9700\u8981\u751f\u6210\u516c\u94a5\uff01");
        open_key_btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (StringUtils.isEmpty((String)RSAKeyFormatComposite.this.privateKeyPath)) {
                        return;
                    }
                    if (Env.isMac()) {
                        GenerateRsaUtil.runCMD(new String[]{"open", RSAKeyFormatComposite.this.privateKeyPath});
                    } else {
                        GenerateRsaUtil.runCMD("cmd /c start \" \"  \"" + RSAKeyFormatComposite.this.privateKeyPath + "\"");
                    }
                }
                catch (Exception e1) {
                    GenerateRsaUtil.info("\u6253\u5f00\u79c1\u94a5\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u7cfb\u7edf\u5f02\u5e38 {}", new Object[]{e1});
                    return;
                }
            }
        });
        open_key_btn.setText("\u6253\u5f00\u5bc6\u94a5\u6587\u4ef6\u8def\u5f84");
        open_key_btn.setBounds(620, 313, 130, 35);
        open_key_btn.setEnabled(false);
        Button button_1 = new Button((Composite)this, 0);
        button_1.setToolTipText("\u8bf7\u5148\u9009\u62e9\u79c1\u94a5\u6587\u4ef6\uff0c\u6b64\u5904\u8c03\u7528OpenSSL.exe\u5de5\u5177\u7531\u79c1\u94a5\u751f\u6210\u5bf9\u5e94\u516c\u94a5");
        button_1.setText("\u751f\u6210\u516c\u94a5\u6587\u4ef6");
        button_1.setBounds(490, 313, 120, 35);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String privateKey = SupportUtil.filterLineSeparator(RSAKeyFormatComposite.this.text_input_rsa.getText().trim());
                if (StringUtils.isEmpty((String)privateKey)) {
                    RSAKeyFormatComposite.this.text_output_rsa.setText("\u8bf7\u653e\u5165\u79c1\u94a5\u6216\u79c1\u94a5\u6587\u4ef6\uff01");
                    return;
                }
                try {
                    int keyFormat = RsaKey.check_rsa_type(privateKey);
                    switch (keyFormat) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 5: {
                            String keyLength = RsaKey.getKeyLength(privateKey);
                            String privateKeyFilePath = RsaKey.convert2KeyFile(privateKey, keyLength);
                            String publicKeyFileString = RsaKey.mkRsaPublicKeyFile(privateKeyFilePath, keyLength);
                            clip_public_button.setEnabled(true);
                            open_key_btn.setEnabled(true);
                            String publicKey = RsaKey.getKeyFromFile(publicKeyFileString);
                            RsaKey.clearHeadBottom(keyLength);
                            RSAKeyFormatComposite.this.text_output_rsa.setText(publicKey);
                            break;
                        }
                        case 3: 
                        case 6: {
                            RSAKeyFormatComposite.this.text_output_rsa.setText("\u8f93\u5165\u7684\u662f\u516c\u94a5\uff0c\u8bf7\u8f93\u5165\u79c1\u94a5\uff01");
                            break;
                        }
                        default: {
                            RSAKeyFormatComposite.this.text_output_rsa.setText("\u79c1\u94a5\u4e0d\u5408\u6cd5\uff0c\u8bf7\u8f93\u51651024/2048\u4f4d\u7684RSA PKCS1(\u975eJAVA\u9002\u7528)\u79c1\u94a5\uff0c\u5e76\u786e\u8ba4\u53bb\u6389\u4e86\u5934\u5c3e\u591a\u4f59\u4fe1\u606f\u3001\u7a7a\u683c\u3001\u6362\u884c\u3002");
                            break;
                        }
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        Button btnpkcs = new Button((Composite)this, 0);
        btnpkcs.setToolTipText("\u8bf7\u5148\u9009\u62e9\u79c1\u94a5\u6587\u4ef6");
        btnpkcs.setText("\u8f6cPKCS8(JAVA\u9002\u7528)\u79c1\u94a5");
        btnpkcs.setBounds(100, 313, 180, 35);
        btnpkcs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    String text_input_rsa_str = SupportUtil.filterLineSeparator(RSAKeyFormatComposite.this.text_input_rsa.getText().trim());
                    int keyFormat = RsaKey.check_rsa_type(text_input_rsa_str);
                    switch (keyFormat) {
                        case 1: {
                            String pkcs8_1024 = RsaKey.convert2pcks8(text_input_rsa_str, "1024");
                            RsaKey.clearHeadBottom("1024");
                            RSAKeyFormatComposite.this.text_output_rsa.setText(pkcs8_1024);
                            clip_public_button.setEnabled(true);
                            open_key_btn.setEnabled(true);
                            break;
                        }
                        case 2: {
                            RSAKeyFormatComposite.this.text_output_rsa.setText("\u8f93\u5165\u7684\u5df2\u7ecf\u662f1024\u957f\u5ea6\u7684PKCS8(JAVA\u9002\u7528)\u79c1\u94a5");
                            break;
                        }
                        case 3: {
                            RSAKeyFormatComposite.this.text_output_rsa.setText("\u8f93\u5165\u7684\u662f1024\u957f\u5ea6\u7684\u516c\u94a5\uff0c\u8bf7\u8f93\u5165\u79c1\u94a5\uff01");
                            break;
                        }
                        case 4: {
                            String pkcs8_2048 = RsaKey.convert2pcks8(text_input_rsa_str, "2048");
                            RsaKey.clearHeadBottom("2048");
                            RSAKeyFormatComposite.this.text_output_rsa.setText(pkcs8_2048);
                            clip_public_button.setEnabled(true);
                            open_key_btn.setEnabled(true);
                            break;
                        }
                        case 5: {
                            RSAKeyFormatComposite.this.text_output_rsa.setText("\u8f93\u5165\u7684\u5df2\u7ecf\u662f2048\u957f\u5ea6\u7684PKCS8(JAVA\u9002\u7528)\u79c1\u94a5");
                            break;
                        }
                        case 6: {
                            RSAKeyFormatComposite.this.text_output_rsa.setText("\u8f93\u5165\u7684\u662f2048\u957f\u5ea6\u7684\u516c\u94a5\uff0c\u8bf7\u8f93\u5165\u79c1\u94a5\uff01");
                            break;
                        }
                        default: {
                            RSAKeyFormatComposite.this.text_output_rsa.setText("\u79c1\u94a5\u4e0d\u5408\u6cd5\uff0c\u8bf7\u8f93\u51651024/2048\u4f4d\u7684RSA PKCS1(\u975eJAVA\u9002\u7528)\u79c1\u94a5\uff0c\u5e76\u786e\u8ba4\u53bb\u6389\u4e86\u5934\u5c3e\u591a\u4f59\u4fe1\u606f\u3001\u7a7a\u683c\u3001\u6362\u884c\u3002");
                            break;
                        }
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        Button btnpkcs_no = new Button((Composite)this, 0);
        btnpkcs_no.setToolTipText("\u8bf7\u5148\u9009\u62e9PKCS8(JAVA\u9002\u7528)\u7684\u79c1\u94a5\u6587\u4ef6");
        btnpkcs_no.setText("\u8f6cPKCS1(\u975eJAVA\u9002\u7528)\u79c1\u94a5");
        btnpkcs_no.setBounds(290, 313, 190, 35);
        btnpkcs_no.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    String text_input_rsa_str = SupportUtil.filterLineSeparator(RSAKeyFormatComposite.this.text_input_rsa.getText().trim());
                    int keyFormat = RsaKey.check_rsa_type(text_input_rsa_str);
                    switch (keyFormat) {
                        case 1: {
                            RSAKeyFormatComposite.this.text_output_rsa.setText("\u8f93\u5165\u7684\u5df2\u7ecf\u662f1024\u957f\u5ea6\u7684PKCS1(\u975eJAVA\u9002\u7528)\u79c1\u94a5");
                            break;
                        }
                        case 2: {
                            String pkcs8_1024 = RsaKey.convertPcks82Original(text_input_rsa_str, "1024");
                            RsaKey.clearHeadBottom("2048");
                            RSAKeyFormatComposite.this.text_output_rsa.setText(pkcs8_1024);
                            clip_public_button.setEnabled(true);
                            open_key_btn.setEnabled(true);
                            break;
                        }
                        case 3: {
                            RSAKeyFormatComposite.this.text_output_rsa.setText("\u8f93\u5165\u7684\u662f1024\u957f\u5ea6\u7684\u516c\u94a5\uff0c\u8bf7\u8f93\u5165\u79c1\u94a5\uff01");
                            break;
                        }
                        case 4: {
                            RSAKeyFormatComposite.this.text_output_rsa.setText("\u8f93\u5165\u7684\u5df2\u7ecf\u662f2048\u957f\u5ea6\u7684PKCS1(\u975eJAVA\u9002\u7528)\u79c1\u94a5\uff01");
                            break;
                        }
                        case 5: {
                            String pkcs8_2048 = RsaKey.convertPcks82Original(text_input_rsa_str, "2048");
                            RsaKey.clearHeadBottom("2048");
                            RSAKeyFormatComposite.this.text_output_rsa.setText(pkcs8_2048);
                            clip_public_button.setEnabled(true);
                            open_key_btn.setEnabled(true);
                            break;
                        }
                        case 6: {
                            RSAKeyFormatComposite.this.text_output_rsa.setText("\u8f93\u5165\u7684\u662f2048\u957f\u5ea6\u7684\u516c\u94a5\uff0c\u8bf7\u8f93\u5165\u79c1\u94a5\uff01");
                            break;
                        }
                        default: {
                            RSAKeyFormatComposite.this.text_output_rsa.setText("\u79c1\u94a5\u4e0d\u5408\u6cd5\uff0c\u8bf7\u8f93\u51651024/2048\u4f4d\u7684RSA PKCS1(\u975eJAVA\u9002\u7528)\u79c1\u94a5\uff0c\u5e76\u786e\u8ba4\u53bb\u6389\u4e86\u5934\u5c3e\u591a\u4f59\u4fe1\u606f\u3001\u7a7a\u683c\u3001\u6362\u884c\u3002");
                            break;
                        }
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    protected void checkSubclass() {
    }

    public static void main(String[] args) {
        RSAWindow.main(args);
        RSAWindow.tabFolder.setSelection(1);
    }
}

