/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.support;

import com.alipay.config.Config;
import com.alipay.config.Env;
import com.alipay.support.RSAWindow;
import com.alipay.support.util.GenerateRsaUtil;
import com.alipay.support.util.RsaKey;
import com.alipay.support.util.SupportUtil;
import com.alipay.util.key.KeyTool;
import com.alipay.util.key.KeyType;
import com.swt.util.listener.KeyListenerUtil;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class RSAMakeKeyComposite
extends Composite {
    private Text text_privatekey;
    private Text text_publickey;
    private Label label_notice;
    private Button button_radio_java;
    private Button button_radio_other;
    private Button button_rsa1024;
    private Button button_rsa2048;
    private String privateKeyPath;

    public static void main(String[] args) {
        RSAWindow.main(args);
    }

    public RSAMakeKeyComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FormLayout());
        Link link_url = new Link((Composite)this, 0);
        link_url.setText("<A>\u4f7f\u7528\u8bf4\u660e</A>");
        link_url.setToolTipText("\u70b9\u51fb\u67e5\u770b\u751f\u6210\u5bc6\u94a5\u4f7f\u7528\u8bf4\u660e");
        Display display = parent.getDisplay();
        link_url.setFont(new Font((Device)display, "\u5b8b\u4f53", 10, 0));
        FormData fd_link_url = new FormData();
        link_url.setLayoutData((Object)fd_link_url);
        fd_link_url.top = new FormAttachment(0, 10);
        fd_link_url.left = new FormAttachment(0, 700);
        fd_link_url.height = 20;
        fd_link_url.width = 80;
        link_url.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RsaKey.openBrowserForUrl("https://doc.open.alipay.com/docs/doc.htm?treeId=291&articleId=105971&docType=1");
            }
        });
        Link update_link_url = new Link((Composite)this, 0);
        update_link_url.setText("<A>\u652f\u4ed8\u5b9dRSA\u7b7e\u540d\u5347\u7ea7\u516c\u544a</A>");
        update_link_url.setToolTipText("\u70b9\u51fb\u67e5\u770b\u652f\u4ed8\u5b9dRSA\u7b7e\u540d\u5347\u7ea7\u516c\u544a");
        update_link_url.setFont(new Font((Device)display, "\u5b8b\u4f53", 10, 0));
        FormData fd_update_link_url = new FormData();
        update_link_url.setLayoutData((Object)fd_update_link_url);
        fd_update_link_url.top = new FormAttachment(0, 10);
        fd_update_link_url.left = new FormAttachment(0, 90);
        fd_update_link_url.height = 20;
        fd_update_link_url.width = 300;
        update_link_url.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RsaKey.openBrowserForUrl("https://open.alipay.com/platform/announcement.htm?id=2");
            }
        });
        Button mk_key_btn = new Button((Composite)this, 0);
        mk_key_btn.setText("\u751f\u6210\u5bc6\u94a5");
        FormData fd_mk_key_btn = new FormData();
        fd_mk_key_btn.left = new FormAttachment(0, 110);
        mk_key_btn.setLayoutData((Object)fd_mk_key_btn);
        fd_mk_key_btn.height = 35;
        fd_mk_key_btn.width = 80;
        final Button open_key_btn = new Button((Composite)this, 0);
        open_key_btn.setToolTipText("\u9700\u8981\u751f\u6210\u516c\u94a5\uff01");
        fd_mk_key_btn.right = new FormAttachment((Control)open_key_btn, -10);
        open_key_btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (StringUtils.isBlank((String)RSAMakeKeyComposite.this.privateKeyPath)) {
                        RSAMakeKeyComposite.this.label_notice.setText("\u6253\u5f00\u6587\u4ef6\u5939\u5931\u8d25\uff0c\u53ef\u80fd\u6587\u4ef6\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u5bc6\u94a5\n");
                        return;
                    }
                    if (Env.isMac()) {
                        GenerateRsaUtil.runCMD(new String[]{"open", RSAMakeKeyComposite.this.privateKeyPath});
                    } else {
                        GenerateRsaUtil.runCMD("cmd /c start \"\"  \"" + RSAMakeKeyComposite.this.privateKeyPath + "\"");
                    }
                }
                catch (Exception e1) {
                    GenerateRsaUtil.info("\u6253\u5f00\u79c1\u94a5\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u7cfb\u7edf\u5f02\u5e38 {}", new Object[]{e1});
                    RSAMakeKeyComposite.this.label_notice.setText("\u6253\u5f00\u6587\u4ef6\u5939\u5931\u8d25\uff0c\u53ef\u80fd\u6587\u4ef6\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u5bc6\u94a5\n");
                    return;
                }
            }
        });
        open_key_btn.setText("\u6253\u5f00\u5bc6\u94a5\u6587\u4ef6\u8def\u5f84");
        open_key_btn.setEnabled(false);
        FormData fd_op_key_btn = new FormData();
        fd_op_key_btn.left = new FormAttachment(0, 206);
        open_key_btn.setLayoutData((Object)fd_op_key_btn);
        fd_op_key_btn.height = 35;
        fd_op_key_btn.width = 160;
        final Button clip_button = new Button((Composite)this, 8);
        clip_button.setToolTipText("\u70b9\u51fb\u590d\u5236\u6587\u672c\u6846\u4e2d\u4fe1\u606f\u81f3\u526a\u5207\u677f");
        clip_button.setText("\u590d\u5236\u79c1\u94a5");
        clip_button.setEnabled(false);
        FormData fd_clip_button = new FormData();
        clip_button.setLayoutData((Object)fd_clip_button);
        clip_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String output = RSAMakeKeyComposite.this.text_privatekey.getText().trim();
                if (output == null || "".equals(output)) {
                    RSAMakeKeyComposite.this.label_notice.setText("\u6587\u672c\u6846\u4e2d\u65e0\u6587\u672c\u4fe1\u606f\u3002\n");
                    return;
                }
                Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection tText = new StringSelection(output);
                clip.setContents(tText, null);
                RSAMakeKeyComposite.this.label_notice.setText("\u5df2\u590d\u5236\u79c1\u94a5\u81f3\u526a\u5207\u677f\u3002\n");
            }
        });
        this.text_privatekey = new Text((Composite)this, 2626);
        FormData fd_text_privatekey = new FormData();
        fd_text_privatekey.bottom = new FormAttachment(70);
        fd_text_privatekey.top = new FormAttachment((Control)mk_key_btn, 10);
        fd_text_privatekey.right = new FormAttachment(100, -10);
        this.text_privatekey.setLayoutData((Object)fd_text_privatekey);
        this.text_privatekey.addKeyListener(KeyListenerUtil.mkCtrlAKeyListener(this.text_privatekey));
        fd_clip_button.bottom = new FormAttachment((Control)this.text_privatekey, 250);
        fd_clip_button.left = new FormAttachment((Control)this.text_privatekey, -100);
        fd_clip_button.height = 35;
        fd_clip_button.width = 80;
        final Button clip_public_button = new Button((Composite)this, 8);
        clip_public_button.setToolTipText("\u70b9\u51fb\u590d\u5236\u516c\u94a5\u6587\u672c\u6846\u4e2d\u4fe1\u606f\u81f3\u526a\u5207\u677f");
        clip_public_button.setText("\u590d\u5236\u516c\u94a5");
        clip_public_button.setEnabled(false);
        FormData fd_clip_public_button = new FormData();
        clip_public_button.setLayoutData((Object)fd_clip_public_button);
        clip_public_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String output = RSAMakeKeyComposite.this.text_publickey.getText().trim();
                if (output == null || "".equals(output)) {
                    RSAMakeKeyComposite.this.label_notice.setText("\u6587\u672c\u6846\u4e2d\u65e0\u6587\u672c\u4fe1\u606f\u3002\n");
                    return;
                }
                Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection tText = new StringSelection(output);
                clip.setContents(tText, null);
                RSAMakeKeyComposite.this.label_notice.setText("\u5df2\u590d\u5236\u516c\u94a5\u81f3\u526a\u5207\u677f\u3002\n");
            }
        });
        Link link = new Link((Composite)this, 0);
        link.setText("<A>\u4e0a\u4f20\u516c\u94a5</A>");
        link.setToolTipText("\u70b9\u51fb\u4e0a\u4f20\u516c\u94a5\u5230\u5f00\u653e\u5e73\u53f0");
        link.setFont(new Font((Device)display, "\u5b8b\u4f53", 10, 0));
        FormData fd_link = new FormData();
        link.setLayoutData((Object)fd_link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RsaKey.openBrowserForUrl("https://openhome.alipay.com/platform/keyManage.htm");
            }
        });
        Label label = new Label((Composite)this, 0);
        fd_text_privatekey.left = new FormAttachment((Control)label, 5);
        FormData fd_label = new FormData();
        fd_label.left = new FormAttachment(1, 0);
        label.setLayoutData((Object)fd_label);
        label.setText("\u5546\u6237\r\n\u5e94\u7528\u79c1\u94a5\uff1a");
        Label label_1 = new Label((Composite)this, 0);
        label_1.setText("\u5546\u6237\r\n\u5e94\u7528\u516c\u94a5\uff1a");
        FormData fd_label_1 = new FormData();
        fd_label_1.top = new FormAttachment((Control)label, 130);
        fd_label_1.left = new FormAttachment(1, 0);
        fd_label_1.bottom = new FormAttachment(100, 10);
        label_1.setLayoutData((Object)fd_label_1);
        this.text_publickey = new Text((Composite)this, 2626);
        FormData fd_text_publickey = new FormData();
        fd_text_publickey.top = new FormAttachment((Control)this.text_privatekey, 15);
        fd_text_publickey.left = new FormAttachment((Control)label_1, 5);
        fd_text_publickey.right = new FormAttachment(100, -10);
        fd_text_publickey.bottom = new FormAttachment(100, -60);
        this.text_publickey.setLayoutData((Object)fd_text_publickey);
        this.text_publickey.addKeyListener(KeyListenerUtil.mkCtrlAKeyListener(this.text_publickey));
        fd_link.top = new FormAttachment((Control)this.text_publickey, 15);
        fd_link.left = new FormAttachment((Control)this.text_publickey, -90);
        fd_link.height = 35;
        fd_link.width = 80;
        fd_clip_public_button.bottom = new FormAttachment((Control)this.text_publickey, 107);
        fd_clip_public_button.left = new FormAttachment((Control)this.text_publickey, -100);
        fd_clip_public_button.height = 35;
        fd_clip_public_button.width = 80;
        Group group_devLanguage = new Group((Composite)this, 32);
        FormData fd_group_devLanguage = new FormData();
        fd_group_devLanguage.top = new FormAttachment(0, 25);
        fd_group_devLanguage.left = new FormAttachment((Control)label, 5);
        fd_group_devLanguage.right = new FormAttachment(100, -10);
        fd_group_devLanguage.height = 25;
        group_devLanguage.setLayoutData((Object)fd_group_devLanguage);
        Group group = new Group((Composite)this, 32);
        fd_mk_key_btn.top = new FormAttachment((Control)group, 5);
        fd_op_key_btn.top = new FormAttachment((Control)group, 5);
        fd_label.top = new FormAttachment((Control)group, 169);
        FormData fd_group = new FormData();
        fd_group.top = new FormAttachment((Control)group_devLanguage, 5);
        fd_group.left = new FormAttachment((Control)label, 5);
        fd_group.right = new FormAttachment(100, -10);
        fd_group.height = 25;
        group.setLayoutData((Object)fd_group);
        this.button_radio_java = new Button((Composite)group_devLanguage, 16);
        this.button_radio_java.setSelection(true);
        this.button_radio_java.setLocation(5, 18);
        this.button_radio_java.setSize(72, 13);
        this.button_radio_java.setText("PKCS8(JAVA\u9002\u7528)");
        this.button_radio_java.pack();
        this.button_radio_other = new Button((Composite)group_devLanguage, 16);
        this.button_radio_other.setLocation(160, 18);
        this.button_radio_other.setSize(72, 13);
        this.button_radio_other.setText("PKCS1(\u975eJAVA\u9002\u7528)");
        this.button_radio_other.pack();
        this.button_rsa1024 = new Button((Composite)group, 16);
        this.button_rsa1024.setLocation(160, 18);
        this.button_rsa1024.setSize(72, 13);
        this.button_rsa1024.setText("1024");
        this.button_rsa1024.pack();
        this.button_rsa2048 = new Button((Composite)group, 16);
        this.button_rsa2048.setSelection(true);
        this.button_rsa2048.setLocation(5, 18);
        this.button_rsa2048.setSize(72, 13);
        this.button_rsa2048.setText("2048");
        this.button_rsa2048.pack();
        Label lblDevLanguage = new Label((Composite)this, 0);
        lblDevLanguage.setText("\u5bc6\u94a5\u683c\u5f0f\uff1a");
        FormData lblDevLanguage_form = new FormData();
        lblDevLanguage_form.top = new FormAttachment(1, 35);
        lblDevLanguage_form.left = new FormAttachment(1, 0);
        lblDevLanguage_form.height = 30;
        lblDevLanguage_form.width = 70;
        lblDevLanguage.setLayoutData((Object)lblDevLanguage_form);
        Label lblNewLabel = new Label((Composite)this, 0);
        lblNewLabel.setText("\u5bc6\u94a5\u957f\u5ea6\uff1a");
        FormData lblNewLabel_form = new FormData();
        lblNewLabel_form.top = new FormAttachment((Control)group_devLanguage, 20);
        lblNewLabel_form.left = new FormAttachment(1, 0);
        lblNewLabel_form.height = 30;
        lblNewLabel_form.width = 70;
        lblNewLabel.setLayoutData((Object)lblNewLabel_form);
        this.label_notice = new Label((Composite)this, 64);
        this.label_notice.setText("\r\n");
        FormData fd_label_2 = new FormData();
        fd_label_2.left = new FormAttachment(0, 100);
        fd_label_2.top = new FormAttachment((Control)this.text_publickey, 2);
        fd_label_2.height = 60;
        fd_label_2.width = 550;
        this.label_notice.setLayoutData((Object)fd_label_2);
        mk_key_btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KeyType keyType = RSAMakeKeyComposite.this.getKeyType();
                String devLanguage = RSAMakeKeyComposite.this.getDevLanguage();
                try {
                    if (Config.DEVLEPMENT_LANGUAGE_JAVA.equals(devLanguage)) {
                        String[] result = KeyTool.generateKey((KeyType)keyType);
                        if (result == null || result.length != 2) {
                            RSAMakeKeyComposite.this.label_notice.setText("\u751f\u6210\u5bc6\u94a5\u5931\u8d25!\n");
                        }
                        RSAMakeKeyComposite.this.text_privatekey.setText(result[0]);
                        RSAMakeKeyComposite.this.text_publickey.setText(result[1]);
                        RSAMakeKeyComposite.this.privateKeyPath = SupportUtil.writeKeyFile(new String[]{"\u5e94\u7528\u79c1\u94a5" + keyType.getLength(), "\u5e94\u7528\u516c\u94a5" + keyType.getLength()}, result);
                        RSAMakeKeyComposite.this.label_notice.setText("\u5bc6\u94a5\u6587\u4ef6\u6210\u529f\u4fdd\u5b58\u81f3\u3010" + RSAMakeKeyComposite.this.privateKeyPath + "\u3011,\u70b9\u51fb\u201c\u6253\u5f00\u5bc6\u94a5\u6587\u4ef6\u8def\u5f84\u201d\u6309\u94ae\u67e5\u770b");
                    } else {
                        String privateKeyFile = GenerateRsaUtil.mkRsaPrivateKeyFile(String.valueOf(keyType.getLength()));
                        RSAMakeKeyComposite.this.privateKeyPath = privateKeyFile.substring(0, privateKeyFile.lastIndexOf(File.separator));
                        String publicKeyFile = GenerateRsaUtil.mkRsaPublicKeyFile(privateKeyFile, keyType.getLength());
                        if (StringUtils.isBlank((String)publicKeyFile)) {
                            RSAMakeKeyComposite.this.label_notice.setText("\u516c\u94a5\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u5bc6\u94a5\n");
                            return;
                        }
                        String publicKey = GenerateRsaUtil.getKeyFromFile(publicKeyFile);
                        if (StringUtils.isBlank((String)publicKey)) {
                            RSAMakeKeyComposite.this.label_notice.setText("\u516c\u94a5\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u516c\u94a5\n");
                            return;
                        }
                        String privateKey = GenerateRsaUtil.getKeyFromFile(privateKeyFile);
                        if (StringUtils.isBlank((String)publicKey)) {
                            RSAMakeKeyComposite.this.label_notice.setText("\u516c\u94a5\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u516c\u94a5\n");
                            return;
                        }
                        RSAMakeKeyComposite.this.text_privatekey.setText(privateKey);
                        RSAMakeKeyComposite.this.text_publickey.setText(publicKey);
                        GenerateRsaUtil.clearHeadBottom(keyType.getLength());
                        RSAMakeKeyComposite.this.label_notice.setText("\u5bc6\u94a5\u6587\u4ef6\u6210\u529f\u4fdd\u5b58\u81f3\u3010" + RSAMakeKeyComposite.this.privateKeyPath + "\u3011,\u70b9\u51fb\u201c\u6253\u5f00\u5bc6\u94a5\u6587\u4ef6\u8def\u5f84\u201d\u6309\u94ae\u67e5\u770b");
                    }
                    open_key_btn.setEnabled(true);
                    clip_button.setEnabled(true);
                    clip_public_button.setEnabled(true);
                }
                catch (Exception e1) {
                    RSAMakeKeyComposite.this.label_notice.setText("\u751f\u6210\u5bc6\u94a5\u5f02\u5e38\u3002\n");
                    e1.printStackTrace();
                }
            }
        });
    }

    protected void checkSubclass() {
    }

    public KeyType getKeyType() {
        if (this.button_rsa1024.getSelection()) {
            return KeyType.RSA1024;
        }
        if (this.button_rsa2048.getSelection()) {
            return KeyType.RSA2048;
        }
        return KeyType.RSA1024;
    }

    public String getDevLanguage() {
        if (this.button_radio_java.getSelection()) {
            return Config.DEVLEPMENT_LANGUAGE_JAVA;
        }
        if (this.button_radio_other.getSelection()) {
            return Config.DEVLEPMENT_LANGUAGE_OTHER;
        }
        return Config.DEVLEPMENT_LANGUAGE_OTHER;
    }

    public String getDateString() {
        return new Date().toLocaleString();
    }
}

