/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.AdapterMethodHandle;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import sun.invoke.util.VerifyType;
import sun.invoke.util.Wrapper;

class BoundMethodHandle
extends MethodHandle {
    private final Object argument;
    private final int vmargslot;

    BoundMethodHandle(DirectMethodHandle directMethodHandle, Object object) {
        super(directMethodHandle.type().dropParameterTypes(0, 1));
        this.argument = BoundMethodHandle.checkReferenceArgument(object, directMethodHandle, 0);
        this.vmargslot = this.type().parameterSlotCount();
        this.initTarget(directMethodHandle, 0);
    }

    BoundMethodHandle(MethodHandle methodHandle, Object object, int n) {
        this(methodHandle.type().dropParameterTypes(n, n + 1), methodHandle, object, n);
    }

    BoundMethodHandle(MethodType methodType, MethodHandle methodHandle, Object object, int n) {
        super(methodType);
        this.argument = methodHandle.type().parameterType(n).isPrimitive() ? BoundMethodHandle.bindPrimitiveArgument(object, methodHandle, n) : BoundMethodHandle.checkReferenceArgument(object, methodHandle, n);
        this.vmargslot = methodType.parameterSlotDepth(n);
        this.initTarget(methodHandle, n);
    }

    private void initTarget(MethodHandle methodHandle, int n) {
        MethodHandleNatives.init(this, (Object)methodHandle, n);
    }

    BoundMethodHandle(MethodType methodType, Object object, int n) {
        super(methodType);
        this.argument = object;
        this.vmargslot = n;
        assert (this instanceof AdapterMethodHandle);
    }

    BoundMethodHandle(MethodHandle methodHandle) {
        super(methodHandle.type().dropParameterTypes(0, 1));
        this.argument = this;
        this.vmargslot = this.type().parameterSlotDepth(0);
        this.initTarget(methodHandle, 0);
    }

    static final Object checkReferenceArgument(Object object, MethodHandle methodHandle, int n) {
        Class<?> clazz = methodHandle.type().parameterType(n);
        if (!clazz.isPrimitive()) {
            if (object == null) {
                return null;
            }
            if (VerifyType.isNullReferenceConversion(object.getClass(), clazz)) {
                return object;
            }
        }
        throw BoundMethodHandle.badBoundArgumentException(object, methodHandle, n);
    }

    static final Object bindPrimitiveArgument(Object object, MethodHandle methodHandle, int n) {
        Class<?> clazz = methodHandle.type().parameterType(n);
        Wrapper wrapper = Wrapper.forPrimitiveType(clazz);
        Object object2 = wrapper.zero();
        if (object2 != null) {
            if (object == null) {
                if (clazz != Integer.TYPE && wrapper.isSubwordOrInt()) {
                    return 0;
                }
                return object2;
            }
            if (VerifyType.isNullReferenceConversion(object.getClass(), object2.getClass())) {
                if (clazz != Integer.TYPE && wrapper.isSubwordOrInt()) {
                    return Wrapper.INT.wrap(object);
                }
                return object;
            }
        }
        throw BoundMethodHandle.badBoundArgumentException(object, methodHandle, n);
    }

    static final RuntimeException badBoundArgumentException(Object object, MethodHandle methodHandle, int n) {
        String string = object == null ? "null" : object.getClass().toString();
        return new ClassCastException("cannot bind " + string + " argument to parameter #" + n + " of " + methodHandle.type());
    }

    @Override
    String debugString() {
        return MethodHandleStatics.addTypeString((Object)this.baseName(), (MethodHandle)this);
    }

    protected String baseName() {
        MethodHandle methodHandle = this;
        while (methodHandle instanceof BoundMethodHandle) {
            Object object = MethodHandleNatives.getTargetInfo(methodHandle);
            if (!(object instanceof MethodHandle)) {
                String string = null;
                if (object instanceof MemberName) {
                    string = ((MemberName)object).getName();
                }
                if (string != null) {
                    return string;
                }
                return BoundMethodHandle.noParens(super.toString());
            }
            methodHandle = (MethodHandle)object;
            assert (methodHandle != this);
        }
        return BoundMethodHandle.noParens(methodHandle.toString());
    }

    private static String noParens(String string) {
        int n = string.indexOf(40);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }
}

