/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import sun.misc.ProxyGenerator;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;
import sun.security.util.SecurityConstants;

/*
 * Exception performing whole class analysis ignored.
 */
public class Proxy
implements Serializable {
    private static final long serialVersionUID = -2222568056686623797L;
    private static final String proxyClassNamePrefix = "$Proxy";
    private static final Class[] constructorParams = new Class[]{InvocationHandler.class};
    private static Map<ClassLoader, Map<List<String>, Object>> loaderToCache = new WeakHashMap<ClassLoader, Map<List<String>, Object>>();
    private static Object pendingGenerationMarker = new Object();
    private static long nextUniqueNumber = 0L;
    private static Object nextUniqueNumberLock = new Object();
    private static Map<Class<?>, Void> proxyClasses = Collections.synchronizedMap(new WeakHashMap());
    protected InvocationHandler h;

    private Proxy() {
    }

    protected Proxy(InvocationHandler invocationHandler) {
        this.doNewInstanceCheck();
        this.h = invocationHandler;
    }

    private void doNewInstanceCheck() {
        SecurityManager securityManager = System.getSecurityManager();
        Class<?> clazz = this.getClass();
        if (securityManager != null && ProxyAccessHelper.needsNewInstanceCheck(clazz)) {
            try {
                securityManager.checkPermission(ProxyAccessHelper.PROXY_PERMISSION);
            }
            catch (SecurityException securityException) {
                throw new SecurityException("Not allowed to construct a Proxy instance that implements a non-public interface", securityException);
            }
        }
    }

    @CallerSensitive
    public static Class<?> getProxyClass(ClassLoader classLoader, Class<?> ... classArray) throws IllegalArgumentException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            Proxy.checkProxyAccess(Reflection.getCallerClass(), classLoader, classArray);
        }
        return Proxy.getProxyClass0(classLoader, classArray);
    }

    private static void checkProxyAccess(Class<?> clazz, ClassLoader classLoader, Class<?> ... classArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            ClassLoader classLoader2 = clazz.getClassLoader();
            if (classLoader == null && classLoader2 != null && !ProxyAccessHelper.allowNullLoader) {
                securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
            }
            ReflectUtil.checkProxyPackageAccess(classLoader2, classArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> getProxyClass0(ClassLoader classLoader, Class<?> ... classArray) {
        HashMap<List<String>, Object> hashMap;
        HashMap<List<String>, Object> hashMap2;
        if (classArray.length > 65535) {
            throw new IllegalArgumentException("interface limit exceeded");
        }
        Class clazz = null;
        String[] stringArray = new String[classArray.length];
        HashSet hashSet = new HashSet();
        for (int i = 0; i < classArray.length; ++i) {
            hashMap2 = classArray[i].getName();
            hashMap = null;
            try {
                hashMap = Class.forName((String)((Object)hashMap2), false, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (hashMap != classArray[i]) {
                throw new IllegalArgumentException(classArray[i] + " is not visible from class loader");
            }
            if (!((Class)((Object)hashMap)).isInterface()) {
                throw new IllegalArgumentException(((Class)((Object)hashMap)).getName() + " is not an interface");
            }
            if (hashSet.contains(hashMap)) {
                throw new IllegalArgumentException("repeated interface: " + ((Class)((Object)hashMap)).getName());
            }
            hashSet.add(hashMap);
            stringArray[i] = hashMap2;
        }
        List<String> list = Arrays.asList(stringArray);
        hashMap = loaderToCache;
        synchronized (hashMap) {
            hashMap2 = loaderToCache.get(classLoader);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<List<String>, Object>();
                loaderToCache.put(classLoader, hashMap2);
            }
        }
        hashMap = hashMap2;
        synchronized (hashMap) {
            while (true) {
                Object v;
                if ((v = hashMap2.get(list)) instanceof Reference) {
                    clazz = (Class)((Reference)v).get();
                }
                if (clazz != null) {
                    return clazz;
                }
                if (v != pendingGenerationMarker) break;
                try {
                    hashMap2.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            hashMap2.put(list, pendingGenerationMarker);
        }
        try {
            long l;
            Object object;
            hashMap = null;
            for (int i = 0; i < classArray.length; ++i) {
                String string;
                int n = classArray[i].getModifiers();
                if (Modifier.isPublic(n)) continue;
                object = classArray[i].getName();
                int n2 = ((String)object).lastIndexOf(46);
                String string2 = string = n2 == -1 ? "" : ((String)object).substring(0, n2 + 1);
                if (hashMap == null) {
                    hashMap = string;
                    continue;
                }
                if (string.equals(hashMap)) continue;
                throw new IllegalArgumentException("non-public interfaces from different packages");
            }
            if (hashMap == null) {
                hashMap = "com.sun.proxy.";
            }
            object = nextUniqueNumberLock;
            synchronized (object) {
                l = nextUniqueNumber++;
            }
            object = (String)((Object)hashMap) + "$Proxy" + l;
            byte[] byArray = ProxyGenerator.generateProxyClass((String)object, (Class[])classArray);
            try {
                clazz = Proxy.defineClass0(classLoader, (String)object, byArray, 0, byArray.length);
            }
            catch (ClassFormatError classFormatError) {
                throw new IllegalArgumentException(classFormatError.toString());
            }
            proxyClasses.put(clazz, null);
        }
        finally {
            hashMap = hashMap2;
            synchronized (hashMap) {
                if (clazz != null) {
                    hashMap2.put(list, new WeakReference<Class>(clazz));
                } else {
                    hashMap2.remove(list);
                }
                hashMap2.notifyAll();
            }
        }
        return clazz;
    }

    @CallerSensitive
    public static Object newProxyInstance(ClassLoader classLoader, Class<?>[] classArray, InvocationHandler invocationHandler) throws IllegalArgumentException {
        if (invocationHandler == null) {
            throw new NullPointerException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            Proxy.checkProxyAccess(Reflection.getCallerClass(), classLoader, classArray);
        }
        Class<?> clazz = Proxy.getProxyClass0(classLoader, classArray);
        try {
            Constructor<?> constructor = clazz.getConstructor(constructorParams);
            InvocationHandler invocationHandler2 = invocationHandler;
            if (securityManager != null && ProxyAccessHelper.needsNewInstanceCheck(clazz)) {
                return AccessController.doPrivileged(new ClassValue<ConcurrentHashMap<Method, MethodHandle>>(constructor, invocationHandler2){

                    @Override
                    protected ConcurrentHashMap<Method, MethodHandle> computeValue(Class<?> type) {
                        return new ConcurrentHashMap<Method, MethodHandle>(4);
                    }
                });
            }
            return Proxy.newInstance(constructor, invocationHandler2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InternalError(noSuchMethodException.toString());
        }
    }

    private static Object newInstance(Constructor<?> constructor, InvocationHandler invocationHandler) {
        try {
            return constructor.newInstance(invocationHandler);
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new InternalError(throwable.toString());
        }
    }

    public static boolean isProxyClass(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        return proxyClasses.containsKey(clazz);
    }

    public static InvocationHandler getInvocationHandler(Object object) throws IllegalArgumentException {
        if (!Proxy.isProxyClass(object.getClass())) {
            throw new IllegalArgumentException("not a proxy instance");
        }
        Proxy proxy = (Proxy)object;
        return proxy.h;
    }

    private static native Class defineClass0(ClassLoader var0, String var1, byte[] var2, int var3, int var4);

    static /* synthetic */ Object access$000(Constructor constructor, InvocationHandler invocationHandler) {
        return Proxy.newInstance(constructor, invocationHandler);
    }
}

