/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.concurrent.ExecutionException;
import sun.nio.ch.ChannelInputStream;
import sun.nio.cs.StreamDecoder;
import sun.nio.cs.StreamEncoder;

public final class Channels {
    private Channels() {
    }

    private static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw new NullPointerException("\"" + string + "\" is null!");
        }
    }

    private static void writeFullyImpl(WritableByteChannel writableByteChannel, ByteBuffer byteBuffer) throws IOException {
        while (byteBuffer.remaining() > 0) {
            int n = writableByteChannel.write(byteBuffer);
            if (n > 0) continue;
            throw new RuntimeException("no bytes written");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFully(WritableByteChannel writableByteChannel, ByteBuffer byteBuffer) throws IOException {
        if (writableByteChannel instanceof SelectableChannel) {
            SelectableChannel selectableChannel = (SelectableChannel)((Object)writableByteChannel);
            Object object = selectableChannel.blockingLock();
            synchronized (object) {
                if (!selectableChannel.isBlocking()) {
                    throw new IllegalBlockingModeException();
                }
                Channels.writeFullyImpl(writableByteChannel, byteBuffer);
            }
        } else {
            Channels.writeFullyImpl(writableByteChannel, byteBuffer);
        }
    }

    public static InputStream newInputStream(ReadableByteChannel readableByteChannel) {
        Channels.checkNotNull(readableByteChannel, "ch");
        return new ChannelInputStream(readableByteChannel);
    }

    public static OutputStream newOutputStream(final WritableByteChannel writableByteChannel) {
        Channels.checkNotNull(writableByteChannel, "ch");
        return new OutputStream(){
            private ByteBuffer bb = null;
            private byte[] bs = null;
            private byte[] b1 = null;

            @Override
            public synchronized void write(int n) throws IOException {
                if (this.b1 == null) {
                    this.b1 = new byte[1];
                }
                this.b1[0] = (byte)n;
                this.write(this.b1);
            }

            @Override
            public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
                if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (n2 == 0) {
                    return;
                }
                ByteBuffer byteBuffer = this.bs == byArray ? this.bb : ByteBuffer.wrap(byArray);
                byteBuffer.limit(Math.min(n + n2, byteBuffer.capacity()));
                byteBuffer.position(n);
                this.bb = byteBuffer;
                this.bs = byArray;
                Channels.writeFully(writableByteChannel, byteBuffer);
            }

            @Override
            public void close() throws IOException {
                writableByteChannel.close();
            }
        };
    }

    public static InputStream newInputStream(final AsynchronousByteChannel asynchronousByteChannel) {
        Channels.checkNotNull(asynchronousByteChannel, "ch");
        return new OutputStream(){
            private ByteBuffer bb;
            private byte[] bs;
            private byte[] b1;

            @Override
            public synchronized void write(int b) throws IOException {
                if (this.b1 == null) {
                    this.b1 = new byte[1];
                }
                this.b1[0] = (byte)b;
                this.write(this.b1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void write(byte[] bs, int off, int len) throws IOException {
                if (off < 0 || off > bs.length || len < 0 || off + len > bs.length || off + len < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (len == 0) {
                    return;
                }
                ByteBuffer bb = this.bs == bs ? this.bb : ByteBuffer.wrap(bs);
                bb.limit(Math.min(off + len, bb.capacity()));
                bb.position(off);
                this.bb = bb;
                this.bs = bs;
                boolean interrupted = false;
                try {
                    while (bb.remaining() > 0) {
                        try {
                            asynchronousByteChannel.write(bb).get();
                        }
                        catch (ExecutionException ee) {
                            throw new IOException(ee.getCause());
                        }
                        catch (InterruptedException ie) {
                            interrupted = true;
                        }
                    }
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }

            @Override
            public void close() throws IOException {
                asynchronousByteChannel.close();
            }
        };
    }

    public static OutputStream newOutputStream(AsynchronousByteChannel asynchronousByteChannel) {
        Channels.checkNotNull(asynchronousByteChannel, "ch");
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static ReadableByteChannel newChannel(InputStream inputStream) {
        Channels.checkNotNull(inputStream, "in");
        if (inputStream instanceof FileInputStream && FileInputStream.class.equals(inputStream.getClass())) {
            return ((FileInputStream)inputStream).getChannel();
        }
        return new ReadableByteChannelImpl(inputStream);
    }

    public static WritableByteChannel newChannel(OutputStream outputStream) {
        Channels.checkNotNull(outputStream, "out");
        if (outputStream instanceof FileOutputStream && FileOutputStream.class.equals(outputStream.getClass())) {
            return ((FileOutputStream)outputStream).getChannel();
        }
        return new WritableByteChannelImpl(outputStream);
    }

    public static Reader newReader(ReadableByteChannel readableByteChannel, CharsetDecoder charsetDecoder, int n) {
        Channels.checkNotNull(readableByteChannel, "ch");
        return StreamDecoder.forDecoder(readableByteChannel, charsetDecoder.reset(), n);
    }

    public static Reader newReader(ReadableByteChannel readableByteChannel, String string) {
        Channels.checkNotNull(string, "csName");
        return Channels.newReader(readableByteChannel, Charset.forName(string).newDecoder(), -1);
    }

    public static Writer newWriter(WritableByteChannel writableByteChannel, CharsetEncoder charsetEncoder, int n) {
        Channels.checkNotNull(writableByteChannel, "ch");
        return StreamEncoder.forEncoder(writableByteChannel, charsetEncoder.reset(), n);
    }

    public static Writer newWriter(WritableByteChannel writableByteChannel, String string) {
        Channels.checkNotNull(string, "csName");
        return Channels.newWriter(writableByteChannel, Charset.forName(string).newEncoder(), -1);
    }

    private static class ReadableByteChannelImpl
    extends AbstractInterruptibleChannel
    implements ReadableByteChannel {
        private final InputStream in;
        private static final int TRANSFER_SIZE = 8192;
        private byte[] buf = new byte[0];
        private final Object readLock = new Object();

        ReadableByteChannelImpl(InputStream in) {
            this.in = in;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(ByteBuffer dst) throws IOException {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (dst.isReadOnly()) {
                throw new IllegalArgumentException();
            }
            int len = dst.remaining();
            int bytesRead = 0;
            Object object = this.readLock;
            synchronized (object) {
                int totalRead;
                for (totalRead = 0; totalRead < len; totalRead += bytesRead) {
                    int bytesToRead = Math.min(len - totalRead, 8192);
                    if (this.buf.length < bytesToRead) {
                        this.buf = new byte[bytesToRead];
                    }
                    if (totalRead > 0 && this.in.available() <= 0) break;
                    try {
                        this.begin();
                        bytesRead = this.in.read(this.buf, 0, bytesToRead);
                        this.end(bytesRead > 0);
                    }
                    catch (Throwable throwable) {
                        this.end(bytesRead > 0);
                        throw throwable;
                    }
                    if (bytesRead < 0) break;
                    dst.put(this.buf, 0, bytesRead);
                }
                if (bytesRead < 0 && totalRead == 0) {
                    return -1;
                }
                return totalRead;
            }
        }

        @Override
        protected void implCloseChannel() throws IOException {
            this.in.close();
        }
    }

    private static class WritableByteChannelImpl
    extends AbstractInterruptibleChannel
    implements WritableByteChannel {
        private final OutputStream out;
        private static final int TRANSFER_SIZE = 8192;
        private byte[] buf = new byte[0];
        private final Object writeLock = new Object();

        WritableByteChannelImpl(OutputStream out) {
            this.out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int write(ByteBuffer src) throws IOException {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            int len = src.remaining();
            Object object = this.writeLock;
            synchronized (object) {
                int totalWritten;
                int bytesToWrite;
                for (totalWritten = 0; totalWritten < len; totalWritten += bytesToWrite) {
                    bytesToWrite = Math.min(len - totalWritten, 8192);
                    if (this.buf.length < bytesToWrite) {
                        this.buf = new byte[bytesToWrite];
                    }
                    src.get(this.buf, 0, bytesToWrite);
                    try {
                        this.begin();
                        this.out.write(this.buf, 0, bytesToWrite);
                        this.end(bytesToWrite > 0);
                    }
                    catch (Throwable throwable) {
                        this.end(bytesToWrite > 0);
                        throw throwable;
                    }
                }
                return totalWritten;
            }
        }

        @Override
        protected void implCloseChannel() throws IOException {
            this.out.close();
        }
    }
}

