/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import sun.awt.image.BufImgSurfaceManager;
import sun.java2d.SurfaceData;
import sun.java2d.SurfaceDataProxy;

public abstract class SurfaceManager {
    private static ImageAccessor imgaccessor;
    private ConcurrentHashMap cacheMap;

    public static void setImageAccessor(ImageAccessor imageAccessor) {
        if (imgaccessor != null) {
            throw new InternalError("Attempt to set ImageAccessor twice");
        }
        imgaccessor = imageAccessor;
    }

    public static SurfaceManager getManager(Image image) {
        SurfaceManager surfaceManager = imgaccessor.getSurfaceManager(image);
        if (surfaceManager == null) {
            try {
                BufferedImage bufferedImage = (BufferedImage)image;
                surfaceManager = new BufImgSurfaceManager(bufferedImage);
                SurfaceManager.setManager(bufferedImage, surfaceManager);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("Invalid Image variant");
            }
        }
        return surfaceManager;
    }

    public static void setManager(Image image, SurfaceManager surfaceManager) {
        imgaccessor.setSurfaceManager(image, surfaceManager);
    }

    public Object getCacheData(Object object) {
        return this.cacheMap == null ? null : this.cacheMap.get(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheData(Object object, Object object2) {
        if (this.cacheMap == null) {
            SurfaceManager surfaceManager = this;
            synchronized (surfaceManager) {
                if (this.cacheMap == null) {
                    this.cacheMap = new ConcurrentHashMap(2);
                }
            }
        }
        this.cacheMap.put(object, object2);
    }

    public abstract SurfaceData getPrimarySurfaceData();

    public abstract SurfaceData restoreContents();

    public void acceleratedSurfaceLost() {
    }

    public ImageCapabilities getCapabilities(GraphicsConfiguration graphicsConfiguration) {
        return new ImageCapabilitiesGc(graphicsConfiguration);
    }

    public synchronized void flush() {
        this.flush(false);
    }

    synchronized void flush(boolean bl) {
        if (this.cacheMap != null) {
            Iterator iterator = this.cacheMap.values().iterator();
            while (iterator.hasNext()) {
                Object v = iterator.next();
                if (!(v instanceof FlushableCacheData) || !((FlushableCacheData)v).flush(bl)) continue;
                iterator.remove();
            }
        }
    }

    public void setAccelerationPriority(float f) {
        if (f == 0.0f) {
            this.flush(true);
        }
    }

    public static interface FlushableCacheData {
        public boolean flush(boolean var1);
    }

    public static abstract class ImageAccessor {
        public abstract SurfaceManager getSurfaceManager(Image var1);

        public abstract void setSurfaceManager(Image var1, SurfaceManager var2);
    }

    class ImageCapabilitiesGc
    extends ImageCapabilities {
        GraphicsConfiguration gc;

        public ImageCapabilitiesGc(GraphicsConfiguration gc) {
            super(false);
            this.gc = gc;
        }

        @Override
        public boolean isAccelerated() {
            Object proxyKey;
            GraphicsConfiguration tmpGc = this.gc;
            if (tmpGc == null) {
                tmpGc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            }
            if (tmpGc instanceof ProxiedGraphicsConfig && (proxyKey = ((ProxiedGraphicsConfig)((Object)tmpGc)).getProxyKey()) != null) {
                SurfaceDataProxy sdp = (SurfaceDataProxy)SurfaceManager.this.getCacheData(proxyKey);
                return sdp != null && sdp.isAccelerated();
            }
            return false;
        }
    }

    public static interface ProxiedGraphicsConfig {
        public Object getProxyKey();
    }
}

