/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.AlphaComposite;
import java.awt.CompositeContext;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.Blit;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.MaskBlit;
import sun.java2d.pipe.CompositePipe;

public class GeneralCompositePipe
implements CompositePipe {
    @Override
    public Object startSequence(SunGraphics2D sunGraphics2D, Shape shape, Rectangle rectangle, int[] nArray) {
        RenderingHints renderingHints = sunGraphics2D.getRenderingHints();
        ColorModel colorModel = sunGraphics2D.getDeviceColorModel();
        PaintContext paintContext = sunGraphics2D.paint.createContext(colorModel, rectangle, shape.getBounds2D(), sunGraphics2D.cloneTransform(), renderingHints);
        CompositeContext compositeContext = sunGraphics2D.composite.createContext(paintContext.getColorModel(), colorModel, renderingHints);
        return new TileContext(this, sunGraphics2D, paintContext, compositeContext, colorModel);
    }

    @Override
    public boolean needTile(Object object, int n, int n2, int n3, int n4) {
        return true;
    }

    @Override
    public void renderPathTile(Object object, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
        Raster raster;
        WritableRaster writableRaster;
        TileContext tileContext = (TileContext)object;
        PaintContext paintContext = tileContext.paintCtxt;
        CompositeContext compositeContext = tileContext.compCtxt;
        SunGraphics2D sunGraphics2D = tileContext.sunG2D;
        Raster raster2 = paintContext.getRaster(n3, n4, n5, n6);
        ColorModel colorModel = paintContext.getColorModel();
        SurfaceData surfaceData = sunGraphics2D.getSurfaceData();
        Raster raster3 = surfaceData.getRaster(n3, n4, n5, n6);
        if (raster3 instanceof WritableRaster && byArray == null) {
            writableRaster = (WritableRaster)raster3;
            writableRaster = writableRaster.createWritableChild(n3, n4, n5, n6, 0, 0, null);
            raster = writableRaster;
        } else {
            raster = raster3.createChild(n3, n4, n5, n6, 0, 0, null);
            writableRaster = raster.createCompatibleWritableRaster();
        }
        compositeContext.compose(raster2, raster, writableRaster);
        if (raster3 != writableRaster && writableRaster.getParent() != raster3) {
            if (raster3 instanceof WritableRaster && byArray == null) {
                ((WritableRaster)raster3).setDataElements(n3, n4, writableRaster);
            } else {
                ColorModel colorModel2 = sunGraphics2D.getDeviceColorModel();
                BufferedImage bufferedImage = new BufferedImage(colorModel2, writableRaster, colorModel2.isAlphaPremultiplied(), null);
                SurfaceData surfaceData2 = BufImgSurfaceData.createData(bufferedImage);
                if (byArray == null) {
                    Blit blit = Blit.getFromCache(surfaceData2.getSurfaceType(), CompositeType.SrcNoEa, surfaceData.getSurfaceType());
                    blit.Blit(surfaceData2, surfaceData, AlphaComposite.Src, null, 0, 0, n3, n4, n5, n6);
                } else {
                    MaskBlit maskBlit = MaskBlit.getFromCache(surfaceData2.getSurfaceType(), CompositeType.SrcNoEa, surfaceData.getSurfaceType());
                    maskBlit.MaskBlit(surfaceData2, surfaceData, AlphaComposite.Src, null, 0, 0, n3, n4, n5, n6, byArray, n, n2);
                }
            }
        }
    }

    @Override
    public void skipTile(Object object, int n, int n2) {
    }

    @Override
    public void endSequence(Object object) {
        TileContext tileContext = (TileContext)object;
        if (tileContext.paintCtxt != null) {
            tileContext.paintCtxt.dispose();
        }
        if (tileContext.compCtxt != null) {
            tileContext.compCtxt.dispose();
        }
    }

    static class TileContext {
        SunGraphics2D sunG2D;
        PaintContext paintCtxt;
        CompositeContext compCtxt;
        ColorModel compModel;
        Object pipeState;

        public TileContext(SunGraphics2D sg, PaintContext pCtx, CompositeContext cCtx, ColorModel cModel) {
            this.sunG2D = sg;
            this.paintCtxt = pCtx;
            this.compCtxt = cCtx;
            this.compModel = cModel;
        }
    }
}

