/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringArrayMap
implements Serializable {
    private static final long serialVersionUID = -5833051164281786907L;
    private final Map<String, Object> map = new HashMap<String, Object>();

    public static String asString(Object pValue) {
        if (pValue == null) {
            return null;
        }
        if (pValue instanceof String) {
            return (String)pValue;
        }
        if (pValue instanceof String[]) {
            return ((String[])pValue)[0];
        }
        if (pValue instanceof List) {
            return (String)((List)pValue).get(0);
        }
        throw new IllegalStateException("Invalid parameter class: " + pValue.getClass().getName());
    }

    public static String[] asStringArray(Object pValue) {
        if (pValue == null) {
            return null;
        }
        if (pValue instanceof String) {
            return new String[]{(String)pValue};
        }
        if (pValue instanceof String[]) {
            return (String[])pValue;
        }
        if (pValue instanceof List) {
            List l = (List)pValue;
            return l.toArray(new String[l.size()]);
        }
        throw new IllegalStateException("Invalid parameter class: " + pValue.getClass().getName());
    }

    public static Enumeration<String> asStringEnum(final Object pValue) {
        if (pValue == null) {
            return null;
        }
        if (pValue instanceof String) {
            return new Enumeration<String>(){
                private Object value;
                {
                    this.value = pValue;
                }

                @Override
                public boolean hasMoreElements() {
                    return this.value != null;
                }

                @Override
                public String nextElement() {
                    if (this.value == null) {
                        throw new NoSuchElementException();
                    }
                    String s = (String)this.value;
                    this.value = null;
                    return s;
                }
            };
        }
        if (pValue instanceof String[]) {
            final String[] values = (String[])pValue;
            return new Enumeration<String>(){
                private int offset;

                @Override
                public boolean hasMoreElements() {
                    return this.offset < values.length;
                }

                @Override
                public String nextElement() {
                    if (this.offset >= values.length) {
                        throw new NoSuchElementException();
                    }
                    return values[this.offset++];
                }
            };
        }
        if (pValue instanceof List) {
            List stringList = (List)pValue;
            return Collections.enumeration(stringList);
        }
        throw new IllegalStateException("Invalid parameter class: " + pValue.getClass().getName());
    }

    public static Map<String, String[]> asMap(Map<String, Object> pMap) {
        HashMap<String, String[]> result = new HashMap<String, String[]>(pMap.size());
        for (Map.Entry<String, Object> entry : pMap.entrySet()) {
            String[] value = StringArrayMap.asStringArray(entry.getValue());
            result.put(entry.getKey(), value);
        }
        return Collections.unmodifiableMap(result);
    }

    protected void addMapValue(Map<String, Object> pMap, String pName, String pValue) {
        ArrayList<Object> o = pMap.get(pName);
        if (o == null) {
            o = pValue;
        } else if (o instanceof String) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(o);
            list.add(pValue);
            o = list;
        } else if (o instanceof List) {
            List stringList = o;
            stringList.add(pValue);
        } else if (o instanceof String[]) {
            String[] arr;
            ArrayList<String> list = new ArrayList<String>();
            for (String str : arr = (String[])o) {
                list.add(str);
            }
            list.add(pValue);
            o = list;
        } else {
            throw new IllegalStateException("Invalid object type: " + o.getClass().getName());
        }
        pMap.put(pName, o);
    }

    protected String convertName(String pName) {
        return pName.toLowerCase();
    }

    public String getValue(String pName) {
        return StringArrayMap.asString(this.map.get(this.convertName(pName)));
    }

    public String[] getValues(String pName) {
        return StringArrayMap.asStringArray(this.map.get(this.convertName(pName)));
    }

    public Enumeration<String> getValueEnum(String pName) {
        return StringArrayMap.asStringEnum(this.map.get(this.convertName(pName)));
    }

    public Enumeration<String> getNames() {
        return Collections.enumeration(this.map.keySet());
    }

    public Map<String, String[]> getMap() {
        return StringArrayMap.asMap(this.map);
    }

    public void addValue(String pName, String pValue) {
        this.addMapValue(this.map, this.convertName(pName), pValue);
    }

    public String[] getNameArray() {
        Set<String> c = this.map.keySet();
        return c.toArray(new String[c.size()]);
    }
}

