/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.thoughtworks.selenium.CommandProcessor;
import com.thoughtworks.selenium.DefaultRemoteCommand;
import com.thoughtworks.selenium.SeleniumException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import org.openqa.selenium.net.Urls;

public class HttpCommandProcessor
implements CommandProcessor {
    private String pathToServlet;
    private String browserStartCommand;
    private String browserURL;
    private String sessionId;
    private String extensionJs;
    private String rcServerLocation;

    public HttpCommandProcessor(String serverHost, int serverPort, String browserStartCommand, String browserURL) {
        this.rcServerLocation = String.valueOf(serverHost) + ":" + Integer.toString(serverPort);
        this.pathToServlet = "http://" + this.rcServerLocation + "/selenium-server/driver/";
        this.browserStartCommand = browserStartCommand;
        this.browserURL = browserURL;
        this.extensionJs = "";
    }

    public HttpCommandProcessor(String pathToServlet, String browserStartCommand, String browserURL) {
        this.pathToServlet = pathToServlet;
        this.browserStartCommand = browserStartCommand;
        this.browserURL = browserURL;
        this.extensionJs = "";
    }

    @Override
    public String getRemoteControlServerLocation() {
        return this.rcServerLocation;
    }

    @Override
    public String doCommand(String commandName, String[] args) {
        DefaultRemoteCommand command = new DefaultRemoteCommand(commandName, args);
        String result = this.executeCommandOnServlet(command.getCommandURLString());
        if (result == null) {
            throw new NullPointerException("Selenium Bug! result must not be null");
        }
        if (!result.startsWith("OK")) {
            return this.throwAssertionFailureExceptionOrError(result);
        }
        return result;
    }

    protected String throwAssertionFailureExceptionOrError(String message) {
        throw new SeleniumException(message);
    }

    public String executeCommandOnServlet(String command) {
        try {
            return this.getCommandResponseAsString(command);
        }
        catch (IOException e) {
            if (e instanceof ConnectException) {
                throw new SeleniumException(e.getMessage(), e);
            }
            e.printStackTrace();
            throw new UnsupportedOperationException("Catch body broken: IOException from " + command + " -> " + e, e);
        }
    }

    private String stringContentsOfInputStream(Reader rdr) throws IOException {
        StringBuffer sb = new StringBuffer();
        try {
            int c;
            while ((c = rdr.read()) != -1) {
                sb.append((char)c);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            rdr.close();
        }
    }

    protected HttpURLConnection getHttpUrlConnection(URL urlForServlet) throws IOException {
        return (HttpURLConnection)urlForServlet.openConnection();
    }

    protected Writer getOutputStreamWriter(HttpURLConnection conn) throws IOException {
        return new BufferedWriter(new OutputStreamWriter(conn.getOutputStream(), Charsets.UTF_8));
    }

    protected Reader getInputStreamReader(HttpURLConnection conn) throws IOException {
        return new InputStreamReader(conn.getInputStream(), "UTF-8");
    }

    protected int getResponseCode(HttpURLConnection conn) throws IOException {
        return conn.getResponseCode();
    }

    protected String getCommandResponseAsString(String command) throws IOException {
        String responseString = null;
        int responsecode = 301;
        HttpURLConnection uc = null;
        Writer wr = null;
        Reader rdr = null;
        while (responsecode == 301) {
            URL result = new URL(this.pathToServlet);
            String body = this.buildCommandBody(command);
            try {
                uc = this.getHttpUrlConnection(result);
                uc.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
                uc.setInstanceFollowRedirects(false);
                uc.setDoOutput(true);
                wr = this.getOutputStreamWriter(uc);
                wr.write(body);
                wr.flush();
                responsecode = this.getResponseCode(uc);
                if (responsecode == 301) {
                    this.pathToServlet = uc.getHeaderField("Location");
                } else if (responsecode != 200) {
                    this.throwAssertionFailureExceptionOrError(uc.getResponseMessage());
                } else {
                    rdr = this.getInputStreamReader(uc);
                    responseString = this.stringContentsOfInputStream(rdr);
                }
            }
            catch (Throwable throwable) {
                this.closeResources(uc, wr, rdr);
                throw throwable;
            }
            this.closeResources(uc, wr, rdr);
        }
        return responseString;
    }

    protected void closeResources(HttpURLConnection conn, Writer wr, Reader rdr) {
        try {
            if (wr != null) {
                wr.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (rdr != null) {
                rdr.close();
            }
        }
        catch (IOException iOException) {}
        if (conn != null) {
            conn.disconnect();
        }
    }

    private String buildCommandBody(String command) {
        StringBuffer sb = new StringBuffer();
        sb.append(command);
        if (this.sessionId != null) {
            sb.append("&sessionId=");
            sb.append(Urls.urlEncode(this.sessionId));
        }
        return sb.toString();
    }

    @Override
    public void setExtensionJs(String extensionJs) {
        this.extensionJs = extensionJs;
    }

    @Override
    public void start() {
        String result = this.getString("getNewBrowserSession", new String[]{this.browserStartCommand, this.browserURL, this.extensionJs});
        this.setSessionInProgress(result);
    }

    @Override
    public void start(String optionsString) {
        String result = this.getString("getNewBrowserSession", new String[]{this.browserStartCommand, this.browserURL, this.extensionJs, optionsString});
        this.setSessionInProgress(result);
    }

    @Override
    public void start(Object optionsObject) {
        this.start(optionsObject.toString());
    }

    protected void setSessionInProgress(String result) {
        this.sessionId = result;
    }

    @Override
    public void stop() {
        if (this.hasSessionInProgress()) {
            this.doCommand("testComplete", null);
        }
        this.setSessionInProgress(null);
    }

    public boolean hasSessionInProgress() {
        return this.sessionId != null;
    }

    @Override
    public String getString(String commandName, String[] args) {
        String result = this.doCommand(commandName, args);
        if (result.length() >= "OK,".length()) {
            return result.substring("OK,".length());
        }
        System.err.println("WARNING: getString(" + commandName + ") saw a bad result " + result);
        return "";
    }

    @Override
    public String[] getStringArray(String commandName, String[] args) {
        String result = this.getString(commandName, args);
        return HttpCommandProcessor.parseCSV(result);
    }

    public static String[] parseCSV(String input) {
        ArrayList output = Lists.newArrayList();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            switch (c) {
                case ',': {
                    output.add(sb.toString());
                    sb = new StringBuffer();
                    break;
                }
                case '\\': {
                    c = input.charAt(++i);
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        output.add(sb.toString());
        return output.toArray(new String[output.size()]);
    }

    @Override
    public Number getNumber(String commandName, String[] args) {
        Number n;
        String result = this.getString(commandName, args);
        try {
            n = NumberFormat.getInstance().parse(result);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        if (n instanceof Long && (long)n.intValue() == n.longValue()) {
            return n.intValue();
        }
        return n;
    }

    @Override
    public Number[] getNumberArray(String commandName, String[] args) {
        String[] result = this.getStringArray(commandName, args);
        Number[] n = new Number[result.length];
        int i = 0;
        while (i < result.length) {
            try {
                n[i] = NumberFormat.getInstance().parse(result[i]);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            ++i;
        }
        return n;
    }

    @Override
    public boolean getBoolean(String commandName, String[] args) {
        String result = this.getString(commandName, args);
        if ("true".equals(result)) {
            boolean b = true;
            return b;
        }
        if ("false".equals(result)) {
            boolean b = false;
            return b;
        }
        throw new RuntimeException("result was neither 'true' nor 'false': " + result);
    }

    @Override
    public boolean[] getBooleanArray(String commandName, String[] args) {
        Object[] result = this.getStringArray(commandName, args);
        boolean[] b = new boolean[result.length];
        int i = 0;
        while (i < result.length) {
            if ("true".equals(result[i])) {
                b[i] = true;
            } else if ("false".equals(result[i])) {
                b[i] = false;
            } else {
                throw new RuntimeException("result was neither 'true' nor 'false': " + Arrays.toString(result));
            }
            ++i;
        }
        return b;
    }
}

