/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.openqa.selenium.Beta;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.service.DriverService;

public class ChromeDriverService
extends DriverService {
    public static final String CHROME_DRIVER_EXE_PROPERTY = "webdriver.chrome.driver";
    public static final String CHROME_DRIVER_LOG_PROPERTY = "webdriver.chrome.logfile";
    public static final String CHROME_DRIVER_VERBOSE_LOG_PROPERTY = "webdriver.chrome.verboseLogging";
    public static final String CHROME_DRIVER_SILENT_OUTPUT_PROPERTY = "webdriver.chrome.silentOutput";

    public ChromeDriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) throws IOException {
        super(executable, port, args, environment);
    }

    public static ChromeDriverService createDefaultService() {
        File exe = ChromeDriverService.findExecutable("chromedriver", CHROME_DRIVER_EXE_PROPERTY, "http://code.google.com/p/selenium/wiki/ChromeDriver", "http://chromedriver.storage.googleapis.com/index.html");
        return new Builder().usingDriverExecutable(exe).usingAnyFreePort().build();
    }

    public static class Builder {
        private int port = 0;
        private File exe = null;
        private ImmutableMap<String, String> environment = ImmutableMap.of();
        String chromeLogFile = System.getProperty("webdriver.chrome.logfile");
        private File logFile = this.chromeLogFile == null ? null : new File(this.chromeLogFile);
        private boolean verbose = Boolean.getBoolean("webdriver.chrome.verboseLogging");
        private boolean silent = Boolean.getBoolean("webdriver.chrome.silentOutput");

        public Builder usingDriverExecutable(File file) {
            Preconditions.checkNotNull((Object)file);
            ChromeDriverService.checkExecutable(file);
            this.exe = file;
            return this;
        }

        public Builder usingPort(int port) {
            Preconditions.checkArgument((port >= 0 ? 1 : 0) != 0, (String)"Invalid port number: %d", (Object[])new Object[]{port});
            this.port = port;
            return this;
        }

        public Builder usingAnyFreePort() {
            this.port = 0;
            return this;
        }

        @Beta
        public Builder withEnvironment(Map<String, String> environment) {
            this.environment = ImmutableMap.copyOf(environment);
            return this;
        }

        public Builder withLogFile(File logFile) {
            this.logFile = logFile;
            return this;
        }

        public Builder withVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder withSilent(boolean silent) {
            this.silent = silent;
            return this;
        }

        public ChromeDriverService build() {
            if (this.port == 0) {
                this.port = PortProber.findFreePort();
            }
            Preconditions.checkState((this.exe != null ? 1 : 0) != 0, (Object)"Path to the driver executable not specified");
            try {
                ImmutableList.Builder argsBuilder = ImmutableList.builder();
                argsBuilder.add((Object)String.format("--port=%d", this.port));
                if (this.logFile != null) {
                    argsBuilder.add((Object)String.format("--log-path=%s", this.logFile.getAbsolutePath()));
                }
                if (this.verbose) {
                    argsBuilder.add((Object)"--verbose");
                }
                if (this.silent) {
                    argsBuilder.add((Object)"--silent");
                }
                return new ChromeDriverService(this.exe, this.port, (ImmutableList<String>)argsBuilder.build(), this.environment);
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
    }
}

