/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.net.UrlChecker;
import org.openqa.selenium.os.CommandLine;

public class DriverService {
    private final URL url;
    private final ReentrantLock lock = new ReentrantLock();
    private CommandLine process = null;
    private final String executable;
    private final ImmutableList<String> args;
    private final ImmutableMap<String, String> environment;

    protected DriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) throws IOException {
        this.executable = executable.getCanonicalPath();
        this.url = new URL(String.format("http://localhost:%d", port));
        this.args = args;
        this.environment = environment;
    }

    public URL getUrl() {
        return this.url;
    }

    protected static File findExecutable(String exeName, String exeProperty, String exeDocs, String exeDownload) {
        String defaultPath = CommandLine.find(exeName);
        String exePath = System.getProperty(exeProperty, defaultPath);
        Preconditions.checkState((exePath != null ? 1 : 0) != 0, (String)"The path to the driver executable must be set by the %s system property; for more information, see %s. The latest version can be downloaded from %s", (Object[])new Object[]{exeProperty, exeDocs, exeDownload});
        File exe = new File(exePath);
        DriverService.checkExecutable(exe);
        return exe;
    }

    protected static void checkExecutable(File exe) {
        Preconditions.checkState((boolean)exe.exists(), (String)"The driver executable does not exist: %s", (Object[])new Object[]{exe.getAbsolutePath()});
        Preconditions.checkState((!exe.isDirectory() ? 1 : 0) != 0, (String)"The driver executable is a directory: %s", (Object[])new Object[]{exe.getAbsolutePath()});
        Preconditions.checkState((boolean)FileHandler.canExecute(exe), (String)"The driver is not executable: %s", (Object[])new Object[]{exe.getAbsolutePath()});
    }

    public boolean isRunning() {
        this.lock.lock();
        try {
            if (this.process == null) {
                return false;
            }
            boolean bl = this.process.isRunning();
            return bl;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void start() throws IOException {
        this.lock.lock();
        try {
            if (this.process != null) {
                return;
            }
            try {
                this.process = new CommandLine(this.executable, (String[])this.args.toArray((Object[])new String[0]));
                this.process.setEnvironmentVariables((Map<String, String>)this.environment);
                this.process.copyOutputTo(System.err);
                this.process.executeAsync();
                URL status = new URL(String.valueOf(this.url.toString()) + "/status");
                new UrlChecker().waitUntilAvailable(20L, TimeUnit.SECONDS, status);
            }
            catch (UrlChecker.TimeoutException e) {
                this.process.checkForError();
                throw new WebDriverException("Timed out waiting for driver server to start.", e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() {
        this.lock.lock();
        try {
            if (this.process == null) {
                return;
            }
            try {
                URL killUrl = new URL(String.valueOf(this.url.toString()) + "/shutdown");
                new UrlChecker().waitUntilUnavailable(3L, TimeUnit.SECONDS, killUrl);
                this.process.destroy();
            }
            catch (MalformedURLException e) {
                throw new WebDriverException(e);
            }
            catch (UrlChecker.TimeoutException e) {
                throw new WebDriverException("Timed out waiting for driver server to shutdown.", e);
            }
        }
        finally {
            this.process = null;
            this.lock.unlock();
        }
    }
}

